<?php
	
	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		
	if (  $step == 3 ) {
	
		$rtn = recordResidentTemperature($_REQUEST);	
		$updtMessage = $rtn[1];
		if ( $rtn[0] == SUCCESS ) {
			$updtMessage = "The " . $_REQUEST['tempReading'] . " temperature reading(s) was/were recorded successfully.";
			$isFail = false;
		}
		else
			$isFail = true;
			
		$step = 1;
	}
	
	if ( $step == 1 ) { 

		$houses = getHousesListing( true );
?>
<form id="rbodytemp" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/indv-services/index/dest/<?php echo $dest; ?>/step/2/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo  $RESIDENT_SERVICES_BREADCRUMB[$dest]; ?></h5>
			   <?php if ( isset($isFail) ) { ?>
			   		<div class="row mt-3 mb-3">
						<div class="col-md-1"></div>
						<div class="col-md-10 col-sm-offset-1 text-center">
							  <div class="alert  <?php echo ( $isFail === false ) ? "alert-success" : "alert-danger"; ?> text-center mb-1">
								<h4>
								<?php 
									echo $updtMessage;
								?>
								</h4>
								</div>
						</div>
						<div class="col-md-1"></div>
					</div>
			   <?php } ?>
              <!-- Floating Labels Form -->
			  
			  <div class="row">
			  		<div class="col-md-2"></div>
					<div class="col-md-4">
					  <div class="form-floating mt-3">
							<select class="form-select js-select" name="houseID" id="houseID" aria-label="House Being Recorded" required>
								  <option selected disabled value="">Choose House Being Recorded </option>
								  <?php for( $i = 0; $i < count($houses); $i++ ) { 
								  		if ( $houses[$i]['HouseID'] == MANAGEMENT ) { continue; }
								  ?>
								  <option value="<?php echo $houses[$i]['HouseID']; ?>"><?php echo $houses[$i]['HouseName']; ?></option>
								  <?php } ?>
							</select>
							<label  for="houseID">House Being Recorded</label>
							<div class="invalid-feedback">
								Please select House Being Recorded .
							</div>
					  	</div>
                	</div>
					
					<div class="col-md-4 position-relative">
						<div class="form-floating mt-3">
							<select class="form-select js-select" name="numReadings" id="numReadings" aria-label="Number of Readings" required>
								  <option selected disabled value="">Choose Number of Readings</option>
								  <option value="1">All House <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?>s</option>
								  <option value="2">A Single <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?></option>
							</select>
							<label  for="numReadings">Number of Readings</label>
							<div class="invalid-feedback">
								Please select Number of Readings.
							</div>
					  	</div>
					</div>
					
					<div class="col-md-2"></div>
			</div>
								
			<div class="text-center mt-5 mb-5">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Proceed to Readings</button>
                </div>	
 			</div>
	   </div>
		
	</form>	
<?php }
	  else if ( $step == 2 ) { 

		$clients = getHouseClients($_REQUEST['houseID']);
		$tempToRecord = (($_REQUEST['numReadings'] == 2 ) ?  1 : count($clients));
?>
	<form id="rbodytemp2" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/indv-services/index/dest/<?php echo $dest; ?>/step/3/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo  $RESIDENT_SERVICES_BREADCRUMB[$dest]; ?></h5>
			  
			 <div class="row">
			  		<div class="col-md-2"></div>
					<div class="col-md-4">
					  <div class="form-floating mt-3 input-group" id='div_tempdate' data-td-target-input='nearest' data-td-target-toggle='nearest'>
						<input type="text" class="form-control" name="tempdate" id="tempdate" placeholder="Temperature Date"  data-td-target='#div_tempdate' required />
						<label   class="form-label" for="tempdate">Temperature Date</label>
						<span class='input-group-text' data-td-target='#div_tempdate' data-td-toggle='datetimepicker'>
							 <span class='bi bi-calendar-date fs-4'></span>
						  </span>
						<div class="invalid-feedback">
							Please provide the temperature date
						</div>
					  </div>
                	</div>
					
					<div class="col-md-4 position-relative">
						<div class="form-floating mt-3">
							<select class="form-select js-select" name="tempReading" id="tempReading" aria-label="Which Temperature" required>
								  <option selected disabled value="">Temperature  to record</option>
								  <option value="Morning">Morning</option>
								  <option value="Evening">Evening</option>
							</select>
							<label  for="tempReading">Which Temperature</label>
							<div class="invalid-feedback">
								Please select temperature to record.
							</div>
					  	</div>
					</div>
					
					<div class="col-md-2"></div>
			</div>
			
			<?php for( $row = 0; $row < $tempToRecord; $row++ ) { ?>
			
			<div class="row">
			  		<div class="col-md-2"></div>
					<div class="col-md-4">
					  <div class="form-floating mt-3">
							<select class="form-select staffselect" name="resident[]" id="resident<?php echo $row; ?>" aria-label="<?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?> Name" >
							  <option selected disabled value="">Choose a <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?></option>
							  <?php for( $j = 0; $j < count($clients); $j++ ) { ?>
							  	<option value="<?php echo $clients[$j]['ClientID']; ?>"><?php echo $clients[$j]['ClientFname'] . ' ' . $clients[$j]['ClientLname']; ?></option>
							  <?php } ?>
							</select>
							<label  for="staffID"><?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?> Name</label>
							<div class="invalid-feedback">
								Please select a <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?> Name.
							</div>
						</div>
                	</div>
					
					<div class="col-md-4 position-relative">
						<div class="form-floating mt-3">
							<input type="number" class="form-control" name="tempValue[]"  min="1" max="100" step="0.1" placeholder="Temperature( <sup>o</sup>F )" >
							<label  for="activitydtl">Temperature( <sup>o</sup>F )</label>
							<div class="invalid-feedback">
								Please provide Temperature( <sup>o</sup>F ).
							</div>
						</div>
					</div>
					
					<div class="col-md-2"></div>
			</div>
			
			<?php } ?>
								
			<div class="text-center mt-5 mb-5">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Record Body Temperature</button>
				   <button type="reset" class="btn btn-secondary mt-3 configbtn" >Start Over</button>
                </div>	
 			</div>
	   </div>
		
	</form>	

<?php
	}
?>