<?php 
	$doredirect = 0;
	$requireSignOn = 'Y';
	$includeFooter = true;
	$filebase = basename(dirname(__FILE__));
	$protocol = isset($_SERVER['HTTPS']) ? 'https' : 'http';
	
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.inc.php' );
	
	// 
	// Check if session is still valid
	//
	if ( $requireSignOn == 'Y' ) {
		if ( ! sessionIsValid( $_SESSION['sessID'], $IDLE_TIMEOUT ) ) {
			deleteSession($_SESSION['sessID']);
			
			$redirectURL =  (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
			
			saveRedirectURL( $_SESSION['sessID'], $redirectURL );
			$_SESSION['userIsLoggedIn'] = false;
			$_SESSION['staffID'] = $_SESSION['userRec']['StaffID'];
			$_SESSION['user_houseID'] = $_SESSION['userRec']['HouseID'];
			$_SESSION['username'] = $_SESSION['userRec']['Username'];
			$_SESSION['user-finit-lname'] = ucfirst(substr(trim($_SESSION['userRec']['StaffFname']), 0, 1 )) . '. ' . ucfirst($_SESSION['userRec']['StaffLname']);
			$_SESSION['user-fullname'] = trim($_SESSION['userRec']['StaffFname']) . ' ' . ucfirst($_SESSION['userRec']['StaffLname']);
			$_SESSION['user-position'] = $_SESSION['userRec']['Position'];
			$_SESSION['user-type'] = $_SESSION['userRec']['StaffType'];
			$_SESSION['user-role'] = $_SESSION['userRec']['StaffRoleID'];
			$_SESSION['user-gender'] = $_SESSION['userRec']['StaffGender'];
			$_SESSION['user-housename'] = $_SESSION['userRec']['HouseName'];
			$_SESSION['user-isDriver'] = $_SESSION['userRec']['IsDriver'];
			$_SESSION['user-email'] = $_SESSION['userRec']['StaffEmail'];
			$_SESSION['doRedirect'] = 1;
			Header('Location: ' . $protocol . '://' . $_SERVER['SERVER_NAME'] . '/authaz/index/dest/signin/' );
			exit;
		}
		else {
			updateSession($_SESSION['sessID']);
		}
		
	}
	
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.header.php' );
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.sidebar.php' );
	
	if ( file_exists( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/hrc-corner.db.php' ) ) {
		include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/hrc-corner.db.php' );
	}
	
	$isFail = -1;
	$config = getHRCFromDB();	
	
	$updtMessage = $config[1];
	if ( $config[0] == SUCCESS ) {

		$hrcmembers = $config[1][0];
		$isHRC = false;		
		
		for ( $hrc = 0; $hrc < count($hrcmembers); $hrc++ ) {
			if ( $_SESSION['staffID'] == $hrcmembers[$hrc]['StaffID'] ) {
				$isHRC = true;	
				$hrc = count($hrcmembers);
			}
		}
		
		if ( ! $isHRC ) {
			$dest = 'violation';
		}
	
	}
	else {
		$updtMessage = "Unable to get HRC information from the database.";
		$isFail = 1;
		$step = 3;
	}	
?>

  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Staff Manangement - Human Rights Corner</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>">Home</a></li>
		  <?php if ( $dest == 'main' ) { ?>
          	<li class="breadcrumb-item active">Human Rights Corner</li>
		 <?php } else { ?>
		 	<li class="breadcrumb-item active"><a href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/hrc-corner/index/dest/hrcnotes/">Human Rights Corner</a></li>
			<li class="breadcrumb-item active"><?php echo $HRC_CORNER_BREADCRUMB[$dest]; ?></li>
		 <?php } ?>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section dashboard">
      <div class="row">
			<!-- ================================================================================== -->
			<?php 
					if ( file_exists( $_SERVER['DOCUMENT_ROOT'] . '/hrc-corner/' .  $dest . '.inc.php' ) ) {
						include( $_SERVER['DOCUMENT_ROOT'] . '/hrc-corner/' .  $dest . '.inc.php' );
					}
			?>
			<!-- ================================================================================== -->

      </div>
    </section>
	
	</main><!-- End #main -->
  
 <?php include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.footer.php' ); ?>