#!/usr/bin/php -q
<?php

	$localRoot =  dirname(dirname(__FILE__));
	include( $localRoot . "/cronjobs/cron.inc.php" );

	$rtn = getStaffDocsDue();
	$rtn1 = getExpiredStaffDocs();
		
	echo dpp($rtn);
	echo dpp($rtn1);
	
	// Set Default Timesone
	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
	
	$message = "";
	$sendMail = 0;

	if ( $rtn[0] != SUCCESS )
	{
		// exit with a false
		echo "

			  Automated Job 'Staff Document Due Notification' failed.

			  ";
		exit;
	}
	
	if ( $rtn[0] == SUCCESS  && count( $rtn[1] ) > 0 )
	{
		
		$myData = $rtn[1];
		$today = intval(date( "Ymd" ));
		$currStaff = 0;

		$message =  "<strong>Staff Document Due Report</strong><br>
					 ========================
					 <br>
					 <br>
					 ";

		$message .= "<table width=\"600\" border=\"1\" cellspacing=\"0\" cellpadding=\"5\">
						<tr>
    						<td colspan='3'>Staff Documents/Items to be Renewed Soon</td>
  						</tr>
						
				 		";
		if ( count($myData) > 0 )
		{
			$sendMail = 1;
			
			for ( $i = 0; $i < count($myData); $i++ )
			{
				
				if ( $currStaff != $myData[$i][0] ) {
				
				//echo "currStaff = $currStaff |||| newStaff = " . $myData[$i][0] . " \n";
				
					$message .= "<tr>
										<td colspan='3' style='border:none;'>&nbsp;</td>
									</tr>
								<tr>
    								<td colspan='3'><strong>Staff: " . getStaffName($myData[$i][0]). "</strong></td>
  								</tr>
								<tr>
								  <td width='300'>Document</td><td width='175'>Renewal Due By</td><td width='125'>Renewal Due In</td>
								</tr>
								<tr>
									<td>" .  $myData[$i][1] .  "</td><td>" .  $myData[$i][2] .  "</td><td>" .  $myData[$i][3] .  (( $myData[$i][3] > 1 ) ? " Days" : " Day" ) .  "</td>
								</tr>";					
					$currStaff = $myData[$i][0];
				}
				else {
					$message .= "
								<tr>
									<td>" .  $myData[$i][1] .  "</td><td>" .  $myData[$i][2] .  "</td><td>" .  $myData[$i][3] .  (( $myData[$i][3] > 1 ) ? " Days" : " Day" ) .  "</td>
								</tr>
							";	
				
				}			
			}
			$message .= "</table><br><br>";
		} 
		else
			$message = "";

	}
		
	$currStaff = 0;
	if ( $rtn1[0] != SUCCESS )
	{
		// exit with a false
		echo "

			  Automated Job 'Staff Document Due Notification' failed.

			  ";
		exit;
	}
	
	
	if ( $rtn1[0] == SUCCESS  && count( $rtn1[1] ) > 0 )
	{
		//if ( count( $rtn1[1] ) <= 0 ) {
	
			$myData1 = $rtn1[1];
			$today = intval(date( "Ymd" ));	
	
			$message .=  "<strong>Expired Staff Document Report</strong><br>
			============================
			<br>
			<br>
			";
	
			$message .= "<table width=\"600\" border=\"1\" cellspacing=\"0\" cellpadding=\"5\">
			<tr>
			<td colspan='3'>Expired Staff Documents/Items that need to be renewed</td>
			</tr>
	
			";
			if ( count($myData1) > 0 )
			{
				$sendMail = 1;
	
				for ( $i = 0; $i < count($myData1); $i++ )
				{
	
					if ( $currStaff != $myData1[$i][0] ) {
						//var_dump($myData1[$i]);
						//echo "currStaff = $currStaff |||| newStaff = " . $myData1[$i][0] . " Staff Name = " . getStaffName($myData1[$i][0]) . " \n";
						$message .= "<tr>
								<td colspan='3' style='border:none;'>&nbsp;</td>
							</tr>
							<tr>
								<td colspan='3'><strong>Staff: " . getStaffName($myData1[$i][0]). "</strong></td>
							</tr>
							<tr>
								<td width='300'>Document</td><td width='175'>Renewal Was Due</td><td width='125'>Days Past Due</td>
							</tr>
							<tr>
								<td>" .  $myData1[$i][1] .  "</td><td>" .  $myData1[$i][2] .  "</td><td>" .  $myData1[$i][3] .  (( $myData1[$i][3] > 1 ) ? " Days" : " Day" ) .  "</td>
							</tr>";						
						$currStaff = $myData1[$i][0];
					}
					else {
						$message .= "
								<tr>
									<td>" .  $myData1[$i][1] .  "</td><td>" .  $myData1[$i][2] .  "</td><td>" .  $myData1[$i][3] .  (( $myData1[$i][3] > 1 ) ? " Days" : " Day" ) .  "</td>
								</tr>
								";
	
					}			
	
				}
				$message .= "</table><br><br>";
			}
		//}
	}

	if ( $sendMail == 1 ) {
	
		emailAdmins( $message, "SDN" );
		echo "
		
			  Automated Job 'Staff Document Due Notification' completed successfully

			  ";
	}

	/*
	if ( $rtn1[0] == SUCCESS  && count( $rtn1[1] ) > 0 )
	{
		//if ( count( $rtn1[1] ) <= 0 ) {

		$myData1 = $rtn1[1];
		$today = intval(date( "Ymd" ));	

		$message .=  "<strong>Expired Staff Document Report</strong><br>
					  ============================
					 <br>
					 <br>
					 ";

		$message .= "<table width=\"600\" border=\"1\" cellspacing=\"0\" cellpadding=\"5\">
						<tr>
							<td colspan='3'>Expired Staff Documents/Items that need to be renewed</td>
						</tr>

						";
		if ( count($myData1) > 0 )
		{
			$sendMail = 1;
			
			for ( $i = 0; $i < count($myData1); $i++ )
			{
				
				if ( $currStaff != $myData1[$i][0] ) {
					//var_dump($myData1[$i]);
					//echo "currStaff = $currStaff |||| newStaff = " . $myData1[$i][0] . " Staff Name = " . getStaffName($myData1[$i][0]) . " \n";
					$message .= "<tr>
									<td colspan='3' style='border:none;'>&nbsp;</td>
								</tr>
								<tr>
									<td colspan='3'><strong>Staff: " . getStaffName($myData1[$i][0]). "</strong></td>
								</tr>
								<tr>
								  <td width='300'>Document</td><td width='175'>Renewal Was Due</td><td width='125'>Days Past Due</td>
								</tr>
								<tr>
									<td>" .  $myData1[$i][1] .  "</td><td>" .  $myData1[$i][2] .  "</td><td>" .  $myData1[$i][3] .  (( $myData1[$i][3] > 1 ) ? " Days" : " Day" ) .  "</td>
								</tr>";						
					$currStaff = $myData1[$i][0];
				}
				else {
					$message .= "
							<tr>
									<td>" .  $myData1[$i][1] .  "</td><td>" .  $myData1[$i][2] .  "</td><td>" .  $myData1[$i][3] .  (( $myData1[$i][3] > 1 ) ? " Days" : " Day" ) .  "</td>
								</tr>
							";
				
				}			
				
			}
			$message .= "</table><br><br>";
		}
	}
	
	
	
	emailAdmins( $message, "SDN" );
	echo "
	
		  Automated Job 'Staff Document Due Notification' completed successfully\n

		  ";
}
*/


//  Emailing Individual notifications
$currStaff = 0;
$message = "";
$sendMail = 0;

if ( $rtn[0] == SUCCESS && count( $rtn[1] ) > 0 )
{
	$myData = $rtn[1];
	$today = intval(date( "Ymd" ));	
	
	if ( count($myData) > 0 )
	{
		$sendMail = 1;
		
		for ( $i = 0; $i < count($myData); $i++ )
		{
			if ( $currStaff != $myData[$i][0] ) {
					//if ( ( $currStaff == 10 ) && $message != '' ) {
					if ( $message != '' ) {
							emailAdmins( $message . "</table>", "SDN", $currStaff );								
					}
					$message = "";
					$currStaff = $myData[$i][0];
					$message .=  "<strong>Document Renewal Due Report for " . getStaffName($myData[$i][0]) . "</strong><br>
								  ================================================
								 <br>
								 <br>
								<table width=\"650\" border=\"1\" cellspacing=\"0\" cellpadding=\"5\">									
			
									";
					$message .= "
							<tr>
								<td colspan='3'><strong>The documents listed below will expire soon, so please have them renewed and bring a copy to the office. Failure to have them renewed maybe grounds for  termination.</strong></td>
							</tr>
							<tr>
							 <td width='300'>Document</td><td width='200'>Renewal Due By</td><td width='150'>Renewal Due In</td>
							</tr>
							<tr>
								<td>" .  $myData[$i][1] .  "</td><td>" .  $myData[$i][2] .  "</td><td>" .  $myData[$i][3] .  (( $myData[$i][3] > 1 ) ? " Days" : " Day" ) .  "</td>
							</tr>";						
			}
			else {
				$message .= "
						<tr>
								<td>" .  $myData[$i][1] .  "</td><td>" .  $myData[$i][2] .  "</td><td>" .  $myData[$i][3] .  (( $myData[$i][3] > 1 ) ? " Days" : " Day" ) .  "</td>
							</tr>
						";
			
			}			
			
		}
		
		if ( $message != '' && $sendMail == 1 ) {
			emailAdmins( $message . "</table>", "SDN", $currStaff );				
		}
	}
}

$currStaff = 0;
$message = "";
$sendMail = 0;
if ( $rtn[0] == SUCCESS )
{
	$myData = $rtn1[1];
	//var_dump($myData);
	$today = intval(date( "Ymd" ));	
	
	if ( count($myData) > 0 )
	{
		$sendMail = 1;
		
		for ( $i = 0; $i < count($myData); $i++ )
		{
			if ( $currStaff != $myData[$i][0] ) {
					//if ( ( $currStaff == 10 ) && $message != '' ) {
					if ( $message != '' ) {
							emailAdmins( $message . "</table>", "SDN", $currStaff );								
					}
					$message = "";
					$currStaff = $myData[$i][0];
					$message .=  "<strong>Document Renewal Overdue Report for " . getStaffName($myData[$i][0]) . "</strong><br>
								  ====================================================================
								 <br>
								 <br>
								<table width=\"650\" border=\"1\" cellspacing=\"0\" cellpadding=\"5\">									
			
									";
					$message .= "
							<tr>
								<td colspan='3' style='color:#ff0000'><strong>The documents listed below are overdue and management has been notifieid, so please have them renewed and bring a copy to the office. Failure to have them renewed maybe grounds for  termination.</strong></td>
							</tr>
							<tr>
							 <td width='300'>Document</td><td width='200'>Renewal Was Due On</td><td width='150'>Renewal Overdue By</td>
							</tr>
							<tr>
								<td>" .  $myData[$i][1] .  "</td><td>" .  $myData[$i][2] .  "</td><td style='color:#ff0000'><strong>" .  $myData[$i][3] .  (( $myData[$i][3] > 1 ) ? " Days" : " Day" ) .  "</strong></td>
							</tr>";						
			}
			else {
				$message .= "
						<tr>
								<td>" .  $myData[$i][1] .  "</td><td>" .  $myData[$i][2] .  "</td><td style='color:#ff0000'><strong>" .  $myData[$i][3] .  (( $myData[$i][3] > 1 ) ? " Days" : " Day" ) .  "</strong></td>
							</tr>
						";
			
			}			
			
		}
			
		if ( $message != '' && $sendMail == 1 ) {
			emailAdmins( $message . "</table>", "SDN", $currStaff );				
		}
	}
}
	
	
?>
