#!/usr/bin/php -q
<?php

	$localRoot =  dirname(dirname(__FILE__));
	include( $localRoot . "/cronjobs/cron.inc.php" );

    // Set Default Timesone
	date_default_timezone_set('America/New_York');
	
	### Variables Variables Variables
	StartTimer();
	$this_file = '/error_log.php';
	$this_file_length = strlen($this_file);
	$this_path = __FILE__;
	
	$jpg_logs = array();
	$html_logs = array();	
	$error_logs = array();	
	
	$root = $localRoot;
	$rpt_tmp_root = dirname(dirname(__FILE__)) . "/reports/tmp";
	$img_tmp_root = dirname(dirname(__FILE__)) . "/reports/graphs";
	
	### Function: List All Files
	function list_files($path = '') {
		global $error_logs, $html_logs, $jpg_logs, $img_tmp_root;
		if ($handle = @opendir($path)) {     
			while (false !== ($filename = readdir($handle))) {  
				if ($filename != '.' && $filename != '..') {
					if(is_dir($path.'/'.$filename)) {
						list_files($path.'/'.$filename);
					} else {
						if (is_file($path.'/'.$filename)) {
							if($filename == 'error_log') {
								$error_logs[] = array('file' => $path.'/'.$filename, 'size' => filesize($path.'/'.$filename));

								//unlink($path.'/'.$filename);
							}
							else if ((strpos($filename, 'savePrintRpt_') !== false) || (strpos($filename, 'saveNoPrintRpt_') !== false)) { 
								$html_logs[] = array('file' => $path.'/'.$filename, 'size' => filesize($path.'/'.$filename));
								unlink($path.'/'.$filename);
							}
							else if ( (fnmatch( "*.jpg", $filename ) === true) && ( $img_tmp_root == $path ) )
							{ 
							    //echo PHP_EOL . strpos( $img_tmp_root, $path ) . " == " . $img_tmp_root . " == " . $path . PHP_EOL;
								$jpg_logs[] = array('file' => $path.'/'.$filename, 'size' => filesize($path.'/'.$filename));
								unlink($path.'/'.$filename);
							}
						} 
					}
				} 
			} 
			closedir($handle);  
		} 
	}

	### Function: Start Timer
	function StartTimer() {
		global $timestart;
		$mtime = microtime();
		$mtime = explode(" ",$mtime);
		$mtime = $mtime[1] + $mtime[0];
		$timestart = $mtime;
		return true;
	}

	### Function: Stop Timer
	function StopTimer($precision=5) {
		global $timestart;
		$mtime = microtime();
		$mtime = explode(" ",$mtime);
		$mtime = $mtime[1] + $mtime[0];
		$timeend = $mtime;
		$timetotal = $timeend-$timestart;
		$scripttime = number_format($timetotal,$precision);
		return $scripttime;
	}

	### Function: Format Size
	function format_size($rawSize) {
		if($rawSize / 1073741824 > 1) {
			return round($rawSize/1073741824, 1).'GB';
		} elseif ($rawSize / 1048576 > 1) {
			return round($rawSize/1048576, 1).'MB';
		} elseif ($rawSize / 1024 > 1) {
			return round($rawSize/1024, 1).'KB';
		} else {
			return round($rawSize, 1).'b';
		}
	}

	### Get The error_log Files
	list_files($root);
    $no = 0;
	$total_size = 0;
	if($error_logs) {
		foreach($error_logs as $key => $error_log) {
			$no++;
			echo '     ' . $no.'. '.$error_log['file'].' ('.format_size($error_log['size']).')' . PHP_EOL;
			$total_size += $error_log['size'];				
		}
        echo PHP_EOL . PHP_EOL . '     ' . $no . ' error_logs Worth ' . format_size($total_size) . ' Found and Deleted.';
	} 
	else {
		echo 'No error_log File Found';
	}

	echo PHP_EOL . PHP_EOL . "";

	### Get The Report HTML Files
	list_files($rpt_tmp_root);
    $no = 0;
	$total_size = 0;
	if($html_logs) {
		foreach($html_logs as $key => $htmlFile) {
			$no++;
			echo '     ' . $no.'. '.$htmlFile['file'].' ('.format_size($htmlFile['size']).')' . PHP_EOL;
			$total_size += $htmlFile['size'];				
		}
        echo PHP_EOL . PHP_EOL . '     ' . $no . ' tmp HTML Files Worth ' . format_size($total_size) . ' Found and Deleted.';
	} 
	else {
		echo 'No temp Report HTML Files Found';
	}
	
	echo PHP_EOL . PHP_EOL . "";

	### Get The image Files
	list_files($img_tmp_root);
    $no = 0;
	$total_size = 0;
	if($jpg_logs) {
		foreach($jpg_logs as $key => $jpgFile) {
			$no++;
			echo '     ' . $no.'. '.$jpgFile['file'].' ('.format_size($jpgFile['size']).')' . PHP_EOL;
			$total_size += $jpgFile['size'];				
		}
        echo PHP_EOL . PHP_EOL . '     ' . $no . '  image Files Worth ' . format_size($total_size) . ' Found and Deleted.';
	} 
	else {
		echo 'No graph image Files Found';
	}

?>
