<?php

// Include the PhpSpreadsheet library
require $_SERVER['DOCUMENT_ROOT'] . '/assets/vendor/autoload.php'; // Assuming you've installed PhpSpreadsheet via Composer

use PhpOffice\PhpSpreadsheet\Reader\Xlsx;

// Connect to MySQL database
$mysqli = loginToDB();

// Check connection
if (mysqli_connect_errno()) {
    $clientsfileload .= "but DB Connection failed: " . mysqli_connect_error();
	$fileUploadError = 1;
	$configError = true;
}

if ( ! file_exists($_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/configurator/loadtables/Houses.xlsx') ) {
	$fileUploadError = 1;
	$configError = true;
	$Stafffileload .= " but there Staff data file was not found. <br>";
	if ( $mysqli ) {
		closeDB( $mysqli );
	}
}

if ( $fileUploadError == 0 ) {

	// Path to your Excel file
	$excelFile = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/configurator/loadtables/Houses.xlsx';
	
	// Load the Excel file
	$reader = new Xlsx();
	$spreadsheet = $reader->load($excelFile);
	
	// Get the active sheet
	$sheet = $spreadsheet->getActiveSheet();
	$highestRow = $sheet->getHighestRow(); // e.g. 10
	
	if ( ! mysqli_begin_transaction( $mysqli, MYSQLI_TRANS_START_READ_WRITE ) ) {
			
		$locationsfileload .= " but there was an error loading locations data to the database. Error Message: " . mysqli_error($mysqli) . "<br>";
		$fileUploadError = 1;
		$configError = true;
		closeDB( $mysqli );	
	}
	else {
		
		//
		// Initial load, so make sure table is empty
		//
		$query  = "DELETE FROM `Houses`";
		$statement = mysqli_prepare($mysqli, $query);
		mysqli_stmt_execute($statement);
		if ( mysqli_stmt_errno($statement) != 0 ) {
			mysqli_rollback($mysqli);
			$locationsfileload .= " but there was an error loading locations data to the database. Error Message: " . mysqli_stmt_error($statement);
			closeDB( $mysqli );		
			$fileUploadError = 1;
			$configError = true;
		}
		mysqli_stmt_close($statement);
			
		// Iterate through each row of the sheet
		$autoHouseID = 0;
		for ($row = 2; $row <= $highestRow; ++$row) {
			
			$HouseID = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
			if ( trim($HouseID) == '' ) { $HouseID = $autoHouseID++; }
			
			$SiteLicenseNo = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
			$ProviderMA_Number = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
			
			$HouseName = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
			$HouseAddress = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
			$HousePhone = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();

			$FaxNumber = $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();
			$HouseInUse = $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
			
			$Latitude = $sheet->getCellByColumnAndRow(9, $row)->getCalculatedValue();
			$Longitude = $sheet->getCellByColumnAndRow(10, $row)->getCalculatedValue();
			$EmergencyDrillRoot = $sheet->getCellByColumnAndRow(11, $row)->getCalculatedValue();
			
			$emergencyMeetingPlace = $sheet->getCellByColumnAndRow(12, $row)->getCalculatedValue();
			$disasterShelter = $sheet->getCellByColumnAndRow(13, $row)->getCalculatedValue();
			
			$query  = "INSERT INTO `Houses`(`HouseID`, `SiteLicenseNo`, `HouseName`, `HouseAddress`, `HousePhone`, `FaxNumber`, `HouseInUse`,";
			$query .= "  `Latitude`, `Longitude`, `EmergencyDrillRoot`, `emergencyMeetingPlace`, `disasterShelter`, `ProviderMA`) ";
			
			$query .= " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
			if ( $statement = mysqli_prepare($mysqli, $query) ) {
			
				mysqli_stmt_bind_param($statement, 'issssssssssss', $HouseID, $SiteLicenseNo, $HouseName, $HouseAddress, $HousePhone, 
				                                                     $FaxNumber, $HouseInUse, $Latitude, $Longitude, $EmergencyDrillRoot, 
																	 $emergencyMeetingPlace, $disasterShelter, $ProviderMA_Number);
				mysqli_stmt_execute($statement);
				if ( mysqli_stmt_errno($statement) != 0 ) {
					mysqli_rollback($mysqli);
					$locationsfileload .= " but there was an error loading locations data to the database. Error Message: " . mysqli_stmt_error($statement) . "<br>";
					closeDB( $mysqli );		
					$fileUploadError = 1;
					$configError = true;
					$row += $highestRow;
				}
				mysqli_stmt_close($statement);
			}
			else {
				mysqli_rollback($mysqli);
				$locationsfileload .= " but there was an error loading locations data to the database. Error Message: " . mysqli_stmt_error($statement) . "<br>";
				closeDB( $mysqli );		
				$fileUploadError = 1;
				$configError = true;
				$row += $highestRow;
			}
		}
	}
	
	if ( $fileUploadError == 0 ) {
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($mysqli);
		$locationsfileload .= " and locations data was successfully loaded to the database. <br>";
		closeDB( $mysqli );
	}
}
?>

