<?php

// Include the PhpSpreadsheet library
require $_SERVER['DOCUMENT_ROOT'] . '/assets/vendor/autoload.php'; // Assuming you've installed PhpSpreadsheet via Composer

use PhpOffice\PhpSpreadsheet\Reader\Xlsx;

// Connect to MySQL database
$mysqli = loginToDB();

// Check connection
if (mysqli_connect_errno()) {
    $clientsfileload .= "but DB Connection failed: " . mysqli_connect_error();
	$fileUploadError = 1;
	$configError = true;
}

if ( ! file_exists($_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/configurator/loadtables/Clients.xlsx') ) {
	$fileUploadError = 1;
	$configError = true;
	$Stafffileload .= " but there Staff data file was not found. <br>";
	if ( $mysqli ) {
		closeDB( $mysqli );
	}
}

if ( $fileUploadError == 0 ) {

	// Path to your Excel file
	$excelFile = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/configurator/loadtables/Clients.xlsx';
		
	// Load the Excel file
	$reader = new Xlsx();
	$spreadsheet = $reader->load($excelFile);
	
	// Get the active sheet
	$sheet = $spreadsheet->getActiveSheet();
	$highestRow = $sheet->getHighestRow(); // e.g. 10
	
	if ( ! mysqli_begin_transaction( $mysqli, MYSQLI_TRANS_START_READ_WRITE ) ) {
			
		$clientsfileload .= " but there was an error loading client data to the database. Error Message: " . mysqli_error($mysqli);
		$fileUploadError = 1;
		$configError = true;
		closeDB( $mysqli );	
	}
	else {
		
		//
		// Initial load, so make sure table is empty
		//
		$query  = "DELETE FROM `Clients`";
		$statement = mysqli_prepare($mysqli, $query);
		mysqli_stmt_execute($statement);
		if ( mysqli_stmt_errno($statement) != 0 ) {
			mysqli_rollback($mysqli);
			$clientsfileload .= " but there was an error loading client data to the database. Error Message: " . mysqli_stmt_error($statement);
			closeDB( $mysqli );		
			$fileUploadError = 1;
			$configError = true;
		}
		mysqli_stmt_close($statement);
					
		// Iterate through each row of the sheet
		$autoClientID = 1;
		$autoHouseID = MANAGEMENT;
		$autoCCS_StaffID = NO_CCS_STAFF;
		$autoSchoolID = NO_SCHOOL_ASSIGNED;
	
		for ($row = 2; $row <= $highestRow && ! $configError; $row++ ) {
			
			$ClientID = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
			if ( trim($ClientID) == '' ) { $ClientID = $autoClientID++; }
			
			$HouseID = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
			//if ( trim($HouseID) == '' ) { $HouseID = $autoHouseID; }
			
			$CCS_StaffID = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
			if ( trim($CCS_StaffID) == '' ) { $CCS_StaffID = $NO_CCS_STAFF; }
			
			$SchoolID = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
			if ( trim($SchoolID) == '' ) { $SchoolID = $autoSchoolID; }
			
			$CCS_StaffAsignDate = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
			$unixTimeStamp = ($CCS_StaffAsignDate - 25569) * 86400;
			$CCS_StaffAsignDate = "" . date('Y-m-d', $unixTimeStamp) . "";
						
			$ClientFname = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
			$ClientLname = $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();
			$ClientGender = $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
			$ClientAdmisionDate = $sheet->getCellByColumnAndRow(9, $row)->getCalculatedValue();
			$unixTimeStamp = ($ClientAdmisionDate - 25569) * 86400;
			$ClientAdmisionDate = "" . date('Y-m-d', $unixTimeStamp) . "";
						
			$AdultAdmitDate = $sheet->getCellByColumnAndRow(10, $row)->getCalculatedValue();
			$unixTimeStamp = ($AdultAdmitDate - 25569) * 86400;
			$AdultAdmitDate = "" . date('Y-m-d', $unixTimeStamp) . "";
			
			$DayAdmitDate = $sheet->getCellByColumnAndRow(11, $row)->getCalculatedValue();
			$unixTimeStamp = ($DayAdmitDate - 25569) * 86400;
			$DayAdmitDate = "" . date('Y-m-d', $unixTimeStamp) . "";
		
			$ClientSSN = $sheet->getCellByColumnAndRow(12, $row)->getCalculatedValue();
			if (preg_match('/[a-zA-Z]/', $ClientSSN)) {
				$ClientSSN = "" . sql_quote( $mysqli, $ClientSSN ) . "";
			}
			else {
				$ClientSSN = "" . sql_quote( $mysqli, encrypt($ClientSSN )) . "";
			}
			$ClientBirthDate = $sheet->getCellByColumnAndRow(13, $row)->getCalculatedValue();
			$unixTimeStamp = ($ClientBirthDate - 25569) * 86400;
			$ClientBirthDate = "" . date('Y-m-d', $unixTimeStamp) . "";
			
			$ParentName = $sheet->getCellByColumnAndRow(14, $row)->getCalculatedValue();
			$ParentPhone = $sheet->getCellByColumnAndRow(15, $row)->getCalculatedValue();
			
			$ParentEmail = $sheet->getCellByColumnAndRow(16, $row)->getCalculatedValue();
			$ClientLtssID = $sheet->getCellByColumnAndRow(17, $row)->getCalculatedValue();
			
			$ClientCaseNum = $sheet->getCellByColumnAndRow(18, $row)->getCalculatedValue();			
			
			$ClientMedicaidNum = $sheet->getCellByColumnAndRow(19, $row)->getCalculatedValue();
			
			$ClientRootDir = trim($ClientFname) . '_' . trim($ClientLname);
			
			$IsAwakeOvernight = $sheet->getCellByColumnAndRow(25, $row)->getCalculatedValue();
			if ( trim($IsAwakeOvernight) == '' ) { $IsAwakeOvernight = 'N'; }
			
			$IsEmpScvClient = $sheet->getCellByColumnAndRow(26, $row)->getCalculatedValue();
			if ( trim($IsEmpScvClient) == '' ) { $IsEmpScvClient = 'N'; }
			
			$PharmacyID = $sheet->getCellByColumnAndRow(27, $row)->getCalculatedValue();
			
			//$query  = "INSERT INTO `Clients`( `ClientID`, `HouseID`, `CCS_StaffID`, `SchoolID`, `CCS_StaffAsignDate`, ";
			$query  = "INSERT INTO `Clients`( `ClientID`, `CCS_StaffID`, `SchoolID`, `CCS_StaffAsignDate`, ";
			$query .= " `ClientFname`, `ClientLname`, `ClientGender`, `ClientAdmisionDate`, `AdultAdmitDate`, ";
			$query .= " `DayAdmitDate`, `ClientSSN`, `ClientBirthDate`, `ParentName`, `ParentPhone`, `ParentEmail`, `ClientLtssID`, ";
			$query .= " `ClientCaseNum`, `ClientMedicaidNum`, `ClientRootDir`,  `IsAwakeOvernight`, `IsEmpScvClient`, `PharmacyID` )";
			$query .= " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
			if ( $statement = mysqli_prepare($mysqli, $query) ) {
			
				mysqli_stmt_bind_param($statement, 'iiissssssssssssssssssi', 
				                                    //$ClientID, $HouseID, $CCS_StaffID, $SchoolID, $CCS_StaffAsignDate,
													$ClientID, $CCS_StaffID, $SchoolID, $CCS_StaffAsignDate,
													$ClientFname, $ClientLname, $ClientGender, $ClientAdmisionDate, 
													$AdultAdmitDate, $DayAdmitDate, $ClientSSN, $ClientBirthDate, $ParentName, 
													$ParentPhone, $ParentEmail, $ClientLtssID, $ClientCaseNum, 
													$ClientMedicaidNum, $ClientRootDir,  $IsAwakeOvernight, $IsEmpScvClient, $PharmacyID);
				mysqli_stmt_execute($statement);
				if ( mysqli_stmt_errno($statement) != 0 ) {
					mysqli_rollback($mysqli);
					$clientsfileload .= " but there was an error loading client data to the database. Error Message: " . mysqli_stmt_error($statement);
					closeDB( $mysqli );		
					$fileUploadError = 1;
					$configError = true;
					$row += $highestRow;
				}
				mysqli_stmt_close($statement);
			}
			else {
				mysqli_rollback($mysqli);
				$clientsfileload .= " but there was an error loading client data to the database. Error Message: " . mysqli_stmt_error($statement);
				closeDB( $mysqli );		
				$fileUploadError = 1;
				$configError = true;
				$row += $highestRow;
			}
		}
	}
	
	if ( $fileUploadError == 0 ) {
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($mysqli);
		$clientsfileload .= " and client data was successfully loaded to the database. ";
		closeDB( $mysqli );
	}
}
?>

