<?php

// Include the PhpSpreadsheet library
require $_SERVER['DOCUMENT_ROOT'] . '/assets/vendor/autoload.php'; // Assuming you've installed PhpSpreadsheet via Composer

use PhpOffice\PhpSpreadsheet\Reader\Xlsx;

// Connect to MySQL database
$mysqli = loginToDB();

// Check connection
if (mysqli_connect_errno()) {
    $clientsfileload .= "but DB Connection failed: " . mysqli_connect_error();
	$fileUploadError = 1;
	$configError = true;
}

if ( ! file_exists($_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/configurator/loadtables/CCS_Staff.xlsx') ) {
	$fileUploadError = 1;
	$configError = true;
	$Stafffileload .= " but there Staff data file was not found. <br>";
	if ( $mysqli ) {
		closeDB( $mysqli );
	}
}

if ( $fileUploadError == 0 ) {

	// Path to your Excel file
	$excelFile = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/configurator/loadtables/CCS_Staff.xlsx';
	
	// Load the Excel file
	$reader = new Xlsx();
	$spreadsheet = $reader->load($excelFile);
	
	// Get the active sheet
	$sheet = $spreadsheet->getActiveSheet();
	$highestRow = $sheet->getHighestRow(); // e.g. 10
	
	if ( ! mysqli_begin_transaction( $mysqli, MYSQLI_TRANS_START_READ_WRITE ) ) {
			
		$CCSstafffileload .= " but there was an error loading CCS staff data to the database. Error Message: " . mysqli_error($mysqli) . "<br>";
		$fileUploadError = 1;
		$configError = true;
		closeDB( $mysqli );	
	}
	else {
		
		//
		// Initial load, so make sure table is empty
		//
		$query  = "DELETE FROM `CCS_Staff`";
		$statement = mysqli_prepare($mysqli, $query);
		mysqli_stmt_execute($statement);
		if ( mysqli_stmt_errno($statement) != 0 ) {
			mysqli_rollback($mysqli);
			$CCSstafffileload .= " but there was an error loading CCS staff data to the database. Error Message: " . mysqli_stmt_error($statement);
			closeDB( $mysqli );		
			$fileUploadError = 1;
			$configError = true;
		}
		mysqli_stmt_close($statement);
			
		// Iterate through each row of the sheet
		$autoID = 1;
		$uname = 1;
		
		for ($row = 2; $row <= $highestRow; ++$row) {
			
			$CCS_StaffID = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
			if ( trim($CCS_StaffID) == '' ) { $CCS_StaffID = $autoID++; }
			
			$CCS_StaffName = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
			$nameParts = explode( " ", str_replace( "-_.,", " ", $CCS_StaffName ) );
			
			$Username = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
			$Password = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
						
			if ( trim($Username) == '' ) {
				$Username = strtolower( substr($nameParts[0], 0, 1) . $nameParts[count($nameParts)-1] );
			}
			
			$query = "SELECT count(*) as cnt FROM `CCS_Staff` WHERE `Username` = '" . trim($Username) . "'";
			$result = mysqli_query( $mysqli, $query  );		
				
			if ( mysqli_errno($mysqli) != 0 ) {
			
				mysqli_rollback($mysqli);
				$CCSstafffileload .= " but there was an error loading CCS staff data to the database. Error Message: " . mysqli_srror($mysqli) . "<br>";
				$fileUploadError = 1;
				$configError = true;
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );					
				break;
			}
			$datarow = mysqli_fetch_assoc( $result );
			if ( $datarow['cnt'] > 0 ) {
				$Username .= $datarow['cnt'];
			}
			
			//if ( trim($Password) == '' ) {
			//	$Password = password_hash( sql_quote( $mysqli, trim( $Username )), PASSWORD_DEFAULT );
			//}
			
			//if ( trim($Password) == '' ) {
			//	$Password = trim( $Username );
			//}
			$Password = password_hash( sql_quote( $mysqli, trim( $Username )), PASSWORD_DEFAULT );
						
			$Address = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
			$City = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
			$State = $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();
			
			$ZipCode = $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
			$CCS_StaffPhone = $sheet->getCellByColumnAndRow(9, $row)->getCalculatedValue();
			$CCS_StaffCell = $sheet->getCellByColumnAndRow(10, $row)->getCalculatedValue();
			
			$CCS_StaffFax = $sheet->getCellByColumnAndRow(11, $row)->getCalculatedValue();
			$CCS_StaffEmail = $sheet->getCellByColumnAndRow(12, $row)->getCalculatedValue();
			$CCS_StaffSupervisor = $sheet->getCellByColumnAndRow(13, $row)->getCalculatedValue();
																	 
			$CCS_StaffSupervisorPhone = $sheet->getCellByColumnAndRow(14, $row)->getCalculatedValue();
			$ssType = $sheet->getCellByColumnAndRow(15, $row)->getCalculatedValue();
				
			$Status = $sheet->getCellByColumnAndRow(16, $row)->getCalculatedValue();
			$StatusDate = $sheet->getCellByColumnAndRow(17, $row)->getCalculatedValue();
			
			$StatusReason = $sheet->getCellByColumnAndRow(18, $row)->getCalculatedValue();
			$PswdReset = $sheet->getCellByColumnAndRow(19, $row)->getCalculatedValue();
			$PswdReset = 'N';
					
			$IsConfirmed = $sheet->getCellByColumnAndRow(20, $row)->getCalculatedValue();
			$LastLoginDate = $sheet->getCellByColumnAndRow(21, $row)->getCalculatedValue();
			$unixTimeStamp = ($LastLoginDate - 25569) * 86400;
			$LastLoginDate = "" . date('Y-m-d', $unixTimeStamp) . "";
						
			$LastLoginTime = $sheet->getCellByColumnAndRow(22, $row)->getCalculatedValue();
			$unixTimeStamp = ($LastLoginTime - 25569) * 86400;
			$LastLoginTime = "" . date('H:i:s', $unixTimeStamp) . "";

			$query  = "INSERT INTO `CCS_Staff`(`CCS_StaffID`, `CCS_StaffName`, `Username`, `Password`, `Address`, `City`, `State`, ";
			$query .= " `ZipCode`, `CCS_StaffPhone`, `CCS_StaffCell`, `CCS_StaffFax`, `CCS_StaffEmail`, `CCS_StaffSupervisor`, ";
			$query .= " `CCS_StaffSupervisorPhone`, `ssType`, `Status`, `StatusDate`, `StatusReason`, `PswdReset`, `IsConfirmed`, ";
			$query .= " `LastLoginDate`, `LastLoginTime`) ";
			$query .= " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
			if ( $statement = mysqli_prepare($mysqli, $query) ) {
			
				mysqli_stmt_bind_param($statement, 'isssssssssssssssssssss', $CCS_StaffID, $CCS_StaffName, $Username, $Password, $Address, 
				                                                     $City, $State, $ZipCode, $CCS_StaffPhone, $CCS_StaffCell, $CCS_StaffFax, 
																	 $CCS_StaffEmail, $CCS_StaffSupervisor, $CCS_StaffSupervisorPhone, 
																	 $ssType, $Status, $StatusDate, $StatusReason, $PswdReset, $IsConfirmed, 
																	 $LastLoginDate, $LastLoginTime );
				mysqli_stmt_execute($statement);
				if ( mysqli_stmt_errno($statement) != 0 ) {
					mysqli_rollback($mysqli);
					$CCSstafffileload .= " but there was an error loading CCS staff data to the database. Error Message: " . mysqli_stmt_error($statement) . "<br>";
					closeDB( $mysqli );		
					$fileUploadError = 1;
					$configError = true;
					$row += $highestRow;
				}
				mysqli_stmt_close($statement);
			}
			else {
				mysqli_rollback($mysqli);
				$CCSstafffileload .= " but there was an error loading CCS staff data to the database. Error Message: " . mysqli_stmt_error($statement) . "<br>";
				closeDB( $mysqli );		
				$fileUploadError = 1;
				$configError = true;
				$row += $highestRow;
			}
		}
	}
	
	if ( $fileUploadError == 0 ) {
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($mysqli);
		$CCSstafffileload .= " and CCS staff data was successfully loaded to the database. <br>";
		closeDB( $mysqli );
	}
}
?>

