<?php
	
	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
	
	$config = getConfigFromDB();
		
	$updtMessage = $config[1];
	if ( $config[0] == SUCCESS ) {

		$bodmembers = $config[1][4];
				
		if ( is_array($bodmembers) && count($bodmembers) <= 0 ) {
						
			$updtMessage = "Sorry, the system did not find any Board of Directors.";
			$isFail = true;
			$step = 1;
		}
	}
	else {
		$isFail = true;
		$step = 1;
	}
		
	if ( $step == 2 )
	{
		$saveRtn = saveBODMinutes( $_REQUEST );
		
		$updtMessage = $saveRtn[1];
		if ( $saveRtn[0] == SUCCESS ) {
			$updtMessage = "Board of Directors Minutes successfully saved.";
			$isFail = false;
		}
		else {
			$isFail = true;
		}
		$step = 1;
	}
	
	if ( $step == 1 ) { 
	
?>
<form id="bodnotes" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/bod-corner/index/dest/<?php echo $dest; ?>/step/2/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo  $BOD_CORNER_BREADCRUMB[$dest]; ?></h5>
			   <?php if ( isset($isFail) ) { ?>
			   		<div class="row mt-3 mb-3">
						<div class="col-md-1"></div>
						<div class="col-md-10 col-sm-offset-1 text-center">
							  <div class="alert  <?php echo ( $isFail === false ) ? "alert-success" : "alert-danger"; ?> text-center mb-1">
								<h4>
								<?php 
									echo $updtMessage;
								?>
								</h4>
								</div>
						</div>
						<div class="col-md-1"></div>
					</div>
			   <?php } ?>
              <!-- Floating Labels Form -->
			  
			  <div class="row">
					<div class="col-md-4">
					  <div class="form-floating mt-3">
							<select class="form-select js-select" name="minutestaker" id="minutestaker" aria-label="Minutes Taker" required>
								  <option selected disabled value="">Choose the Minutes Taker </option>
								  <?php for( $i = 0; $i < count($bodmembers); $i++ ) { ?>
								  <option value="<?php echo $bodmembers[$i]['Director']; ?>"><?php echo $bodmembers[$i]['Director']; ?></option>
								  <?php } ?>
							</select>
							<label  class="slct2" for="minutestaker">Minutes Taker</label>
							<div class="invalid-feedback">
								Please select a Minutes Taker.
							</div>
					  	</div>
                	</div>	
					<div class="col-md-4 position-relative">
					  <div class="form-floating mt-3 input-group" id='div_currentdate' data-td-target-input='nearest' data-td-target-toggle='nearest'>
						<input type="text" class="form-control" name="currentdate" id="currentdate" placeholder="Staff Hire Date"  data-td-target='#div_currentdate' required />
						<label   class="form-label" for="currentdate">Current Meeting Date</label>
						<span class='input-group-text' data-td-target='#div_currentdate' data-td-toggle='datetimepicker'>
							 <span class='bi bi-calendar-date fs-3'></span>
						  </span>
						<div class="invalid-feedback">
							Please provide the Current Meeting Date.
						</div>
					  </div>
                	</div>
					<div class="col-md-4 position-relative">
					  <div class="form-floating mt-3 input-group" id='div_nextdate' data-td-target-input='nearest' data-td-target-toggle='nearest'>
						<input type="text" class="form-control" name="nextdate" id="nextdate" placeholder="Staff Hire Date"  data-td-target='#div_nextdate' />
						<label   class="form-label" for="nextdate">Next Meeting Date</label>
						<span class='input-group-text' data-td-target='#div_nextdate' data-td-toggle='datetimepicker'>
							 <span class='bi bi-calendar-date fs-3'></span>
						  </span>
						<div class="invalid-feedback">
							Please provide the Next Meeting Date.
						</div>
					  </div>
                	</div>
			</div>
			
			<div class="row">
					<div class="col-md-4 mt-5">
						<h5>Meeting Attendance</h5>
                	</div>	
					<div class="col-md-4 position-relative">
                	</div>
					<div class="col-md-4 position-relative">
                	</div>
			</div>
			
			<?php
				for ( $i = 0; $i < count($bodmembers); $i++ ) {
			?>
		    <div class="row align-items-center">
					<div class="col-md-3">
					  <div class="form-floating mt-2 ">
							<?php echo $bodmembers[$i]['Director']; ?>
							<input type="hidden" name="director[]"  class="director-<?php echo $i; ?>" value ="<?php echo $bodmembers[$i]['Director']; ?>" />
					  	</div>
                	</div>	
					<div class="col-md-3">
					  <div class="form-floating mt-2 d-flex flex-column justify-content-center">
							<?php echo $bodmembers[$i]['Title']; ?>
							<input type="hidden" name="position[]" value ="<?php echo $bodmembers[$i]['Title']; ?>" />
					  	</div>
                	</div>	
					<div class="col-md-3">
					  <div class="form-floating mt-2">
							<select class="form-select js-select" name="attended[]" id="attended-<?php echo $i; ?>" aria-label="Attended Meeting" required>
								  <option selected disabled value="">Choose Attendance </option>
								  <option value="Y">Yes </option>
								  <option value="N">No </option>
							</select>
							<label  for="attended-<?php echo $i; ?>">Attended Meeting?</label>
							<div class="invalid-feedback">
								Please select attendance.
							</div>
					  	</div>
                	</div>
					<div class="col-md-3">
					  <div class="form-floating mt-2">
							<select class="form-select js-select" name="attendmethod[]" id="attendmethod-<?php echo $i; ?>" aria-label="Attendance Method" required>
								  <option selected disabled value="">Choose Method </option>
								  <option value="In Person">In Person </option>
								  <option value="Phone/Zoom">Phone/Zoom </option>
								  <option value="Absent">Absent </option>
							</select>
							<label  for="attendmethod-<?php echo $i; ?>">Attendance Method</label>
							<div class="invalid-feedback">
								Please select attendance method.
							</div>
					  	</div>
                	</div>	
			</div>
			
			<?php } ?>
			
			<div class="row">
					<div class="col-md-12">
					  <div class="form-floating mt-3">
							<textarea class="form-control tinymce-editor" name="meeting_notes" id="meeting_notes" placeholder="Meeting Minutes"  aria-label="Meeting Minutes" style="height: 100px" required>
								 
							</textarea>
							<label  for="attended-<?php echo $i; ?>">Meeting Minutes</label>
							<div class="invalid-feedback">
								Please provide Meeting Minutes.
							</div>
					  	</div>
                	</div>
			</div>
								
			<div class="text-center mt-5 mb-5">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Post Board Minutes</button>
                </div>	
 			</div>
	   </div>
		
	</form>	
<?php 
	}
?>
		