function militartTimeToStandard( time )
{
	time = time.split(':'); // convert to array

	// fetch
	var hours = Number(time[0]);
	var minutes = Number(time[1]);
	
	// calculate
	var timeValue;
	
	if (hours > 0 && hours <= 12) {
	  timeValue= "" + hours;
	} else if (hours > 12) {
	  timeValue= "" + (hours - 12);
	} else if (hours == 0) {
	  timeValue= "12";
	}
	 
	timeValue += (minutes < 10) ? ":0" + minutes : ":" + minutes;  // get minutes
	timeValue += (hours >= 12) ? " PM" : " AM";  // get AM/PM

	return( timeValue );
}

function deltaDate(input, days, months, years) {
	return new Date(
	  input.getFullYear() + years, 
	  input.getMonth() + months, 
	  Math.min(
		input.getDate() + days,
		new Date(input.getFullYear() + years, input.getMonth() + months + 1, 0).getDate()
	  )
	);
}
	
	
var thisMonth = new Date();
var thisMonthLess3 = deltaDate( thisMonth, 0, -3, 0 );
	
	
$(document).ready(function() {								
	
		if ( $('#div_seizureDate').length > 0 ) {
			new tempusDominus.TempusDominus(document.getElementById('div_seizureDate'), {
			   display: {
				 viewMode: 'calendar',
				 components: {
				   decades: true,
				   year: true,
				   month: true,
				   date: true,
				   hours: false,
				   minutes: false,
				   seconds: false,
				 },
				 icons: {
				   time: 'bi bi-clock',
				   up: 'bi bi-arrow-up',
				   down: 'bi bi-arrow-down',
				   previous: 'bi bi-chevron-left',
				   next: 'bi bi-chevron-right',
				   clear: 'bi bi-trash-fill',
				   close: 'bi bi-x-lg',
				 },
				 buttons: {
				   today: true,
				   clear: true,
				   close: true,
				 },
			   },
			   restrictions: {
					minDate: new Date(thisMonthLess3.getFullYear(), thisMonthLess3.getMonth(), 1 ),
					maxDate: new Date(thisMonth.getFullYear(), thisMonth.getMonth() + 1, thisMonth.getDate() ),
			   },
			   localization: {
		   format: 'MM/dd/yyyy',
	   },
		useCurrent: true,
			 });
		}
	
	$(".timeOfDay").each( function() {
		 	
		var fieldID = $(this).attr("id");
		
		//$('#smryHour-'+fieldID).val($(this).val());
		//$('#tdSmryHour-'+fieldID).text( militartTimeToStandard( $(this).val() ));
	
		new tempusDominus.TempusDominus(document.getElementById(fieldID), {
		   display: {
			 viewMode: 'clock',
			 components: {
			   decades: false,
			   year: false,
			   month: false,
			   date: false,
			   hours: true,
			   minutes: true,
			   seconds: false
			 },
			 icons: {
			   time: 'bi bi-clock',
			   up: 'bi bi-arrow-up',
			   down: 'bi bi-arrow-down',
			   previous: 'bi bi-chevron-left',
			   next: 'bi bi-chevron-right',
			   clear: 'bi bi-trash-fill',
			   close: 'bi bi-x-lg',
			 },
			 buttons: {
			   clear: true,
			   close: true,
			 },
		   },
			localization: {
					   format: 'hh:mm T',
				   },
		useCurrent: false,
		 });
	 });	
	
	 $( '#program,#resident' ).select2( {
		theme: "bootstrap-5",
		placeholder: $( this ).data( 'placeholder' ),
		width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
	 });
		
		$('#agency,#physician').focus( function() {
			$(this).select();
		});
		
		$('#seizure1').submit( function() {
			
			var whichDate;
			
			if( $('#seizureDate').val().trim() == '' ) {
				$('#trerrmsg').show();
				$('#errmsg').text( "Seizure Date cannot be blank");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
			
			if ( $("#program")[0].selectedIndex == 0 ) 
			{
				$('#trerrmsg').show();
				$('#errmsg').text( "Please select a program, it is mandatory");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
						
			if ( $("#resident")[0].selectedIndex == 0 ) 
			{
				$('#trerrmsg').show();
				$('#errmsg').text( "Please select a resident, it is mandatory");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
			
			return true;
		});
		
		$('#seizure2').submit( function() {
						
			if( $('#agency').val().trim().length == 0 ) {
				$('#trerrmsg').show();
				$('#errmsg').text( "Agency cannot be blank");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
			
			if( $('#physician').val().trim().length == 0 ) {
				$('#trerrmsg').show();
				$('#errmsg').text( "Agency cannot be blank");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
			
			if( $('.seizureChk:checked').length <= 0 ) {
				$('#trerrmsg').show();
				$('#errmsg').text( "No description, body movements nor behavior after seizure selected");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
			
			if( $('.timeOfDay').val().trim().length == 0 ) {
				$('#trerrmsg').show();
				$('#errmsg').text( "Time of Day cannot be blank");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
			
			if( $('.textDuration').val().trim().length == 0 ) {
				$('#trerrmsg').show();
				$('#errmsg').text( "Duration cannot be blank");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
			
			if( $('.smryDate').val().trim().length == 0 ) {
				$('#trerrmsg').show();
				$('#errmsg').text( "Date cannot be blank");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
			
			if( $('.smryHour').val().trim().length == 0 ) {
				$('#trerrmsg').show();
				$('#errmsg').text( "Hour cannot be blank");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
			
			if( $('.smryNotes').val().trim().length == 0 ) {
				$('#trerrmsg').show();
				$('#errmsg').text( "Notes/Comments cannot be blank");
				$('#errmsg').css({"color":"#ffffff"});
				return false;
			}
						
			return true;
		});
		
		 $(".timeOfDay").change( function() {
		 	var fieldID = ( $(this).attr("id").split("-") )[1];
			
			//alert($(this).val());
			
			$('#smryHour-'+fieldID).val($(this).val());
			//alert($('#smryHour-'+fieldID).val());
			$('#tdSmryHour-'+fieldID).text( $(this).val() );
			//$('#tdSmryHour-'+fieldID).text( militartTimeToStandard( $(this).val() ));
		 });
		 
		 $("#program").change( function() {
										
		 	//alert("Program hanged");
		 
		 		// Populate Region select using ajax
				var programCd  = $(this).val();
				var programHouse = $("#houseID").val();
							
				// Create our XMLHttpRequest object
				var programchr = new XMLHttpRequest();
				
				// Create some variables we need to send to our PHP file
				var url = "/assets/ajaxphp/getProgramUsers.php";
				url = url + "?programCd="+programCd
				url = url + "&programHouse="+programHouse;
				
				//alert(url);
				
				programchr.open("GET", url, true);
				
				// Set content type header information for sending url encoded variables in the request
				programchr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
				
				// Access the onreadystatechange event for the XMLHttpRequest object
				programchr.onreadystatechange = function() {		 
					if(programchr.readyState == 4 && programchr.status == 200) {
						var return_data = programchr.responseText;
						//alert(return_data);
									
						var programUsers = JSON.parse(return_data);
						//alert(programUsers);
						
						$('#resident').empty();
						for ( var j = 0; j < programUsers.length; j++ ) {
							$('#resident').append('<option value="'  + programUsers[j].ClientID + '">' + programUsers[j].ClientName  + '</option>');
						}
						var options = $('#resident option');
						var arr = options.map(function(_, o) { return { t: $(o).text(), v: o.value }; }).get();
						arr.sort(function(o1, o2) { return o1.t > o2.t ? 1 : o1.t < o2.t ? -1 : 0; });
						options.each(function(i, o) {
							o.value = arr[i].v;
							$(o).text(arr[i].t);
						});
						$('#resident').prepend('<option selected disabled value="">Select a Resident</option>');
					}
				}
				
				// Send the data to PHP now... and wait for response to update the status div
				programchr.send(null); // Actually execute the request
		 
		 });
	
});

	
