$(document).ready(function() {								

	var numMeds = $('#numMeds').val();
	var submitbtn = "";
	
	$("#disc-error-msg").hide();
	
	for ( var i = 0; i < numMeds; i++ ) 
	{
		new tempusDominus.TempusDominus(document.getElementById('div_discDate'+i), {
		   display: {
			 viewMode: 'calendar',
			 components: {
			   decades: true,
			   year: true,
			   month: true,
			   date: true,
			   hours: false,
			   minutes: false,
			   seconds: false,
			 },
			 icons: {
			   time: 'bi bi-clock',
			   up: 'bi bi-arrow-up',
			   down: 'bi bi-arrow-down',
			   previous: 'bi bi-chevron-left',
			   next: 'bi bi-chevron-right',
			   clear: 'bi bi-trash-fill',
			   close: 'bi bi-x-lg',
			 },
			 buttons: {
			   today: true,
			   clear: true,
			   close: true,
			 },
		   },
			localization: {
		   format: 'MM/dd/yyyy',
	   },
		useCurrent: false,
		 });
	}
	
	$( '#programID,#clientID' ).select2( {
		theme: "bootstrap-5",
		placeholder: $( this ).data( 'placeholder' ),
		width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
		//allowClear: true
	} );
	
	$("#programID").change(function() {
						
		// Populate Region select using ajax
		var programID  = $(this).val();
	
		// Create our XMLHttpRequest object
		var programchr = new XMLHttpRequest();
		
		// Create some variables we need to send to our PHP file
		var url = "/assets/ajaxphp/getProgramClients.php";
		var vars = "programID="+programID;
		programchr.open("POST", url, true);
		
		// Set content type header information for sending url encoded variables in the request
		programchr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		
		// Access the onreadystatechange event for the XMLHttpRequest object
		programchr.onreadystatechange = function() {		 
			if(programchr.readyState == 4 && programchr.status == 200) {
				var return_data = programchr.responseText;
								
				//alert( return_data );
				var programObj = JSON.parse(return_data)[1];
			
				//alert( programObj.length ); 
				$('#clientID').empty();
				for ( var j = 0; j < programObj.length; j++ ) {
					$('#clientID').append('<option value="'  + programObj[j].ClientID + '">' + programObj[j].ClientName  + '</option>');
				}
				var options = $('#clientID option');
				var arr = options.map(function(_, o) { return { t: $(o).text(), v: o.value }; }).get();
				arr.sort(function(o1, o2) { return o1.t > o2.t ? 1 : o1.t < o2.t ? -1 : 0; });
				options.each(function(i, o) {
					o.value = arr[i].v;
					$(o).text(arr[i].t);
				});
				$('#clientID').prepend('<option selected disabled value="">Choose a ' + $('#clientTag').val() + '</option>');
			}
		}
		
		// Send the data to PHP now... and wait for response to update the status div
		programchr.send(vars); // Actually execute the request
		
	});
	
	
	$('#allmedschecked').click( function() {						  
			for ( var i = 0; i < numMeds; i++ ) 
			{
				if ( $('#allmedschecked').is(':checked') ) {
					$('#medID'+i).prop("checked", true);
					$('#selectedMedID'+i).val($('#medID'+i).val());
				}
				else {
					$('#medID'+i).prop("checked", false);
					$('#selectedMedID'+i).val(0);
				}
			}
	});
	
	
	$('.discmedchk').click( function() {						  
		$('.discmedchk').each( function(){
			var idNo = $(this).prop('id').replace(/\D/g,'')
			if ( $(this).is(':checked') ) {
				$("#disc-error").hide();
				$('#selectedMedID'+idNo).val($('#medID'+idNo).val());
				if ( $('#meddelete').is(':checked') ) {
					$('#discDate'+idNo).prop("required", false);
					$('#disccmnts'+idNo).prop("required", false);
				}
				else {
					$('#discDate'+idNo).prop("required", true);
					$('#disccmnts'+idNo).prop("required", true);
				}
			}
			else {
				$('#selectedMedID'+idNo).val(0);
				$('#allmedschecked').prop("checked", false);
				$('#discDate'+idNo).prop("required", false);
				$('#disccmnts'+idNo).prop("required", false);
			}
		});
	});
	
	
	$('#meddelete').click( function() {
									
		if ( $(this).is(':checked') ) {
			$("#edit-error,#edit-error-msg").hide();
			for ( var i = 0; i < numMeds; i++ ) 
			{
				$("#discDate"+i).prop("required", false);
				$("#disccmnts"+i).prop("required", false);
			}
			$("#discontinueit").prop("disabled", false);
		}
	});
	
	$('#meddisc').click( function() {
		
		if ( $(this).is(':checked') ) {
			$("#edit-error,#edit-error-msg").hide();
			for ( var i = 0; i < numMeds; i++ ) 
			{
				if ( $('#medID'+i).is(':checked') ) {
					$("#discDate"+i).prop("required", true);
					$("#disccmnts"+i).prop("required", true);
				}
			}
			$("#discontinueit").prop("disabled", false);
		}
	});
	
	$('#discmed').submit( function() {	
			
		if ( ( $('#programID').val() == null ) || ( $('#programID').val() == "" ) || ( $('#programID').selectedIndex == 'undefined' ) ) {
			return false;
		}
		
		if ( ( $('#clientID').val() == null ) || ( $('#clientID').val() == "" ) || ( $('#clientID').selectedIndex == 'undefined' ) ) {
			return false;
		}
		return true;
 	});
	
	$('#discmed2').submit( function() {	
		
		if ( $('input[type="checkbox"]:checked').length == 0 ) {
			$("#disc-error").show();
			$("#disc-error-msg").show();
			$("#disc-error-msg").html("<h4>Nothing to do as no medications were selected.</h4>");
			return false;
		}
		
		if ( $('input[type="radio"]:checked').length == 0 ) {
			$("#disc-error").show();
			$("#disc-error-msg").show();
			$("#disc-error-msg").html("<h4>Please selelct action ( Discontinue or Delete ) to take.</h4>");
			return false;
		}
		
		for ( var i = 0; i < numMeds; i++ ) 
		{
			if ( $('#medID'+i).is(':checked') ) {
					
				if ( $('#meddisc').is(':checked') ) {
					if ( ( $('#discDate'+i).val() == null ) || ( $('#discDate'+i).val().trim() == "" ) ) {
						return false;
					}
					if ( ( $('#disccmnts'+i).val() == null ) || ( $('#disccmnts'+i).val().trim() == "" ) ) {
						return false;
					}
				}
			}
		}
		return true;
 	});

});

	
	



