
$(document).ready(function() {								
	
	$("[rel=tooltip]").tooltip({ placement: 'left'});

	$( '#ResolvedBy' ).select2( {
		theme: "bootstrap-5",
		placeholder: $( this ).data( 'placeholder' ),
		width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
		//allowClear: true
	} );
	
	if ( $('#div_ResolutionDate').length ) {
		new tempusDominus.TempusDominus(document.getElementById('div_ResolutionDate'), {
		   display: {
			 viewMode: 'calendar',
			 components: {
			   decades: true,
			   year: true,
			   month: true,
			   date: true,
			   hours: false,
			   minutes: false,
			   seconds: false,
			 },
			 icons: {
			   time: 'bi bi-clock',
			   up: 'bi bi-arrow-up',
			   down: 'bi bi-arrow-down',
			   previous: 'bi bi-chevron-left',
			   next: 'bi bi-chevron-right',
			   clear: 'bi bi-trash-fill',
			   close: 'bi bi-x-lg',
			 },
			 buttons: {
			   today: true,
			   clear: true,
			   close: true,
			 }
		   },
			localization: {
		   format: 'MM/dd/yyyy',
	   },
		useCurrent: false,
		 });
	}
	
	$('#docname').change( function() {
		if ( ( $('#docname').val() == null ) || ( $('#docname').val().trim().length == 0 ) ) {
			$('#docname').val("");
		}	
		else {
			$('#formField').val(  $('#docname').val().trim().toLowerCase().replace(/ /g, '_').replace( /"|'|-|:|;/g, '_' ) );                                     
		}
	});
	
	$('#cprobs').submit( function() {	
		
		if ( ( $('#ProblemSolution').val() == null ) || ( $('#ProblemSolution').val().trim().length == 0 ) ) {
			return false;
		}
		
		if ( ( $('#ResolvedBy').val() == null ) || ( $('#ResolvedBy').val() == "" ) || ( $('#ResolvedBy').selectedIndex == 'undefined' ) ) {
			return false;
		}
		
		if ( ( $('#ResolutionDate').val() == null ) || ( $('#ResolutionDate').val().trim().length == 0 ) ) {
			return false;
		}
		
		if ( ( $('#ResolutionDetails').val() == null ) || ( $('#ResolutionDetails').val().trim().length == 0 ) ) {
			return false;
		}
		

		return true;
		
	});
	
});

	
