$(document).ready(function() {								

	function deltaDate(input, days, months, years) {
		return new Date(
		  input.getFullYear() + years, 
		  input.getMonth() + months, 
		  Math.min(
			input.getDate() + days,
			new Date(input.getFullYear() + years, input.getMonth() + months + 1, 0).getDate()
		  )
		);
	}
	
	var numMeds = $('#numMeds').val();
	var submitbtn = "";
	var thisMonth = new Date();
	var thisMonthLess3 = deltaDate( thisMonth, 0, -3, 0 );
		
	$("#disc-error-msg").hide();
	
	if ( $('#div_attendancemonth').length > 0 ) {
		new tempusDominus.TempusDominus(document.getElementById('div_attendancemonth'), {
		   display: {
			 viewMode: 'years',
			 components: {
			   decades: true,
			   year: true,
			   month: true,
			   date: false,
			   hours: false,
			   minutes: false,
			   seconds: false,
			 },
			 icons: {
			   time: 'bi bi-clock',
			   up: 'bi bi-arrow-up',
			   down: 'bi bi-arrow-down',
			   previous: 'bi bi-chevron-left',
			   next: 'bi bi-chevron-right',
			   clear: 'bi bi-trash-fill',
			   close: 'bi bi-x-lg',
			 },
			 buttons: {
			   today: true,
			   clear: true,
			   close: true,
			 },
		   },
		   restrictions: {
				//minDate: new Date(thisMonthLess3.getFullYear(), thisMonthLess3.getMonth(), 1 ),
				minDate: new Date(thisMonthLess3.getFullYear() - 2, 1, 1 ),
				maxDate: new Date(),
		   },
		   localization: {
			   format: 'MM/yyyy',
		   },
		   useCurrent: true,
		 });
	}
	
	$( '#programID,#houseID' ).select2( {
		theme: "bootstrap-5",
		placeholder: $( this ).data( 'placeholder' ),
		width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
	});
	
	$(".inpAttendance").on( "keyup", function() {	
		var totalInpCtr = 0;
		var idArray = $(this).prop("id").split("-");
		var clientID  = idArray[idArray.length - 1];
		var attmonth  = idArray[idArray.length - 4];
		var attyear = idArray[idArray.length - 2];
		var monthdays = daysInMonth( attmonth, attyear );
		var inpID = "";
		
		for( var d = 1; d <= monthdays; d++ )
		{
			idArray[idArray.length - 3] = ( d < 10 ) ? '0'+d : d;
			inpID = idArray.join("-");
			
			if ( $('#'+inpID).length <= 0 ) { continue; }
			
			if ( $('#'+inpID).val().length > 0 ) {
					totalInpCtr += parseInt($('#'+inpID).val());
			}
			else {
				$('#inpAll-'+clientID).val( "" );
			}
		}

		$('#clientTotal-'+clientID).val( totalInpCtr );			
	});
	
	$(".inpAttendance").blur(function() {	
		var totalInpCtr = 0;
		var idArray = $(this).prop("id").split("-");
		var clientID  = idArray[idArray.length - 1];
		var attmonth  = idArray[idArray.length - 4];
		var attyear = idArray[idArray.length - 2];
		var monthdays = daysInMonth( attmonth, attyear );
		var inpID = "";
		
		for( var d = 1; d <= monthdays; d++ )
		{
			idArray[idArray.length - 3] = ( d < 10 ) ? '0'+d : d;
			inpID = idArray.join("-");
			
			if ( $('#'+inpID).length <= 0 ) { continue; }
			
			if ( $('#'+inpID).val().length > 0 ) {
					totalInpCtr += parseInt($('#'+inpID).val());
			}
			else {
				$('#inpAll-'+clientID).val( "" );
			}
		}

		$('#clientTotal-'+clientID).val( totalInpCtr );
    });
	
	
	$("#checkEverything").click(function() {
		
		$(".chkClientAll").each( function() {
			if ( ! $(this).is(':checked') ) { 
				
			}
			else {
				$(this).prop( "checked", false );
			}
			$(this).trigger( "click" );
			// $('.chkAttendance').prop( "checked", true ); 
		});
	});
	
	$("#uncheckEverything").click(function() {
		
		$(".chkClientAll").each( function() {
			if ( $(this).is(':checked') ) { 
				
			}
			else {
				$(this).prop( "checked", true );
			}
			$(this).trigger( "click" );
			// $('.chkAttendance').prop( "checked", true ); 
		});
	});
	
	$(".chkAttendance").click(function() {						
		var clientID  = $(this).prop("id").split("-")[$(this).prop("id").split("-").length - 1];
		var idArray = $(this).prop("id").split("-");
		var  ele1 = idArray.shift();
		
		var removeOne = -1;
		if ( $(this).is(':checked') ) {
			removeOne = 1;
		}
		if( $('#clientTotal-'+clientID).val().length > 0 ) {
			$('#clientTotal-'+clientID).val( parseInt($('#clientTotal-'+clientID).val()) + removeOne);
		}
		else {
			$('#clientTotal-'+clientID).val(removeOne);
		}
		if( $('#clientTotal-'+clientID).val() == 0 ) {
			$('#clientTotal-'+clientID).val("");
		}
		
		$('#chkAll-'+clientID).prop( "checked", false );
		
    });
	
	$(".chkClientAll").click(function() {						
		var clientID  = $(this).prop("id").split("-")[$(this).prop("id").split("-").length - 1]; 
		var totalCtr = 0;
		if ( $(this).is(':checked') ) {
			$(".chkAll-"+clientID).prop( "checked", true );
			$(".chkAll-"+clientID).each( function() {
				if ( $(this).is(':checked') && $(this).is(':visible') ) { 
					totalCtr += 1;
				}
			});
		}
		else {
			$(".chkAll-"+clientID).prop( "checked", false );
		}
		$('#clientTotal-'+clientID).val( totalCtr );
		if( $('#clientTotal-'+clientID).val() == 0 ) {
			$('#clientTotal-'+clientID).val("");
		}
    });
	
	$(".inpClientAll").blur(function() {	
									 
		var clientID  = $(this).prop("id").split("-")[$(this).prop("id").split("-").length - 1]; 
		var totalCtr = 0;
		
		if ( $.trim($('#inpAll-'+clientID).val()) == "") {
			$('.unitAll-'+clientID).val("");
			$('#clientTotal-'+clientID).val("");
		}
		else {
			$('.unitAll-'+clientID).val($(this).val());
		}
    });
	
	$(".inpClientAll").on( "keyup", function() {	
									 
		var clientID  = $(this).prop("id").split("-")[$(this).prop("id").split("-").length - 1]; 
		var totalCtr = 0;
		
		if ( $.trim($('#inpAll-'+clientID).val()) == "") {
			$('.unitAll-'+clientID).val("");
			$('#clientTotal-'+clientID).val("");
		}
		else {
			$('.unitAll-'+clientID).val($(this).val());
		}
		
		$(".unitAll-"+clientID).each( function() {
			if ( $(this).val() == "" ) { 
			}
			else {
				totalCtr += parseInt($(this).val());
			}
		});
		
		$('#clientTotal-'+clientID).val( totalCtr );
		if( $('#clientTotal-'+clientID).val() == 0 ) {
			$('#clientTotal-'+clientID).val("");
		}
    });
	
	$("#programID").change(function() {
						
		// Populate Region select using ajax
		var programID  = $(this).val();
	
		//if ( programID == 5 || programID == 6 ) {
		//	$('#houseID').prop( "required", true );
		//}
		//else {
		//	$('#houseID').prop( "required", false );
		//} 
		
		// Create our XMLHttpRequest object
		var programchr = new XMLHttpRequest();
		
		// Create some variables we need to send to our PHP file
		var url = "/assets/ajaxphp/getProgramHouses.php";
		url = url + "?programID="+programID;
		programchr.open("GET", url, true);
				
				//alert(url);
		// Set content type header information for sending url encoded variables in the request
		programchr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		
		// Access the onreadystatechange event for the XMLHttpRequest object
		programchr.onreadystatechange = function() {		 
			if(programchr.readyState == 4 && programchr.status == 200) {
				var return_data = programchr.responseText;
							
				//alert(return_data);
				
				var programObj = JSON.parse(return_data);
				
			
				$('#houseID').empty();
				for ( var j = 0; j < programObj.length; j++ ) {
					$('#houseID').append('<option value="'  + programObj[j].HouseID + '">' + programObj[j].HouseName  + '</option>');
				}
				var options = $('#houseID option');
				var arr = options.map(function(_, o) { return { t: $(o).text(), v: o.value }; }).get();
				arr.sort(function(o1, o2) { return o1.t > o2.t ? 1 : o1.t < o2.t ? -1 : 0; });
				options.each(function(i, o) {
					o.value = arr[i].v;
					$(o).text(arr[i].t);
				});
				//if ( programID == 14 ) {
				//	$('#houseID').prepend('<option value="A">All Personal Supports</option>');
				//}
				//if ( programID == 6 ) {
				//	$('#houseID').prepend('<option value="A">All Community Residential Services</option>');
				//}
				$('#houseID').prepend('<option value="A">All Houses for Selected Service</option>');
				$('#houseID').prepend('<option selected disabled value="">Choose a House</option>');
				
			}
		}
		
		// Send the data to PHP now... and wait for response to update the status div
		programchr.send(null); // Actually execute the request
		
	});
	
	$('#attendance').submit( function() {	
			
		
		if (  $('#attendancemonth').val().trim() == ""  || $('#attendancemonth').val().length == 0 ) {
			$('div#attendmonth').show();	
			//$('#attendancemonth').closest("div.invalid-feedback").show();
			return false;
		}
		if ( ( $('#programID').val() == null ) || ( $('#programID').val() == "" ) || ( $('#programID').selectedIndex == 'undefined' ) ) {
			return false;
		}
		
		if ( $('#programID').val() == 5 || $('#programID').val() == 6 ) {
			if ( ( $('#houseID').val() == null ) || ( $('#houseID').val() == "" ) || ( $('#houseID').selectedIndex == 'undefined' ) ) {
				return false;
			}
		}
		return true;
 	});
	
	$('#attendance2').submit( function() {	
		if (  $('#attendancemonth').val().trim() == ""  || $('#attendancemonth').val().length == 0 ) {
			return false;
		}
		if ( ( $('#programID').val() == null ) || ( $('#programID').val() == "" ) || ( $('#programID').selectedIndex == 'undefined' ) ) {
			return false;
		}
		if ( $('#programID').val() == 5 || $('#programID').val() == 6 ) {
			if ( ( $('#houseID').val() == null ) || ( $('#houseID').val() == "" ) || ( $('#houseID').selectedIndex == 'undefined' ) ) {
				return false;
			}
		}
		return true;
 	});

});

	
	



