<?php

	function str_rand(int $length = 64){ // 64 = 32
        $length = ($length < 4) ? 4 : $length;
        return bin2hex(random_bytes(($length-($length%2))/2));
    }
	
	function showMenu( $menuID )
	{
		if ( isset($_SESSION['menus-allowed']) ) {
			if ( is_array($menuID) ) {
				foreach ( $menuID as $menuKey => $menuValue ) {
					if ( in_array( $menuValue, $_SESSION['menus-allowed'] ) ) {
						return true;
					}
				}
				return false;
			}
			else
				return ( in_array( $menuID, $_SESSION['menus-allowed'] ) );
		}
		else
			return false;
	}
	
	function formatDate( $indate )
	{
		if ( ( $indate == '' ) || ( $indate == '0000-00-00' ) ) { return ''; }
		
		if ( strpos($indate, "/")  >=  0 ) {
			return $indate;
		}
		else if ( strpos($indate, "-")  >=  0 ) {
			$earray =  explode("-", $indate );
		}

		return  $earray[1] . '/' . $earray[2] . '/' . $earray[0];
	}

	function dbDateFormat( $indate )
	{		
		if ( ( $indate == '' ) || ( $indate == '0000-00-00' ) ) { return '0000-00-00'; }
		
		
		if ( strpos($indate, "-") >=  0 ) {
			return $indate;
		}
		
		$earray = explode("/", $indate );
		return  $earray[2] . '-' . $earray[0] . '-' . $earray[1];
	
	}
	
	function scrambbleEmail( $email )
	{
		list( $front, $back ) = explode("@", $email );
		$backlist = explode( ".", $back );
		
		$frontarr = str_split( trim($front) );
		for( $i = 1; $i < count($frontarr); $i++ ) {
			$frontarr[$i] = '*';
		}
		$front = implode( "", $frontarr );
		
		$mid = $backlist[0];
		$midarr = str_split( trim($mid) );
		for( $i = 1; $i < count($midarr); $i++ ) {
			$midarr[$i] = '*';
		}
		$mid = implode( "", $midarr );
		$backlist[0] = $mid;
		$back = implode(".", $backlist );
		
		return $front . '@' . $back;
		
	}
	
	function cleanHouseList( $clients, $houses ) {
		$cleanedHouses = array();
		
		for ( $cl = 0; $cl < count($clients); $cl++ ) {
			for ( $ho = 0; $ho < count($houses); $ho++ ) {
				if ( $clients[$cl]['HouseID'] == $houses[$ho]['HouseID'] ) {
					$cleanedHouses[] = $houses[$ho];
					array_splice($houses, $ho, 1);
					$ho = count($houses);
				}
			}
		}
		return $cleanedHouses;
	}
	
	function createDirectory($path, $permissions = 0755) {
		if (!is_dir($path)) {
			if (!mkdir($path, $permissions, true)) {
				return false;
			}
		}
		return true;
	}

	function formatPhone( $number ) {
	
		$result = '';
		
		// Allow only Digits, remove all other characters.
		$number = preg_replace("/[^\d]/","",$number);
		
		// get number length.
		$length = strlen($number);
		
		// if number = 10
		//if ($length == 11) {
		/*
		if (($length == 10) || ($length == 11)) {
			$number = preg_replace("/^1?(\d{1})(\d{3})(\d{3})(\d{4})$/", "+$1 ($2) - $3 - $4", $number);
		}
		if ($length == 12) {
			$number = preg_replace("/^1?(\d{3})(\d{3})(\d{3})(\d{3})$/", "+$1 $2 - $3 - $4", $number);
		}
		*/
		if (  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $number,  $matches ) || 
			  preg_match( '/^\d(\d{3})(\d{3})(\d{4})$/', $number,  $matches ) || 
			  preg_match( '/(\d{3})(\d{3})(\d{4})$/', $number,  $matches ) )
		{
			$result = '(' . $matches[1] . ') ' .$matches[2] . '-' . $matches[3];
		}
		return $result;
	}
	
	function formatSSN( $inSSN )
	{
		$formamtted = "";
		$searchArr  = array ( " ", "-" );
		$replaceStr = "";

		$formatted = str_replace( $searchArr, $replaceStr, $inSSN );
		return substr( $formatted, 0, 3 ) . "-" . substr( $formatted, 3, 2 ) . "-" . substr( $formatted, -4 );
	}
	
	function dpp($arr)
	{
		return "<pre>".print_r($arr,true)."</pre>";	
	}
	 
	/**
	 * Calculates how many months is past between two timestamps.
	 *
	 * @param  int $start Start timestamp.
	 * @param  int $end   Optional end timestamp.
	 *
	 * @return int
	 */
	function get_month_diff($start, $end = FALSE)
	{
		$end OR $end = time();
	
		$start = new DateTime("$start");
		$end   = new DateTime("$end");
		$diff  = $start->diff($end);
	
		return $diff->format('%y') * 12 + $diff->format('%m');
	}

	function get_month_difference($start, $end = FALSE)
	{
		$end OR $end = date("Y-m-d");
	
		list( $fYr, $fMonth, $fday )  = explode( "-", $start );
		list( $cYr, $cMonth, $cDay )  = explode( "-", $end );
		
		if ( $fYr == $cYr ) {
			$diff = $cMonth - $fMonth;
		}
		else {
			$diff = ((( $cyr - $fYr ) * 12 ) + $cMonth ) - $fmonth;
		}
		return $diff;
	}
	
	function get_ip_address(){
		foreach (array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR') as $key){
			if (array_key_exists($key, $_SERVER) === true){
				foreach (explode(',', $_SERVER[$key]) as $ip){
					$ip = trim($ip); // just to be safe
	
					if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false){
						return $ip;
					}
				}
			}
		}
	}

	function encrypt($string)
	{
		$output = false;
	
		// hash
		$key = hash( 'sha256', SECRET_KEY );
		
		// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
		$iv = substr( hash( 'sha256', SECRET_IV ), 0, 16);
		
		$output = openssl_encrypt($string, ENCRYPT_METHOD, $key, 0, $iv);
		//$output = base64_encode($output);
		
		return $output;
	}
	
	
	function decrypt($string)
	{
		$output = false;
	
		// hash
		$key = hash( 'sha256', SECRET_KEY );
		
		// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
		$iv = substr( hash( 'sha256', SECRET_IV ), 0, 16);
		
		//$output = openssl_decrypt(base64_decode($string), ENCRYPT_METHOD, $key, 0, $iv);
		 $output = openssl_decrypt($string, ENCRYPT_METHOD, $key, 0, $iv);
	
		return $output;
	}

	
	function sendVerificationEmail( $staffRec, $src = 'ADD' )
	{
		
		  // Requires the "PHP Email Form" library
		  // The "PHP Email Form" library is available only in the pro version of the template
		  // The library should be uploaded to: vendor/php-email-form/php-email-form.php
		  // For more info and help: https://bootstrapmade.com/php-email-form/
		  
		  if ( $src == 'ADD' ) {
		  	list( $username, $passwd ) = explode( "/", $staffRec['userpass'] );
		  }
		  
		  //if( file_exists($configFile = $_SERVER['DOCUMENT_ROOT'] . '/assets/config/config.inc.php' )) {
		  //	include( $configFile );
		  //}
		  
		  
		  $getConfig = getConfigFromDB();
		  if ( $getConfig[0] == SUCCESS ) {
			  $PULL_CONFIG_DATA = true;
			  include( $_SERVER['DOCUMENT_ROOT'] . '/assets/config/generateConfig.inc.php' );
		  }
		  
		  // Replace contact@example.com with your real receiving email address
		  $receiving_email_address = $staffRec['staffemail'];
		
		  if( file_exists($php_email_form = $_SERVER['DOCUMENT_ROOT'] . '/assets/vendor/php-email-form/php-email-form.php' )) {
			include( $php_email_form );
		  } else {
			die( 'Unable to load the "PHP Email Form" Library!');
		  }
		
		  $contact = new PHP_Email_Form;
		  $contact->ajax = false;

		  $contact->to = $receiving_email_address;
		  $contact->from_name = $agency_info['agency_shortname'] . ' Admin';
		  $contact->from_email = 'do_not_reply@cishinc.com';
		  $contact->subject = "Email Verification";
		  
		  $contact->to = $receiving_email_address;
		  $contact->from_name = $agency_info['agency_shortname'] . ' Admin';
		  $contact->from_email = 'do_not_reply@cishinc.com';
		  $contact->from_email = getenv('EMAIL_USER');
		  $contact->subject = "Email Verification";
		  
		  $message  =  PHP_EOL . PHP_EOL . $staffRec['firstname'] . ' ' . $staffRec['middleinitial'] . ' ' . $staffRec['lastname'] . PHP_EOL . PHP_EOL .  'Your staff account has been ' . ( ( $src == 'ADD' ) ? ( 'created as follows: ' . PHP_EOL . PHP_EOL . ' Username: ' . $username . PHP_EOL . 'Password: ' . $passwd . PHP_EOL . PHP_EOL ) : 'updated' . PHP_EOL . PHP_EOL ) . 'To confirm your account and verify your email address, follow this link <a href="https://' . $_SERVER['SERVER_NAME'] . '/authaz/index/dest/verifyemail/id/' . $staffRec['staffID'] . '/"><strong>Verify My Email Address</strong></a>' . PHP_EOL . PHP_EOL . 'If the link above is not clickable, copy this link ( https://' . $_SERVER['SERVER_NAME'] . '/authaz/index/dest/verifyemail/id/' . $staffRec['staffID'] . '/ ) and paste it in your browser. ' . PHP_EOL . PHP_EOL . $agency_info['agency_shortname'] . ' Management';
		  
		  
		  $contact->add_message( $message, '', 10);
		
		  $contact->send();
	
	}
	
	
	function getGeoCode($address)
	{
		//global $GOOGLE_API_KEY;
		
		//$address = str_replace(' ', '+', $address);
		$encodedAddress = urlencode($address);
		
		// geocoding api url
		$url = "https://maps.googleapis.com/maps/api/geocode/json?address={$encodedAddress}&key={$_ENV['GOOGLE_API_KEY']}";
		
		// Use file_get_contents to get the response
		$response = file_get_contents($url);
	
		// Decode the JSON response
		$json = json_decode($response, true);
	
		// Check if the response status is OK
		if ($json['status'] === 'OK') {
			// Get the latitude and longitude from the response
			$lat = $json['results'][0]['geometry']['location']['lat'];
			$lng = $json['results'][0]['geometry']['location']['lng'];
			return array('lat' => $lat, 'lng' => $lng);
		} else {
			// Handle the error
			return array('lat' => '', 'lng' => '');
		}
	}
	
	function sessionIsValid( $sessID, $timeout )
	{
		$dbSessionTime = getSessionTime( $sessID );
		$sessionDifference = time() - $dbSessionTime;
		
		if ( $sessionDifference > ( $timeout * 60 ) ) {
			//echo "login required";
			return false;
		}
		else {
			//echo "update required";
			return true;
		}
	}
	
	function resizeImage( $srcImage )
	{
		$maxDim = 800;
    	$target_filename = $srcImage;
		$ext = strtolower( pathinfo($srcImage, PATHINFO_EXTENSION) );
        list($width, $height, $type, $attr) = getimagesize( $srcImage );
        if ( $width > $maxDim || $height > $maxDim ) {
            $fn = $srcImage;
            $size = getimagesize( $fn );
            $ratio = $size[0]/$size[1]; // width/height
            if( $ratio > 1) {
                $width = $maxDim;
                $height = $maxDim/$ratio;
            } else {
                $width = $maxDim*$ratio;
                $height = $maxDim;
            }
            $src = imagecreatefromstring( file_get_contents( $fn ) );
            $dst = imagecreatetruecolor( $width, $height );
            imagecopyresampled( $dst, $src, 0, 0, 0, 0, $width, $height, $size[0], $size[1] );
            imagedestroy( $src );
			if ( $ext == 'png' )
            	imagepng( $dst, $target_filename ); // adjust format as needed
			else if ( $ext == 'jpg' )
				imagejpeg( $dst, $target_filename ); // adjust format as needed
			else if ( $ext == 'gif' )
				imagegif( $dst, $target_filename ); // adjust format as needed
            imagedestroy( $dst );
        }
		return  $target_filename;
	}
	
	// Mail function
	function emailAdmins( $message, $src, $emailStaff = 0 )
	{
		
		global $TIMEZONE;
		global $localRoot;
				
		if ( is_array($emailStaff) ) 
			$admins = $emailStaff;
		else
			$admins = ( $emailStaff == 0 ) ? getAdminEmails( ( $src == "HDV" ) ? 0 : 2, 0  ) : getAdminEmails( ( $src == "HDV" ) ? 0 : 1, $emailStaff  );
				
		
		$subjects = array( "IP" => "Closed Expired PCPs (IPs) and Goals",
						   "HDV" => "Health/Dental/Vision Appointment Notification",
						   "CP" => "Care Plan Pending Notification",
						   "DDN" => "Corporate Document Due Notification",
						   "SDN" => "Staff Document Due/Overdue Notification",
						   "RDUE" => "Report(s) Due Notification",
						   "MAR" => "MAR Pending Approval Notification",
						   "APNDX7" => "Missing AIR ( Appendix 7 ) Notification",
						   "MARINIT" => "MAR Automated Initialization",
						   "LLD" => "Last Login Date Notification",
						   "EDR" => "Staff Documents Renewal Date Reset Report" );

		if ( $admins[0] != SUCCESS )
		{
			//echo "returning on false";
			return false;
		}

		date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		
		require_once $localRoot . '/assets/PHPMailer/PHPMailerAutoload.php';
		//require '../PHPMailerAutoload.php';
		
		$mailit = new PHPMailer();

		// Send HTML email
		$mailit->IsHTML();

		// send mail by php Mail
		//$mailit->IsMAIL();
		
		// send mail by SMTP
		$mailit->isSMTP();
		
		//Enable SMTP debugging
		// 0 = off (for production use)
		// 1 = client messages
		// 2 = client and server messages
		//$mailit->SMTPDebug = 2;
		
		//Ask for HTML-friendly debug output
		//$mailit->Debugoutput = 'html';
		
		//Whether to use SMTP authentication
		$mailit->SMTPAuth = true;
		$mailit->CharSet   = "UTF-8";
		$mailit->SMTPSecure   = 'ssl'; 
		
		//$mailit->Host       = "mail.cishinc.com";    		// sets the SMTP server
		//$mailit->Username   = "do_not_reply@cishinc.com"; 	// SMTP account username
		//$mailit->Password   = "DoNotReply01";        		// SMTP account password
		
		$mailit->Host       = $_ENV['EMAIL_HOST'];			// sets the SMTP server
		$mailit->Port       = $_ENV['EMAIL_PORT'];			// SMTP SMTP Port
		$mailit->Username   = $_ENV['EMAIL_USER'];			// SMTP account username
		$mailit->Password   = $_ENV['EMAIL_PSWD'];			// SMTP account password
		$fromUserName       = $_ENV['EMAIL_NAME'];
		
		// Add Sender
		//$mailit->SetFrom('do_not_reply@cishinc.com', '');
		$mailit->SetFrom( $_ENV['EMAIL_USER'], $_ENV['EMAIL_NAME'] );
		$mailit->Subject    = "[Automated Job] " . $subjects[$src] ;
		$mailit->AltBody    = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test

		$mailit->MsgHTML($message);

		// Add recipients
		$recipients = explode( ",", $email_dest );
		
		foreach ( $admins[1] as $index => $email )
		{
			//echo $email . " == ";
			$mailit->AddAddress( trim($email) );
		}

		if ( $src == "HDV" ) {
			$mailit->SingleTo = true;
		}

		if(!$mailit->Send()) {
	  		echo "Mailer Error: " . $mailit->ErrorInfo;
		}
		else {
	  		echo "Message successfully sent! \n";
		}
	}
	
	function sendSMTP_Email( $message ) 
	{
	
		global $localRoot;
		
		/**
		 * This example shows making an SMTP connection with authentication.
		 */
		
		//SMTP needs accurate times, and the PHP time zone MUST be set
		//This should be done in your php.ini, but this is how to do it if you don't have access to that
		date_default_timezone_set('Etc/UTC');
		
		
		
		require '../PHPMailerAutoload.php';
		
		require $localRoot . '/assets/PHPMailer/PHPMailerAutoload.php';
		
		//Create a new PHPMailer instance
		$mail = new PHPMailer;
		//Tell PHPMailer to use SMTP
		$mail->isSMTP();
		//Enable SMTP debugging
		// 0 = off (for production use)
		// 1 = client messages
		// 2 = client and server messages
		$mail->SMTPDebug = 2;
		//Ask for HTML-friendly debug output
		$mail->Debugoutput = 'html';
		//Set the hostname of the mail server
		$mail->Host = "mail.example.com";
		//Set the SMTP port number - likely to be 25, 465 or 587
		$mail->Port = 25;
		//Whether to use SMTP authentication
		$mail->SMTPAuth = true;
		//Username to use for SMTP authentication
		$mail->Username = "yourname@example.com";
		//Password to use for SMTP authentication
		$mail->Password = "yourpassword";
		//Set who the message is to be sent from
		$mail->setFrom('from@example.com', 'First Last');
		//Set an alternative reply-to address
		$mail->addReplyTo('replyto@example.com', 'First Last');
		//Set who the message is to be sent to
		$mail->addAddress('whoto@example.com', 'John Doe');
		//Set the subject line
		$mail->Subject = 'PHPMailer SMTP test';
		//Read an HTML message body from an external file, convert referenced images to embedded,
		//convert HTML into a basic plain-text alternative body
		$mail->msgHTML(file_get_contents('contents.html'), dirname(__FILE__));
		//Replace the plain text body with one created manually
		$mail->AltBody = 'This is a plain-text message body';
		//Attach an image file
		$mail->addAttachment('images/phpmailer_mini.png');
		
		//send the message, check for errors
		if (!$mail->send()) {
			echo "Mailer Error: " . $mail->ErrorInfo;
		} else {
			echo "Message sent!";
		}
		
	}
	
	function clientListCell( $rKey, $cKey, $rData, $opts, $dataUpdatable = false )
	{
	//echo dpp($rData);
		$rowTag = array( 2 => 'hour11p12a', 'hour12a1a', 'hour1a2a', 'hour2a3a', 'hour3a4a', 'hour4a5a', 'hour5a6a', 'hour6a7a', 'hour7a8a' );
		$cellStr = "";
		//$currVals = "<script type='text/javascript'>";
		
		if ( $rData[$cKey] == '0' || $rData[$cKey] == '' || $dataUpdatable )
		{
			$cellStr  = "<select id='" . $rowTag[$cKey] . "-" . $rKey . "' name='" . $rowTag[$cKey] . "-" . $rKey . "'><option value=''></option>";
			foreach( $opts as $cd => $desc )
			{
				$cellStr .= "<option value='" . $cd . "'" . (( $cd == $rData[$cKey] ) ? ' selected ' : '')  . ">" . $cd . "</option>";				
			}
			$currVals .= "$('#" . $rowTag[$cKey] . "-" . $rKey . "').val( '" . $rData[$cKey] . "' ); ";
			$cellStr .= "</select>"; // . $currVals . "<!--/script-->";
			// $currVals = "<script type='text/javascript'>";
		}
		else
		{
			$cellStr = $rData[$cKey] . " <input type='hidden' name='" . $rowTag[$cKey] . "-" . $rKey . "' value='" . $rData[$cKey] . "'>";
		}
		return $cellStr;
	}
		  
?>
