<?php
	
	  
	  
	 //
	 // Attendance Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/rqstoff.db.php' );
	 
	function postStaffActivityLog( $formdata, $staffID )
	{
		$dbHandle = loginToDB();
		$retVal = array();
		
		global $TIMEZONE;
		
		date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		$logdate = date('Y-m-d');
		$logtime = date('h:i:s A');
		
		$timeArr = explode( " ", $formdata['timestart'] );
		$startTime = $timeArr[count($timeArr)-2] . ' ' . $timeArr[count($timeArr)-1];
		$timeArr = explode( " ", $formdata['timeend'] );
		$endTime = $timeArr[count($timeArr)-2] . ' ' . $timeArr[count($timeArr)-1];
		
		$query  = "INSERT INTO `StaffActivityLog`(`StaffID`, `LogDate`, `LogTime`, `ActivityStart`, ";
		$query .= "`ActivityEnd`, `ActivityDetail`, `PostedBy`) VALUES ( ";
		$query .= "" . $staffID . ", ";
		$query .= "'" . $logdate . "', ";
		$query .= "'" . $logtime . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $startTime ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $endTime ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['activitydtl'] ) . "', ";
		$query .= "" . $staffID . " ";
		$query .= " )";
		
		//echo $query;
		
		mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
          			
            //echo $rtnMsg;                 // Free result set
            if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return array( SQLERROR, $rtnMsg . "<br />" . $query );
		}
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return array( SUCCESS, "Staff Activity posted successfully" );
	}
	
	function recordStaffTemperature( $staffData )
	{
		
		$dbHandle = loginToDB();
		
		global $TIMEZONE;
		
		date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		list( $tempMonth, $tempDay, $tempYear ) = explode("/", $staffData['tempdate']);
		
		for( $jj = 0; $jj < count($staffData['staffID']); $jj++ ) 
		{
			if  ( ( $staffData['staffID'][$jj] == '' ) or ( $staffData['tempValue'][$jj] == '' ) ) { continue; }
			
			$query = "INSERT INTO `StaffBodyTemperature`(`StaffID`, `Month`, `Year`, `TempReadingTime`, `";
			$query .= "" . ltrim($tempDay, "0") . "` ) VALUES ( ";
			$query .= $staffData['staffID'][$jj] . ", ";
			$query .= ltrim($tempMonth, "0") . ", ";
			$query .= "'" . $tempYear . "', ";
			$query .= "'" . $staffData['tempReading'] . "', ";
			$query .= $staffData['tempValue'][$jj] . " ";
			$query .= " )";
			$query .= " ON DUPLICATE KEY UPDATE ";
			$query .= "`" . ltrim($tempDay, "0") . "` = " . $staffData['tempValue'][$jj];
			
			//echo $query;
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);
						
				// Free result set
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, $rtnMsg . "<br />" . $query );
			}
		}
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return array( SUCCESS, "Staff Body Temperature posted successfully" );
	}
	
	function SaveProfileUpdates( $updateRec ) 
	{
		$dbHandle = loginToDB();
		
		$query = " UPDATE `Staff` SET `PhoneNum`= '" . formatPhone( sql_quote( $dbHandle, $updateRec['phone'] ) ) .  "', ";
		$query .=  " `PhoneGateway`= " . $updateRec['carrier'] . ", `StaffEmail` = '" . $updateRec['email'] . "' WHERE `StaffID`=" . $updateRec['staffID'];
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
					
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		
		
		$query = " UPDATE `StaffAuthAz` SET `StaffPassword`= '" . password_hash( $updateRec['passwd'], PASSWORD_DEFAULT ) .  "' WHERE `StaffID`=" . $updateRec['staffID'];
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
					
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return array( SUCCESS, "Your profile was updated successfully" );
	}
	
   function getTripPurpose()
   {

   		$dbHandle  = loginToDB();

		$retStr    = "";
   		$purpose = "";
		$query = "SELECT usePurpose FROM VehiculeUsePurpose order by useID";

		//echo $query;

		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$purpose .=  "<option value=\"" . $row[0] . "\">" . $row[0] .  "</option><br />";
			}
			$retStr = array( SUCCESS, $purpose );
		}
		else
			$retStr = array( FAIL, $purpose );
          		
        // Free result set
        if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return $retStr;
   }
   
    function getVehicules( $StaffID = 0 )
   {

   		$dbHandle  = loginToDB();

		$retStr    = "";
   		$vehicules = "";
		$mileage   = array();
		$vehicleTag = array();
		
		$query = "SELECT a.vehiculeID, a.vehiculeYear, a.vehiculeMake, a.vehiculeModel, a.vehicleColor, a.endingMileage, a.tagImage FROM VehiculeLkup a WHERE  a.inService = 'Y' ORDER BY 1 ";
		//$query .= " UNION ";
		//$query .= "SELECT a.vehiculeID, a.vehiculeYear, a.vehiculeMake, a.endingMileage FROM VehiculeLkup a, Employees b WHERE  b.Status = 'Active' and b.HouseID = 0 and b.StaffID = " .  $StaffID . " order by 1";

		//echo $query;

		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$vehicules .=  "<option value=\"" . $row[0] . "\">" . $row[1] . " " . $row[2]  . " " . $row[3] . " ( " . $row[4] . " )</option><br />";
				$mileage[$row[0]] = $row[5] . '';
				$vehicleTag[$row[0]] =  $row[6];
			}
			$retStr = array( SUCCESS, $vehicules, $mileage, $vehicleTag );
		}
		else
			$retStr = array( FAIL, $vehicules );
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		return $retStr;

   }


	function getVehiculeEndingMileage(  )
   {

   		$dbHandle  = loginToDB();

		$retStr    = "";
		$mileage   = array();
   				
		$query = "SELECT vehiculeID, EndingMileage FROM  VehiculeLog a WHERE LogID IN ( SELECT MAX(LogID) FROM VehiculeLog b WHERE a.vehiculeID = b.vehiculeID) order by vehiculeID";
		
		//echo $query;

		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$mileage[$row[0]] =  $row[1];
			}
			$retStr = array( SUCCESS, $mileage );
		}
		else
			$retStr = array( FAIL, $mileage );
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return $retStr;

   }
   
   function getRepairList()
	{
		$retStr = '';
		$dbHandle    = loginToDB();
		$query  = "SELECT `repairLkupID`, `repairLkupDesc`  FROM `VehicleRepairLkup` order by 2";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$retStr .= "<option value=\"" . $row[1] . "\">" . $row[1] . "</option>";
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( SUCCESS, $retStr );
		}
		else
			return array( SQLERROR, mysqli_error($dbHandle) );
	}
	
	function getMileageAndTag()
	{
		$dbHandle  = loginToDB();

		$retStr    = array( 'endingMileage' => '', 'tagImage'=> ''  );;
		
		$query = "SELECT a.endingMileage, a.tagImage FROM VehiculeLkup a WHERE  a.`vehiculeID`= " . $_GET['vehicleID'] . " AND a.inService = 'Y' ORDER BY 1 ";

		//echo $query;
		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			$retStr = mysqli_fetch_assoc( $result );
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		return $retStr;
	}
	
	function putVehiculeLog( $formdata )
    {
		
		$dbHandle = loginToDB();
		$retStr = "";
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		}
		
		$repairID = getNextID( 'VehiculeRepairs', 'repairID', $dbHandle );
		$query = "INSERT INTO `VehiculeRepairs`(`repairID`, `repairDate`, `repairDone`, `repairDetails`, `repairMileage`, `repairCost`) VALUES ( ";
		$query .= $repairID . ", ";
		$query  .= "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['repairdate'] ) . "', '%m/%d/%Y'), ";		
		$query .=  "'" . sql_quote( $dbHandle,  $formdata['repairWorkDone'] ) . "', ";
		$query .=  "'" . sql_quote( $dbHandle,  $formdata['repairDetails'] ) . "', ";
		$query .= $formdata['repairMileage'] . ", ";
		$query .= $formdata['repairCost'] . " ";
		$query .= " ) ";
		
		//echo $query;
		
		mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 ) {
			$retStr = array( FAIL, mysqli_error($dbHandle) );
			mysqli_rollback($dbHandle);
			closeDB( $dbHandle );
			return $retStr;
		}
		
		$fuelingID = getNextID( 'VehiculeFueling', 'fuelingID', $dbHandle );
		$query = "INSERT INTO `VehiculeFueling`(`fuelingID`, `fuelingDate`, `fuelingMileage`, `fuelingCost`) VALUES (";
		$query .= $fuelingID . ", ";
		$query  .= "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['fueldate'] ) . "', '%m/%d/%Y'), ";		
		$query .= $formdata['fuelingMileage'] . ", ";
		$query .= $formdata['fuelingCost'] . " ";
		$query .= " ) ";
		//echo $query;
		
		mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 ) {
			$retStr = array( FAIL, mysqli_error($dbHandle) );
			mysqli_rollback($dbHandle);
			closeDB( $dbHandle );
			return $retStr;
		}	
	
		$logID = getNextID( 'VehiculeLog', 'LogID', $dbHandle );
		$query  = "INSERT INTO VehiculeLog (LogID, LogDate, StaffID, BeginningMileage, TripPurpose, TripDetails, EndingMileage, UsageMileage, vehiculeID, repairID, fuelingID) ";

		$query .= "VALUES ( ";
		$query .=  $logID . ", ";
		$query .=  "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['usagedate'] ) . "', '%m/%d/%Y'), ";
		$query .=  $formdata['staffID'] . ", ";
		$query .=  $formdata['beginMileage'] . ", ";
		$query .=  "'" . sql_quote( $dbHandle,  $formdata['tripPurpose'] ) . "', ";
		$query .=  "'" . sql_quote( $dbHandle,  $formdata['tripDetails'] ) . "', ";
		$query .=  $formdata['endMileage'] . ", ";
		$query .=  $formdata['usageMileage'] . ", ";
		$query .=  $formdata['vehiculeID'] . ", ";
		$query .=  $repairID . ", ";
		$query .=  $fuelingID . " ";
		$query .= " )";

		//echo $query;
		mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 ) {
			$retStr = array( FAIL, mysqli_error($dbHandle) );
			mysqli_rollback($dbHandle);
			closeDB( $dbHandle );
			return $retStr;
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

	   $retStr = array( SUCCESS, '' );
	   mysqli_commit($dbHandle);
	   closeDB( $dbHandle );

	   return $retStr;
   }
	
	
?>
