<?php
	
	function getProgramUsers()
	{
			global $DAY_REHABILITATION_SERVICES;
			$dbHandle = loginToDB();

			$rtn = "";			
			
			$houseand = "";
			$clientand = "";
			
			if ( $_GET['programHouse'] == MANAGEMENT ) {
				$houseand = "  ";
			}
			else  { 
				$houseand = " and  HouseID = " . $_GET['programHouse'] . " ";
			}
			
			if ( $_GET['programCd'] == DAY_REHABILITATION_SERVICES )  {
				$clientand = " and ( ( ClientServiceID = " . $_GET['programCd'] . " ) OR ( IsDayClient = 'Y' ) ) ";
			}
			else { // if (  $_GET['programCd'] == 'A' )  
				$clientand = " and  ClientServiceID = " . $_GET['programCd'] . " ";
			}
			
			$query  = "select ClientID,  CONCAT(ClientFname, ' ', ClientLname ) as ClientName from Clients  where ClientStatus =  'Open' " . $clientand . $houseand;
			//echo $query;
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtn = array( SQLERROR, mysqli_error($dbHandle) . "<br><br>QUERY<BR>=====<br><br>" . $query );
				
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return array( SQLERROR, $rtn );
			}
			else
			{
				$rtn = array(); 
				while ( $row = mysqli_fetch_assoc( $result ) )
				{
					$rtn[] = $row;
				}
			}
				
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		   closeDB( $dbHandle );
		   return $rtn;
	  }
	  
	  
	  function getSeizureCategories()
	  {
			$dbHandle = loginToDB();
			$seizureCatgry = array();
			
			$query = "SELECT * FROM `SeizureCatgryLkup` ";

			$result = mysqli_query( $dbHandle, $query  );
	
			while ($row = mysqli_fetch_assoc($result)) {
				$seizureCatgry[] = $row;
			}
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return $seizureCatgry;
	  }
	  
	  function getSeizureItems()
	  {
			$dbHandle = loginToDB();
			$seizureItems = array();
			
			$query = "SELECT `CatgryID`,`CatgryItemID`,`ItemDesc` FROM `SeizureItemLkup` order by 1, 2, 3";
			
			$result = mysqli_query( $dbHandle, $query  );
	
			while ($row = mysqli_fetch_assoc($result)) {
				$seizureItems[] = $row;
			}
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return $seizureItems;
			
	  }
	  
	  function getClientSeizureItems( $clientID, $year )
	  {
	  		$dbHandle = loginToDB();
			$seizureItems = array();
			
			$query = "SELECT * FROM `ClientSeizureRecord` WHERE `ClientID`=  " . $clientID . " AND `SeizureYear`=" . $year . " order by 1, 2, 3, 4, 5, 6, 7, 8";
						
			//echo $query;
			
			$result = mysqli_query( $dbHandle, $query  );
	
			while ($row = mysqli_fetch_assoc($result)) {
				$seizureItems[] = $row;
			}
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return $seizureItems;
	  }
	  
	 
	  
	  function getClientSeizureDaysInYear( $clientID, $year )
	  {
	  		$dbHandle = loginToDB();
			$seizureDays = array();
			
			$query = "SELECT DISTINCT `SeizureRecordID`, `SeizureMonth`, `SeizureDay` FROM `ClientSeizureRecord` WHERE `ClientID`=  " . $clientID . " AND `SeizureYear`=" . $year . " order by 2,3";
			
			$result = mysqli_query( $dbHandle, $query  );
	
			while ($row = mysqli_fetch_assoc($result)) {
				$seizureDays[] = $row;
			}
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return $seizureDays;
	  }
	  
	  function getClientNotesForYear( $clientID, $year )
	  {
	  		$dbHandle = loginToDB();
			$clientNotes = array();
			
			$query = "SELECT distinct a.`SeizureNotesID`, a.`SeizureRecordID`, b.`ClientID`, b.`SeizureYear`, b.`SeizureMonth`, b.`SeizureDay`, a.`SeizureNotesDate`, ";
			$query .= "  a.`SeizureNotesHour`, a.`StaffInitials`, a.`SeizureNotes`, a.`CounselorInitials` FROM `ClientSeizureRecordNotes` a, ";
			$query .= " `ClientSeizureRecord` b  WHERE a.`SeizureRecordID`=b.`SeizureRecordID` AND `ClientID`= " . $clientID . "";
			$query .= " AND `SeizureYear`= " . $year . "  order by  1, 2, 3, 4, 5, 6, 7";
			
			//echo $query;
			
			$result = mysqli_query( $dbHandle, $query  );
	
			while ($row = mysqli_fetch_assoc($result)) {
				$clientNotes[] = $row;
			}
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return $clientNotes;
	  }
	  
	  function getClientSeizureSummary( $clientID, $year )
	  {
	  		$dbHandle = loginToDB();
			$seizureItems = array();
			
			$query = "SELECT distinct a.`SeizureSummaryID`, a.`SeizureRecordID`, b.`ClientID`, b.`SeizureYear`, b.`SeizureMonth`, b.`SeizureDay`, ";
			$query .= " a.`TimeOfDay`, a.`Duration`, a.`StaffInitials`FROM `ClientSeizureRecordSummary` a, `ClientSeizureRecord` b  ";
			$query .= " WHERE a.`SeizureRecordID`=b.`SeizureRecordID` AND `ClientID`= " . $clientID . " AND `SeizureYear`= " . $year . "  order by 1, 2, 3, 4, 5, 6, 7 ";
			
			$result = mysqli_query( $dbHandle, $query  );
	
			while ($row = mysqli_fetch_assoc($result)) {
				$seizureItems[] = $row;
			}
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return $seizureItems;
	  }
	  
	  function getClientSeizureAgencyDoc( $clientID )
	  {
	  		$dbHandle = loginToDB();
			$seizureItems = array();
			
			$query = "SELECT * FROM `ClientSeizureAgencyDoc` WHERE `ClientID` = " . $clientID;
			
			$result = mysqli_query( $dbHandle, $query  );
			$row = mysqli_fetch_assoc($result);
			$seizureItems[] = $row;
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return $seizureItems;
	  }
	  
	  function postSeizureRocord($seizureRec)
	  {
	  		$dbHandle = loginToDB();
	  
	  		mysqli_begin_transaction( $dbHandle );
			
			$query  = "SELECT ifnull(MAX(`SeizureAgencyDocID`), 0) + 1 as 'SeizureAgencyDocID' FROM `ClientSeizureAgencyDoc`";
			$result = mysqli_query( $dbHandle, $query  );
			$row = mysqli_fetch_assoc($result);
			$seizureAgencyDocID = $row['SeizureAgencyDocID'];
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
			$query  = "INSERT INTO `ClientSeizureAgencyDoc`(`SeizureAgencyDocID`, `ClientID`, `Agency`, `Doctor`) VALUES (";
			$query .= $seizureAgencyDocID . ", ". $seizureRec['clientID'] . ", ";
			$query .= "'" . sql_quote( $dbHandle, $seizureRec['agency'] ) . "', ";
			$query .= "'" . sql_quote( $dbHandle, $seizureRec['physician'] ) . "'  ";
			$query .= " ) ON DUPLICATE KEY UPDATE ";
			$query .= " `Agency` = '" . sql_quote( $dbHandle, $seizureRec['agency'] ) . "',  ";
			$query .= " `Doctor` = '" . sql_quote( $dbHandle, $seizureRec['physician'] ) . "'  ";
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$errMsg = mysqli_error( $dbHandle );
				
				// Free result set
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				mysqli_rollback($dbHandle);
				closeDB( $dbHandle );
				return array( FAIL, $errMsg );
			}
			
			$query  = "SELECT ifnull(MAX(`SeizureRecordID`), 0) + 1 as 'SeizureRecordID' FROM `ClientSeizureRecord`";
			$result = mysqli_query( $dbHandle, $query  );
			$row = mysqli_fetch_assoc($result);
			$seizureRecordID = $row['SeizureRecordID'];
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
			$query  = "SELECT ifnull(MAX(`SeizureSummaryID`), 0) + 1 as 'SeizureSummaryID' FROM `ClientSeizureRecordSummary`";
			$result = mysqli_query( $dbHandle, $query  );
			$row = mysqli_fetch_assoc($result);
			$seizureSummaryID = $row['SeizureSummaryID'];
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
			$query  = "SELECT ifnull(MAX(`SeizureNotesID`), 0) + 1 as 'SeizureNotesID' FROM `ClientSeizureRecordNotes`";
			$result = mysqli_query( $dbHandle, $query  );
			$row = mysqli_fetch_assoc($result);
			$seizureNotesID = $row['SeizureNotesID'];
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
			
			for ( $i = 0; $i < count($seizureRec['textTOD']); $i++ ) {
			
				//list( $hourTOD, $minTOD ) = explode(":",$seizureRec['textTOD'][$i] );
				//$TOD = date("g:i A", strtotime($seizureRec['textTOD'][$i] . " UTC"));
								
				$query  = "INSERT INTO `ClientSeizureRecordSummary`(`SeizureSummaryID`, `SeizureRecordID`, `TimeOfDay`, `Duration`, `StaffInitials`) ";
				$query .= " VALUES ( " . $seizureSummaryID . ", ". $seizureRecordID . ", '" . $seizureRec['textTOD'][$i] . "', " . $seizureRec['textDuration'][$i] . ", ";
				$query .= "'" . $seizureRec['textInitials'][$i] . "' ) ON DUPLICATE KEY UPDATE ";
				$query .= " `TimeOfDay` = '" . $TOD . "',  ";
				$query .= " `Duration` = " . $seizureRec['textDuration'][$i] . ",  ";
				$query .= " `StaffInitials` = '" . sql_quote( $dbHandle, $seizureRec['textInitials'][$i] ) . "'  ";
			
				$result = mysqli_query( $dbHandle, $query  );
				if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$errMsg = mysqli_error( $dbHandle );
					
					// Free result set
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					mysqli_rollback($dbHandle);
					closeDB( $dbHandle );
					return array( FAIL, $errMsg );
				}
			}
						
			
			for ( $i = 0; $i < count($seizureRec['smryDate']); $i++ ) {
			
				//$notesHour = date("g:i A", strtotime($seizureRec['smryHour'][$i] . " UTC"));
				$query  = "INSERT INTO `ClientSeizureRecordNotes`(`SeizureNotesID`, `SeizureRecordID`, `SeizureNotesDate`, ";
				$query .= " `SeizureNotesHour`, `StaffInitials`, `SeizureNotes`, `CounselorInitials`) VALUES ( ";
				$query .= "" . $seizureNotesID . ", ". $seizureRecordID . ", '" . $seizureRec['smryDate'][$i] . "', '" . $seizureRec['smryHour'][$i] . "', "; 
				$query .= "'" . $seizureRec['smryInitials'][$i] . "', '" . htmlspecialchars($seizureRec['smryNotes'][$i], ENT_QUOTES ) . "', ";
				$query .= "'" . $seizureRec['counselorInitials'][$i] . "' ) ON DUPLICATE KEY UPDATE ";
				$query .= " `SeizureNotesDate` = '" . $seizureRec['smryDate'][$i] . "',  ";
				$query .= " `SeizureNotesHour` = '" . $notesHour . "',  ";
				$query .= " `StaffInitials` = '" . $seizureRec['smryInitials'][$i] . "',  ";
				$query .= " `SeizureNotes` = '" . sql_quote( $dbHandle, $seizureRec['smryNotes'][$i] ) . "',  ";
				$query .= " `CounselorInitials` = '" . sql_quote( $dbHandle, $seizureRec['counselorInitials'][$i] ) . "'  ";
			
				$result = mysqli_query( $dbHandle, $query  );
				if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$errMsg = mysqli_error( $dbHandle );
					
					// Free result set
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					mysqli_rollback($dbHandle);
					closeDB( $dbHandle );
					return array( FAIL, $errMsg );
				}
			}
			
			
			for ( $i = 0; $i < count($seizureRec['chkSeizure']); $i++ ) {
				
				$query  = "SELECT ifnull(MAX(`SeqID`), 0) + 1 as 'SeqID' FROM `ClientSeizureRecord` WHERE `SeizureRecordID` = " . $seizureRecordID;
				$result = mysqli_query( $dbHandle, $query  );
				$row = mysqli_fetch_assoc($result);
				$seqID = $row['SeqID'];
		
				// Free result set
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
						
				list( $catgryID, $catgryItemID, $year, $month, $day ) = explode( "-", $seizureRec['chkSeizure'][$i] );
				$query  = "INSERT INTO `ClientSeizureRecord`(`SeizureRecordID`, `SeqID`, `ClientID`, `SeizureYear`, `SeizureMonth`, `SeizureDay`, ";
				$query .= " `CatgryID`, `CatgryItemID`) VALUES ( " . $seizureRecordID . ", " . $seqID . ", " . $seizureRec['clientID'] . ", ";
				$query .= $year . ", " . $month . ", " . $day . ", " . $catgryID  . ", " . $catgryItemID . " )  ON DUPLICATE KEY UPDATE ";
				$query .= " `CatgryID` = " . $catgryID . ",   `CatgryItemID` = " . $catgryItemID . "  ";
												
				$result = mysqli_query( $dbHandle, $query  );		
				if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$errMsg = mysqli_error( $dbHandle );
					
					// Free result set
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					mysqli_rollback($dbHandle);
					closeDB( $dbHandle );
					return array( FAIL, $errMsg );
				}
				
			}
			
			mysqli_commit($dbHandle);
			closeDB( $dbHandle );
			return array( SUCCESS, "");
	  }
?>