<?php

	function saveClientInfo( $clientRec )
	{		
		global $TIMEZONE;
		$clientID = getNextID( 'Clients', 'ClientID' );			
		date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		
		$dbHandle = loginToDB();
		//$startDate = date("Y-m-d");
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		}
		
		//INSERT INTO `Clients`
		//            
		
		$query    = "INSERT INTO `Clients`(`ClientID`, `ResidenceID`, `CCS_StaffID`, `SchoolID`, `CCS_StaffAsignDate`, `ClientFname`, `ClientLname`,  ";
		$query   .= " `ClientAdmisionDate`, `AdultAdmitDate`, `DayAdmitDate`, `ClientSSN`, `ClientBirthDate`, `ParentName`, `ParentPhone`,  ";
		$query   .= " `ParentEmail`, `ClientCaseNum`, `ClientMedicaidNum`, `ClientRootDir`, `ClientGender`, `IsAwakeOvernight`, `PharmacyID`, ";
		$query   .= " `ClientImage`, `IsEmpScvClient`, `ClientLtssID` ) VALUES ( ";
		$query   .=  $clientID . ", " .  $clientRec['residence'] . ", " . $clientRec['ccsname'] . ", ";
		if ( isset($clientRec['clientschool'] ) && trim($clientRec['clientschool']) != '' ) { 
			$query   .=  $clientRec['clientschool'] . ", " ;
		}
		else {
			$query   .=  "NULL, " ;
		}
		$query   .= " STR_TO_DATE( '" . $clientRec['ccsassigndate'] . "', '%m/%d/%Y'), ";
		$query   .= "'" . sql_quote( $dbHandle, $clientRec['firstname'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $clientRec['lastname'] ) . "', ";
		
		$query   .= " STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y'), ";
		$query   .= " STR_TO_DATE( '" . $clientRec['adultadmissiondate'] . "', '%m/%d/%Y'), ";
		$query   .= " STR_TO_DATE( '" . $clientRec['dprgmadmissiondate'] . "', '%m/%d/%Y'), ";
		$query   .= "'" . sql_quote( $dbHandle, encrypt($clientRec['ssno']) ) . "', ";
		$query   .= " STR_TO_DATE( '" . $clientRec['birthdate'] . "', '%m/%d/%Y'), ";
		$query   .= "'" . sql_quote( $dbHandle, $clientRec['parentname'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, formatPhone($clientRec['parentnumber'] )) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $clientRec['parentemail'] ) . "', ";
		
		$query   .= "'" . sql_quote( $dbHandle, $clientRec['casenumber'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $clientRec['medicaid'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, strtolower($clientRec['docdir']) ) . "', ";
		$query   .= "'" . $clientRec['clientgender'] . "', ";
		$query   .= "'" . $clientRec['awakeovernight'] . "', ";
		$query   .=  $clientRec['clientpharmacy'] . ", ";
		$query   .= "'" . sql_quote( $dbHandle, strtolower($clientRec['clientimage']) ) . "', ";
		$query   .= "'" . $clientRec['isEmpSvc'] . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $clientRec['clientltssid'] ) . "' ";
		$query   .= " ) ";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "saveClientInfo() failed in INSERT INTO `Clients` with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		foreach( $clientRec['program'] as $pgmKey => $pgmValue ) {
						
				if ( ! isset($clientRec['subprogram'][$pgmValue] ) ) {
					$clientRec['subprogram'][$pgmValue] = array( 'NULL' );
				}
				
				for ( $si = 0; $si < count($clientRec['subprogram'][$pgmValue]); $si++ )
				{	
					$clientServiceID = getNextID( 'ClientServices', 'ClientServicesID', $dbHandle );
					
					//Insert  Services into ClientServices
					$query   = "INSERT INTO `ClientServices`(`ClientID`, `ServiceID`, `SubServiceID`, `StartDate`, `HouseID`, `ClientServicesID`) ";
					$query   .= " VALUES ( ";
					$query   .=  $clientID . ", " . $pgmValue . ", " . $clientRec['subprogram'][$pgmValue][$si] . ",  ";
					$query   .= " STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y'), ";
					
					$query   .= $clientRec['clienthouse'][$pgmValue][0] . ", " . $clientServiceID;
					
					$query   .= " )";
					
					//echo $query;
					
					$result = mysqli_query( $dbHandle, $query  );		
			
					if ( mysqli_errno($dbHandle) != 0 ) {
						$errorNumber = mysqli_errno($dbHandle);
						$errorMessage = mysqli_error($dbHandle);
						mysqli_rollback($dbHandle);
						if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
						closeDB( $dbHandle );
						return array( FAIL, "saveClientInfo() failed in INSERT INTO `ClientServices` with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
					}
				}
			
		}
		
		//
		// Insert PCP dates PCPDateManagement
		//
		foreach( $clientRec['program'] as $programKey => $programValue ) {
		
			$query   = "INSERT INTO `PCPDateManagement`(`ClientID`, `ServiceID`, `OriginalIPDate`, `CurrentIPDate`, `NextIPDate`) VALUES ( ";
			$query  .=  $clientID . ", ";
			$query  .=  $programValue . ", ";
			$query   .= " STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y') + INTERVAL 30 DAY, ";
			$query   .= " STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y') + INTERVAL 30 DAY, ";
			$query   .= " STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y') + INTERVAL 395 DAY ";
			$query  .=  " ) ON DUPLICATE KEY UPDATE ";
			$query  .=  "OriginalIPDate = STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y') + INTERVAL 30 DAY, " ;
			$query  .=  "CurrentIPDate = STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y') + INTERVAL 30 DAY, " ;
			$query  .=  "NextIPDate = STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y') + INTERVAL 395 DAY " ;
					
			$result = mysqli_query( $dbHandle, $query  );		
			
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				mysqli_rollback($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "saveClientInfo() failed in INSERT INTO `PCPDateManagement` with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		}
		$retStr = array( SUCCESS, "" );
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS,  "Client record for " . $clientRec['firstname'] . " " . $clientRec['lastname'] . " was successfully added." );
	
	}
	
	function updateClientInfo( $clientRec )
	{
		//echo dpp($clientRec);
		
		$clientServiceID = getNextID( 'ClientServices', 'ClientServicesID' );
		$dbHandle = loginToDB();
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an update transaction. Please notify the application administrator" );
		}
		
		if ( trim($clientRec['docdir']) == '' ) {
			$firstname = trim(str_replace( array( "'", "\"", " ", "-" ), '', $clientRec['firstname'] ) );
			$lastname = trim(str_replace( array( "'", "\"", " ", "-" ), '', $clientRec['lastname'] ) );
			$clientRec['docdir'] = strtolower(  $firstname . '_' . $lastname  );
		}
		
		$query    = "UPDATE `Clients` SET ";
		$query   .= " `ResidenceID`=" . $clientRec['residence'] . ", ";
		$query   .= " `CCS_StaffID`=" . $clientRec['ccsname'] . ", `SchoolID` = ";

		if ( isset($clientRec['clientschool'] ) && $clientRec['clientschool'] > 0 ) { 
			$query   .=  $clientRec['clientschool'] . ", " ;
		}
		else {
			$query   .=  "NULL, " ;
		}
		$query   .= " `CCS_StaffAsignDate` = STR_TO_DATE( '" . $clientRec['ccsassigndate'] . "', '%m/%d/%Y'), ";
		$query   .= " `ClientFname`='" . sql_quote( $dbHandle, $clientRec['firstname'] ) . "', ";
		$query   .= " `ClientLname`='" . sql_quote( $dbHandle, $clientRec['lastname'] ) . "', ";	
		$query   .= " `ClientGender`='" . $clientRec['clientgender'] . "', ";
		$query   .= " `ClientAdmisionDate`=STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y'), ";
		$query   .= " `AdultAdmitDate`=STR_TO_DATE( '" . $clientRec['adultadmissiondate'] . "', '%m/%d/%Y'), ";
		$query   .= " `DayAdmitDate`=STR_TO_DATE( '" . $clientRec['dprgmadmissiondate'] . "', '%m/%d/%Y'), ";
		$query   .= " `ClientSSN`='" . sql_quote( $dbHandle, encrypt($clientRec['ssno']) ) . "', ";
		$query   .= " `ClientBirthDate`=STR_TO_DATE( '" . $clientRec['birthdate'] . "', '%m/%d/%Y'), ";
		
		$query   .= " `ParentName`='" . sql_quote( $dbHandle, $clientRec['parentname'] ) . "', ";
		$query   .= " `ParentPhone`='" . sql_quote( $dbHandle, formatPhone($clientRec['parentnumber'] )) . "', ";
		$query   .= " `ParentEmail`='" . sql_quote( $dbHandle, $clientRec['parentemail'] ) . "', ";
		$query   .= " `ClientCaseNum`='" . sql_quote( $dbHandle, $clientRec['casenumber'] ) . "', ";
		$query   .= " `ClientMedicaidNum`='" . sql_quote( $dbHandle, $clientRec['medicaid'] ) . "', ";
		$query   .= " `ClientRootDir`='" . sql_quote( $dbHandle, strtolower($clientRec['docdir']) ) . "', ";		
		$query   .= " `ClientImage`='" . sql_quote( $dbHandle, $clientRec['clientimage'] ) . "', ";		
		$query   .= " `IsAwakeOvernight`='" . $clientRec['awakeovernight'] . "', ";
		
		$query   .= " `IsEmpScvClient`='" . $clientRec['isEmpSvc'] . "', ";
		$query   .= " `PharmacyID`=" . $clientRec['clientpharmacy'] . ", ";
		$query   .= " `ClientLtssID`='" . $clientRec['clientltssid'] . "'  WHERE `ClientID`= " . $clientRec['clientname'];
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "updateClientInfo() failed at UPDATE `Clients` with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		/* Move current entries to ClientServicesHistory */
		
		$query    = "REPLACE INTO ClientServicesHistory SELECT * FROM `ClientServices` WHERE `ClientID`= " . $clientRec['clientname'];
		$result = mysqli_query( $dbHandle, $query  );
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "updateClientInfo() failed at INSERT INTO into ClientServicesHistory with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		/* Delete current entries in ClientServices */
		/*
		$query    = "DELETE FROM `ClientServices` WHERE `ClientID`= " . $clientRec['clientname'];
		$result = mysqli_query( $dbHandle, $query  );
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "updateClientInfo() failed at DELETE FROM `ClientServices` with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		*/
		
		/* Insert new entries in ClientServices */
		foreach( $clientRec['program'] as $pgmKey => $pgmValue ) {
					
			if ( ! isset($clientRec['subprogram'][$pgmValue] ) ) {
				$clientRec['subprogram'][$pgmValue] = array( 'NULL' );
			}
			
			for ( $si = 0; $si < count($clientRec['subprogram'][$pgmValue]); $si++ )
			{	
			
				//echo "<br>" . $pgmValue . " in array " . in_array( $pgmValue, $clientRec['clientServicesID'] ) ? "TRUE == " : " FALSE == ";
				if ( in_array( $pgmValue, array_keys($clientRec['clientServicesID']) ) ) {
					
					$query = " UPDATE `ClientServices` SET ";
					//$query   .= " `ServiceID`=" .  . " "; 
					$query   .= " `SubServiceID`=" .  $clientRec['subprogram'][$pgmValue][$si] . ", ";
					$query   .= " `StartDate`= STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y'), ";
					$query   .= " `HouseID`=" . $clientRec['clienthouse'][$pgmValue][0] . " ";
					$query   .= "  WHERE `ClientServicesID` = " . $clientRec['clientServicesID'][$pgmValue] . " ";
				}
				else {
					$clientServiceID = getNextID( 'ClientServices', 'ClientServicesID', $dbHandle );
					
					//Insert  Services into ClientServices
					$query   = "INSERT INTO `ClientServices`(`ClientID`, `ServiceID`, `SubServiceID`, `StartDate`, `HouseID`, `ClientServicesID`) ";
					$query   .= " VALUES ( ";  
					$query   .=  $clientRec['clientname'] . ", " . $pgmValue . ", " . $clientRec['subprogram'][$pgmValue][$si] . ",  ";
					//$query   .= " STR_TO_DATE( '" . date("m/d/Y") . "', '%m/%d/%Y'), ";
					$query   .= " STR_TO_DATE( '" . $clientRec['admissiondate'] . "', '%m/%d/%Y'), ";
					$query   .= $clientRec['clienthouse'][$pgmValue][0] . ", " . $clientServiceID;
					$query   .= " )";
				}
				//echo $query . "<br>";
				
				
				$result = mysqli_query( $dbHandle, $query  );		
		
				if ( mysqli_errno($dbHandle) != 0 ) {
					$errorNumber = mysqli_errno($dbHandle);
					$errorMessage = mysqli_error($dbHandle);
					mysqli_rollback($dbHandle);
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					closeDB( $dbHandle );
					return array( FAIL, "updateClientInfo() failed in INSERT INTO `ClientServices` with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );

				}
				
			}
			
		}
		
		/* Update EndDates in ClientServices */
		foreach( $clientRec['clientServicesID'] as $csiKey => $csiValue ) {
		
			if ( ! in_Array( $csiKey, $clientRec['program'] ) ) {
				$query = " UPDATE `ClientServices` SET ";
				$query   .= " `EndDate`= STR_TO_DATE( '" . date("m/d/Y") . "', '%m/%d/%Y') ";
				$query   .= "  WHERE `ClientServicesID` = " . $clientRec['clientServicesID'][$csiKey] . " ";
				
				$result = mysqli_query( $dbHandle, $query  );		
		
				if ( mysqli_errno($dbHandle) != 0 ) {
					$errorNumber = mysqli_errno($dbHandle);
					$errorMessage = mysqli_error($dbHandle);
					mysqli_rollback($dbHandle);
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					closeDB( $dbHandle );
					return array( FAIL, "updateClientInfo() failed to update `ClientServices` EndDates with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );

				}
				
			}
			
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS,  "Client record for " . $clientRec['firstname'] . " " . $clientRec['lastname'] . " was successfully updated." );
	
	}
	
	//
	//  Change Client House
	//
	function changeClientHouse( $changeInfo ) 
	{
		$dbHandle = loginToDB();
		global $CLIENTREF;
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin a update transaction. Please notify the application administrator" );
		}

		list( $clientID, $housID ) = explode(":", $changeInfo['clientname']) ;
		
		$query   = "UPDATE `ClientServices` SET `HouseID`=" . $changeInfo['newclienthouse'] . " ";
		$query  .= " WHERE `ClientID` = " . $clientID . " AND `HouseID` = " . $housID;
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "changeClientHouse() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS,  ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ) . " House successfully changed." );
	}
	
	//
	//  Client Leaving
	//
	function postClientExiting( $exitInfo ) 
	{
		$dbHandle = loginToDB();
		global $CLIENTREF;
		
		$query   = "UPDATE `Clients` SET `ClientDischargeDate`=STR_TO_DATE('" . $exitInfo['statusChgDate'] . "', '%m/%d/%Y'), ";
		$query  .= " `ClientDischargedSummary`='" . sql_quote( $dbHandle, $exitInfo['leavereason'] ) . "', ";
		$query  .= " `ClientStatus`= 'Closed' WHERE `ClientID` = " . $exitInfo['clientname'] . "";
		
		//echo $query;
		//echo dpp($exitInfo);
		
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "postClientExiting() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ) . " status successfully updated." );
	}
	
	
	//
	//  Resolve Critical Problem
	//
	function resolveCriticalProblem( $problemInfo ) 
	{
		$dbHandle = loginToDB();
		
		$query   = "UPDATE `CriticalProblems` SET `ResolutionDate`=STR_TO_DATE('" . $problemInfo['ResolutionDate'] . "', '%m/%d/%Y'), ";
		$query  .= " `ResolvedBy`='" . sql_quote( $dbHandle, $problemInfo['ResolvedBy'] ) . "', ";
		$query  .= " `ResolutionDetails`='" . sql_quote( $dbHandle, $problemInfo['ResolutionDetails'] ) . "', ";
		$query  .= " `ProblemStatus`= 'Closed' WHERE `ProblemID` = " . $problemInfo['ProblemID'] . "";
		
		//echo $query;
		//echo dpp($exitInfo);
		
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "resolveCriticalProblem() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, "Critical Problem successfully resolved." );
	}
	
?>
