<?php

	function updatePCPDates( $formdata )
	{
		$dbHandle = loginToDB();
		
		for ( $i = 0; $i < count($formdata['clientID']); $i++ ) {
			$query  = "Replace into `PCPDateManagement`(`ClientID`, `ServiceID`, `OriginalIPDate`, `CurrentIPDate`, `NextIPDate`) ";
			$query .= " VALUES ( " ;
		 	$query  .= "" . $formdata['clientID'][$i] . ", ";
			$query  .= "" . $formdata['serviceID'] . ", ";
			$query  .= "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['originaldate'][$i] ) . "', '%m/%d/%Y'), ";
			$query  .= "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['currdate'][$i] ) . "', '%m/%d/%Y'), ";
			$query  .= "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['newdate'][$i] ) . "', '%m/%d/%Y') ";
			$query .= " ) " ;
		 
		 //echo $query . PHP_EOL;
		 
		 	$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{			
			   	// Free result set
			   	if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
				closeDB( $dbHandle );
				return array( FAIL, mysqli_error( $dbHandle ));
			}
		
		 }
		 
		 // Free result set
	   	 if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
		 closeDB( $dbHandle );
		 return array( SUCCESS, "All PCP Dates successfully updated.");
		
	}
	
	function currentPCPRetirement( $formdata )
	{
	
		  $retStr = ""; 
		  global $CLIENTREF;
		  
		  // Move IP charting to the history table
		  $dbHandle = loginToDB();
		  
		  if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		}
		  
		  $query  = "REPLACE INTO PCPChartingHistory  SELECT * FROM PCPCharting WHERE ClientID = " . $formdata['clientID'] . " AND ServiceID =" . $formdata['serviceID'];
		 // echo $query . "<br>";
		  // exit;
		  mysqli_query( $dbHandle, $query  );
		  if ( mysqli_errno( $dbHandle ) == 0 )
		  {
				$query  = "DELETE FROM PCPCharting WHERE ClientID = " . $formdata['clientID'] . " AND ServiceID =" . $formdata['serviceID'];
				mysqli_query( $dbHandle, $query  );
				if ( mysqli_errno( $dbHandle ) == 0 )
				{
					// Delete ObjectiveGoalManagement
					$query  = "REPLACE INTO PCPObjectivesGoalManagementHistory  SELECT * FROM PCPObjectivesGoalManagement WHERE ClientID = " . $formdata['clientID'] . " AND ServiceID =" . $formdata['serviceID'];
					mysqli_query( $dbHandle, $query  );
					if ( mysqli_errno( $dbHandle ) == 0 )
					{
						$query  = "DELETE FROM PCPObjectivesGoalManagement WHERE ClientID = " . $formdata['clientID'] . " AND ServiceID =" . $formdata['serviceID'];
						mysqli_query( $dbHandle, $query  );
						if ( mysqli_errno( $dbHandle ) == 0 )
						{
							$retStr = array( SUCCESS, ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ) . "'s PCP successfully retired." );
						}
						else {
							
							$retStr = array( FAIL, mysqli_error($dbHandle) );
							mysqli_rollback($dbHandle);
							closeDB( $dbHandle );
							return $retStr;
						}						
					}
					else {
						$retStr = array( FAIL, mysqli_error($dbHandle) );
						mysqli_rollback($dbHandle);
						closeDB( $dbHandle );
						return $retStr;
					}
				}
				else {
					$retStr = array( FAIL, mysqli_error($dbHandle) );
					mysqli_rollback($dbHandle);
					closeDB( $dbHandle );
					return $retStr;
				}
		  }
		  else {
		  	$retStr = array( FAIL, mysqli_error($dbHandle) );
			mysqli_rollback($dbHandle);
			closeDB( $dbHandle );
			return $retStr;
		  }
		
	   mysqli_commit($dbHandle);
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		return $retStr;
	}
	
	function putPCPObjectiveGoal( $formdata )
	{
	
		  $retStr = ""; 
		  $dbHandle = loginToDB();
		  $objectiveID = getNextID( 'PCPClientsObjectives', 'ObjectiveID' );
		  
		  if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		 }
		
		  $query =  "INSERT INTO `PCPClientsObjectives`(`ObjectiveID`, `ServiceID`, `EntryDate`, `ObjectiveDescription` ) VALUES ( ";	
		  $query .=  $objectiveID . ", ";
		  $query .=  $formdata['serviceID'] . ", ";
		  $query .=  "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['entrydate'] ) . "', '%m/%d/%Y'), ";	  
		  $query .=  "'" . sql_quote( $dbHandle,  $formdata['description'] ) . "' ";
		  $query .= " )";
		  
		  //echo $query . "<br />";
		  
		  mysqli_query( $dbHandle, $query  );
		  if ( mysqli_errno( $dbHandle ) != 0 ) {
				$retStr = array( FAIL, mysqli_error($dbHandle) );
				mysqli_rollback($dbHandle);
				closeDB( $dbHandle );
				return $retStr;
		  }
		  else {
		  	 for( $i = 1; $i <= $formdata['numgoalstoadd']; $i++ ) {
			 	 
				$daysPerWeek = ( $formdata['goalfreq'.$i] == 'D' ) ? 7 : $formdata['goalweekdays'.$i];
				$goalID = getNextID( 'PCPGoals', 'GoalID', $dbHandle );
				
			 	$query =  "INSERT INTO `PCPGoals`(`GoalID`, `ObjectiveID`, `GoalType`, `GoalDataFreq`, `GoalDataNumDays`, `GoalDescription`) VALUES ( "; 
			 
				$query .=  $goalID . ", ";
				$query .=  $objectiveID . ", ";
			  	$query .=  "'" . trim($formdata['goaltype'.$i]) . "', ";
				$query .=  "'" . trim($formdata['goalfreq'.$i]) . "', ";
				$query .=  $daysPerWeek . ", ";
				$query .=  "'" . sql_quote( $dbHandle,  str_replace( array( "\n", "\t", "\r"), " ", str_replace("'", "\'", $formdata['goaldescription'.$i])) ) . "' ";
		  
			 	$query .= " )";
				
				//echo $query . "<br />";
				
				mysqli_query( $dbHandle, $query  );
			    if ( mysqli_errno( $dbHandle ) != 0 ) {
					$retStr = array( FAIL, mysqli_error($dbHandle) );
					mysqli_rollback($dbHandle);
					closeDB( $dbHandle );
					return $retStr;
			    }
			 }
		  }

		  $retStr = array( SUCCESS, "New objective/goals saved successfully" );
		  mysqli_commit($dbHandle);
		  	
		  // Free result set
		  if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		  closeDB( $dbHandle );
		  return $retStr;
	}
	
	function getPCPServiceObjectives( $formdata )
	{
		$dbHandle = loginToDB();
		$serviceObjectives = array();
		
		$query  = "SELECT `ObjectiveID`, `ServiceID`, `ObjectiveDescription` FROM `PCPClientsObjectives`   ";
		$query .= "WHERE `ServiceID`= " . $formdata['pcpprogram'] . " AND `ObjectiveStatus`='Open'";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$serviceObjectives[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $serviceObjectives;
		
	}	
	
	function getPCPObjectiveGoals( $objectiveID )
	{
		$dbHandle = loginToDB();
		$serviceObjectives = array();
		
		$query  = "SELECT `GoalID`, `GoalDescription` FROM `PCPGoals` WHERE `ObjectiveID`=" . $objectiveID . " AND `GoalStatus`='Open'";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$serviceObjectives[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $serviceObjectives;
	}
	
	function getClientsPCPDates()
	{
			$dbHandle = loginToDB();

			$rtn = "";			
			
			$query  = "SELECT FormatDateMMDDYYYY(`CurrentIPDate`) as CurrentIPDate, FormatDateMMDDYYYY(`NextIPDate`) as NextIPDate FROM `PCPDateManagement` ";
			$query .= " WHERE `ClientID`= " . $_GET['clientID'] . " AND `ServiceID`= " . $_GET['serviceID'] . "";
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtn = array( SQLERROR, mysqli_error($dbHandle) . "<br><br>QUERY<BR>=====<br><br>" . $query );
				
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return array( SQLERROR, $rtn );
			}
			else
			{
				$rtn = array(); 
				while ( $row = mysqli_fetch_assoc( $result ) )
				{
					$rtn[] = $row;
				}
			}
				
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		   closeDB( $dbHandle );
		   return $rtn;
	  }
	 
	 function getNextIPSeqID( $clientID, $serviceID, $objID, $goalID  )
	 {
		$dbHandle = loginToDB();
		$query  = "select COALESCE( max( SeqID ), 0 ) + 1 as SeqID from PCPObjectivesGoalManagementHistory where ";
		$query .= " ClientID = " . $clientID . " and ServiceID = " . $serviceID . " and ObjectiveID = " . $objID . " and GoalID = " . $goalID;
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $row[0];
	}
		
	function assignPCPObjectiveGoals( $formdata )
	{

		 if ( !isset($formdata['objectiveID']) || ( isset($formdata['objectiveID']) && count($formdata['objectiveID']) <= 0 ) ) {
			
				return array( FAIL, "No objectives selected for " . getClientName($formdata['clientID']) );
		 }
		
		 if ( !isset($formdata['goalID']) || ( isset($formdata['goalID']) && count($formdata['goalID']) <= 0 ) ) {
			
				return array( FAIL, "Objectives selected but no corresponding goals selected" );
		 }
	
		 if ( trim($formdata['beginDate']) == '' || trim($formdata['endDate']) == '' ) {
		 
		 	return array( FAIL, "Objective/Goal begin date, end date or both not provided." );
		 }
		 
		  $retStr = ""; 
		  $dbHandle = loginToDB();
		  
		  if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		 }
		
		  for( $j = 0; $j < count($formdata['goalID']); $j++ )
		  {
		  		
			  
		      list( $objectiveID, $goalID ) = explode( ":", $formdata['goalID'][$j] );
			  $seqID = getNextIPSeqID( $formdata['clientID'], $formdata['serviceID'], $objectiveID, $goalID  );
			  
			  $query =  "INSERT INTO `PCPObjectivesGoalManagement`(`ClientID`, `ServiceID`, `ObjectiveID`, `GoalID`, `SeqID`, `BeginDate`, `EndDate`) VALUES ( ";
			  $query .=  $formdata['clientID'] . ", ";
			  $query .=  $formdata['serviceID'] . ", ";
			  $query .=  $objectiveID . ", ";
			  $query .=  $goalID . ", ";
			  $query .=  $seqID . ", ";
			  $query .=  "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['beginDate'] ) . "', '%m/%d/%Y'), ";	
			  $query .=  "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['endDate'] ) . "', '%m/%d/%Y') ";	 
			    
			  $query .= " )";
			  
			  //echo $query . "<br />";
			  
			  mysqli_query( $dbHandle, $query  );
			  if ( mysqli_errno( $dbHandle ) != 0 ) {
					$retStr = array( FAIL, mysqli_error($dbHandle) );
					mysqli_rollback($dbHandle);
					closeDB( $dbHandle );
					return $retStr;
			  }
		  }

		  mysqli_commit($dbHandle);
		  	
		  // Free result set
		  if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		  $retStr = array( SUCCESS, "Objective/goals successfully assigned to " . getClientName($formdata['clientID']) );
		  closeDB( $dbHandle );
		  return $retStr;
	}
	
?>
