<?php
	
	//
	// Attendance Functions
	//
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/attendance.db.php' );
	
	function getAwakeOvernightData( $formdata )
	{
		$rtnArray = array();
		$dbHandle    = loginToDB();
		
		global  $monthToDigit;
		
		$query  = " SELECT awakeDate, DATE_FORMAT( awakeDate,  '%m/%d/%Y' ) , COALESCE( hour11p12a,  '0' ) , COALESCE( hour12a1a,  '0' ) , ";
		$query .= " COALESCE( hour1a2a,  '0' ) , COALESCE( hour2a3a,  '0' ) , COALESCE( hour3a4a,  '0' ) , COALESCE( hour4a5a,  '0' ) , ";
		$query .= " COALESCE( hour5a6a,  '0' ) , COALESCE( hour6a7a,  '0' ) , COALESCE( hour7a8a,  '0' ) , staffInitials ";
        $query .= " FROM AwakeOvernightChecklist WHERE clientID = " . $formdata['resident'] . " and MONTH(awakeDate) = " . $monthToDigit[$formdata['chart_month']] .  "";
		$query .= " and YEAR(awakeDate) = " . $formdata['chart_year'] . " ORDER BY clientID, awakeDate ";
		
		//echo $query;
							
		$idx = 1;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$retStr[$idx++] = $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( SUCCESS, $retStr ); 
			
		}
		else {
			$msg =  mysqli_error($dbHandle);
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
			closeDB( $dbHandle );
			return array( FAIL, $msg );
		}
	}
	
	function postBloodPressure( $bpRec )
	{
		$dbHandle = loginToDB();
		
		// BP Readings
		$NormalS = 90; $NormalD = 60;
		$ElevatedS = 120; $ElevatedD = 80;
		$HighS = 140; $HighD = 90;
		
		$query = "SELECT ifnull(max(`BPLogID`),0)+1 as BPLogID FROM `BloodPressureLog`";
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_assoc($result);
		$bpLogID = $row['BPLogID'];
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		// Determine Blood Pressure Staus
		$bpStatus = 'High';
		if ( $bpRec['systolic'] < $NormalS || $bpRec['diastolic'] < $NormalD ) {
			$bpStatus = 'Low';
		}
		else if ( $bpRec['systolic'] <= $ElevatedS && $bpRec['diastolic'] <= $ElevatedD ) {
			$bpStatus = 'Normal';
		}
		else if ( $bpRec['systolic'] < $HighS && $bpRec['diastolic'] < $HighD ) {
			$bpStatus = 'Elevated';
		}

		
		$query = "INSERT INTO `BloodPressureLog`(`BPLogID`, `ClientID`, `LogDate`, `LogTime`, `Systolic`, `Diastolic`, `Pulse`, `BPStatus`, `Notes`) VALUES ( ";
		$query .= $bpLogID . ", " . $bpRec['client'] . ", ";
		$query   .= " STR_TO_DATE( '" . $bpRec['bplogdate'] . "', '%m/%d/%Y'), ";
		$query .= "'" . $bpRec['bplogtime'] . "', ";
		$query .=  $bpRec['systolic'] . ", " .$bpRec['diastolic'] . ", " . $bpRec['pulse'] . ", ";
		$query .= "'" . $bpStatus . "', '" . $bpRec['notes'] . "' ";
		$query .= " )";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$errMsg = "Error No: " . mysqli_errno( $dbHandle ) . " Error Message:  " . mysqli_error( $dbHandle );
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array(FAIL, $errMsg );
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		return array( SUCCESS, "" );
	}
	
	function postChecklistInfo( $formdata )
	{
		$rtnArray = array();
		$dbHandle    = loginToDB();
		$numRecords = $formdata['numDays'];

		for ( $i = 1; $i <= $numRecords; $i++ )
		{
			
			$staffInit = $formdata['staffInitials-'.$i];
			if ( $formdata['hour11p12a-'.$i] == '' && $formdata['hour12a1a-'.$i] == '' && $formdata['hour1a2a-'.$i] == '' && 
			     $formdata['hour2a3a-'.$i] == '' && $formdata['hour3a4a-'.$i] == '' && $formdata['hour4a5a-'.$i] == '' && 
				 $formdata['hour5a6a-'.$i] == '' && $formdata['hour6a7a-'.$i] == '' && $formdata['hour7a8a-'.$i] == '' )
			{
				$staffInit = '';
			}
			$query  = "INSERT INTO AwakeOvernightChecklist(clientID, awakeDate, hour11p12a, hour12a1a, hour1a2a, hour2a3a, ";
			$query .= " hour3a4a, hour4a5a, hour5a6a, hour6a7a, hour7a8a, staffInitials) VALUES ( ";
			$query .=  $formdata['resident'] . ", '" . sql_quote( $dbHandle,  $formdata['awakeDate-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour11p12a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour12a1a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour1a2a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour2a3a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour3a4a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour4a5a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour5a6a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour6a7a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour7a8a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
			$query .=  " ) ON DUPLICATE KEY UPDATE ";
			$query .=  " hour11p12a = '" . sql_quote( $dbHandle,  $formdata['hour11p12a-'.$i] ) . "', ";
			$query .=  " hour12a1a = '" . sql_quote( $dbHandle,  $formdata['hour12a1a-'.$i] ) . "', ";
			$query .=  " hour1a2a = '" . sql_quote( $dbHandle,  $formdata['hour1a2a-'.$i] ) . "', ";
			$query .=  " hour2a3a = '" . sql_quote( $dbHandle,  $formdata['hour2a3a-'.$i] ) . "', ";
			$query .=  " hour3a4a = '" . sql_quote( $dbHandle,  $formdata['hour3a4a-'.$i] ) . "', ";
			$query .=  " hour4a5a = '" . sql_quote( $dbHandle,  $formdata['hour4a5a-'.$i] ) . "', ";
			$query .=  " hour5a6a = '" . sql_quote( $dbHandle,  $formdata['hour5a6a-'.$i] ) . "', ";
			$query .=  " hour6a7a = '" . sql_quote( $dbHandle,  $formdata['hour6a7a-'.$i] ) . "', ";
			$query .=  " hour7a8a = '" . sql_quote( $dbHandle,  $formdata['hour7a8a-'.$i] ) . "', ";
			$query .=  " staffInitials = '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
						
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);
          			
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return array( SQLERROR, $rtnMsg );
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "Awake Overnight Checklist for " . getClientName( $formdata['resident'] ) . " successfully saved." );
		
	}
?>
