<?php

	function activateHouse( $houseID )
	{
		$house = getHouseName( $houseID );
		$dbHandle = loginToDB();
		
		$query    = "UPDATE `Houses` SET `HouseInUse`='Y' WHERE `HouseID`=" . $houseID;
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );		
				
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "activateHouse() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $house . " House was successfully activated." );
	}
	
	
	function deactivateHouse( $houseID )
	{
		$house = getHouseName( $houseID );
		$dbHandle = loginToDB();
		
		$query = "SELECT * FROM `Clients` WHERE HouseID = " . $houseID . "";
		$result = mysqli_query( $dbHandle, $query  );	
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "deactivateHouse() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		if ( mysqli_num_rows($result) > 0 ) {
		
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "Deactivate House failed, since there is at least 1 person in " . $house );
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		$query    = "UPDATE `Houses` SET `HouseInUse`='N' WHERE `HouseID`=" . $houseID;
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "deactivateHouse() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS,  $house . " House was successfully deactivated." );
	}
	
	function saveHouseInfo( $houseRec )
	{
		$houseID = getNextID( 'Houses', 'HouseID' );		
		$dbHandle = loginToDB();
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		}
		$EmergencyDrillRoot = preg_replace( '/-{2,}/', '-', preg_replace( '/\'/', '', preg_replace('/\s/', '-', $houseRec['housename'])));
		$query    = "INSERT INTO `Houses`(`HouseID`, `SiteLicenseNo`, `HouseName`, `HouseAddress`, `HousePhone`, `FaxNumber`, ";
		$query   .= "`HouseInUse`, `Latitude`, `Longitude`, `EmergencyDrillRoot`, `EmergencyMeetingPlace`, `DisasterShelter`, `ProviderMA`) VALUES ( ";
		$query   .= $houseID . ", ";
		$query   .= "'" . sql_quote( $dbHandle, $houseRec['sitenumber'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, preg_replace( '/\s+/', ' ', $houseRec['housename'] ) ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $houseRec['houseaddress'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $houseRec['housephone'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $houseRec['fax'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $houseRec['houseinuse'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $houseRec['latitude'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $houseRec['longitude'] ) . "', ";
		$query   .= "'" . $EmergencyDrillRoot . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $houseRec['emergencyplace'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $houseRec['disastersheltr'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $houseRec['providerMA'] ) . "' ";
		$query   .= " ) ";	
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "saveHouseInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS,  $houseRec['housename'] . " was successfully added." );
	
	}
?>
