<?php
	
	//
	// Add New Documents
	//
	function postNewDocument( $docRec )
	{

		$whichDocs = array( 'C' => 'CorporateDocsLkup', 'S' => 'StaffDocsLkup' );
		$docID = getNextID( $whichDocs[$docRec['doctype']], 'DocID' );	
		$dbHandle = loginToDB();
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		}
		
		if ( $docRec['doctype'] == 'C' ) {
			$query = "INSERT INTO `CorporateDocsLkup`(`DocID`, `Document`, `RenewalInterval`, `NotifyDaysBefore`, `FormField`, `CalcRenewDate` ) VALUES ( ";
		}
		else {
			$query = "INSERT INTO `StaffDocsLkup`(`DocID`, `Document`, `RenewInterval`, `NotifyDaysBefore`, `FormField`, `CalcRenewDate`) VALUES ( ";
		}
		
		$query .=   $docID . ", ";
		$query .=  "'" . sql_quote( $dbHandle, $docRec['docname'] ) . "', ";
		$query .=  $docRec['renewalinterval'] . ", ";
		$query .=  $docRec['notifyBefore'] . ", ";
		$query .=  "'" . sql_quote( $dbHandle, $docRec['formField'] ) . "', ";
		$query .=  "'" . sql_quote( $dbHandle, $docRec['calcNewDate'] ) . "' ";
		$query .= " )";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "postNewDocument() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		if ( $docRec['doctype'] == 'C' ) {
			$query = "INSERT INTO `CorporateDocMonitor`(`DocID`) VALUES (" . $docID . " )";
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				mysqli_rollback($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "postNewDocument() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
				
		return array( SUCCESS, "New document ( " . $docRec['docname'] . " ) to monitor posted successfully." );
	}
	
	//
	// Get Corporate Documents to be updated
	//
	function getCorporateDocuments()
	{
		$dbHandle = loginToDB();
		$docslist = array();
		
		$query  = "SELECT  a.`DocID`, `Document`, FormatDateMMDDYYYY(`DocDate` ) AS 'DocDate', FormatDateMMDDYYYY(`RenewalDate`) AS 'RenewalDate'";
		$query .= " FROM `CorporateDocMonitor` a, `CorporateDocsLkup` b WHERE  a.`DocID`= b.`DocID` ORDER BY 2" ;

		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "getCorporateDocuments() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " . PHP_EOL . "Please notify the administrator." );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$docslist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $docslist );
	}
	
	//
	//  Update Corporate Doc Dates
	//
	function updateCorpDocDates( $docRec )
	{
		//echo dpp( $docRec );
		
		$dbHandle = loginToDB();
		$staffRtn = array();
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin a update transaction. Please notify the application administrator" );
		}
			
		
		for ( $j = 0; $j < count($docRec['docID']); $j++ ) 
		{ 
			$query    = "UPDATE `CorporateDocMonitor` SET ";
			$query   .= "`DocDate` = STR_TO_DATE( '" . $docRec[$docRec['docName'][$j] . '_docdt'] . "', '%m/%d/%Y'), ";
			$query   .= "`RenewalDate` = STR_TO_DATE( '" . $docRec[$docRec['docName'][$j] . '_rnwdt'] . "', '%m/%d/%Y') ";
			$query   .= " WHERE `DocID` = " . $docRec['docID'][$j] . " ";
			
			//echo "<br>" . $docRec['docID'][$j] . ": " . $query;
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				mysqli_rollback($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "updateCorpDocDates() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		
		}

		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, "Company Document(s) Dates successfully updated" );
			
	}
?>
