<?php
	
	function getStaffDocsDue()
	{
		$dbHandle = loginToDB();
		$rtnStr = array();
		$OK = FAIL;
		$i = 0;
		
		$query = "SELECT  b.`StaffID`, a.`Document`, DATE_FORMAT( b.`RenewalDate`, '%M %e, %Y' ), abs(datediff(curdate(), b.`RenewalDate` )) FROM `StaffDocsLkup` a, `StaffDocMonitor` b WHERE a.`DocID` = b.`DocID` and curdate() < b.`RenewalDate` and abs(datediff(curdate(), b.`RenewalDate` )) <= a.`NotifyDaysBefore` and b.`DocRequired` = 'Y' and b.`StaffID` in ( SELECT `StaffID` FROM `Staff` WHERE `Status`='Active' )";	
		
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			$OK = SUCCESS;
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$rtnStr[$i++] =  $row;
			}
		}
						
								   // Free result set
								   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
			closeDB( $dbHandle );
		return array( $OK, $rtnStr );
	}
	
	function getExpiredStaffDocs( $staffID = 0 )
	{
		$dbHandle = loginToDB();
		$rtnStr = array();
		$OK = FAIL;
		$i = 0;
		
		//$query = "SELECT b.`StaffID`, a.`Document`, coalesce( DATE_FORMAT( b.`RenewalDate`, '%M %e, %Y' ),  'January 1, 1970' ) as 'RenewDate', coalesce( abs(datediff(curdate(), b.`RenewalDate` )), a.`NotifyDaysBefore`) FROM `EmployeeDocsLkup` a, `EmployeesDocMonitor` b WHERE b.`StaffID` in ( select `StaffID` from `Employees` )  and a.`DocID` = b.`DocID` and curdate() > b.`RenewalDate` and b.`DocRequired` = 'Y'";
		$staffCondition = ( $staffID == 0 ) ? "" : " b.`StaffID` = " . $staffID . " and ";
		$query = "SELECT b.`StaffID`, a.`Document`, coalesce( DATE_FORMAT( b.`RenewalDate`, '%M %e, %Y' ),  'No Date Provided' ) as 'RenewDate', coalesce( abs(datediff(curdate(), b.`RenewalDate` )), 'Undetermined' ) FROM `StaffDocsLkup` a, `StaffDocMonitor` b WHERE " . $staffCondition . " b.`StaffID` in ( select `StaffID` FROM `Staff` WHERE `Status`='Active' )  and a.`DocID` = b.`DocID` and curdate() > b.`RenewalDate` and b.`DocRequired` = 'Y'";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			$OK = SUCCESS;
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$rtnStr[$i++] =  $row;
			}
		}
						
								   // Free result set
								   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
			closeDB( $dbHandle );
		return array( $OK, $rtnStr );
	}
	
	function getCISHDocsDue()
	{
		$dbHandle = loginToDB();
		$rtnStr = array();
		$OK = FAIL;
		$i = 0;
		
		$query = "SELECT a.`Document`, DATE_FORMAT( b.`RenewalDate`, '%M %e, %Y' ), abs(datediff(curdate(), b.`RenewalDate` )) FROM `CorporateDocsLkup` a, `CorporateDocMonitor` b WHERE a.`DocID` = b.`DocID` and curdate() < b.`RenewalDate` and abs(datediff(curdate(), b.`RenewalDate` )) <= a.`NotifyDaysBefore` ";	
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			$OK = SUCCESS;
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$rtnStr[$i++] =  $row;
			}
		}
						
								   // Free result set
								   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
			closeDB( $dbHandle );
		return array( $OK, $rtnStr );
	}
	
	function getExpiredCISHDocs()
	{
		$dbHandle = loginToDB();
		$rtnStr = array();
		$OK = FAIL;
		$i = 0;
		
		$query = "SELECT a.`Document`, DATE_FORMAT( b.`RenewalDate`, '%M %e, %Y' ), abs(datediff(curdate(), b.`RenewalDate` )) FROM `CorporateDocsLkup` a, `CorporateDocMonitor` b WHERE a.DocID = b.DocID and curdate() > b.`RenewalDate` ";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			$OK = SUCCESS;
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$rtnStr[$i++] =  $row;
			}
		}
						
								   // Free result set
								   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		
		closeDB( $dbHandle );
		return array( $OK, $rtnStr );
	}
	
	function getAdminEmails( $all = 0, $staffID = 0 )
	{
		$dbHandle = loginToDB();
		$retStr = "";
		
		$emails = array();
		$staffAnd = ($staffID == 0) ? "" : " and StaffID = " . $staffID . "";
	
		if ( $staffID != 0 )
			$query  = "select `StaffEmail` from `Staff` where `Status` = 'Active'  " . $staffAnd;
		else {
			if ( $all == 0 )
				$query  = "select `StaffEmail` from `Staff` where `Status` = 'Active'  ";
			else if ( $all == 1 )
				$query  = "select a.`StaffEmail` from `Staff` a, `StaffAuthAz` b where  a.`Status` = 'Active' and a.`StaffID` = b.`StaffID` and b.`StaffRoleID` = 1";		
			else if ( $all == 2 )
				$query  = "select StaffEmail from Staff where  Status = 'Active' and StaffID in ( select StaffID from `ReportRecipients` WHERE `Applications` = 'Y' ) ";
			else
				$query  = "select StaffEmail from Staff where  Status = 'Active' and StaffID in ( select StaffID from `ReportRecipients` ) ";
		}
		$query .= $staffAnd;
				
		//echo "
		//
		//	" . $query . "
		//	
		//	";
		$result = mysqli_query( $dbHandle, $query  );
	
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			$i = 0;
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$emails[$i++] =  $row[0];
			}
			$retStr = array( SUCCESS, $emails );
		}
		else
			$retStr = array( FAIL, mysqli_error($dbHandle) );
				
						   // Free result set
						   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
		closeDB( $dbHandle );
		return $retStr;
	}
	
	function getChangedEmployeeDocs()
	{
		$dbHandle = loginToDB();
		$changedDocs = array();
		
		$query = " SELECT a.`StaffID`, a.`DocID`, a.`DocRequired`, date_format(a.`DocDate`, \"%m-%e-%Y\") as DocDate, ";
		$query .= " date_format(a.`RenewalDate`, \"%m-%e-%Y\") as RenewalDate, date_format(a.`LastUpdateDatetime`, \"%m-%e-%Y %l:%i %p\") as LastUpdateDatetime , ";
		$query .= " a.`UpdatedBy`, concat( c.`StaffFname`, ' ', c.`StaffMInit`, ' ', c.`StaffLname` ) as StaffName, ";
		$query .= " d.`Document`, date_format(b.`DocDate`, \"%m-%e-%Y\") as DocDate1, date_format(b.`RenewalDate`,\"%m-%e-%Y\") as RenewalDate1 ";
		$query .= " FROM `StaffDocMonitor` a, `StaffDocMonitorHistory` b, Staff c, `StaffDocsLkup` d ";
		$query .= " WHERE a.`StaffID`=b.`StaffID` and a.`DocID` = b.`DocID` ";
		$query .= " AND ( a.`DocDate` != b.`DocDate` OR a.`RenewalDate` != b.`RenewalDate` ) ";
		$query .= " AND a.`StaffID`= c.`StaffID` AND a.`DocID` = d.`DocID` ";
		$query .= " AND ( a.`LastUpdateDatetime` is not NULL OR  a.`UpdatedBy` is not NULL ) ";
		$query .= " AND ABS(DATEDIFF( a.`LastUpdateDatetime`, NOW())) <= 30 ";
		$query .= " ORDER by StaffName,LastUpdateDatetime";

//echo $query;
		$result = mysqli_query( $dbHandle, $query  );
		$i = 0;
		while ($row = mysqli_fetch_row($result)) {
			$changedDocs[$i++] = $row;
		}
			
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $changedDocs;
	}
	
	function getNurseInfo()
	{
		$retStr = "";
		$dbHandle    = loginToDB();
		
		$query = "SELECT min(`StaffID`), concat(`StaffFname`, ' ', `StaffLname`), `Initials` ";
		$query .= " FROM `Employees` WHERE `AdminType`='N' and `Status`='Active' ";

		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
		
		return $row;
	}
	
	function getMARClientMedications( $formdata, $dupsOK = FALSE )
	{
		$retMedAdmin = $retPRNMedAdmin = $retFYIMedAdmin = array();
		$clientName = getClientName($formdata['clientID']);
		$dbHandle    = loginToDB();
		
		$getDistinct = ( $dupsOK === TRUE ) ? "" : " distinct ";
		$query  = "SELECT  " . $getDistinct . " a.MedID, b.MedName, a.MedDosage, a.SeqID, a.MedTime, date_format(a.`StartDate`, '%m/%d/%Y' ) as 'StartDate',
		a.TimeKey, a.Direction, a.`StartDate`, a.`MedType` FROM ClientsMedications a, Medications b where a.ClientID = " . $formdata['clientID'] . " and a.MedID = b.MedID and a.MedStatus != 'Discontinued' and a.`ServiceID` = " . $formdata['programID'] . " ";
		$query  .= " UNION ";
		$query  .= "SELECT  " . $getDistinct . " a.MedID, b.MedName, a.MedDosage, a.SeqID, a.MedTime, date_format(a.`StartDate`, '%m/%d/%Y' ) as 'StartDate',
		a.TimeKey, a.Direction, a.`StartDate`, a.`MedType` FROM ClientsMedicationsHistory a, Medications b where a.ClientID = " . $formdata['clientID'] . " and a.MedID = b.MedID and a.MedStatus = 'Discontinued' and a.`ServiceID` = " . $formdata['programID'] . " ";
		$query  .= " ORDER BY 10, 1, 7, 4 ";
		
		echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		
		$i = $j = $k = 1;
		while ( $row = mysqli_fetch_row( $result ) )
		{	
			if ( $row[9] == 4 )	
				$retPRNMedAdmin[$k++] = $row;
			else if ( $row[9] == 1 )
				$retFYIMedAdmin[$j++] = $row;
			else				
				$retMedAdmin[$i++] = $row;
		}
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( $retMedAdmin, $retFYIMedAdmin, $retPRNMedAdmin );
		//return $retMedAdmin;
	}
	
	function getMedDosages( $clientID, $medID, $programCd, $timeKey, $seqID )
	{
		$retStr = array();
		$dbHandle    = loginToDB();
		$i = 0;
		
		$query  = "SELECT `MedTime`, `MedDosage`, `StartDate` FROM `ClientsMedications` WHERE `ClientID` = " . $clientID;
		$query .= " and `MedID` = " . $medID . " and ServiceID = " . $programCd . "";
		//$query .= " and `SeqID` = " . $seqID . " and TimeKey = '" . $timeKey . "'";
		//echo $query . "<br />";
		
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
			$retStr[$i++] = $row;
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return $retStr;
	}
	
	function getResultValues($formdata)
	{
		$dbHandle    = loginToDB();
		//$i = 0;
		
		//echo pp($formdata);
		
		$query  = "SELECT * FROM `MARDailyResults` WHERE `ClientID` = " . $formdata[0];
		$query .= " and `MedID` = " . $formdata[1] . " and `SeqID` = " . $formdata[2];
		$query .= " and `TimeKey` = '" . $formdata[3] . "' and `Month` = '" . $formdata[4] . "'";
		$query .= " and `Year` = '" . $formdata[5] . "' and `MARType` = '" . $formdata[6] . "'";
		$query .= " and MedType = '" . $formdata[7] . "'";
		
		//echo $query . "<br />";
		
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $row;
	}
	
	function getDayInitClients()
	{
		global $agency_info;
		$dbHandle = loginToDB();
		$rtn = array();
		$state = substr(trim($agency_info['office_statezip']), 0, 2);
		
		$query   = "select a.ClientID from Clients a, `ServicesProvidedLkup` b, `StateLookup` c  WHERE   a.`ClientServiceID` in ( 'A', 'D' ) ";
		$query .= " AND a.`ClientServiceID` = b.`ServiceID` AND b.StateID = b.StateID AND `StateAbbrev` = '" . $state . "'";
		$query .= " AND a.IsDayClient = 'Y' AND UPPER(a.ClientStatus) = 'OPEN'";
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
				$rtn[] =  $row[0];						
		}
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
		closeDB( $dbHandle );
		return $rtn;
	}
	
	function getResidentialInitClients()
	{
		global $agency_info;
		$dbHandle = loginToDB();
		$rtn = array();
		$state = substr(trim($agency_info['office_statezip']), 0, 2);
		
		$query   = "select a.ClientID from Clients a  WHERE   `ClientServiceID` = " . 
		$agency_info['office_statezip'];
		$query .= " AND UPPER(a.ClientStatus) = 'OPEN'";
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
				$rtn[] =  $row[0];						
		}
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
		closeDB( $dbHandle );
		return $rtn;
	}
	
	
	
?>
