<?php
	
	function putCCS_Staff( $formdata )
	{
		
		$retStr = "";
		$staffID = getNextID( 'CCS_Staff', 'CCS_StaffID' );	
		$dbHandle    = loginToDB();
		
		$query = "INSERT INTO `CCS_Staff`(`CCS_StaffID`, `CCS_StaffName`, `Username`, `Password`, `Address`, `City`, `State`, ";
		$query .= " `ZipCode`, `CCS_StaffPhone`, `CCS_StaffCell`, `CCS_StaffFax`, `CCS_StaffEmail`, `CCS_StaffSupervisor`, `CCS_StaffSupervisorPhone`)";
		$query .= " VALUES( " . $staffID . ", ";
		$query .= "'" . sql_quote( $dbHandle,  trim( $formdata['firstname'] ) ) . ' ' . sql_quote( $dbHandle,  trim( $formdata['lastname'] ) )  . "', ";
		$query .= "'" . $formdata['username']  . "', ";
		$query .= "'" . password_hash( $formdata['password'], PASSWORD_DEFAULT ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['address'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['city'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['state'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['zipcode'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  formatPhone( $formdata['phonenum'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  formatPhone( $formdata['cellnum'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  formatPhone( $formdata['fax'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['staffemail'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['supervisor'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  formatPhone( $formdata['supervisorphone'] ) ) . "' ";
		$query .= " ) ";

		mysqli_query( $dbHandle, $query  );
		
		//echo "SQL Return Code = " . mysqli_errno( $dbHandle ) . " with error " . mysqli_error($dbHandle);
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg );
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "CCS Staff ( " . trim( $formdata['firstname'] ) . ' ' .  trim( $formdata['lastname'] ) . " ) successfully added." );
	}
	
	function updateCCS_StaffInfo( $formdata )
	{
		
		$retStr = "";
		$dbHandle    = loginToDB();
		
		$query = "UPDATE `CCS_Staff` SET ";
		$query .= " `CCS_StaffName`='" . sql_quote( $dbHandle,  trim( $formdata['staffname'] ) ) . "', ";
		$query .= " `Address`='" . sql_quote( $dbHandle,  $formdata['address'] ) . "', ";
		$query .= " `City`='" . sql_quote( $dbHandle,  $formdata['city'] ) . "', ";
		$query .= " `State`='" . sql_quote( $dbHandle,  $formdata['state'] ) . "', ";
		$query .= " `ZipCode`='" . sql_quote( $dbHandle,  $formdata['zipcode'] ) . "', ";
		$query .= " `CCS_StaffPhone`='" . sql_quote( $dbHandle,  formatPhone( $formdata['phonenum'] ) ) . "', ";
		$query .= " `CCS_StaffCell`='" . sql_quote( $dbHandle,  formatPhone( $formdata['cellnum'] ) ) . "', ";
		$query .= " `CCS_StaffFax`='" . sql_quote( $dbHandle,  formatPhone( $formdata['fax'] ) ) . "', ";
		$query .= " `CCS_StaffEmail`='" . sql_quote( $dbHandle,  $formdata['staffemail'] ) . "', ";
		$query .= " `CCS_StaffSupervisor`='" . sql_quote( $dbHandle,  $formdata['supervisor'] ) . "', ";
		$query .= " `CCS_StaffSupervisorPhone`='" . sql_quote( $dbHandle,  formatPhone( $formdata['supervisorphone'] ) ) . "' ";
		$query .= "  WHERE `CCS_StaffID` = " . $formdata['staffID'] . " ";

	//	echo $query;
		
		mysqli_query( $dbHandle, $query  );
		
		//echo "SQL Return Code = " . mysqli_errno( $dbHandle ) . " with error " . mysqli_error($dbHandle);
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg );
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "CCS Staff ( " . trim( $formdata['staffname'] ) . " ) successfully updated." );
	}
	
	function assignCCS_Staff( $formdata )
	{
		$retStr = "";
		$dbHandle    = loginToDB();
		global $CLIENTREF;
		
		for( $i = 1; $i <= MULTIPLE_TRANSACTIONS; $i++ )
		{
			if ( isset($formdata['clientID'.$i] ) && isset($formdata['ccsstaff'.$i] ) )
			{
				$query = "UPDATE `Clients` SET `CCS_StaffID` = " . $formdata['ccsstaff'.$i] . " WHERE `ClientID` = " . $formdata['clientID'.$i] . " ";
				
				mysqli_query( $dbHandle, $query  );
				if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$rtnMsg = mysqli_error($dbHandle);
          			
				   // Free result set
				   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

					closeDB( $dbHandle );
					return array( FAIL, $rtnMsg );
				}
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "All selected CCS Staff members have been assigned to their respective " . rtrim(trim($CLIENTREF), "s") );
	}
	
	function updateCCS_StaffLeaving( $exitInfo )
	{
			$dbHandle = loginToDB();
			$retStr = ""; 				
			
			$query   = "UPDATE `CCS_Staff` SET `StatusDate`=STR_TO_DATE('" . $exitInfo['statusChgDate'] . "', '%m/%d/%Y'), ";
			$query  .= " `StatusReason`='" . sql_quote( $dbHandle, $exitInfo['leavereason'] ) . "', ";
			$query  .= " `Status`= 'Not Active' WHERE `CCS_StaffID` = " . $exitInfo['staffname'] . "";
		
			//echo $query;
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) == 0 )
			{
				// move record to history
				$query  = " insert ignore into CCS_StaffHistory select * from CCS_Staff where CCS_StaffID = " . $exitInfo['staffname'];
				mysqli_query( $dbHandle, $query  );
				if ( mysqli_errno( $dbHandle ) == 0 )
				{
					//deletre for current table if move to history OK
					$query  = " delete from CCS_Staff where CCS_StaffID = " . $exitInfo['staffname'];
					mysqli_query( $dbHandle, $query  );
				}
				$retStr = array( SUCCESS, getCCS_StaffName($exitInfo['staffname']) . "'s record updated successfully " );
			}
			else
			  $retStr = array( FAIL, mysqli_error($dbHandle) );
				
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return $retStr;
	}

?>
