<?php

	function userSignOn( $userRec )
	{		
		$dbHandle = loginToDB();
		$userrec = array();
		
		$query  = "SELECT a.`StaffID`,  b.`StaffPassword` ";
		$query .= " FROM `Staff` a, `StaffAuthAz` b ";
		$query .= " WHERE a.`StaffID`=b.`StaffID`  ";
		$query .= " AND a.`Status`='Active' AND b.`Username` = ? ";
		$query .= " AND b.`AdminByPass`='N' ";
		
		$query .= " UNION ";
		
		$query .= "SELECT a.`StaffID`, b.`StaffPassword` ";
		$query .= " FROM `Staff` a, `StaffAuthAz` b ";
		$query .= " WHERE a.`StaffID`=b.`StaffID`  ";
		$query .= " AND a.`Status`='Active' AND b.`Username` = ? ";
		$query .= " AND b.`AdminByPass`='Y' ";
		
		//echo $query;
		
		/* create a prepared statement */
		$stmt = mysqli_prepare($dbHandle, $query );
		
		if (!$stmt) {
			$error = mysqli_error($dbHandle);
			echo "IN error branch";
			closeDB( $dbHandle );
			return array( FAIL, $error );
		}
		else {
			/* bind parameters for markers */
			mysqli_stmt_bind_param($stmt, "ss", $userRec['username'], $userRec['username']);
			
			/* execute query */
			mysqli_stmt_execute($stmt);
			
			/* bind result variables */
			mysqli_stmt_bind_result($stmt, $userrec['StaffID'], $userrec['StaffPassword'] );
			
			/* fetch value */
			mysqli_stmt_fetch($stmt);
			
			//echo dpp($userrec);
			
			closeDB( $dbHandle );
			return array( SUCCESS, $userrec );
		}
	
	}
	
	function userSignOnDetails( $userRec )
	{		
		$dbHandle = loginToDB();
		$userrec = array();
		
		$query  = "SELECT a.`StaffID`, c.`HouseID`, a.`StaffFname`, a.`StaffLname`, a.`StaffGender`, a.`StaffType`, a.`StaffEmail`, b.`StaffRoleID`, ";
		$query .= "  b.`PswdReset`, d.`Position`, e.`HouseName`, c.`IsConfirmed`, c.`isEmailVerified`, b.`Username`,  c.`IsDriver` ";
		$query .= " FROM `Staff` a, `StaffAuthAz` b, `StaffIndicators` c, `StaffPositions` d, `Houses` e ";
		$query .= " WHERE a.`StaffID`=b.`StaffID` AND a.`StaffID`=c.`StaffID` ";
		$query .= " AND c.`PositionID` = d.`PositionID` AND c.`HouseID` = e.`HouseID` ";
		$query .= " AND a.`Status`='Active' AND b.`Username` = '".  $userRec['username'] . "'";
		$query .= " AND b.`AdminByPass`='N' ";
		
		$query .= " UNION ";
		
		$query .= "SELECT a.`StaffID`, b.`ByPassHouseID` as 'HouseID', a.`StaffFname`, a.`StaffLname`, a.`StaffGender`, a.`StaffType`, a.`StaffEmail`, ";
		$query .= " b.`StaffRoleID`, b.`PswdReset`, d.`Position`, e.`HouseName`, c.`IsConfirmed`, c.`isEmailVerified`, b.`Username`,  c.`IsDriver` ";
		$query .= " FROM `Staff` a, `StaffAuthAz` b, `StaffIndicators` c, `StaffPositions` d, `Houses` e ";
		$query .= " WHERE a.`StaffID`=b.`StaffID` AND a.`StaffID`=c.`StaffID` ";
		$query .= " AND c.`PositionID` = d.`PositionID` AND c.`HouseID` = e.`HouseID` ";
		$query .= " AND a.`Status`='Active' AND b.`Username` = '".  $userRec['username'] . "'";
		$query .= " AND b.`AdminByPass`='Y' ";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errMessage = "Error #: " . mysqli_errno($dbHandle) . " Error Message: " . mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, $errMessage );
		}
		
		if ( mysqli_num_rows($result) == 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );	
			return array( FAIL, "There is no record that matches the username" );
		}
		
		if ( mysqli_num_rows($result) > 1 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );	
			return array( FAIL, "More than one record matched the username and password combination you entered. Please contact the administrator" );
		}
		
		$userrec = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $userrec );
		
	}
	
	function updateStaffSignOnDateTime( $staffID, $dt, $tm )
	{
		$dbHandle = loginToDB();
		
		// Update login date and time
		$query  = "UPDATE `StaffAuthAz` SET `LastLoginDate`='" . $dt . "',`LastLoginTime`='" . $tm. "' WHERE `StaffID`= ". $staffID . "";
		$result = mysqli_query( $dbHandle, $query  );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
	}
	
	function getSecurityQuestions()
	{
	
		$dbHandle = loginToDB();
		$questions = array();
		
		$query  = "SELECT * FROM `SecurityQuestions`";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$questions[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $questions;
	}
	
	function getUserSecurityQuestions( $userRec )
	{
		$dbHandle = loginToDB();
		$questions = array();
		
		$query  = "select a.`StaffID`, b.`Question`, c.`IDType`, c.`QuestionID`, c.`SeqID`, c.`Answer` ";
		$query .= " from `Staff` a, `SecurityQuestions` b, `SecurityAnswers` c, `StaffAuthAz` d";
		$query .= " WHERE  a.`Status` = 'Active' AND a.`StaffID` = c.`ID` AND a.`StaffID` = d.`StaffID` AND b.`QuestionID` = c.`QuestionID` ";
		$query .= " AND b.`SeqID` = c.`SeqID` AND ( LOWER(d.`Username`) = '" . strtolower( sql_quote( $dbHandle,  $userRec['unameemail'] ) ) . "' ";
		$query .= " OR  LOWER(a.`StaffEmail`) = '" . strtolower( sql_quote( $dbHandle,  $userRec['unameemail'] ) ) . "' ) " ;
	
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errNo = mysqli_errno($dbHandle);
			$errMsg = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "getUserSecurityQuestions() failed with Error #: " . $errNo . " and Error Message: " . $errMsg );
		}
		
		if ( mysqli_num_rows($result) == 0 ) {
			$errNo = mysqli_errno($dbHandle);
			$errMsg = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "getUserSecurityQuestions() failed. No Security Questions found for this user. Please contact the administrator for assistance" );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$questions[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $questions );
	}
	
	function resetPassword( $userRec )
	{
	
		$dbHandle = loginToDB();
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an password reset transaction. Please contact the administrator for assistance." );
		}
		
		//Delete existing rows;
		$query = "DELETE FROM `SecurityAnswers` WHERE `ID`= ". $userRec['staffID'] . "";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "resetPassword() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
				
		// Insert Security Answers
		for ( $i = 0; $i < count($userRec['answer']); $i++ ) {
		
			list( $id, $seqID ) = explode("-", $userRec['securityquestion'][$i] );
			$ansIDType = ( $SSIDTYPE == $userRec['idtype'] ) ? 'S' : 'E'; 
			
			$query   = "INSERT INTO `SecurityAnswers`(`ID`, `IDType`, `QuestionID`, `SeqID`, `Answer`) VALUES( ";
			$query  .= $userRec['staffID'] . ", ";
			$query  .= "'" . $ansIDType . "', ";
			$query  .= $id . ", ";
			$query  .= $seqID . ", ";
			$query  .= "'" . sql_quote( $dbHandle, $userRec['answer'][$i] ) . "' ";
			$query  .= ") ";
			
			//echo $query;
			
			$result = mysqli_query( $dbHandle, $query  );		
		
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				mysqli_rollback($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "resetPassword() with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		// update Password
		$query  = "UPDATE `StaffAuthAz` SET `PswdReset`='Y', `StaffPassword`= '" . password_hash(sql_quote( $dbHandle, trim( $userRec['newpassword'] )), PASSWORD_DEFAULT ) . "' WHERE `StaffID`= ". $userRec['staffID'] . "";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "resetPassword() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, "Password reset successful. " );
	}
	
	function resetForgottenPassword( $userRec )
	{
	
		//echo dpp($userRec);
		
		$dbHandle = loginToDB();
		
		//Delete existing rows;
		$query  = "SELECT `Answer` FROM `SecurityAnswers` WHERE `ID`= ". $userRec['staffID'] . " AND `IDType` = '" . $userRec['IDType'] . "'";
		$query .= " AND `QuestionID` = " . $userRec['questionID'] . " AND `SeqID` = " . $userRec['seqID'] . " ";
		
		//echo $query . PHP_EOL;
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "resetForgottenPassword() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		$row = mysqli_fetch_assoc( $result );
		$answer = $row['Answer'];
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		if ( trim($userRec['answer']) == trim($answer) ) { 			
			// update Password
			$query  = "UPDATE `StaffAuthAz` SET `StaffPassword`= '" . password_hash( sql_quote( $dbHandle, trim( $userRec['newpassword'] )), PASSWORD_DEFAULT ) . "' WHERE `StaffID`= ". $userRec['staffID'] . "";
			echo $query . PHP_EOL;
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "resetForgottenPassword() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
			
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( SUCCESS, "Password reset successful. " );
		}
		else {
		}
	}
	
	
	
?>
