<?php
	
	//
	// Get  Attendance
	//
	function getCurrentAttendance($attendParms)
	{
	
		//echo dpp($attendParms);
		
		$dbHandle = loginToDB();
		$attendRtn = array();
		list( $aMonth, $aYear ) = explode( "/", $attendParms['attendancemonth'] );
		$attendaceMonth = implode( "", array( $aYear, $aMonth ));
		
		/*
		$query  = "SELECT a.*, CONCAT( b.`ClientFname`, ' ', b.`ClientLname` ) As ClientName FROM `DailyAttendance` a, `Clients` b ";
		$query .= isset($attendParms['houseID'])  ? ", `Houses` c  " : " ";
		$query .= " WHERE a.`ProgramID`=" . $attendParms['programID'] . " AND ( ( a.`ProgramID`=b.`ClientServiceID` ";
		if ( isset($attendParms['houseID']) ) {
			$query .= " AND b.`HouseID`=" . $attendParms['houseID'];
		}
		$query .= " ) ";
		
		
		if ( $attendParms['programID'] == DAY_REHABILITATION_SERVICES ) {
			$query .= " OR b.IsDayClient = 'Y' ";
		}
		$query .= " ) ";
		
		$query .= " AND a.`Month`=" . $aMonth . " AND a.`Year`=" .  $aYear . " AND a.`ClientID`=b.`ClientID` ";
		
		
		if ( isset($attendParms['houseID']) ) {
			$query .= " AND b.`HouseID`=c.`HouseID` ";
		}
		$query .= " ORDER BY ClientName ";
		*/
		
		$query  = "SELECT a.*, CONCAT( b.`ClientFname`, ' ', b.`ClientLname` ) As ClientName FROM `DailyAttendance` a, `Clients` b , `ClientServices` c ";
		if ( isset($attendParms['houseID']) && $attendParms['houseID'] != 'A' )
		{
			$query .= " , `Houses` d ";
		}
		$query .= " WHERE a.`Month`=" . $aMonth . " AND a.`Year`=" .  $aYear . " AND a.`ClientID`=b.`ClientID` AND a.`ClientID`=c.`ClientID` ";
		$query .= " AND c.`ServiceID` = " . $attendParms['programID'] . " ";
		$query .= " AND c.`ClientServicesID` = a.`ClientServicesID` " . " ";
		$query .=  " AND ( ( $attendaceMonth >= DATE_FORMAT( c.`StartDate`,'%Y%m') AND c.`EndDate` is NULL ) OR  ";
		$query .=  " ( $attendaceMonth BETWEEN DATE_FORMAT( c.`StartDate`,'%Y%m') and date_format(c.`EndDate`, '%Y%m') ) ) ";
			
		if ( isset($attendParms['houseID']) && $attendParms['houseID'] != 'A' )
		{
			$query .= " AND c.`HouseID` = " . $attendParms['houseID'] . " ";
			$query .= " AND c.`HouseID` = d.`HouseID`" . " ";
		}
		$query .= " ORDER by ClientName ";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$error = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  array( FAIL, $error );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$attendRtn[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $attendRtn );
	}
	
	
	//
	// Mark Attendance
	//
	function markAttendance( $attendanceRec )
	{

		//echo dpp($attendanceRec);
		
		$dbHandle = loginToDB();
		$attendRtn = array();
		
		global $agency_info;
		
		list( $stateCD, $zipCode ) = explode( " ", $agency_info['office_statezip'] );
				
		for( $i = 0; $i < count($attendanceRec['clientID']); $i++ ) {
		
			if ( trim($attendanceRec['clientTotal'][$i]) == '' ) {
				$attendanceRec['clientTotal'][$i] = 0;
			}
			
			$ClientServiceHouse = $attendanceRec['houseID'];
			if ( $attendanceRec['houseID'] == 'A' ) {
				$ClientServiceHouse = $attendanceRec['clientpgmhouse'][$attendanceRec['clientID'][$i]];
			}
			$query = "SELECT `ClientServicesID` FROM `ClientServices` WHERE `ClientID`=" . $attendanceRec['clientID'][$i] . " ";
			$query .= " AND `ServiceID`=" . $attendanceRec['programID'] . " AND `HouseID`= " . $ClientServiceHouse . "";
			
			//echo $query;
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_num_rows($result) == 0 ) {
											
				$error = mysqli_error($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );					
				return  array( FAIL, "Unable to determine CLientServicesID for  " . getClientName( $attendanceRec['clientID'][$i] ) );				
			}
			
			$row = mysqli_fetch_assoc( $result );
			$ClientServicesID = $row['ClientServicesID'];
			
			$query = "REPLACE INTO `DailyAttendance`(`ClientID`, `ClientServicesID`, `Month`, `Year`,  `MonthlyTotal`) VALUES ( ";
			$query .= $attendanceRec['clientID'][$i] . ", ";
			$query .= $ClientServicesID . ", ";
			$query .= $attendanceRec['attendanceMonth'] . ", ";
			$query .= $attendanceRec['attendanceYear'] . ", ";
			$query .= $attendanceRec['clientTotal'][$i] . " ";
			$query .= " ) ";
			
			//echo $query. "<br />";
			$result = mysqli_query( $dbHandle, $query  );		
		
			if ( mysqli_errno($dbHandle) != 0 ) {
				$error = mysqli_error($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );					
				return  array( FAIL, $error );
			}
		}
				
		for( $i = 0; $i < count($attendanceRec['clientID']); $i++ ) {
		
			if ( ! isset($attendanceRec['chkAttendance'][$i]) ) { continue; }
			
			$ClientServiceHouse = $attendanceRec['houseID'];
			if ( $attendanceRec['houseID'] == 'A' ) {
				$ClientServiceHouse = $attendanceRec['clientpgmhouse'][$attendanceRec['clientID'][$i]];
			}
			
			$query = "SELECT `ClientServicesID` FROM `ClientServices` WHERE `ClientID`=" . $attendanceRec['clientID'][$i] . " ";
			$query .= " AND `ServiceID`=" . $attendanceRec['programID'] . " AND `HouseID`= " . $ClientServiceHouse . "";
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_num_rows($result) == 0 ) {
											
				$error = mysqli_error($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );					
				return  array( FAIL, "Unable to determine CLientServicesID for  " . getClientName( $attendanceRec['clientID'][$i] ) );				
			}
			
			$row = mysqli_fetch_assoc( $result );
			$ClientServicesID = $row['ClientServicesID'];
			
			$query = "UPDATE `DailyAttendance` SET ";
			foreach( $attendanceRec['chkAttendance'][$i] as $key => $value ) {
				if ( trim($value) != '' ) {
					$query .=  "`D" . $key ."` = " . $value . ", ";
				}
				else
					$query .=  "`D" . $key ."` = 0, ";
			}
			$query = RTRIM( $query, ", " );
			$query .= " WHERE `ClientID`=" . $attendanceRec['clientID'][$i] . " AND `ClientServicesID` = " . $ClientServicesID . " ";
			$query .= " AND `Month`=" . $attendanceRec['attendanceMonth'] . " AND `Year` = " .$attendanceRec['attendanceYear'] . " ";
			
			//echo "<br>" . $query;
			
			$result = mysqli_query( $dbHandle, $query  );
			
			if ( mysqli_errno($dbHandle) != 0 ) {
				$error = mysqli_error($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );					
				return  array( FAIL, $error );
			}
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		//if ( $attendanceRec['programID'] == PERSONAL_SUPPORTS ) 		
		//	return array( SUCCESS, "Attendance for selected " . getServiceName(  $attendanceRec['programID'], $stateCD ) . " " . $attendanceRec['clientTag'] . "s for " . date("F Y",  mktime(0, 0, 0, $attendanceRec['attendanceMonth'], 1, $attendanceRec['attendanceYear'])) . "  completed successfully." );
		//else	
			return array( SUCCESS, "Attendance for all " . getServiceName(  $attendanceRec['programID'], $stateCD ) . " " . $attendanceRec['clientTag'] . "s for " . date("F Y",  mktime(0, 0, 0, $attendanceRec['attendanceMonth'], 1, $attendanceRec['attendanceYear'])) . "  completed successfully." );
		
	}
?>