<?php
	
	//
	// Get all staff with unapproved time off
	//
	function getPendingApprovals( $staffID )
	{
		$dbHandle = loginToDB();
		$stafflist =  array();
		
		$query  = "SELECT `PositionID` FROM `StaffIndicators` WHERE `StaffID` = " . $staffID . "";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows( $result ) == 0 )
		{
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "getPendingApprovals() was unable to determine manager's PositionID. Cannot Proceed." . PHP_EOL . "Please notify the administrator." );
		}
		$row = mysqli_fetch_assoc( $result );
		$position = $row['PositionID'];
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		if ( $position == 1 || $position == 2  ) {
			$query  = "SELECT a.`StaffID`, CONCAT( a.`StaffFname`, ' ', a.`StaffLname` ) AS StaffName ";
			$query .= " FROM `Staff` a, `TimeOffRequest` b WHERE a.`StaffID`=b.`StaffID` AND a.`Status` = 'Active'";
		}
		else {
			$query  = "SELECT a.`StaffID`, CONCAT( a.`StaffFname`, ' ', a.`StaffLname` ) AS StaffName ";
			$query .= " FROM `Staff` a, `TimeOffRequest` b WHERE a.`SupervisorID`=" . $staffID . " AND a.`StaffID`=b.`StaffID` AND a.`Status` = 'Active'";
		}
		
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$row['StaffName'] = ucwords($row['StaffName']);
			$stafflist[] = $row;
		}
			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	   closeDB( $dbHandle );
		
	   return array( SUCCESS, $stafflist );
	}
	
	function approveOrRejectTimeOffRequest($requests)
	{
		$staffName = getStaffName($_SESSION['staffID']);
		$dbHandle = loginToDB();
		
		//echo dpp($requests);
		
		foreach( $requests['approveReject'] as $key => $keyValue )
		{
			list( $requestID, $action ) = explode( "-", $keyValue );
			
			$query   = " SELECT `RequestTypeID` FROM `TimeOffRequest` WHERE `StaffID`= " . $requests['staffID'] . " AND `RequestID`= ". $requestID . " ";
			$result = mysqli_query( $dbHandle, $query  );
			$row = mysqli_fetch_assoc($result);
			$requestTypeID = $row['RequestTypeID'];
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
			if ( $action == 'A' ) {
				$query   = "INSERT INTO `TimeOffApproved`(`StaffID`, `RequestID`, `RequestTypeID`, `RequestMonth`, `RequestDay`, `RequestYear`, `HoursRequested`,  `ApprovedOn`, `ApprovedBy` ) ";
				$query  .= " SELECT `StaffID`, `RequestID`, `RequestTypeID`, `RequestMonth`, `RequestDay`, `RequestYear`, `HoursRequested`,  now(), '" . $staffName . "' FROM `TimeOffRequest` ";
				$query  .= " WHERE `StaffID`=" . $requests['staffID']. " and `RequestID` = " . $requestID . "";
			} 
			else {
				$query   = "INSERT INTO `TimeOffRejected`(`StaffID`, `RequestID`, `RequestTypeID`, `RequestMonth`, `RequestDay`, `RequestYear`,  `HoursRequested`, `RejectReason`, `RejectDate`, `RejectStaffID`)  ";
				$query  .= " SELECT `StaffID`, `RequestID`, `RequestTypeID`, `RequestMonth`, `RequestDay`, `RequestYear`,  `HoursRequested`, '" .  $requests['rejectreason'][$key] . "', CURDATE(), '" . $staffName . "' FROM `TimeOffRequest` ";
				$query  .= " WHERE `StaffID`=" . $requests['staffID']. " and `RequestID` = " . $requestID . "";
			}
			
			//echo $query . "<br />";
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);          			
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "Unable to approve/reject time off requests: " . $rtnMsg  );
			}
			
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
			
			if ( $action == 'A' ) {
				
				$query   = "UPDATE `TimeOffHoursUsed` set `HoursUsed` = `HoursUsed` + ";
				$query  .= " ( Select `HoursRequested` FROM `TimeOffRequest` WHERE `StaffID`=" . $requests['staffID']. " and `RequestID` = " . $requestID . " AND `RequestTypeID` in ( 1, 3 ) )";
				$query  .= " WHERE `StaffID`=" . $requests['staffID']. " and `RequestTypeID` = " . $requestTypeID . " AND CURDATE() between `AnnivStartDate` and `AnnivEndDate`";
				
				//echo $query . "<br />";
				
				$result = mysqli_query( $dbHandle, $query  );
				if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$rtnMsg = mysqli_error($dbHandle);          			
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					closeDB( $dbHandle );
					return array( FAIL, "Unable to approve/reject time off requests: " . $rtnMsg  );
				}
				
				// Free result set
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			}
			
			
			$query = "DELETE FROM `TimeOffRequest` WHERE `StaffID`=" . $requests['staffID']. " and `RequestID`=" . $requestID . "";
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);          			
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "Unable to approve/reject time off requests: " . $rtnMsg  );
			}
			
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
		}
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return array( SUCCESS, "Successfully approved/rejected all time off requests for " . getStaffName($requests['staffID'])  );
	}

?>