<?php
	//
	// General Admin Functions
	//
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/admin-general.db.php' );
	
	//
	 // Appointment Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/appointments.db.php' );
	 
	 //
	 // BP Management Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/bp-mgmt.db.php' );
	 
	 //
	 // House Management Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/house-mgmt.db.php' );
	 
	 //
	 // Manage Vehicles Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/manage-vehicles.db.php' );
	 
	 //
	 // Document Management Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/documents-mgmt.db.php' );
	 
	 //
	 // Resident Management Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/resident-mgmt.db.php' );
	 
	  //
	 // Pharmacy Management Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/pharmacy-mgmt.db.php' );
	 
	 //
	 // Provider Management Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/provider-mgmt.db.php' );
	 
	 //
	 // Approve Time Off Requests Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/aprvrqstoff.db.php' );
	 
	 //
	 // CCS Staff Management Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/ccs-mgmt.db.php' );
	 
	 //
	 // Nurse's Corner Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/nurses-corner.db.php' );
	 
	 //
	 // PCP Management Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/pcp-mgmt.db.php' );
	 
	 
	//
	//  Get Staff Positions
	//
	function getStaffPositions()
	{
		$dbHandle = loginToDB();
		$positiona = array();
		
		$query  = "SELECT * FROM `StaffPositions` order by 2  ";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$positiona[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $positiona;
	}
	
	//
	//  Get Staff Documents
	//
	function getStaffDocuments($emplRec, $fromHistory = false )
	{
		$dbHandle = loginToDB();
		$documents = array();
		
		$query  = "SELECT `StaffID`, `DocID`, `DocRequired`, DATE_FORMAT(`DocDate`, '%m/%d/%Y' ) AS DocDate, DATE_FORMAT(`RenewalDate`, '%m/%d/%Y' ) AS RenewalDate, `LastUpdateDatetime`, `UpdatedBy` ";
		$query .= " FROM `StaffDocMonitor" . (($fromHistory) ? "History" : "") . "` WHERE `StaffID` = "  . $emplRec['staffname'] . "  ";
			
		//echo $query;
			
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "Unable to retrieve staff's document list" );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$documents[$row['DocID']] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $documents );
	}
	
	//
	//  Get Critical Problems
	//
	function getCriticalProblems()
	{
		$dbHandle = loginToDB();
		$problems = array();
		
		$query  = "SELECT b.`ProblemID`, `SubmittedBy`, CONCAT( a.`ClientFname`, ' ', a.`ClientLname` ) as ClientName, FormatDateMMDDYYYY(`IncidentDate`) ";
		$query  .= " as IncidentDate, `ProblemType` FROM `Clients` a, `CriticalProblems` b WHERE a.`ClientID`=b.`ClientID` and b.`ProblemStatus`='Open'";
			
		//echo $query;
			
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "Unable to retrieve critical problems list" );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$problems[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $problems );
	}
	
	//
	//  Get  Get Critical Problems Details
	//
	function getCriticalProblemDetail($problemID)
	{
		$dbHandle = loginToDB();
		
		$query  = "SELECT `ProblemID`, `ClientID`, FormatDateMMMDYYYY(`IncidentDate`) as IncidentDate, `ProblemType`, `ProblemDescription`, `ProblemSolution`, `ProblemStatus`, ";
		$query  .= " `SubmittedBy`, `DiscussedWith`, `NotificationTime`, `ResolvedBy`, `ResolutionDate`, `ResolutionDetails` ";
		$query  .= " FROM `CriticalProblems` WHERE `ProblemID` =  " . $problemID; 	
		//echo $query;
			
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "Unable to retrieve critical problems details" );
		}
		
		$problem = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $problem );
	}
	
	//
	//  Save Staff Info
	//
	function saveStaffInfo( $staffRec )
	{
	 	//echo dpp($staffRec);
	 
		$staffID = getNextID( 'Staff', 'StaffID' );		
		$dbHandle = loginToDB();
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		}
		
		$staffRootDir = str_replace( array( "__", "-" ), "_", strtolower(str_replace("'", "", sql_quote( $dbHandle, $staffRec['firstname'] ))) . "_" . 
		                strtolower(sql_quote( $dbHandle, $staffRec['middleinitial'] )) . "_" . 
						strtolower(str_replace("'", "", sql_quote( $dbHandle, $staffRec['lastname'] ))));
		
		$query    = "INSERT INTO `Staff` ( `StaffID`, `StaffFname`, `StaffMInit`, `StaffLname`, `StaffGender`, `StaffInitials`,  ";
		$query   .= " `StaffHireDate`, `PhoneNum`, `PhoneGateway`, `StaffEmail`, `StatusDate`, `StaffRootDir`, ";
		$query   .= " `StaffImage`, `EmergencyContactName`, `EmergencyContactPhone`, `EmergencyContactEmail`) VALUES ( ";
		$query   .= $staffID . ", ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['firstname'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['middleinitial'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['lastname'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['staffgender'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['initials'] ) . "', ";
		$query   .= "STR_TO_DATE('" . sql_quote( $dbHandle, $staffRec['hiredate'] ) . "', '%m/%d/%Y'), ";
		$query   .= "'" . formatPhone( sql_quote( $dbHandle, $staffRec['phonenumber'] ) ) . "', ";
		$query   .= isset($staffRec['phonegateway']) ? $staffRec['phonegateway'] : 'NULL' . ", "; 
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['staffemail'] ) . "', ";
		$query   .= "'" . date("Y-m-d") . "', ";
		$query   .= "'" . $staffRootDir . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['staffimage'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['emername'] ) . "', ";
		$query   .= "'" . formatPhone( sql_quote( $dbHandle, $staffRec['emerphonenumber'] ) ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['emeremail'] ) . "' ";
		$query   .= " ) ";	
		//echo "<br>" . $query;
	
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "saveStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
			
		$query    = "INSERT INTO `StaffIndicators` ( `StaffID`, `PositionID`, `HouseID`,  `IsDayStaff`, `IsPickDropStaff`, ";
		$query   .= " `IsDriver`, `IsWeekendStaff`, `CanAssignClientMeds`, `IsQuarantined`,  `UsesOwnCar`, `CarIsInsured` ) VALUES ( ";
		$query   .= $staffID . ", ";
		$query   .= $staffRec['staffposition'] . ", ";
		$query   .= $staffRec['staffhouse'] . ", ";
		$query   .= "'" . $staffRec['daystaff'] . "', ";
		$query   .= "'" . $staffRec['pickupdriver'] . "', ";
		$query   .= "'" . $staffRec['isdriver'] . "', ";
		$query   .= "'" . $staffRec['isweekendstaff'] . "', ";
		$query   .= "'" . $staffRec['assignmed'] . "', ";
		$query   .= "'" . $staffRec['quarantined'] . "', ";
		$query   .= "'" . $staffRec['useOwnCar'] . "', ";
		$query   .= "'" . $staffRec['isinsured'] . "' ";
		$query   .= " ) ";
		//echo "<br>" . $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "saveStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		list( $username, $passwd ) = explode( "/", $staffRec['userpass'] );
		
		$query    = "INSERT INTO `StaffAuthAz`(`StaffID`, `Username`, `StaffPassword`, `StaffRoleID` ) VALUES (   ";
		$query   .= $staffID . ", ";
		$query   .= "'" . sql_quote( $dbHandle, trim( $username )) . "', ";
		$query   .= "'" . password_hash( sql_quote( $dbHandle, trim( $passwd )), PASSWORD_DEFAULT ) . "', ";
		$query   .= $staffRec['staffrole'] . " ";
		$query   .= " ) ";
		//echo "<br>" . $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "saveStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		
		if ( $staffRec['hrcstaff'] == 'Y' ) {
		
			if ( $staffRec['hrctitle'] == 'C' ) {
				$query   = "UPDATE `HRCTeam` SET `Role`='M'  WHERE `Role` = 'C'";
				$result = mysqli_query( $dbHandle, $query  );
				if ( mysqli_errno($dbHandle) != 0 ) {
					$errorNumber = mysqli_errno($dbHandle);
					$errorMessage = mysqli_error($dbHandle);
					mysqli_rollback($dbHandle);
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					closeDB( $dbHandle );
					return array( FAIL, "saveStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
				}
			}
			
			$hrcID = getNextID( 'HRCTeam', 'HrcID', $dbHandle );		
			$query    = "INSERT INTO `HRCTeam`(`HrcID`, `StaffID`, `Member`, `Role`, `Sex`, `Title` ) VALUES ( ";
			$query   .= $hrcID . ", " . $staffID . ", ";
			$query   .=  "'" . sql_quote( $dbHandle, $staffRec['firstname'] ) . " " . sql_quote( $dbHandle, $staffRec['lastname'] ) . "', ";
			$query   .= "'" . sql_quote( $dbHandle, $staffRec['hrctitle'] ) . "', ";
			$query   .= "'" . sql_quote( $dbHandle, $staffRec['staffgender'] ) . "', ";
			$query   .= "'" . (( $staffRec['hrctitle'] == 'C') ? 'COMMITTEE CHAIR' : 'COMMITTEE MEMBER') . "' ) ";
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				mysqli_rollback($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "saveStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		}
		
		$insertServices = false;
		$query    = "INSERT INTO `StaffServices`(`StaffID`, `ServiceID`) VALUES ";
		for ( $j = 0; $j < count($staffRec['stafftype']); $j++ ) 
		{ 
			$insertServices = true;
			$query   .= " ( ";
			$query   .= $staffID . ", " . $staffRec['stafftype'][$j];
			$query   .= " )";
			if ( $j < ( count($staffRec['stafftype']) - 1 ) ) {
				$query   .= ", ";
			}
			
		}
		if ( $insertServices ) {
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				mysqli_rollback($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "saveStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		}
		
		$query    = "INSERT INTO `StaffDocMonitor`(`StaffID`, `DocID`, `DocRequired`, `DocDate`, `RenewalDate` ) VALUES ";
		for ( $j = 0; $j < count($staffRec['docID']); $j++ ) 
		{ 
			$query   .= " ( ";
			$query   .= $staffID . ", ";
			$query   .= $staffRec['docID'][$j] . ", ";
			$query   .= "'" . $staffRec[$staffRec['docName'][$j]] . "', ";
			$query   .= "STR_TO_DATE('" . $staffRec[$staffRec['docName'][$j] . '_docdt'] . "', '%m/%d/%Y'), ";
			$query   .= "STR_TO_DATE('" . $staffRec[$staffRec['docName'][$j] . '_rnwdt'] . "', '%m/%d/%Y')  ";
			$query   .= " )";
			if ( $j < ( count($staffRec['docID']) - 1 ) ) {
				$query   .= ", ";
			}
			
		}
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "saveStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, 'staffID' => $staffID, 'staffRootDir' => $staffRootDir );
			
	}
	
	
	//
	//  Change Staff House
	//
	function changeStaffHouse( $changeInfo ) 
	{
		$dbHandle = loginToDB();
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin a update transaction. Please notify the application administrator" );
		}
		
		list( $staffID, $housID ) = explode(":", $changeInfo['staffname']) ;
		if ( $changeInfo['changetype'] == 'T' ) {		
			$query   = "UPDATE `StaffAuthAz` SET `AdminByPass`='Y',`ByPassHouseID`=" . $changeInfo['newstaffhouse'] . " ";
		}
		else {
			$query   = "UPDATE `StaffIndicators` SET `HouseID`=" . $changeInfo['newstaffhouse'] . " ";
		}
		$query  .= " WHERE `StaffID` = " . $staffID . "";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "changeStaffHouse() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		if ( $changeInfo['changetype'] == 'P' ) {
			$query   = "UPDATE `StaffAuthAz` SET `AdminByPass`='N',`ByPassHouseID`=NULL  WHERE `StaffID` = " . $staffID . "";
			$result = mysqli_query( $dbHandle, $query  );		
		
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				mysqli_rollback($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );					
				return array( FAIL, "changeStaffHouse() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, "Staff House successfully changed." );
	}
	
	//
	//  Document Renewal Dates
	//
	//function getDocumentRenewalList( $staffRec )
	function getDocumentRenewalList()
	{
		$dbHandle = loginToDB();
		$docslist = array();
		
		$query  = "SELECT c.`StaffID`, CONCAT( c.`StaffFname`, ' ', c.`StaffLname` ) AS StaffName, a.`DocID`, `Document`, `DocRequired`, FormatDateMMDDYYYY(`DocDate`) as 'DocDate', FormatDateMMDDYYYY(`RenewalDate`) AS  'RenewalDate'";
		$query .= " FROM `StaffDocMonitor` a, `StaffDocsLkup` b, `Staff` c WHERE  a.`StaffID`= c.`StaffID` AND a.`DocID`= b.`DocID` AND `DocRequired` = 'Y' ORDER BY 2" ;

		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "getDocumentRenewalList() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " . PHP_EOL . "Please notify the administrator." );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$docslist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $docslist );
	}
	
	//
	//  Review Applications
	//
	
	//
	//  Staff Member Leaving
	//
	function postStaffExiting( $exitInfo ) 
	{
		$dbHandle = loginToDB();
		$retStr = array();
		
		//Setting auto commit to false
   		mysqli_autocommit($dbHandle, False);
				
		$query   = "UPDATE `Staff` SET `StatusDate`=STR_TO_DATE('" . $exitInfo['statusChgDate'] . "', '%m/%d/%Y'), ";
		$query  .= " `StatusReason`='" . sql_quote( $dbHandle, $exitInfo['leavereason'] ) . "', ";
		$query  .= " `Status`= 'Inactive' WHERE `StaffID` = " . $exitInfo['staffname'] . "";
		
		//echo $query;
		//echo dpp($exitInfo);
		
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) == 0 ) { 
		
			 // Get next SeqID 
			 $query  = "SELECT ifnull(MAX(`SeqID`), 0)+1 as SeqID FROM `StaffHistory` WHERE `StaffID`=" . $exitInfo['staffname'];

			 $result = mysqli_query( $dbHandle, $query  );
			 $row = mysqli_fetch_assoc( $result );
			 $seqID = $row['SeqID'];
					
			// move record to history
			$query  = "INSERT INTO `StaffHistory`(`StaffID`, `SeqID`, `SupervisorID`, `StaffFname`, `StaffMInit`, `StaffLname`, `StaffType`, ";
			$query .=  "`StaffGender`, `StaffInitials`, `StaffHireDate`, `PhoneNum`, `PhoneGateway`, `StaffEmail`,  `EmergencyContactName`, ";
			$query .=  "`EmergencyContactPhone`, `EmergencyContactEmail`, `Status`, `StatusDate`, `StatusReason`, `StaffRootDir`, `StaffImage` ) ";
			$query .=  "SELECT `StaffID`, " . $seqID . ", `SupervisorID`, `StaffFname`, `StaffMInit`, `StaffLname`, `StaffGender`, `StaffType`, ";
			$query .=  "`StaffInitials`, `StaffHireDate`, `PhoneNum`, `PhoneGateway`, `StaffEmail`, `EmergencyContactName`, `EmergencyContactPhone`, ";
			$query .=  "`EmergencyContactEmail`, `Status`, STR_TO_DATE('" . $exitInfo['statusChgDate'] . "', '%m/%d/%Y'), ";
			$query .=  "'" . sql_quote( $dbHandle, $exitInfo['leavereason'] ) . "', `StaffRootDir`, `StaffImage` FROM `Staff` ";
			$query .=  " WHERE `StaffID`= " . $exitInfo['staffname'] . "  ";
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) == 0 )
			{
			
				$query  = "INSERT INTO `StaffAuthAzHistory`(`StaffID`, `SeqID`, `Username`, `StaffPassword`, `StaffRoleID`, `PswdReset`, ";
				$query .= "`AdminByPass`, `ByPassHouseID`, `LastLoginDate`, `LastLoginTime`) SELECT `StaffID`, " . $seqID . ", `Username`, ";
				$query .= "md5(`Username`), `StaffRoleID`, `PswdReset`, `AdminByPass`, `ByPassHouseID`, `LastLoginDate`, `LastLoginTime` ";
				$query .= "FROM `StaffAuthAz`  WHERE `StaffID`= " . $exitInfo['staffname'] . "  ";
				
				mysqli_query( $dbHandle, $query  );
				if ( mysqli_errno( $dbHandle ) == 0 )
				{
					$query  = "INSERT INTO `StaffIndicatorsHistory`(`StaffID`, `SeqID`, `PositionID`, `HouseID`, `IsConfirmed`, `isEmailVerified`, `IsDriver`, ";
					$query .= "`IsQuarantined`, `IsDayStaff`, `IsPickDropStaff`, `IsWeekendStaff`, `CanAssignClientMeds`, `UsesOwnCar`, `CarIsInsured`) ";
					$query .= "SELECT `StaffID`, " . $seqID . ", `PositionID`, `HouseID`, `IsConfirmed`, `isEmailVerified`, `IsDriver`, `IsQuarantined`, "; 
					$query .= "`IsDayStaff`, `IsPickDropStaff`, `IsWeekendStaff`, `CanAssignClientMeds`, `UsesOwnCar`, `CarIsInsured` FROM `StaffIndicators` ";
					$query .=  " WHERE `StaffID`= " . $exitInfo['staffname'] . "  ";
					
					mysqli_query( $dbHandle, $query  );
					if ( mysqli_errno( $dbHandle ) == 0 )
					{
						$query  = "INSERT INTO `StaffDocMonitorHistory`(`StaffID`, `SeqID`, `DocID`, `DocRequired`, `DocDate`, `RenewalDate`, ";
						$query .= "`LastUpdateDatetime`, `UpdatedBy`)  SELECT `StaffID`, " . $seqID . ", `DocID`, `DocRequired`, `DocDate`, `RenewalDate`, ";
						$query .= "`LastUpdateDatetime`, `UpdatedBy` FROM `StaffDocMonitor`  WHERE `StaffID`= " . $exitInfo['staffname'] . "  ";
						
						mysqli_query( $dbHandle, $query  );
						if ( mysqli_errno( $dbHandle ) == 0 )
						{
							$query  = "DELETE FROM `StaffDocMonitor` WHERE `StaffID`= " . $exitInfo['staffname'] . "  ";
							mysqli_query( $dbHandle, $query  );
							if ( mysqli_errno( $dbHandle ) == 0 )
							{
								$query  = "DELETE FROM `StaffIndicators` WHERE `StaffID`= " . $exitInfo['staffname'] . "  ";
								mysqli_query( $dbHandle, $query  );
								if ( mysqli_errno( $dbHandle ) == 0 )
								{
									$query  = "DELETE FROM `StaffAuthAz` WHERE `StaffID`= " . $exitInfo['staffname'] . "  ";
									mysqli_query( $dbHandle, $query  );
									if ( mysqli_errno( $dbHandle ) == 0 )
									{
										$query  = "DELETE FROM `Staff` WHERE `StaffID`= " . $exitInfo['staffname'] . "  ";
										
										//echo $query;
										mysqli_query( $dbHandle, $query  );
										if ( mysqli_errno( $dbHandle ) == 0 )
										{
												//Saving the changes
   												mysqli_commit($dbHandle);
										}
										else {
									
											$retStr = array( FAIL, mysqli_error($dbHandle) );
													
											//Roll back changes the changes
											mysqli_rollback($dbHandle);
										}
								
									}
									else {
								
										$retStr = array( FAIL, mysqli_error($dbHandle) );
												
										//Roll back changes the changes
										mysqli_rollback($dbHandle);
									}
								}
								else {
							
									$retStr = array( FAIL, mysqli_error($dbHandle) );
											
									//Roll back changes the changes
									mysqli_rollback($dbHandle);
								}
							}
							else {
						
								$retStr = array( FAIL, mysqli_error($dbHandle) );
										
								//Roll back changes the changes
								mysqli_rollback($dbHandle);
							}	
						}
						else {
					
							$retStr = array( FAIL, mysqli_error($dbHandle) );
									
							//Roll back changes the changes
							mysqli_rollback($dbHandle);
						}
					}
					else {
					
						$retStr = array( FAIL, mysqli_error($dbHandle) );
								
						//Roll back changes the changes
						mysqli_rollback($dbHandle);
					}
				}
				else {
				
					$retStr = array( FAIL, mysqli_error($dbHandle) );
							
					//Roll back changes the changes
					mysqli_rollback($dbHandle);
				}
				
			}
			else {
			
				$retStr = array( FAIL, mysqli_error($dbHandle) );
						
				//Roll back changes the changes
				mysqli_rollback($dbHandle);
			}
		}
		else {
			//$errorNumber = mysqli_errno($dbHandle);
			//$errorMessage = mysqli_error($dbHandle);
			//if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			//closeDB( $dbHandle );					
			//return array( FAIL, "postStaffExiting() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			
			$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
			//Roll back changes the changes
			mysqli_rollback($dbHandle);
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		$retStr = array( SUCCESS, "Staff Member Leaving completed successfully." );
		
		return $retStr;
	}
	
	//
	//  Update Staff Info
	//
	function updateStaffInfo( $staffRec )
	{
		
		$dbHandle = loginToDB();
		$staffRtn = array();
		
		// Get Current Email Address
		$query  = "SELECT `StaffEmail` FROM `Staff` WHERE `StaffID` =  " . $staffRec['staffID'];
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "updateStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " . PHP_EOL . "Please notify the administrator." );
		}
		
		$row = mysqli_fetch_assoc( $result );
		$currentEmail = $row['StaffEmail'];
		$currentRootDir = trim($staffRec['staffRootDir']);
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin a update transaction. Please notify the application administrator" );
		}
		
		$newRootDir = strtolower(str_replace("'", "", sql_quote( $dbHandle, $staffRec['firstname'] ))) . "_" . strtolower(sql_quote( $dbHandle, $staffRec['middleinitial'] )) . "_" . strtolower(str_replace("'", "", sql_quote( $dbHandle, $staffRec['lastname'] )));
		
		$query    = "UPDATE `Staff` SET ";
		$query   .= " `StaffFname` = '" . sql_quote( $dbHandle, $staffRec['firstname'] ) . "', ";
		$query   .= " `StaffMInit` = '" . sql_quote( $dbHandle, $staffRec['middleinitial'] ) . "', ";
		$query   .= " `StaffLname` = '" . sql_quote( $dbHandle, $staffRec['lastname'] ) . "', ";
		$query   .= " `StaffInitials` = '" . sql_quote( $dbHandle, $staffRec['initials'] ) . "', ";
		$query   .= " `StaffHireDate` = STR_TO_DATE('" . sql_quote( $dbHandle, $staffRec['hiredate'] ) . "', '%m/%d/%Y'), ";
		$query   .= " `StaffGender` = '" . sql_quote( $dbHandle, $staffRec['staffgender'] ) . "', ";
		$query   .= " `PhoneNum` = '" . formatPhone( sql_quote( $dbHandle, $staffRec['phonenumber'] ) ) . "', ";
		if ( isset($staffRec['phonegateway']) && (trim($staffRec['phonegateway']) != '' )) {
			$query   .= " `PhoneGateway` = " . $staffRec['phonegateway'] . ", ";
		}
		$query   .= " `StaffEmail` = '" . sql_quote( $dbHandle, $staffRec['staffemail'] ) . "', ";
		$query   .= " `EmergencyContactName` = '" . sql_quote( $dbHandle, $staffRec['emername'] ) . "', ";
		$query   .= " `EmergencyContactPhone` = '" . formatPhone( sql_quote( $dbHandle, $staffRec['emerphonenumber'] ) ) . "', ";
		$query   .= " `EmergencyContactEmail` = '" . sql_quote( $dbHandle, $staffRec['emeremail'] ) . "', ";
		$query   .= " `StaffRootDir` = '" . sql_quote( $dbHandle, $newRootDir ) . "', ";
		$query   .= " `StaffImage` = '" . sql_quote( $dbHandle, $staffRec['staffimage'] ) . "' ";
		$query   .= " WHERE `StaffID` = " . $staffRec['staffID'];
		
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "updateStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		$query    = "UPDATE `StaffIndicators` SET ";
		$query   .= "`PositionID` = " . $staffRec['newstaffposition'] . ", ";
		$query   .= "`HouseID` = " . $staffRec['newstaffhouse'] . ", ";
		$query   .= "`IsDayStaff` = '" . $staffRec['daystaff'] . "', ";
		$query   .= "`IsPickDropStaff` = '" . $staffRec['pickupdriver'] . "', ";
		$query   .= "`IsDriver` = '" . $staffRec['isdriver'] . "', ";
		$query   .= "`IsWeekendStaff` = '" . $staffRec['isweekendstaff'] . "', ";
		$query   .= "`CanAssignClientMeds` = '" . $staffRec['assignmed'] . "', ";
		$query   .= "`IsQuarantined` = '" . $staffRec['quarantined'] . "', ";
		$query   .= "`UsesOwnCar` = '" . $staffRec['useOwnCar'] . "', ";
		$query   .= "`CarIsInsured` = '" . $staffRec['isinsured'] . "' ";
		$query   .= " WHERE `StaffID` = " . $staffRec['staffID'];
		
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "updateStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		$query    = "UPDATE `StaffAuthAz` SET ";
		$query   .= " `StaffRoleID` = ". $staffRec['newstaffRole'] . " ";
		$query   .= " WHERE `StaffID` = " . $staffRec['staffID'];
		
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "updateStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
			
		//echo "<br>" . "I am going to Staff Docs";	
		for ( $j = 0; $j < count($staffRec['docID']); $j++ ) 
		{ 
			$query    = "UPDATE `StaffDocMonitor` SET ";
			$query   .= "`DocRequired` = '" . $staffRec[$staffRec['docName'][$j]] . "', ";
			$query   .= "`DocDate` = STR_TO_DATE('" . $staffRec[$staffRec['docName'][$j] . '_docdt'] . "', '%m/%d/%Y'), ";
			$query   .= "`RenewalDate` = STR_TO_DATE('" . $staffRec[$staffRec['docName'][$j] . '_rnwdt'] . "', '%m/%d/%Y') ";
			$query   .= " WHERE `StaffID` = " .  $staffRec['staffID'] . " ";
			$query   .= " AND `DocID` = " . $staffRec['docID'][$j] . " ";
			
			//echo "<br>" . $query;
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "updateStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		
		}
		
		// If Old email and new email are not the same reset IsEmailVerified
		if ( trim($currentEmail) != trim(sql_quote( $dbHandle, $staffRec['staffemail'] ) ) ) {
			$query    = "UPDATE `StaffIndicators` SET ";
			$query   .= "`isEmailVerified` = 'N' ";
			$query   .= " WHERE `StaffID` = " . $staffRec['staffID'];
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				mysqli_rollback($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "updateStaffInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, 'currentStaffEmail' => $currentEmail, 'newRootDir' => $newRootDir );
			
	}
	
	function getStaffInformation( $staffRec )
	{
		$retArray = array();
		$dbHandle = loginToDB();
	
		list( $staffID, $houseID ) =  explode(":",$staffRec['staffname']);
		
		$query  = "select a.StaffID, c.HouseID , a.StaffFname, a.StaffLname, b.Username, b.`StaffPassword`, b.`StaffRoleID`, b.PswdReset, 'E' as 'IDType', c.IsDriver ";
		$query .= " from `Staff` a, `StaffAuthAz` b, `StaffIndicators` c where  a.Status = 'Active' and a.StaffID = " . $staffID . " ";
		$query .= " and a.`StaffID`=b.`StaffID` AND a.`StaffID`=c.`StaffID` and b.AdminByPass = 'N' and c.IsConfirmed = 'Y'";
					
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			if ( mysqli_num_rows( $result ) == 0 )
			{
				$retArray = array( 0 => FAIL, "User record not found. Please check with application admin" );
			}
			else {
				$row = mysqli_fetch_assoc( $result );
				$retArray = array( 0 => SUCCESS, $row );
			}
		}
		else {
			$errMsg = mysqli_error( $dbHandle );
			$errNo  = mysqli_errno( $dbHandle );
			$retArray = array( 0 => FAIL, SQLERROR, "Error No: " . $errNo . ": Error Message: " . $errMsg . "<br>" . $query );
		}
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $retArray;
		
   }
	
	//
	//  Rehire Staff
	//
	function makeFormerEmployeeCurrent( $staffRec )
	{
		$dbHandle = loginToDB();
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		}
		
		$staffRec['staffimage'] = isset($staffRec['staffimage']) ? $staffRec['staffimage'] : '';
		
		$staffRootDir = strtolower(str_replace("'", "", sql_quote( $dbHandle, $staffRec['firstname'] ))) . "_" . strtolower(sql_quote( $dbHandle, $staffRec['middleinitial'] )) . "_" . strtolower(str_replace("'", "", sql_quote( $dbHandle, $staffRec['lastname'] )));
		
		$query    = "INSERT INTO `Staff` ( `StaffID`, `StaffFname`, `StaffMInit`, `StaffLname`, `StaffGender`, `StaffType`, ";
		$query   .= " `StaffInitials`, `StaffHireDate`, `PhoneNum`, `PhoneGateway`, `StaffEmail`, `StatusDate`, `StaffRootDir`, ";
		$query   .= " `StaffImage`, `EmergencyContactName`, `EmergencyContactPhone`, `EmergencyContactEmail`) VALUES ( ";
		$query   .= $staffRec['staffID'] . ", ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['firstname'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['middleinitial'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['lastname'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['staffgender'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['newstaffRole'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['initials'] ) . "', ";
		$query   .= "STR_TO_DATE('" . sql_quote( $dbHandle, $staffRec['hiredate'] ) . "', '%m/%d/%Y'), ";
		$query   .= "'" . formatPhone( sql_quote( $dbHandle, $staffRec['phonenumber'] ) ) . "', ";
		$query   .= ( isset($staffRec['phonegateway']) ? $staffRec['phonegateway'] : 0 ) . ", "; 
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['staffemail'] ) . "', ";
		$query   .= "'" . date("Y-m-d") . "', ";
		$query   .= "'" . $staffRootDir . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['staffimage'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['emername'] ) . "', ";
		$query   .= "'" . formatPhone( sql_quote( $dbHandle, $staffRec['emerphonenumber'] ) ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $staffRec['emeremail'] ) . "' ";
		$query   .= " ) ";	
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "makeFormerEmployeeCurrent() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		$query    = "INSERT INTO `StaffIndicators` ( `StaffID`, `PositionID`, `HouseID`,  `IsDayStaff`, `IsPickDropStaff`, ";
		$query   .= " `IsDriver`, `IsWeekendStaff`, `CanAssignClientMeds`, `IsQuarantined`,  `UsesOwnCar`, `CarIsInsured` ) VALUES ( ";
		$query   .=  $staffRec['staffID'] . ", ";
		$query   .= $staffRec['newstaffposition'] . ", ";
		$query   .= $staffRec['newstaffhouse'] . ", ";
		$query   .= "'" . $staffRec['daystaff'] . "', ";
		$query   .= "'" . $staffRec['pickupdriver'] . "', ";
		$query   .= "'" . $staffRec['isdriver'] . "', ";
		$query   .= "'" . $staffRec['isweekendstaff'] . "', ";
		$query   .= "'" . $staffRec['assignmed'] . "', ";
		$query   .= "'" . $staffRec['quarantined'] . "', ";
		$query   .= "'" . $staffRec['useOwnCar'] . "', ";
		$query   .= "'" . $staffRec['isinsured'] . "' ";
		$query   .= " ) ";
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "makeFormerEmployeeCurrent() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		list( $username, $passwd ) = explode( "/", $staffRec['userpass'] );
		
		$query    = "INSERT INTO `StaffAuthAz`(`StaffID`, `Username`, `StaffPassword`, `StaffRoleID` ) VALUES (   ";
		$query   .= $staffRec['staffID'] . ", ";
		$query   .= "'" . password_hash(sql_quote( $dbHandle, trim( $staffRec['username'] )), PASSWORD_DEFAULT ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, trim( $staffRec['username'] )) . "'), ";
		$query   .= $staffRec['newstaffRole'] . " ";
		$query   .= " ) ";
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "makeFormerEmployeeCurrent() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		$query    = "INSERT INTO `StaffDocMonitor`(`StaffID`, `DocID`, `DocRequired`, `DocDate`, `RenewalDate` ) VALUES ";
		
		for ( $j = 0; $j < count($staffRec['docID']); $j++ ) 
		{ 
			$query   .= " ( ";
			$query   .=  $staffRec['staffID']  . ", ";
			$query   .= $staffRec['docID'][$j] . ", ";
			$query   .= "'" . $staffRec[$staffRec['docName'][$j]] . "', ";
			$query   .= "STR_TO_DATE('" . $staffRec[$staffRec['docName'][$j] . '_docdt'] . "', '%m/%d/%Y'), ";
			$query   .= "STR_TO_DATE('" . $staffRec[$staffRec['docName'][$j] . '_rnwdt'] . "', '%m/%d/%Y')  ";
			$query   .= " )";
			if ( $j < ( count($staffRec['docID']) - 1 ) ) {
				$query   .= ", ";
			}
			
		}
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "makeFormerEmployeeCurrent() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, 'staffID' => $staffID, 'staffRootDir' => $staffRootDir );
			
	}
	
	function adjustSickVacationHours( $hours )
	{
		$dbHandle = loginToDB();
		for( $j = 0; $j < count($hours['requestID']); $j++ ) {
			
			$query  = "UPDATE `TimeOffHoursUsed` SET `CarryOverHours`=" . $hours['carryover'][$j] . ", `HoursUsed`=" . $hours['hoursused'][$j] . " ";
			$query .= " WHERE `StaffID`=". $hours['staffID'] . " AND `RequestTypeID`=" . $hours['requestID'][$j] . " AND CURDATE() BETWEEN `AnnivStartDate` AND `AnnivEndDate` ";
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);          			
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "Unable to approve/reject time off requests: " . $rtnMsg  );
			}
			
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		}
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return array( SUCCESS, "Successfully adjusted the sick leave hours and/or vacation hours for " . getStaffName($hours['staffID'])  );
	}
	 
	
?>
