<?php
	
	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		
	if (  $step == 2 ) {
	
		$rtn = putVehiculeLog($_REQUEST);	
		$updtMessage = $rtn[1];
		if ( $rtn[0] == SUCCESS ) {
			$updtMessage = "Vehicle usage/repair/fueling logged successfully.";
			$isFail = false;
		}
		else
			$isFail = true;
			
		$step = 1;
	}
	
	if ( $step == 1 ) { 

		$services = getMyServicesProvided();
		$tripPurpose = getTripPurpose();
		if ( $tripPurpose[0] != SUCCESS ) {
			$updtMessage .= ' ' . $tripPurpose[0];
			$step = 1;
		}
		$vehicles = getVehicules();

?>
<form id="vehiclelog" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/staff-corner/index/dest/<?php echo $dest; ?>/step/2/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo  $STAFF_CORNER_BREADCRUMB[$dest]; ?></h5>
			   <?php if ( isset($isFail) ) { ?>
			   		<div class="row mt-3 mb-3">
						<div class="col-md-1"></div>
						<div class="col-md-10 col-sm-offset-1 text-center">
							  <div class="alert  <?php echo ( $isFail === false ) ? "alert-success" : "alert-danger"; ?> text-center mb-1">
								<h4>
								<?php 
									echo $updtMessage;
								?>
								</h4>
								</div>
						</div>
						<div class="col-md-1"></div>
					</div>
			   <?php } ?>
              <!-- Floating Labels Form -->
			  <?php //echo dpp(); ?>
			  <div class="row">
					<div class="col-md-3">
						<div class="form-floating mt-3">
							<input type="text" class="form-control" name="staffname"   id="staffname" placeholder="Staff Name" value="<?php echo getStaffName( $_SESSION['staffID'] ); ?>" readonly > 
							<label  for="staffname">Staff Name</label>
							<div class="invalid-feedback">
								Please enter staff name.
							</div>
							<input type="hidden" name ="staffID" value="<?php echo $_SESSION['staffID']; ?>" />
						</div>
					</div>
					<div class="col-md-3 position-relative">
						<div class="form-floating mt-3">
							<select class="form-select js-select" name="vehiculeID" id="vehiculeID" aria-label="Vehicle Used" required>
								  <option selected disabled value="">Select Vehicle</option>
								  <?php  echo ( $vehicles[0] == SUCCESS  ) ? $vehicles[1]  : ""; ?>
							</select>
							<label  for="vehiculeID">Vehicle Used</label>
							<div class="invalid-feedback">
								Please select vehicle used.
							</div>
					  	</div>
					</div>

					<div class="col-md-3">
						<div class="form-floating mt-3 input-group" id='div_usagedate' data-td-target-input='nearest' data-td-target-toggle='nearest'>
							<input type="text" class="form-control" name="usagedate" id="usagedate" placeholder="Usage Date"  data-td-target='#div_usagedate' required readonly />
							<label   class="form-label" for="usagedate">Usage Date</label>
							<span class='input-group-text' data-td-target='#div_usagedate' data-td-toggle='datetimepicker'>
								 <span class='bi bi-calendar-date fs-4'></span>
							  </span>
							<div class="invalid-feedback">
								Please provide the usage date
							</div>
					  	</div>
					</div>
					<div class="col-md-3">
						<div class="form-floating mt-3">
							<select class="form-select js-select" name="tripPurpose" id="tripPurpose" aria-label="Trip Purpose" required>
								  <option selected disabled value="">Select a Trip Purpose</option>
								  <?php  echo ( $tripPurpose[0] == SUCCESS  ) ? $tripPurpose[1]  : ""; ?>
							</select>
							<label  for="tripPurpose">Trip Purpose</label>
							<div class="invalid-feedback">
								Please select a trip purpose.
							</div>
					  	</div>
					</div>
					
			</div>	
				
			<div class="row">
					<div class="col-md-2">
						<div class="form-floating mt-3">
						  	<input type="number"  min="1" step="1" class="form-control" name="beginMileage"   id="beginMileage" placeholder="Start Mileage" value="" required />
						  	<label  for="beginMileage">Start Mileage</label>
							<div class="invalid-feedback">
								Please enter Start Mileage.
							</div>
					  	</div>
					</div>
					<div class="col-md-2">
						<div class="form-floating mt-3">
							<input type="number"  min="1" step="1" class="form-control" name="endMileage"   id="endMileage" placeholder="End Mileage" value="" required >
							<label  for="endMileage">End Mileage</label>
							<div class="invalid-feedback">
								Please enter End Mileage.
							</div>
						</div>
					</div>
					<div class="col-md-2 d-flex align-items-center justify-content-center" id="vehicleTag">

					</div>
					<div class="col-md-6">
						<div class="form-floating mt-3">
							<textarea class="form-control" name="tripDetails"   id="tripDetails" placeholder="Trip Details" value="" required ></textarea>
							<label  for="tripDetails">Trip Details</label>
							<div class="invalid-feedback">
								Please enter Trip Details.
							</div>
						</div>
					</div>
					
					
			</div>	
			
			<div class="row">
					
					<div class="col-md-3">
						<div class="form-floating mt-3">
							<input type="number" class="form-control" name="usageMileage"   id="usageMileage" placeholder="Usage Mileage" value=""  readonly >
							<label  for="usageMileage">Usage Mileage</label>
							<div class="invalid-feedback">
								Please enter Usage Mileage.
							</div>
						</div>
					</div>
					<div class="col-md-3">
						<div class="form-floating mt-3">
							<input type="number" class="form-control" name="lastEndMileage"   id="lastEndMileage" placeholder="Last Ending Mileage" value="" readonly >
							<label  for="lastEndMileage">Last Ending Mileage</label>
							<div class="invalid-feedback">
								Please enter Last Ending Mileage.
							</div>
						</div>
					</div>

					<div class="col-md-6">
						<div class="form-floating mt-3">
							<textarea class="form-control" name="mileageNote"   id="mileageNote" placeholder="Mileage Note" value=""  ></textarea>
							<label  for="mileageNote">Mileage Note</label>
							<div class="invalid-feedback">
								Please enter Mileage Note.
							</div>
						</div>
					</div>
			</div>	
			
			<div class="row mt-5">
				<div class="row">
					<div class="col-md-3 align-self-center">
							<label>Was any repair done on the vehiclue?</label>
					</div>
					<div class="col-md-3">
						<div class="form-check form-check-inline">
						  <input class="form-check-input" type="radio" name="repaired" id="repairedYes" value="Y">
						  <label class="form-check-label" for="repairedYes"> Yes</label>
						</div>
						<div class="form-check form-check-inline">
						  <input class="form-check-input" type="radio" name="repaired" id="repairedNo" value="N" checked="checked">
						  <label class="form-check-label" for="repairedNo"> No</label>
						</div>
					</div>
				</div>	
					
					
			    <div class="row d-none" id="repairdone">
					<div class="col-md-3">
						<div class="form-floating mt-3 input-group" id='div_repairdate' data-td-target-input='nearest' data-td-target-toggle='nearest'>
							<input type="text" class="form-control" name="repairdate" id="repairdate" placeholder="Repair Date"  data-td-target='#div_repairdate' required readonly />
							<label   class="form-label" for="repairdate">Repair Date</label>
							<span class='input-group-text' data-td-target='#div_repairdate' data-td-toggle='datetimepicker'>
								 <span class='bi bi-calendar-date fs-4'></span>
							  </span>
							<div class="invalid-feedback">
								Please provide the repair date
							</div>
					  </div>
					</div>
					<div class="col-md-3">
						<div class="form-floating mt-3">
							<input type="number" min="1" step="1" class="form-control" name="repairMileage"   id="repairMileage" placeholder="Repair Mileage" value="" required >
							<label  for="repairMileage">Repair Mileage</label>
							<div class="invalid-feedback">
								Please enter repair mileage.
							</div>
						</div>
					</div>
					<div class="col-md-3">
						<div class="form-floating mt-3">
							<input type="number"  min="1.0" step="0.01"  class="form-control" name="repairCost"   id="repairCost" placeholder="Repair Cost" value="" required >
							<label  for="repairCost">Repair Cost</label>
							<div class="invalid-feedback">
								Please enter repair cost.
							</div>
						</div>
					</div>
					
					<div class="col-md-3">
						<div class="form-floating mt-3">
							<?php $repairList = getRepairList(); ?>
							<select class="form-select js-select" name="repairWorkDone" id="repairWorkDone" aria-label="Repair Done" required>
								  <option selected disabled value="">Select Repair Done</option>
								  <?php  echo ( $repairList[0] == SUCCESS  ) ? $repairList[1]  : ""; ?>
							</select>
							<label  for="repairWorkDone">Repair Done</label>
							<div class="invalid-feedback">
								Please select vehicle used.
							</div>
					  	</div>
					</div>
					<div class="col-md-12">
						<div class="form-floating mt-3">
							<textarea class="form-control" name="repairDetails"   id="repairDetails" placeholder="Repair Details" value="" required ></textarea>
							<label  for="repairDetails">Repair Details</label>
							<div class="invalid-feedback">
								Please enter Repair Details.
							</div>
						</div>
					</div>
				</div>
			
			</div>					
			
		   <div class="row mt-4">
				<div class="row">
					<div class="col-md-3 align-self-center">
							<label>Did you buy fuel for the vehiclue?</label>
					</div>
					<div class="col-md-3">
						<div class="form-check form-check-inline">
						  <input class="form-check-input" type="radio" name="fueled" id="fueledYes" value="Y">
						  <label class="form-check-label" for="fueledYes"> Yes</label>
						</div>
						<div class="form-check form-check-inline">
						  <input class="form-check-input" type="radio" name="fueled" id="fueledNo" value="N" checked="checked">
						  <label class="form-check-label" for="fueledNo"> No</label>
						</div>
					</div>
				</div>	
					
					
			    <div class="row d-none" id="gotfuel">
					<div class="col-md-3">
						<div class="form-floating mt-3 input-group" id='div_fueldate' data-td-target-input='nearest' data-td-target-toggle='nearest'>
							<input type="text" class="form-control" name="fueldate" id="fueldate" placeholder="Fueling Date"  data-td-target='#div_fueldate' required readonly />
							<label   class="form-label" for="fueldate">Fueling Date</label>
							<span class='input-group-text' data-td-target='#div_fueldate' data-td-toggle='datetimepicker'>
								 <span class='bi bi-calendar-date fs-4'></span>
							  </span>
							<div class="invalid-feedback">
								Please provide the fueling date
							</div>
					  </div>
					</div>
					<div class="col-md-3">
						<div class="form-floating mt-3">
							<input type="number" class="form-control" name="fuelingMileage"   id="fuelingMileage" placeholder="Fueling Mileage" value="" required >
							<label  for="fuelingMileage">Fueling Mileage</label>
							<div class="invalid-feedback">
								Please enter fueling mileage.
							</div>
						</div>
					</div>
					
					<div class="col-md-3">
						<div class="form-floating mt-3">
							<input type="number" min="1.0" step="0.01"  class="form-control" name="fuelingCost"   id="fuelingCost" placeholder="Fueling Cost" value="" required >
							<label  for="fuelingCost">Fueling Cost</label>
							<div class="invalid-feedback">
								Please enter fueling cost.
							</div>
						</div>
					</div>

					
				</div>
			
			</div>	
			
			<div class="row mt-5">
					<div class="col-md-12">
						<div class="form-check">
							<input class="form-check-input" type="checkbox" name="validCheck" id="validCheck" value="1" required />
							<label  for="validCheck">I have checked the values entered and confirm they are correct as entered.</label>
							<div class="invalid-feedback">
								Please acknowledge that values entered are correct.
							</div>
						</div>
					</div>
			</div>	
							
			<div class="text-center mt-5 mb-5">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Log Vehicle Use</button>
				   <button type="reset" class="btn btn-secondary mt-3 configbtn" >Start Over</button>
                </div>	
 			</div>
	   </div>
		
		I have checked the values entered and confirm they are correct as entered.
		
	</form>	

<?php
	}
?>