<?php

	$isWeekendStaff = getWeekendStatus($_SESSION['staffID']);
		
	$cannotRequestVacation = cannotRequestVacation( $_SESSION['staffID'] );
	$cannotRequestSick = cannotRequestSick( $_SESSION['staffID'] );
	$maxSickAllowed = getMaxSickAllowed($_SESSION['staffID']);
	$maxVacationAllowed = getMaxVacationAllowed($_SESSION['staffID']);	
	
	$sickAvailable = getRequestsAvailable($_SESSION['staffID'], SICK); 
	$vacationAvailable = getRequestsAvailable($_SESSION['staffID'], VACATION); 
	$pendingSickRequested = getRequestsRequested($_SESSION['staffID'], SICK);  
	$pendingVacationRequested = getRequestsRequested($_SESSION['staffID'], VACATION); 
	if ( $isWeekendStaff ) {
		$maxSickAllowed =  (( $maxSickAllowed > 20 ) ? 20 : $maxSickAllowed );
		$maxVacationAllowed =  (( $maxVacationAllowed > 20 ) ? 20 : $maxVacationAllowed );
	}
	else {
		$maxSickAllowed =  (( $maxSickAllowed > 8 ) ? 8 : $maxSickAllowed );
		$maxVacationAllowed =  (( $maxVacationAllowed > 8 ) ? 8 : $maxVacationAllowed );
	}
		
		
	$fromStep2 = false;
	if ( $step == 2 ) {
				
		$rtnVal = postTimeOffRequestLkup($_REQUEST);
		$rqstRtnMsg = $rtnVal[1];
		$fromStep2 = true;
		$step = 1;
		if ( $rtnVal[0] == SUCCESS && $rtnVal[2] > 0 ) {
			$managerRecord = getStaffManager($_REQUEST['staffID']);
			$adminRecord = getStaffManager( '', 'A' );
			$adminEmailInvalid = $mgrEmailInvalid = $atLeastOneValidEmail = false;
			
			$adminEmail = filter_var( $adminRecord['SupervisorEmail'], FILTER_VALIDATE_EMAIL);
			if ( ! $adminEmail ) { 
				$adminEmailInvalid = true;
			}
			else {
				$atLeastOneValidEmail = true;
			}
			
			if (!filter_var($managerRecord['SupervisorEmail'], FILTER_VALIDATE_EMAIL)) {
			  	$mgrEmailInvalid = true;
			}
			else {
				$atLeastOneValidEmail = true;
			}
			
			if ( ( ! $adminEmailInvalid ) && $mgrEmailInvalid ) {
				$managerRecord = $adminRecord;
			}
			
			if ( $atLeastOneValidEmail ) {
				
				//SMTP needs accurate times, and the PHP time zone MUST be set
				//This should be done in your php.ini, but this is how to do it if you don't have access to that
				date_default_timezone_set( getTimeZone( $TIMEZONE ) );

				require $_SERVER['DOCUMENT_ROOT'] . "/assets/PHPMailer/PHPMailerAutoload.php" ;
				$mailit = new PHPMailer();
						
				// Send HTML email
				$mailit->IsHTML();
				
				// Send mail by SMTP 
				$mailit->IsSMTP(); 			   					// telling the PHPMailer to use SMTP
				$mailit->SMTPDebug  = 0;                     	// enables SMTP debug information (for testing)
																// 0 = off (for production use)
																// 1 = client messages
																// 2 = client and server messages
				
				$mailit->Debugoutput = 'html';					//Ask for HTML-friendly debug output
				
				$mailit->SMTPAuth   = true;                  	// enable SMTP authentication
				
				//$mailit->Host       = $SMTP_PARMS['host'];    	// sets the SMTP server
				//$mailit->Port       = $SMTP_PARMS['port'];      // set the SMTP port for the GMAIL server
				//$mailit->Username   = $SMTP_PARMS['user']; 	    // SMTP account username
				//$mailit->Password   = $SMTP_PARMS['password'];  // SMTP account password
				
				$mailit->Host       = getenv('EMAIL_HOST');
				$mailit->Port       = getenv('EMAIL_PORT');
				$mailit->Username   = getenv('EMAIL_USER');
				$mailit->Password   = getenv('EMAIL_PSWD');
				$fromUserName       = getenv('EMAIL_NAME');
									
				//$mailit->SetFrom( $SMTP_PARMS['user'], $SMTP_PARMS['name'] );
				
				$mailit->SetFrom( $mailit->Username, $fromUserName );
				$mailit->Subject    = 'Time Off Request.';
				
				$mailit->AltBody    = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
				
				if ( $adminRecord === $managerRecord ) {
				//echo "Location 1";
					$mailit->AddAddress( trim($adminRecord['SupervisorEmail']), $adminRecord['NAME'] );
				}
				else {
					if ( ! $mgrEmailInvalid ) {
					//echo "Location 2";
						$mailit->AddAddress( trim($managerRecord['SupervisorEmail']), $managerRecord['NAME'] );
					}
					
					if (  ! $adminEmailInvalid  && $mgrEmailInvalid ) {
					//echo "Location 3";
						$mailit->AddAddress( trim($adminRecord['SupervisorEmail']), $adminRecord['NAME'] );
					}
					
					if (  ! $adminEmailInvalid  && ! $mgrEmailInvalid ) {
					//echo "Location 4";
						$mailit->AddCC( trim($adminRecord['SupervisorEmail']), $adminRecord['NAME'] );
					}
				}
				
				$mailmessage = "<table width=\"500\" border=\"0\" cellspacing=\"5\" cellpadding=\"0\">";
				$mailmessage .= "<tr><td colspan=\"2\">";
				$mailmessage .= "Time Off Request for  " . getStaffName( $_REQUEST['staffID'] ) . " is listed below and requires your approval.<br /><br />";
				$mailmessage .= "</td></tr>";
				$mailmessage .= "<tr><th style=\"border-bottom: 2px solid #000\" align=\"left\" width=\"150\" scope=\"col\"><strong>Request Date</strong></th><th style=\"border-bottom: 2px solid #000\" align=\"left\"  width=\"200\" scope=\"col\"><strong>Request</strong></th>";
				$mailmessage .= "<th style=\"border-bottom: 2px solid #000\" align=\"left\"  width=\"150\" scope=\"col\"><strong>Number of Hours</strong></th></tr>";
				
				$timeOffRequests = getUnapprovedTimeOffRequests($_REQUEST['staffID']);
				
				for( $i = 0; $i < count($timeOffRequests); $i++ )
				{
				
					$mailmessage .= "<tr><td><strong>" .  date("F j Y", mktime(0, 0, 0, $timeOffRequests[$i]['RequestMonth'], $timeOffRequests[$i]['RequestDay'], $timeOffRequests[$i]['RequestYear'])) . "</strong></td>";
					$mailmessage .= "<td><strong>" .  $timeOffRequests[$i]['RequestName'] . "</strong></td><td><strong>" .  $timeOffRequests[$i]['HoursRequested'] . "</strong></td></tr></tr>";
				}
				$mailmessage .= "<tr><td colspan=\"2\">";
								
				$mailmessage .= "<br /><a href=\"" . $protocol . "://" . $_SERVER['SERVER_NAME'] . "/admin/index/dest/aprvrqstoff/step/2/id/" . $_REQUEST['staffID'] . "/\">Proceed to review and approval of Time Off Requests now</a>" ;
				$mailmessage .= "<br /></td></tr></table>";
				
				$mailit->MsgHTML($mailmessage);
				
				if(!$mailit->Send()) {
					$rqstRtnMsg .= ", but sending approval message for time off request failed. Mailer Error: " . $mailit->ErrorInfo;
				} 
				else {
					$rqstRtnMsg .= ", and approval message for time off request was successfully sent!";
				}
			}
			else {
				$rqstRtnMsg .= ", but no supervisor nor administrator email was found to send the approval request to. Please notify your supervisor and/or the administrator to approve your request.";
			}
		}
	}

	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
	if ( $step == 1 ){
	
		$monthCount = 1;   // list for 12 months beginning from anniversary month
		
		$approvedTimeOff = getApprovedTimeOff($_SESSION['staffID']);
		$reqiestedTimeOff = getRequestedTimeOff($_SESSION['staffID']);
		$holidays = getCorporateHolidays();
		
		$approvedRqst = array();
		$approvedRqstID = array();
		$approvedRqstTypeID = array();
		$approvedHours = array();
		$sickRqst = array();
		$approvedRqstIdx = 0;
		
		$requestedRqst = array();
		$requestedRqstID = array();
		$requestedRqstTypeID = array();
		$requestedHours = array();
		$requestedRqstIdx = 0;
		
		foreach ( $approvedTimeOff as $key => $rqstRec )
		{
			$approvedRqst[] =  $rqstRec['RequestDay'];
			$approvedRqstID[] =  $rqstRec['RequestID'];
			$approvedRqstTypeID[] =  $rqstRec['RequestTypeID'] . "-" . $rqstRec['Source']; 
			$approvedHours[] = $rqstRec['HoursRequested'];
			if ( $rqstRec['RequestTypeID'] == SICK ) {
				$sickRqst[] = $rqstRec['RequestDay'];
			}
		}
		
		foreach ( $reqiestedTimeOff as $key => $rqstRec )
		{
			$requestedRqst[] =  $rqstRec['RequestDay'];
			$requestedRqstID[] =  $rqstRec['RequestID'];
			$requestedRqstTypeID[] =  $rqstRec['RequestTypeID'] . "-" . $rqstRec['Source'];
			$requestedHours[] = $rqstRec['HoursRequested'];
		}
		
		$CurrMonth = date('m');
		$currYear = date('Y');
		
		list( $startYear, $startMonth, $startDay ) = explode( "-", getStaffStartDate($_SESSION['staffID']) );
		
		$thisAnnivesary = $currYear . "" . $startMonth . $startDay;
		$nextAnnivesary = ( $currYear + 1 ) . "" . $startMonth . $startDay;;
				
		$timeOffList = getTimeOffRequestLkup();
		
	if ( $fromStep2 === true ) {
?>
<br />
		<table  class="rqsttbl" width="1080" border="0" align="center" cellpadding="10" cellspacing="0">
  			<tr>
				<td align="center" bgcolor="<?php echo ( $rtnVal[0] == FAIL ) ? "#ff3333" : "#009900"; ?>"><h3 style="color:#FFFFFF; text-transform:none; font-size:16px; font-weight:800"><?php echo $rqstRtnMsg; ?></h3></td>
			</tr>
		</table>
<?php 
	}
	if ( $step == 1 ) {
		
?>
		<form id="rqsttimeoff" name="rqsttimeoff"  class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/staff-corner/index/dest/<?php echo $dest; ?>/step/2/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo $STAFF_CORNER_BREADCRUMB[$dest]; ?></h5>

				<div id="disc-error" >
					<div class="row mt-3 mb-3">
						<div class="col-md-1"> </div>
						<div class="col-md-10 text-center">
							  <div id="disc-error-msg" class="alert  alert-danger text-center mb-1">
								
							  </div>
						</div>
						<div class="col-md-1"> </div>
					</div>
				</div>
					
			
			<div class="table-responsive">
			  <table class="table align-middle rqsttblkey">
					<thead>
						 <tr>
							<th class="thbdr thapproved"  scope="col">&nbsp;</th>
							<th align="left" nowrap="nowrap" class="thtimeoff" scope="col">Approved TimeOff </th>
							<th class="thbdr thsick"  bgcolor="ff0000" scope="col">&nbsp;</th>
							<th align="left" nowrap="nowrap"  class="thtimeoff" scope="col">Approved Sick</th>
							<th class="thbdr thpending"  bgcolor="#99ff99" scope="col">&nbsp;</th>
							<th align="left" nowrap="nowrap" class="thtimeoff" scope="col">Approval Pending</th>
							<th class="thbdr thnew"  bgcolor="#ffcc00" scope="col">&nbsp;</th>
							<th  align="left" nowrap="nowrap" class="thtimeoff" scope="col">New Request</th>
							<th class="thbdr thholiday"  bgcolor="#990000" scope="col">&nbsp;</th>
							<th  align="left" nowrap="nowrap" class="thtimeoff" scope="col">Holiday</th>
							<th class="thbdr thweekend"  bgcolor="#999999" scope="col">&nbsp;</th>
							<th align="left" nowrap="nowrap"  class="thtimeoff" scope="col">Weekend</th>
							 <th class="thbdr thclosed"  bgcolor="#dddddd" scope="col">&nbsp;</th>
							<th align="left" nowrap="nowrap" class="thtimeoff" scope="col">Closed Days </th>
							 <th class="thbdr thopen"  bgcolor="#ffffff" scope="col">&nbsp;</th>
							<th align="left" nowrap="nowrap" class="thtimeoff" scope="col">Open Days</th>
						  </tr>
					  </thead>
					</table>
			</div>
			
			<div id="inputPreview" class="table-responsive">
			  <table class="table table-striped table-bordered align-middle rqsttbl">
			  	  <thead>
				  	<tr>
						<th width="160" scope="col">Month</th>
						<th width="30" scope="col">1</th><th width="30" scope="col">2</th>
						<th width="30" scope="col">3</th><th width="30" scope="col">4</th>
						<th width="30" scope="col">5</th><th width="30" scope="col">6</th>		
						<th width="30" scope="col">7</th><th width="30" scope="col">8</th>
						<th width="30" scope="col">9</th><th width="30" scope="col">10</th>
						<th width="30" scope="col">11</th><th width="30" scope="col">12</th>
						<th width="30" scope="col">13</th><th width="30" scope="col">14</th>		
						<th width="30" scope="col">15</th><th width="30" scope="col">16</th>
						<th width="30" scope="col">17</th><th width="30" scope="col">18</th>		
						<th width="30" scope="col">19</th><th width="30" scope="col">20</th>
						<th width="30" scope="col">21</th><th width="30" scope="col">22</th>		
						<th width="30" scope="col">23</th><th width="30" scope="col">24</th>
						<th width="30" scope="col">25</th><th width="30" scope="col">26</th>		
						<th width="30" scope="col">27</th><th width="30" scope="col">28</th>
						<th width="30" scope="col">29</th><th width="30" scope="col">30</th>
						<th width="30" scope="col">31</th>
					  </tr>
				  </thead>
				  <tbody>
	
	
<!-- ----------- -->

				 <?php 
					 
					for( $mth = 1; $mth <= TIME_OFF_MONTHS; $mth++ ) { 
					
						if ( $mth <  $startMonth && $currYear >= $startYear ) { continue; } 
						//if ( $mth > $startMonth && $currYear >= $startYear ) { continue; }
						
						$monthDays = cal_days_in_month(CAL_GREGORIAN, $mth, $currYear );
						echo "<tr><td  nowrap class=\"tdmonth\" > &nbsp;" . date('F', strtotime( $currYear . "/" . $mth . "/01" )) . " " . $currYear . "</td>";
							
						for ( $day = 1; $day <= $monthDays; $day++ ) {
							$date= $currYear . "/" . $mth . "/" . $day;
							$holiday = $currYear . (($mth<10) ? "0".$mth : $mth) . (($day<10) ? "0".$day : $day);
							$today = date("Ymd");
							
							$checkit = "";
							$currRequestID = 0;
							$currRequestTypeID = 0;
							$currRequestHours = 0;
							if ( in_array($holiday, $holidays) ) {
								$chkclass = "chkholiday";
								$divclass = "divholiday";
							}
							else if ( $holiday < $thisAnnivesary )
							{
								$chkclass = "chkpassed";
								$divclass = "divpassed";
							}
							else if ( in_array($holiday, $sickRqst) ) {
								$chkclass = "chksick";
								$checkit = "checked";
								$divclass = "divsick";
								if ( $holiday < $today ) { 
									$chkclass = "chksickpassed";
								}
								$currRequestID = $approvedRqstID[$approvedRqstIdx];
								$currRequestHours = $approvedHours[$approvedRqstIdx];
								$currRequestTypeID = $currYear . "-" . (($mth<10) ? "0".$mth : $mth) . "-" . (($day<10) ? "0".$day : $day) . "-" . $approvedRqstTypeID[$approvedRqstIdx++];
							}
							else if ( in_array($holiday, $approvedRqst) ) {
								$chkclass = "chkapproved";
								$checkit = "checked";
								$divclass = "divapproved";
								if ( $holiday < $today ) { 
									$chkclass = "chkapprovedpassed";
								}
								$currRequestID = $approvedRqstID[$approvedRqstIdx];
								$currRequestHours = $approvedHours[$approvedRqstIdx];
								$currRequestTypeID = $currYear . "-" . (($mth<10) ? "0".$mth : $mth) . "-" . (($day<10) ? "0".$day : $day) . "-" . $approvedRqstTypeID[$approvedRqstIdx++];
							}
							else if ( in_array($holiday, $requestedRqst) ) {
								$chkclass = "chkpending";
								$checkit = "checked";
								$divclass = "divpending";
								if ( $holiday < $today ) { 
									$chkclass = " chkrequestedpassed";
								}
								$currRequestHours = $approvedHours[$approvedRqstIdx];
								$currRequestID = $requestedRqstID[$requestedRqstIdx];
								$currRequestTypeID = $currYear . "-" . (($mth<10) ? "0".$mth : $mth) . "-" . (($day<10) ? "0".$day : $day) . "-" . $requestedRqstTypeID[$requestedRqstIdx++];
							}
							else if ( $holiday < $today ) { 
								if ( date('N', strtotime($date)) >= 6 ) {
									$chkclass = "chkweekendpassed";
									$divclass = "divweekendpassed";
								}
								else {
									$chkclass = "chkpassed";
									$divclass = "divpassed";
								}
							}
							else if ( date('N', strtotime($date)) >= 6 ) { 
								
								$chkclass = "chkweekend";
								$divclass = "divweekend";
								
							}
							else {
								if ( $isWeekendStaff ) {
									$chkclass = "chkpassed";
									$divclass = "divpassed";
								}
								else {
									$chkclass = "chkdefault";
									$divclass = "divdefault";
								}
							}
				?>
							<td width="20" >
						   
						   <!--div id="inputPreview"-->
						   <div class="<?php echo $divclass; ?>">
								<input name="dayRequested[]" id="timeoff_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>" type="checkbox" class="<?php echo $chkclass; ?>" value="<?php echo $currYear . "-" . (($mth<10) ? "0".$mth : $mth) . "-" . (($day<10) ? "0".$day : $day); ?>" <?php echo $checkit; ?> >
								<label  for="timeoff_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>"></label>
								<input type="hidden" name="requestID[]" id="rqstID_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>" value="<?php echo $currRequestID; ?>" />
								<input type="hidden" name="requestTypeID[]" id="rqstTypeID_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>" value="<?php echo $currRequestTypeID; ?>" />
								<input type="hidden" name="numHoursRequested[]" id="hrsRequested_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>" value="<?php echo $currRequestHours; ?>" />
							</div>
							<!--select name="" style="padding-left:0px; display:none;" id='rqstSelect_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>' class="slctRqstType">
								<option value="" selected></option>
							<?php 
								foreach( $timeOffList as $arrIdx => $listRec ) { 
									if ( ( $listRec['RequestTypeID'] == HOLIDAY ) ||
										 ( $listRec['RequestTypeID'] == BEREAVEMENT ) ||
										 ( $listRec['RequestTypeID'] == VACATION && $cannotRequestVacation ) ) { continue; }
							?>
							
									<option value="<?php echo $listRec['RequestTypeID']; ?>"><?php echo $listRec['RequestName']; ?></option>
							<?php } ?>
							</select-->
						   </td>
				 <?php  
						} 
						$monthCount++;
						echo "</tr>";
					}
				?>
				
				
				
					 <?php 
					 
					$currYear++;
					for( $mth = 1; $mth <= TIME_OFF_MONTHS; $mth++ ) { 
					
						if ( $mth >  $startMonth && $currYear >= date("Y") + 1 ) { continue; } 
						
						$monthDays = cal_days_in_month(CAL_GREGORIAN, $mth, $currYear );
						echo "<tr><td  nowrap class=\"tdmonth\" > &nbsp;" . date('F', strtotime( $currYear . "/" . $mth . "/01" )) . " " . $currYear . "</td>";
							
						for ( $day = 1; $day <= $monthDays; $day++ ) {
							$date= $currYear . "/" . $mth . "/" . $day;
							$holiday = $currYear . (($mth<10) ? "0".$mth : $mth) . (($day<10) ? "0".$day : $day);
							$today = date("Ymd");
							
							$checkit = "";
							$currRequestID = 0;
							$currRequestTypeID = 0;
							$currRequestHours = 0;
							if ( in_array($holiday, $holidays) ) {
								$chkclass = "chkholiday";
								$divclass = "divholiday";
							}
							
							else if ( $holiday >= $nextAnnivesary )
							{
								$chkclass = "chkpassed";
								$divclass = "divpassed";
							}
							else if ( in_array($holiday, $sickRqst) ) {
								$chkclass = "chksick";
								$checkit = "checked";
								$divclass = "divsick";
								if ( $holiday < $today ) { 
									$chkclass = "chksickpassed";
								}
								$currRequestID = $approvedRqstID[$approvedRqstIdx];
								$currRequestHours = $approvedHours[$approvedRqstIdx];
								$currRequestTypeID = $currYear . "-" . (($mth<10) ? "0".$mth : $mth) . "-" . (($day<10) ? "0".$day : $day) . "-" . $approvedRqstTypeID[$approvedRqstIdx++];
							}
							else if ( in_array($holiday, $approvedRqst) ) {
								$chkclass = "chkapproved";
								$checkit = "checked";
								$divclass = "divapproved";
								if ( $holiday < $today ) { 
									$chkclass = "chkapprovedpassed";
								}
								$currRequestID = $approvedRqstID[$approvedRqstIdx];
								$currRequestHours = $approvedHours[$approvedRqstIdx];
								$currRequestTypeID = $currYear . "-" . (($mth<10) ? "0".$mth : $mth) . "-" . (($day<10) ? "0".$day : $day) . "-" . $approvedRqstTypeID[$approvedRqstIdx++];
							}
							else if ( in_array($holiday, $requestedRqst) ) {
								$chkclass = "chkpending";
								$checkit = "checked";
								$divclass = "divpending";
								if ( $holiday < $today ) { 
									$chkclass = " chkrequestedpassed";
								}
								$currRequestHours = $approvedHours[$approvedRqstIdx];
								$currRequestID = $requestedRqstID[$requestedRqstIdx];
								$currRequestTypeID = $currYear . "-" . (($mth<10) ? "0".$mth : $mth) . "-" . (($day<10) ? "0".$day : $day) . "-" . $requestedRqstTypeID[$requestedRqstIdx++];
							}
							else if ( $holiday < $today ) { 
								if ( date('N', strtotime($date)) >= 6 ) {
									$chkclass = "chkweekendpassed";
									$divclass = "divweekendpassed";
								}
								else {
									$chkclass = "chkpassed";
									$divclass = "divpassed";
								}
							}
							else if ( date('N', strtotime($date)) >= 6 ) { 
								$chkclass = "chkweekend";
								$divclass = "divweekend";
							}
							else {
								if ( $isWeekendStaff ) {
									$chkclass = "chkpassed";
									$divclass = "divpassed";
								}
								else {
									$chkclass = "chkdefault";
									$divclass = "divdefault";
								}
							}
				?>
							<td width="20" >
			
						   
						   <!--div id="inputPreview"-->
						   <div class="<?php echo $divclass; ?>">
								<input name="dayRequested[]" id="timeoff_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>" type="checkbox" class="<?php echo $chkclass; ?>" value="<?php echo $currYear . "-" . (($mth<10) ? "0".$mth : $mth) . "-" . (($day<10) ? "0".$day : $day); ?>" <?php echo $checkit; ?>>
								<label  for="timeoff_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>"></label>
								<input type="hidden" name="requestID[]" id="rqstID_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>" value="<?php echo $currRequestID; ?>" />
								<input type="hidden" name="requestTypeID[]" id="rqstTypeID_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>" value="<?php echo $currRequestTypeID; ?>" />
								<input type="hidden" name="numHoursRequested[]" id="hrsRequested_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>" value="<?php echo $currRequestHours; ?>" />
							</div>
							<!--select name="" style="padding-left:0px; display:none;" id='rqstSelect_<?php echo $currYear . (($mth<10) ? "0".$mth : $mth) .  (($day<10) ? "0".$day : $day); ?>' class="slctRqstType">
								<option value="" selected></option>
							<?php 
								foreach( $timeOffList as $arrIdx => $listRec ) { 
									if ( ( $listRec['RequestTypeID'] == HOLIDAY ) ||
										 ( $listRec['RequestTypeID'] == BEREAVEMENT ) ||
										 ( $listRec['RequestTypeID'] == VACATION && $cannotRequestVacation ) ) { continue; }
							?>
							
									<option value="<?php echo $listRec['RequestTypeID']; ?>"><?php echo $listRec['RequestName']; ?></option>
							<?php } ?>
							</select-->
						   </td>
				 <?php  
						} 
						$monthCount++;
						echo "</tr>";
					}
				?>
		
					</tbody>
				</table>

				</div>
								  		
				<div class="w-100 d-inline-flex align-items-end justify-content-end">
					<input name="staffID" type="hidden" value="<?php echo $_SESSION['staffID']; ?>" />
					<?php if (  $fromStep2 === true ) { ?>
					<input name="Submit" type="button" class="btn btn-primary" value="Request More Time Off" onclick="window.location.href='<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/staff-corner/index/dest/<?php echo $dest; ?>/'" />
					<?php } else { ?>
					<input name="Submit" type="submit" class="btn btn-primary" id="timeOffBtn" value="Submit Time Off Request" />
					<?php } ?>
				</div>

			</form>

			<div class="modal fade" id="timeoffSelector" tabindex="-1" aria-labelledby="basicModalLabel" aria-hidden="true">
 
				  <div class="modal-dialog modal-lg">
				 
					<div class="modal-content border border-danger">
				 
					  <div class="modal-header bg-primary py-2">
							<h4 class="modal-title text-white" id="basicModalLabel">Select Request Type</h4>
							<!--button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button-->
					  </div>
				 
					  <div class="modal-body">
				 
							<?php if ( $maxSickAllowed <= 0 ) { ?>
								<div class="text-danger fs-6 d-flex align-items-center justify-content-center py-3">Sorry there are no sick leave hours available to you at this time..</div>
							<?php } ?>
							<?php if ( $maxVacationAllowed <= 0 ) { ?>
								<div class="text-danger fs-6 d-flex align-items-center justify-content-center py-3">Sorry there are no vacation hours available to you at this time..</div>
								
							<?php } ?>
								<?php 
									$tdcnt = 0;
									//echo "cannotRequestVacation = $cannotRequestVacation, isWeekendStaff = $isWeekendStaff, cannotRequestSick = $cannotRequestSick";
									foreach( $timeOffList as $arrIdx => $listRec ) { 
										if ( ( $listRec['RequestTypeID'] == HOLIDAY ) ||
											 ( $listRec['RequestTypeID'] == BEREAVEMENT ) ||
											 ( $listRec['RequestTypeID'] == VACATION && $cannotRequestVacation ) ||
											 ( $listRec['RequestTypeID'] == JURYDUTY && $isWeekendStaff ) ||
											 ( $listRec['RequestTypeID'] == PERSONAL && $isWeekendStaff ) ||
											 ( $listRec['RequestTypeID'] == SICK && $cannotRequestSick ) ) { continue; }
											 
											 if ( $listRec['RequestTypeID'] == PERSONAL ) {
											 	$colwidth = "4";
											 }
											 else if ( $listRec['RequestTypeID'] == SICK ) {
											 	$colwidth = "3";
											 }
											 else
											 	$colwidth = "2";
								?>
										<?php if ( $tdcnt == 0 ) { ?> 	
											<div class="row fs-6 d-flex  align-items-start justify-content-center py-2">
												<div class="col-md-<?php echo $colwidth; ?> d-inline-flex align-items-center justify-content-center">
												<input type="radio" class="requestSelected" name="request" value="<?php echo $listRec['RequestTypeID']; ?>" /> &nbsp; <?php echo $listRec['RequestName']; ?>
												</div>
										<?php } else if ( $tdcnt < 4 ) { ?>			
											<div class="col-md-<?php echo $colwidth; ?> d-inline-flex align-items-center justify-content-center">
											<input type="radio" class="requestSelected" name="request" value="<?php echo $listRec['RequestTypeID']; ?>" /> &nbsp; <?php echo $listRec['RequestName']; ?>
											</div>
										<?php } 
											  $tdcnt++;
											  if ( $tdcnt == 4 ) { ?>		
												</div>
											<?php 
												$tdcnt = 0;
											} ?>
								
								<?php } 
									
								?>
								</div>
				 		
							<?php if ( ( ! $cannotRequestSick ) && ( $maxSickAllowed >= 1 ) ) { ?>
							
							<div class="divrange col-md-12 mt-3 row mx-auto">
								<div class="col-md-10 offset-md-1">
									<label class="form-label fs-6" for="sickdaysrange">Select Number of Hours <span class="text-danger fs-6">( Only for Sick Leave )</span> <span id="myValueParent" class="ms-3" style="font-weight:bold; background:blue; color:white; border:1px solid blue; padding:5px 10px; min-width:20px;">
										<span id="myValue" class="text-center fs-4" style="background:blue"></span>
										</span> </label>
								</div>
								<div class="col-md-10 offset-md-1 mb-3">
									<div style="position:relative; margin:auto; width:100%">
										
										<input type="range" class="form-range mt-3" id="sickdaysrange" min="0" max="<?php echo $maxSickAllowed; ?>" step="1"  value="0" disabled />
									</div>
								</div>
							</div>

							<?php } ?>
					 </div>
				 
					<div class="modal-footer bg-light pb-2">
						<button type="button" class="btn btn-primary" data-bs-dismiss="modal"><h5>Save Selection</h5></button>       
					</div>
				 
					</div>
				 
				  </div>
				  
<!-- ------------------------- -->
	
	
<?php
	}
}
?>



				  <!--div id = "dialog-4" title = "Select Request Type">

				  
						<h5 style="float:left; margin-left:10px;"><strong>Select Request Type</strong></h5>
						<table border="0" cellspacing="10" width="480" align="center">
						<?php if ( $maxSickAllowed <= 0 ) { ?>
							<tr><td colspan="4" height="30" valign="middle" style="color:#FF0000">Sorry there are no sick leave hours remaining.</td></tr>
						<?php } ?>
						<?php if ( $maxVacationAllowed <= 0 ) { ?>
							<tr><td colspan="4" height="30" valign="middle" style="color:#FF0000">Sorry there are no vacation hours remaining.</td></tr>
						<?php } ?>
							<?php 
								$tdcnt = 0;
								//echo "cannotRequestVacation = $cannotRequestVacation, isWeekendStaff = $isWeekendStaff, cannotRequestSick = $cannotRequestSick";
								foreach( $timeOffList as $arrIdx => $listRec ) { 
									if ( ( $listRec['RequestTypeID'] == HOLIDAY ) ||
										 ( $listRec['RequestTypeID'] == BEREAVEMENT ) ||
										 ( $listRec['RequestTypeID'] == VACATION && $cannotRequestVacation ) ||
										 ( $listRec['RequestTypeID'] == JURYDUTY && $isWeekendStaff ) ||
										 ( $listRec['RequestTypeID'] == PERSONAL && $isWeekendStaff ) ||
										 ( $listRec['RequestTypeID'] == SICK && $cannotRequestSick ) ) { continue; }
							?>
									<?php if ( $tdcnt == 0 ) { ?> 	
										<tr>
											<td width="120" align="left" valign="middle" height="30"><input type="radio" class="requestSelected" name="request" value="<?php echo $listRec['RequestTypeID']; ?>" /> &nbsp; <?php echo $listRec['RequestName']; ?></td>
									<?php } else if ( $tdcnt < 4 ) { ?>			
										<td width="120"  align="left" valign="middle" height="30"><input type="radio" class="requestSelected" name="request" value="<?php echo $listRec['RequestTypeID']; ?>" /> &nbsp; <?php echo $listRec['RequestName']; ?></td>
									<?php } 
										  $tdcnt++;
										  if ( $tdcnt == 4 ) { ?>		
											</tr>
										<?php 
											$tdcnt = 0;
										} ?>
							
							<?php } 
								while ( $tdcnt < 3 ) {
							?>
								<td></td>
							<?php 
									$tdcnt++;
									if ( $tdcnt == 3 ) {
							?>
							</tr>
							<?php
									}
								} ?>
							</table>
							<br />	
							<?php if ( ( ! $cannotRequestSick ) && ( $maxSickAllowed >= 1 ) ) { ?>
							<div><h5 style="float:left; margin-left:10px;"><strong>Select Number of Hours</strong> <span style="color: #FF0000; font-size:12px;">( Only for Sick Leave )</span></h5></div>
							<!--
							<input style="float:left; margin-left:10px; padding: 5px;" type="number" min="1" step="1" max="<?php echo $maxSickAllowed; ?>" name="sickHours" id="sickHours" disabled /> -->
							<!--div style="margin:50px 0 0 30px; width:440px;" id="slider-range-max"></div--> 
							<?php } ?>
								
				  <!--/div-->