<?php
	
	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		
	if (  $step == 2 ) {
	
		$rtn = recordStaffTemperature($_REQUEST);	
		$updtMessage = $rtn[1];
		if ( $rtn[0] == SUCCESS ) {
			$updtMessage = "Your " . $_REQUEST['tempReading'] . " temperature was recorded successfully.";
			$isFail = false;
		}
		else
			$isFail = true;
			
		$step = 1;
	}
	
	if ( $step == 1 ) { 

		$services = getMyServicesProvided();
?>
<form id="stafflog" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/staff-corner/index/dest/<?php echo $dest; ?>/step/2/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo  $STAFF_CORNER_BREADCRUMB[$dest]; ?></h5>
			   <?php if ( isset($isFail) ) { ?>
			   		<div class="row mt-3 mb-3">
						<div class="col-md-1"></div>
						<div class="col-md-10 col-sm-offset-1 text-center">
							  <div class="alert  <?php echo ( $isFail === false ) ? "alert-success" : "alert-danger"; ?> text-center mb-1">
								<h4>
								<?php 
									echo $updtMessage;
								?>
								</h4>
								</div>
						</div>
						<div class="col-md-1"></div>
					</div>
			   <?php } ?>
              <!-- Floating Labels Form -->
			  
			  <div class="row">
			  		<div class="col-md-3"></div>
					<div class="col-md-3">
					  <div class="form-floating mt-3 input-group" id="div_tempdate" data-td-target-input="nearest" data-td-target-toggle="nearest">
						<input type="text" class="form-control" name="tempdate" id="tempdate" placeholder="Temperature Date"  data-td-target="#div_tempdate" required readonly />
						<label   class="form-label" for="tempdate">Temperature Date</label>
						<span class="input-group-text" data-td-target="#div_tempdate" data-td-toggle="datetimepicker">
							 <span class='bi bi-calendar-date fs-4'></span>
						  </span>
						<div class="invalid-feedback">
							Please provide the temperature date
						</div>
					  </div>
                	</div>
					
					<div class="col-md-3 position-relative">
						<div class="form-floating mt-3">
							<select class="form-select js-select" name="tempReading" id="tempReading" aria-label="Which Temperature" required>
								  <option selected disabled value="">Temperature  to record</option>
								  <option value="Start of Shift">Start of Shift</option>
								  <option value="End of Shift">End of Shift</option>
							</select>
							<label  for="tempReading">Which Temperature</label>
							<div class="invalid-feedback">
								Please select temperature to record.
							</div>
					  	</div>
					</div>
					
					<div class="col-md-3"></div>
			</div>
			
			<?php for( $row = 0; $row < MULTIPLE_TRANSACTIONS; $row++ ) { ?>
			
			<div class="row">
			  		<div class="col-md-3"></div>
					<div class="col-md-3">
					  <div class="form-floating mt-3">
							<select class="form-select staffselect" name="staffID[]" aria-label="Staff Name" >
							  <option selected disabled value="">Choose a Staff</option>
							  <?php echo getTimeOffStaffListing( $_SESSION['staffID'], ADMINISTRATOR ); ?>
							</select>
							<label  for="staffID">Staff Name</label>
							<div class="invalid-feedback">
								Please select a Staff Name.
							</div>
						</div>
                	</div>
					
					<div class="col-md-3 position-relative">
						<div class="form-floating mt-3">
							<input type="number" class="form-control" name="tempValue[]"  min="1" max="100" step="0.1" placeholder="Temperature( <sup>o</sup>F )" >
							<label  for="activitydtl">Temperature( <sup>o</sup>F )</label>
							<div class="invalid-feedback">
								Please provide Temperature( <sup>o</sup>F ).
							</div>
						</div>
					</div>
					
					<div class="col-md-3"></div>
			</div>
			
			<?php } ?>
								
			<div class="text-center mt-5 mb-5">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Record Body Temperature</button>
				   <button type="reset" class="btn btn-secondary mt-3 configbtn" >Start Over</button>
                </div>	
 			</div>
	   </div>
		
	</form>	

<?php
	}
?>