
<?php 
		require_once __DIR__ . '/../assets/PHPDotEnv/vendor/autoload.php';

		$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/../assets/PHPDotEnv', '.onboarding');
		$dotenv->load();

		$onboardError = false;
		$exitCode = 0;
		
		include( __DIR__ . '/../assets/config/constants.inc.php' );
		include( __DIR__ . '/../assets/functions/functions.inc.php' );
		include( __DIR__ . '/../assets/db/db.inc.php' );
		include( __DIR__ . '/../assets/db/general.db.php' );
		
		// Get form data
		$formData = json_decode(file_get_contents(__DIR__ . '/form_data.json'), true);

        // GET values from the $_REQUEST global variable
        //
        $agencyName = $formData['agencyfname'];
        $agencyShortName = $formData['agencysname'];
        $agencySubDomain = $formData['agencysubdomain'];
        $agencyAdminEmail = $formData['agencyadminemail'];
		$agencyAdminUser = $formData['username'];
		$agencyAdminPassword = $formData['adminpassword'];
		$agencyAdminPassword1 = $formData['adminpassword2'];
		
        $corporationID = generateCorporationID();
		$dbhash = strtolower( trim(generateCorporationID(6)));
		
		// Open onboarding log file
		//
        $logfileHandle = fopen('../logs/onboarding-' . date("m-d-Y") . '.log', 'w'); // Open the log file for appending
				
		if ( trim($agencyAdminPassword) != trim($agencyAdminPassword1) ) {
			$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Passwords don't match.";
			fwrite( $logfileHandle, "Onboarding for " . $agencyName . " failed. Passwords don't match." );
			$onboardError = true;
			
			file_put_contents('status.json', json_encode([
				'status' => 'error',
				'message' => "Onboarding for " . $agencyName . " failed. Passwords don't match."
			]));
			exit;
		}
		
		if ( !($onboardError === TRUE) ) 
		{	
			// Connect to Config DB and make sure that the new subdaomain does not exist
			//
	
			// Create connection (without specifying database)
			$dbHandle = new mysqli($_ENV['MAIN_DB_HOST'], $_ENV['MAIN_DB_USER'], $_ENV['MAIN_DB_PASS'], $_ENV['MAIN_DB_CONFIG'] );
								
			if ($dbHandle->connect_error) {
				$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Unable to check if " . $agencySubDomain . " already exists.";
				fwrite( $logfileHandle, "Onboarding for " . $agencyName . " failed. Unable to check if " . $agencySubDomain . " already exists." );
				$onboardError = true;
				
				file_put_contents('status.json', json_encode([
					'status' => 'error',
					'message' => "Onboarding for " . $agencyName . " failed. Unable to check if " . $agencySubDomain . " already exists."
				]));
				exit;
			}
			else {
				$sql = "SELECT ifnull(count(*), 0) as numFound FROM `CorporationConfig` WHERE `CorporationDomain` like '" . $agencyShortName . ".%'";
				$dataResult = $dbHandle->query($sql);
				$dataRow = $dataResult->fetch_assoc();
				if ( $dataRow['numFound'] != 0 ) {
					$onboardingMessage =  "Onboarding for " . $agencyName . " failed as " . $agencySubDomain . " already exists. Please change the Preferred Short Name, or contact SPrimeCare support.";
					fwrite( $logfileHandle, "Onboarding for " . $agencyName . " failed as " . $agencySubDomain . " already exists. . Please change the Preferred Short Name, or contact SPrimeCare support." );
					$onboardError = true;
					
					file_put_contents('status.json', json_encode([
						'status' => 'error',
						'message' => "Onboarding for " . $agencyName . " failed as " . $agencySubDomain . " already exists. Please change the Preferred Short Name, or contact SPrimeCare support."
					]));
					exit;
				}
			}

			if ( !($onboardError === TRUE) )
			{
				//  Generate values for DB_NAME, DB_USER and DB_PASS
				//
				$DB_HOST = $_ENV['MAIN_DB_HOST'];
				if ( preg_match("/sprimecare/i", $_ENV['MAIN_DOMAIN'] ) ) {
					$DB_NAME = 'ltsscish_' . $dbhash . '_' . strtolower( trim($agencyShortName) ) . 'DB';
					$DB_USER = 'ltsscish_'  . $dbhash . '_' . strtolower( trim($agencyShortName) ) . '_dbUser';
				}
				else {
					$DB_NAME = 'cishinc1_' . strtolower( trim($agencyShortName) ) . 'DB';
					$DB_USER = 'cishinc1_' . strtolower( trim($agencyShortName) ) . '_dbUser';
				}
				$DB_PASS = generateStrongPassword();
		
				//  Copy env file to subdomian env file
				//
				$source = ''. __DIR__ . '/../assets/PHPDotEnv/' . '.env';
				$destination = ''. __DIR__ . '/../assets/PHPDotEnv/.' . trim($agencySubDomain) . '.env';
				
				if ( !copy($source, $destination)) {
		
						$onboardingMessage =  "Onboarding for " . $agencyName . " failed to copy and update .env file.";
						fwrite( $logfileHandle, "Onboarding for " . $agencyName . " failed to copy and update .env file." );
						$onboardError = true;
						
						file_put_contents('status.json', json_encode([
							'status' => 'error',
							'message' => "Onboarding for " . $agencyName . " failed to copy and update .env file."
						]));
						exit;
				}
				else {
						// Append required information to the .env file
		
						$fileHandle = fopen($destination, 'a'); // Open the file for appending
		
						if ( !$fileHandle) {
								$onboardingMessage =  "Onboarding for " . $agencyName . " failed to update .env file check with admin.";
								fwrite( $logfileHandle, "Onboarding for " . $agencyName . " failed to update .env file check with admin.." );
								$onboardError = true;
								
								file_put_contents('status.json', json_encode([
									'status' => 'error',
									'message' => "Onboarding for " . $agencyName . " failed to copy and update .env file."
								]));
								exit;
						}
						else {
		
								fwrite($fileHandle, 'CORPORATION_ID='.$corporationID . PHP_EOL);
								fwrite($fileHandle, 'DB_HOST='.$DB_HOST . PHP_EOL);
								fwrite($fileHandle, 'DB_NAME='.$DB_NAME . PHP_EOL);
								fwrite($fileHandle, 'DB_USER='.$DB_USER . PHP_EOL);
								fwrite($fileHandle, 'DB_PASS="'.$DB_PASS . '"' . PHP_EOL);
								fwrite($fileHandle, 'GOOGLE_API_KEY=' . PHP_EOL);
								fwrite($fileHandle, 'AGENCY_NAME="'.$agencyName . '"' . PHP_EOL);
								fwrite($fileHandle, 'AGENCY_SHORT_NAME='.$agencyShortName . PHP_EOL);
								fwrite($fileHandle, 'AGENCY_DOMAIN='.$agencySubDomain . PHP_EOL);
								fclose($fileHandle); // close the file after writing
		
								// Convert windows files to UNIX format
								$command = 'dos2unix ' . $destination;  
								$output = shell_exec($command);
		
								fwrite( $logfileHandle,  "ENV file created" . PHP_EOL);
		
								// Create connection (without specifying database)
								$dbHandle = new mysqli($_ENV['MAIN_DB_HOST'], $_ENV['MAIN_DB_USER'], $_ENV['MAIN_DB_PASS'], $_ENV['MAIN_SYSTEM_DB'] );
		
								// Check connection
								if ($dbHandle->connect_error) {
										$onboardingMessage =  "Onboarding for " . $agencyName . " failed to connect to the database server.";
										fwrite( $logfileHandle, "Connection failed: " . $dbHandle->connect_error . "\n");
										$onboardError = true;
										
										file_put_contents('status.json', json_encode([
											'status' => 'error',
											'message' => 'Connection failed: ' . $dbHandle->connect_error . '\n'
										]));
										exit;
								}
								else {
									$sql_create_db = "CREATE DATABASE IF NOT EXISTS $DB_NAME";
									if ( !($dbHandle->query($sql_create_db) === TRUE)) {
											$onboardingMessage =  "Onboarding for " . $agencyName . " failed to create database ( " . $DB_NAME . " ).";
											fwrite( $logfileHandle, "Error creating database: " . $dbHandle->error . "\n");
											$onboardError = true;
											
											file_put_contents('status.json', json_encode([
												'status' => 'error',
												'message' => "Onboarding for " . $agencyName . " failed to create database ( " . $DB_NAME . " ): " . $dbHandle->error
											]));
											exit;
									}
									else {
			
											$onboardError = false;
											fwrite( $logfileHandle, "Database created" . PHP_EOL);
											$sql_create_user = "CREATE USER IF NOT EXISTS '" . $DB_USER . "'@'%' IDENTIFIED BY '" . $DB_PASS . "'";
			
											if ( !($dbHandle->query($sql_create_user) === TRUE) ) {
													$onboardingMessage =  "Onboarding for " . $agencyName . " failed to create user ( " . $DB_USER . " ).";
													fwrite( $logfileHandle, "Error creating user: " . $dbHandle->error . "\n");
													$onboardError = true;
													
													file_put_contents('status.json', json_encode([
														'status' => 'error',
														'message' => "Error creating user: " . $dbHandle->error . "\n"
													]));
													exit;
											}
											else {
													fwrite( $logfileHandle, "User created and added to database $DB_NAME" . PHP_EOL);	
													
													$sql_grant_permissions = "GRANT rds_superuser_role TO '" . $DB_USER . "'@'%'";
													
													if ( !($dbHandle->query($sql_grant_permissions) === TRUE) ) {
															$onboardingMessage =  "Onboarding for " . $agencyName . " failed to grant privileges to user ( " . $DB_USER . " ).";
															fwrite( $logfileHandle, "Error granting user privileges: " . $dbHandle->error . "\n");
															$onboardError = true;
															
															file_put_contents('status.json', json_encode([
																'status' => 'error',
																'message' => "Onboarding for " . $agencyName . " failed to grant privileges to user ( " . $DB_USER . " ): " . $dbHandle->error
															]));
															exit;
													}
													else {
			
															fwrite( $logfileHandle, "User privileges granted successfully. " . "\n");
			
															// Apply the changes
															$sql_flush_privileges = "FLUSH PRIVILEGES";
															if ( !($dbHandle->query($sql_flush_privileges) ) === TRUE) {
																	$onboardingMessage =  "Onboarding for " . $agencyName . " failed to flush privileges to user ( " . $DB_USER . " ).";
																	echo "Error flushing user privileges: " . $dbHandle->error . "\n";
																	$onboardError = true;
																	
																	file_put_contents('status.json', json_encode([
																		'status' => 'error',
																		'message' => "Onboarding for " . $agencyName . " failed to flush privileges to user ( " . $DB_USER . " ): " . $dbHandle->error
																	]));
																	exit;
															}
															else {
																	fwrite( $logfileHandle, "User privileges flushed successfully. " . "\n");
															}
													}
													
													// Grant permissions to the user on the new database
													$sql_grant_permissions = "SET DEFAULT ROLE rds_superuser_role TO '" . $DB_USER . "'@'%'";
													
													if ( !($dbHandle->query($sql_grant_permissions) === TRUE) ) {
															$onboardingMessage =  "Onboarding for " . $agencyName . " failed to grant privileges to user ( " . $DB_USER . " ).";
															fwrite( $logfileHandle, "Error granting user privileges: " . $dbHandle->error . "\n");
															$onboardError = true;
															
															file_put_contents('status.json', json_encode([
																'status' => 'error',
																'message' => "Onboarding for " . $agencyName . " failed to grant privileges to user ( " . $DB_USER . " ): " . $dbHandle->error
															]));
															exit;
													}
													else {
			
															fwrite( $logfileHandle, "User privileges granted successfully. " . "\n");
			
															// Apply the changes
															$sql_flush_privileges = "FLUSH PRIVILEGES";
															if ( !($dbHandle->query($sql_flush_privileges) ) === TRUE) {
																	$onboardingMessage =  "Onboarding for " . $agencyName . " failed to flush privileges to user ( " . $DB_USER . " ).";
																	echo "Error flushing user privileges: " . $dbHandle->error . "\n";
																	$onboardError = true;
																	
																	file_put_contents('status.json', json_encode([
																		'status' => 'error',
																		'message' => "Onboarding for " . $agencyName . " failed to flush privileges to user ( " . $DB_USER . " ): " . $dbHandle->error
																	]));
																	exit;
															}
															else {
																	fwrite( $logfileHandle, "User privileges flushed successfully. " . "\n");
															}
													}
						

													// Grant permissions to the user on the new database
													$sql_grant_permissions = "GRANT USAGE ON " . $DB_NAME . ".* TO '" . $DB_USER . "'@'%'";
													if ( !($dbHandle->query($sql_grant_permissions) === TRUE) ) {
															$onboardingMessage =  "Onboarding for " . $agencyName . " failed to grant privileges to user ( " . $DB_USER . " ).";
															fwrite( $logfileHandle, "Error granting user privileges: " . $dbHandle->error . "\n");
															$onboardError = true;
															
															file_put_contents('status.json', json_encode([
																'status' => 'error',
																'message' => "Onboarding for " . $agencyName . " failed to grant privileges to user ( " . $DB_USER . " ): " . $dbHandle->error
															]));
															exit;
													}
													else {
			
															fwrite( $logfileHandle, "User privileges granted successfully. " . "\n");
			
															// Apply the changes
															$sql_flush_privileges = "FLUSH PRIVILEGES";
															if ( !($dbHandle->query($sql_flush_privileges) ) === TRUE) {
																	$onboardingMessage =  "Onboarding for " . $agencyName . " failed to flush privileges to user ( " . $DB_USER . " ).";
																	echo "Error flushing user privileges: " . $dbHandle->error . "\n";
																	$onboardError = true;
																	
																	file_put_contents('status.json', json_encode([
																		'status' => 'error',
																		'message' => "Onboarding for " . $agencyName . " failed to flush privileges to user ( " . $DB_USER . " ): " . $dbHandle->error
																	]));
																	exit;
															}
															else {
																	fwrite( $logfileHandle, "User privileges flushed successfully. " . "\n");
															}
													}
													
													//$sql_grant_permissions = "SET PASSWORD FOR '" . $DB_USER . "'@'%' = PASSWORD('" . $DB_PASS . "')";
													$sql_grant_permissions = "ALTER USER  '" . $DB_USER . "'@'%' IDENTIFIED BY '" . $DB_PASS . "'";
													if ( !($dbHandle->query($sql_grant_permissions) === TRUE) ) {
															$onboardingMessage =  "Onboarding for " . $agencyName . " failed to grant privileges to user ( " . $DB_USER . " ).";
															fwrite( $logfileHandle, "Error granting user privileges: " . $dbHandle->error . "\n");
															$onboardError = true;
															
															file_put_contents('status.json', json_encode([
																'status' => 'error',
																'message' => "Onboarding for " . $agencyName . " failed to grant privileges to user ( " . $DB_USER . " ): " . $dbHandle->error
															]));
															exit;
													}
													else {
			
															fwrite( $logfileHandle, "User privileges granted successfully. " . "\n");
			
															// Apply the changes
															$sql_flush_privileges = "FLUSH PRIVILEGES";
															if ( !($dbHandle->query($sql_flush_privileges) ) === TRUE) {
																	$onboardingMessage =  "Onboarding for " . $agencyName . " failed to flush privileges to user ( " . $DB_USER . " ): " . $dbHandle->error;
																	echo "Error flushing user privileges: " . $dbHandle->error . "\n";
																	$onboardError = true;
																	
																	file_put_contents('status.json', json_encode([
																		'status' => 'error',
																		'message' => "Onboarding for " . $agencyName . " failed to flush privileges to user ( " . $DB_USER . " ): " . $dbHandle->error
																	]));
																	exit;
															}
															else {
																	fwrite( $logfileHandle, "User privileges flushed successfully. " . "\n");
															}
													}
											}
									}	
								}

								if ( !($onboardError === TRUE) )  
								{
									// Get data from staging database
									//
									
									// Get the list of tables
									$result = $dbHandle->query("SHOW TABLES");
									if (!$result) {
											$onboardingMessage =  "Onboarding for " . $agencyName . " failed with error: ( " . $dbHandle->error . " ).";
											$onboardError = true;
											fclose($file);
											
											file_put_contents('status.json', json_encode([
												'status' => 'error',
												'message' => "Onboarding for " . $agencyName . " failed with error: ( " . $dbHandle->error . " )."
											]));
											exit;
									}
			
									$tables = array();
			
									while ($row = $result->fetch_array()) {
											$tables[] = $row[0];
									}	
									
									//while ($row = $result->fetch_array()) {
									foreach( $tables as $tabIdx => $table ) {
											//fwrite( $logfileHandle, 'Pulling structure of table ' . $table . "\n" );
											$dbTableFile = '../clients-online-files/dbdumps/' . $table . '.sql';
											$file = fopen($dbTableFile, 'w');
											
											if ($file) {
												// The file is now created or truncated, you can proceed to write to it
												// Write CREATE TABLE statement
												//fwrite( $logfileHandle,"SHOW CREATE TABLE `$table`\n");
												$createTableResult = $dbHandle->query("SHOW CREATE TABLE `$table`");
												$createTableRow = $createTableResult->fetch_assoc();
												
												$sql_with_if_not_exists = preg_replace('/^CREATE TABLE/i', 'CREATE TABLE IF NOT EXISTS', $createTableRow['Create Table']);
												fwrite($file, $sql_with_if_not_exists . ";\n\n");
												fclose($file);
											} 
											
									}

									foreach( $tables as $tabIdx => $table ) {
											//fwrite( $logfileHandle,"Dumping table: " . $table . "\n");
											$dbTableDump = '../clients-online-files/dbdumps/' . $table . 'Dump.sql';
											$file = fopen($dbTableDump, 'w');
											if ($file) {
												// The file is now created or truncated, you can proceed to write to it
												//fwrite( $logfileHandle,"SELECT * FROM `$table`\n\n");
												// Dump table data
												$dataResult = $dbHandle->query("SELECT * FROM `$table`");
												while ($dataRow = $dataResult->fetch_assoc()) {
														$columns = array_keys($dataRow);
														//$values = array_map([$dbHandle, 'real_escape_string'], array_values($dataRow));
														$values = array_map(function ($value) use ($dbHandle) {
															return $dbHandle->real_escape_string($value ?? 'NULL');
														}, array_values($dataRow));
														$columnsList = implode('`, `', $columns);
														$valuesList = implode("', '", $values);
			
														$insertStatement = "INSERT INTO `$table` (`$columnsList`) VALUES ('$valuesList');\n";
														fwrite($file, $insertStatement);
												}
												fwrite($file, "\n");
												fclose($file);
											} 
									}
								}

								if ( $onboardError === TRUE )  
								{
								}
								else {
									// Close the connection
									$dbHandle->close();
			
									// Dump data to new database
									//
									fwrite( $logfileHandle,"\n\nDumping backup to new database.");
			
									// Connect to the target database
									$dbHandle = new mysqli($_ENV['MAIN_DB_HOST'], $_ENV['MAIN_DB_USER'], $_ENV['MAIN_DB_PASS'], $DB_NAME );
			
									// Check connection
									if ($dbHandle->connect_error) {
											$onboardingMessage =  "Onboarding for " . $agencyName . " failed with error: ( " . $dbHandle->connect_error . " ).";
											fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed with error: ( " . $dbHandle->connect_error . " ).");
											$onboardError = true;
											
											file_put_contents('status.json', json_encode([
												'status' => 'error',
												'message' => "Onboarding for " . $agencyName . " failed with error: ( " . $dbHandle->connect_error . " )."
											]));
											exit;
									}	
									else {
										 foreach( $tables as $tabIdx => $table ) {
										 
											$dbTableFile = '../clients-online-files/dbdumps/' . $table . '.sql';
											
											// Read the SQL dump file
											$sql = file_get_contents($dbTableFile);
											
											try { 
												if ( trim($sql) == '' ) {
														unlink($dbTableFile);
												}
												else
												{
													if ( $dbHandle->multi_query($sql) ) {
															do {
																	// Keep processing results until all queries are done
																	if ($result = $dbHandle->store_result()) {
																			$result->free();
																	}
															} while ($dbHandle->next_result());
															unlink($dbTableFile);
													} else {
													
															// check if table exists
															$chksql = "SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?";
															$chkstmt = $dbHandle->prepare($chksql);
															$chkstmt->bind_param("ss", $DB_NAME, $table);
															$chkstmt->execute();
															$chkstmt->store_result();
															
															if ($chkstmt->num_rows > 0) {
																
															} else {
																
																$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error creating table "  . $table . ": ( " . $dbHandle->error . " ).\n";
																fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error creating table "  . $table . ": ( " . $dbHandle->error . " ).\n");
															}
													}
												}
											}
											catch( mysqli_sql_exception $e ) {
												// check if table exists
												$chksql = "SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?";
												$chkstmt = $dbHandle->prepare($chksql);
												$chkstmt->bind_param("ss", $DB_NAME, $table);
												$chkstmt->execute();
												$chkstmt->store_result();
												
												if ($chkstmt->num_rows > 0) {
													
												} else {
															
													$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error creating table "  . $table . ": ( " . $e->getMessage() . " ).\n";
													fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error creating table "  . $table . ": ( " . $e->getMessage() . " ).\n");
												}
											}
										}	
								
										// Repeat until all tables are created
										//
										
										// Specify the directory where the SQL files are located
										$directory = '../clients-online-files/dbdumps/';
										
										// Get all .sql files in the directory
										$files = glob($directory . '*.sql');
										
										// Filter out files that contain the word 'Dump'
										$filteredFiles = array_filter($files, function($file) {
											return strpos(basename($file), 'Dump') === false;
										});
										
										// Convert the filtered results back into an array
										$filteredFiles = array_values($filteredFiles);
										
										while( is_array($filteredFiles) && count($filteredFiles) > 0 ) {
											// Print the filtered list of files
											foreach ($filteredFiles as $dbTableFile) {
																						
												// Read the SQL dump file
												$sql = file_get_contents($dbTableFile);
												
												try { 
													if ( trim($sql) == '' ) {
														unlink($dbTableFile);
													}
													else
													{
														if ( $dbHandle->multi_query($sql) ) {
																do {
																		// Keep processing results until all queries are done
																		if ($result = $dbHandle->store_result()) {
																				$result->free();
																		}
																} while ($dbHandle->next_result());
																unlink($dbTableFile);
														} else {
																$chksql = "SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?";
																$chkstmt = $dbHandle->prepare($chksql);
																$chkstmt->bind_param("ss", $DB_NAME, $table);
																$chkstmt->execute();
																$chkstmt->store_result();
																
																if ($chkstmt->num_rows > 0) {
																	
																} else {
													
																	//$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error creating table "  . $table . ": ( " . $dbHandle->error . " ).\n";
																	fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error creating table "  . $table . ": ( " . $dbHandle->error . " ).\n");
																}
														}
													}
												}
												catch( mysqli_sql_exception $e ) {
													$chksql = "SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?";
													$chkstmt = $dbHandle->prepare($chksql);
													$chkstmt->bind_param("ss", $DB_NAME, $table);
													$chkstmt->execute();
													$chkstmt->store_result();
													
													if ($chkstmt->num_rows > 0) {
														
													} else {
														//$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error creating table "  . $table . ": ( " . $e->getMessage() . " ).\n";
														fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error creating table "  . $table . ": ( " . $e->getMessage() . " ).\n");
													}
												}
											
											}
											
											// Get all .sql files in the directory
											$files = glob($directory . '*.sql');
											
											// Filter out files that contain the word 'Dump'
											$filteredFiles = array_filter($files, function($file) {
												return strpos(basename($file), 'Dump') === false;
											});
											
											// Convert the filtered results back into an array
											$filteredFiles = array_values($filteredFiles);
											
											
										}
										
								
										// Disable foreign key checks
										$dbHandle->query("SET foreign_key_checks = 0");
	
										foreach( $tables as $tabIdx => $table ) {
										 
											$dbTableDumpFile = '../clients-online-files/dbdumps/' . $table . 'Dump.sql';
											
											$dumpsql = file_get_contents($dbTableDumpFile);
	
											try {
												if ( trim($dumpsql) == '' ) {
														unlink($dbTableDumpFile);
												}
												else
												{
													if ($dbHandle->multi_query($dumpsql)) {
															do {
																	// Keep processing results until all queries are done
																	if ($result = $dbHandle->store_result()) {
																			$result->free();
																	}
															} while ($dbHandle->next_result());
															unlink($dbTableDumpFile);
													} else {
															//$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error importing table "  . $table . ": ( " . $dbHandle->error . " ).\n";
															fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error importing table "  . $table . ": ( " . $dbHandle->error . " ).\n");
															$onboardError = true;
													}
												}
											} catch( mysqli_sql_exception $e ) {
												//$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error importing table "  . $table . ": ( " . $dbHandle->error . " ).\n";
												fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error importing table "  . $table . ": ( " . $dbHandle->error . " ).\n");
												$onboardError = true;
												
												file_put_contents('status.json', json_encode([
													'status' => 'error',
													'message' => "Onboarding for " . $agencyName . " failed. Error importing table "  . $table . ": ( " . $dbHandle->error . " ).\n"
												]));
												exit;
											
												echo "";
											}
										}
										// Enable foreign key checks
										$dbHandle->query("SET foreign_key_checks = 1");
										
										//$dbHandle->close();
									}
								}
								
										
								// Create the functions and procedures
								if ( !($onboardError === TRUE) )  
								{
									
									$dbFunctionsFile = '../clients-online-files/dbdumps/functions/functions-procedures.sql';
											
									// Read the SQL dump file
									$sql = file_get_contents($dbFunctionsFile);
									$sql = preg_replace('/\badmin\b/i', "" . $DB_USER . "", $sql);
									
									//echo $sql;
									
									try { 
										if ( trim($sql) == '' ) {	
										}
										else
										{
											if ( $dbHandle->multi_query($sql) ) {
													do {
															// Keep processing results until all queries are done
															if ($result = $dbHandle->store_result()) {
																	$result->free();
															}
													} while ($dbHandle->next_result());
											} else {
														$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error creating table "  . $table . ": ( " . $dbHandle->error . " ).\n";
														fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error creating table "  . $table . ": ( " . $dbHandle->error . " ).\n");
											}
										}
									}
									catch( mysqli_sql_exception $e ) {
										$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error creating functions : ( " . $e->getMessage() . " ).\n";
										fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error creating functions : ( " . $e->getMessage() . " ).\n");
										//$onboardError = true;
									}
								
								}
										
								//  Tables, Functions and Procedures counts as well as Table Row Counts
								
								$sql  = "SELECT SUM(ROUTINE_TYPE = 'FUNCTION') AS function_count, SUM(ROUTINE_TYPE = 'PROCEDURE') AS procedure_count ";
								$sql .= " FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA = ?";
								$stmt = $dbHandle->prepare($sql);
								$stmt->bind_param("s", $_ENV['MAIN_SYSTEM_DB']);
								$stmt->execute();
								$stmt->bind_result($staging_function_count, $staging_procedure_count);
								$stmt->fetch();
								$stmt->close();
								
								
								$sql  = "SELECT SUM(ROUTINE_TYPE = 'FUNCTION') AS function_count, SUM(ROUTINE_TYPE = 'PROCEDURE') AS procedure_count ";
								$sql .= " FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA = ?";
								$stmt = $dbHandle->prepare($sql);
								$stmt->bind_param("s", $DB_NAME);
								$stmt->execute();
								$stmt->bind_result($newdb_function_count, $newdb_procedure_count);
								$stmt->fetch();
								$stmt->close();
								
								// Get list of tables from staging database
								$sql = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ?";
								$stmt = $dbHandle->prepare($sql);
								$stmt->bind_param("s", $_ENV['MAIN_SYSTEM_DB']);
								$stmt->execute();
								$result = $stmt->get_result();
								
								$staging_total_records = 0;
								$staging_table_counts = [];
								
								while ($row = $result->fetch_assoc()) {
									$table = $row['TABLE_NAME'];
									$count_query = "SELECT COUNT(*) as count FROM `$table`";
									$count_result = $dbHandle->query($count_query);
									
									if ($count_row = $count_result->fetch_assoc()) {
										$staging_table_counts[$table] = $count_row['count'];
										$staging_total_records += $count_row['count'];
									}
								}
								$stmt->close();

								// Get list of tables from new database
								$sql = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ?";
								$stmt = $dbHandle->prepare($sql);
								$stmt->bind_param("s", $DB_NAME);
								$stmt->execute();
								$result = $stmt->get_result();
								
								$newdb_total_records = 0;
								$newdb_table_counts = [];
								
								while ($row = $result->fetch_assoc()) {
									$table = $row['TABLE_NAME'];
									$count_query = "SELECT COUNT(*) as count FROM `$table`";
									$count_result = $dbHandle->query($count_query);
									
									if ($count_row = $count_result->fetch_assoc()) {
										$newdb_table_counts[$table] = $count_row['count'];
										$newdb_total_records += $count_row['count'];
									}
								}
								$stmt->close();
								
								$dbHandle->close();  // Now close the database handle to the new database
								
								if ( $staging_function_count == $newdb_function_count && $newdb_procedure_count == $staging_procedure_count && 
									 count($staging_table_counts) == count($newdb_table_counts) )
								{
									$onboardError = false;
									$onboardingMessage = "";
								}
										
								// Write agency configuration data to config database
								//
								if ( !($onboardError === TRUE) ) {
								
										fwrite( $logfileHandle,"Writing " . $agencySubDomain . " configuration to configuration database " . $_ENV['MAIN_DB_CONFIG']);
										
										// Create connection (without specifying database)
										$dbHandle = new mysqli($_ENV['MAIN_DB_HOST'], $_ENV['MAIN_DB_USER'], $_ENV['MAIN_DB_PASS'], $_ENV['MAIN_DB_CONFIG'] );
										if ( $dbHandle->connect_error ) {
												$onboardingMessage =  "Onboarding for " . $agencyName . " failed to write configuration for " . $agencySubDomain . " to the configuration dayabase.";
												fwrite( $logfileHandle, "Onboarding for " . $agencyName . " failed to write configuration for " . $agencySubDomain . " to the configuration dayabase." );
												$onboardError = true;
												
												file_put_contents('status.json', json_encode([
													'status' => 'error',
													'message' => "Onboarding for " . $agencyName . " failed to write configuration for " . $agencySubDomain . " to the configuration dayabase."
												]));
												exit;
												
										}
		
										if ( !( $onboardError === TRUE ) )
										{
												// Grant permissions to the user on the new database
												$sql_ins_config = "INSERT INTO `CorporationConfig`(`CorporationName`, `CorporationID`, `CorporationDomain`, ";
												$sql_ins_config .= "  `CorporationDB`, `CorporationDBUser`, `CorporationDBPass`) VALUES ( ";
												$sql_ins_config .= "'" . $agencyShortName . "', '" . $corporationID . "', '" . $agencySubDomain . "', '" . $DB_NAME . "', '" . $DB_USER . "', '" . $DB_PASS . "')";
												if ( $dbHandle->query($sql_ins_config) ) {
														
												} else {
														$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n";
														fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n");
														$onboardError = true;
														
														file_put_contents('status.json', json_encode([
															'status' => 'error',
															'message' => "Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n"
														]));
														exit;
												}
										}
										
										//  Create Admin user in new database
										//
										if ( !( $onboardError === TRUE ) )
										{
											// Create connection (without specifying database)
											$dbHandle = new mysqli($_ENV['MAIN_DB_HOST'], $DB_USER, $DB_PASS, $DB_NAME );
											if ( $dbHandle->connect_error ) {
													$onboardingMessage =  "Onboarding for " . $agencyName . " failed to save admin credentials to the new database " . $DB_NAME . ".";
													fwrite( $logfileHandle, "Onboarding for " . $agencyName . " failed to save admin credentials to the new database " . $DB_NAME . "." );
													$onboardError = true;
													
													file_put_contents('status.json', json_encode([
														'status' => 'error',
														'message' => "Onboarding for " . $agencyName . " failed to save admin credentials to the new database " . $DB_NAME . "."
													]));
													exit;
														
											}
										}
								
										if ( !( $onboardError === TRUE ) )
										{
												$staffID = getNextID( "`Staff`", "`StaffID`", $dbHandle );
												if ( $staffID == -1 ) {
													$onboardingMessage =  "Onboarding for " . $agencyName . " failed to save admin credentials to the new database " . $DB_NAME . ".";
													fwrite( $logfileHandle, "Onboarding for " . $agencyName . " failed to save admin credentials to the new database " . $DB_NAME . "." );
													$onboardError = true;
													
													file_put_contents('status.json', json_encode([
														'status' => 'error',
														'message' => "Onboarding for " . $agencyName . " failed to save admin credentials to the new database " . $DB_NAME . "."
													]));
													exit;
												}
												else {
													// Grant permissions to the user on the new database
													$sql_ins_staff = "INSERT INTO `ConfigureStaff`(`StaffID`, `SupervisorID`, `StaffFname`, `StaffLname`, `StaffEmail` ) VALUES (";							
													$sql_ins_staff .= $staffID . ", " . $staffID . ", '" . $agencyShortName . "', 'Administrator', '" . $agencyAdminEmail . "' )";
													if ( $dbHandle->query($sql_ins_staff) ) {
															
													} else {
															$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n";
															fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n");
															$onboardError = true;
															
															file_put_contents('status.json', json_encode([
																'status' => 'error',
																'message' => "Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n"
															]));
															exit;
													}
												}
												
												if ( !( $onboardError === TRUE ) )
												{
													$sql_ins_staff = "INSERT INTO `ConfigureStaffAuthAz`(`StaffID`, `Username`, `StaffPassword`, `StaffRoleID`, `PswdReset`) VALUES (";												
																								
													$sql_ins_staff .= $staffID . ", '" . $agencyAdminUser . "', '" . password_hash( sql_quote( $dbHandle, trim( $agencyAdminPassword )), PASSWORD_DEFAULT ) . "', 11, 'Y' )";
													if ( $dbHandle->query($sql_ins_staff) ) {
															
													} else {
															$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n";
															fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n");
															$onboardError = true;
															
															file_put_contents('status.json', json_encode([
																'status' => 'error',
																'message' => "Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n"
															]));
															exit;
													}
												}
												
												
												if ( !( $onboardError === TRUE ) )
												{
													$sql_ins_staff = "INSERT INTO `ConfigureStaffIndicators`(`StaffID`, `PositionID`, `HouseID`, `IsConfirmed`, `isEmailVerified`) VALUES (";																					
													$sql_ins_staff .= $staffID . ", 14, 0, 'Y', 'Y' )";
													if ( $dbHandle->query($sql_ins_staff) ) {
															
													} else {
															$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n";
															fwrite( $logfileHandle,"Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n");
															$onboardError = true;
															
															file_put_contents('status.json', json_encode([
																'status' => 'error',
																'message' => "Onboarding for " . $agencyName . " failed. Error writing config for "  . $agencySubDomain . ": ( " . $dbHandle->error . " ).\n"
															]));
															exit;
													}
												}
												
										}
										
										// Check connection
										if ( $onboardError === TRUE ) {
		
												$onboardingMessage =  "Onboarding for " . $agencyName . " is not complete. Please contact support to enter the following Agency Information in the config database." . PHP_EOL . "CorporationName = $agencyShortName" . PHP_EOL . ", CorporationID = $corporationID" . PHP_EOL . ", CorporationDomain = $agencySubDomain" . PHP_EOL . ", CorporationDB = $DB_NAME" . PHP_EOL . ", CorporationDBUser = $DB_USER" . PHP_EOL . ", CorporationDBPass = $DB_PASS" . PHP_EOL;
												fwrite( $logfileHandle,  "Onboarding for " . $agencyName . " is not complete. Please contact support to enter the following Agency Information in the config database." . PHP_EOL . "CorporationName = $agencyShortName" . PHP_EOL . ", CorporationID = $corporationID" . PHP_EOL . ", CorporationDomain = $agencySubDomain" . PHP_EOL . ", CorporationDB = $DB_NAME" . PHP_EOL . ", CorporationDBUser = $DB_USER" . PHP_EOL . ", CorporationDBPass = $DB_PASS" . PHP_EOL );
												echo "Connection failed: " . $dbHandle->connect_error . "\n";
												$onboardError = true;
												
												file_put_contents('status.json', json_encode([
													'status' => 'error',
													'message' => "Onboarding for " . $agencyName . " is not complete. Please contact support to enter the following Agency Information in the config database." . PHP_EOL . "CorporationName = $agencyShortName" . PHP_EOL . ", CorporationID = $corporationID" . PHP_EOL . ", CorporationDomain = $agencySubDomain" . PHP_EOL . ", CorporationDB = $DB_NAME" . PHP_EOL . ", CorporationDBUser = $DB_USER" . PHP_EOL . ", CorporationDBPass = $DB_PASS"
												]));
												exit;
										}
										else {
												$onboardingMessage =  "Onboarding for " . $agencyName . " completed sucessfully and the " . $agencySubDomain . " configuration data was also written to the configuration database " . $_ENV['MAIN_DB_CONFIG'] . " successfully";
												 fwrite( $logfileHandle, "Onboarding for " . $agencyName . " completed sucessfully and the " . $agencySubDomain . " configuration data was also written to the configuration database " . $_ENV['MAIN_DB_CONFIG'] . " successfully");
												 
												 file_put_contents('status.json', json_encode([
													'status' => 'done',
													'message' => "Onboarding for " . $agencyName . " completed sucessfully and the " . $agencySubDomain . " configuration data was also written to the configuration database " . $_ENV['MAIN_DB_CONFIG'] . " successfully"
												]));
												exit;

										}
								}	
								
								// Close the connection
								
								if (isset($dbHandle) && $dbHandle instanceof mysqli && !$dbHandle->connect_errno) {
									$dbHandle->close();
								} 
						}
				}
			}
		}
        fclose($logfileHandle);																																											
																																																																																
	
?>


