<?php
	
	$doconfigredirect = 1;
	$requireSignOn = 'N';
	$includeFooter = false;
	$nosidebar = true;
	$onboardError = 0;
	$fromConfigScreen = true;
	$protocol = isset($_SERVER['HTTPS']) ? 'https' : 'http';

	require_once __DIR__ . '/../assets/PHPDotEnv/vendor/autoload.php';
	
    $dotenv = Dotenv\Dotenv::createImmutable(__DIR__.'/../assets/PHPDotEnv', '.onboarding');
    $dotenv->load();
		
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.inc.php' );
	
	$PULL_CONFIG_DATA = false;
	unset($agency_info);
	
	$filebase = basename(dirname(__FILE__));
	
	if ( preg_match("/onboardingAndStatus/i", $_SERVER['SCRIPT_NAME'] ) ) {
		$dest = "onboarding";
	}
	
	@unlink($_SERVER['DOCUMENT_ROOT'] . '/onboardingAndStatus/status.json');
											
	$step = 1;
	
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/status.header.php' );
?>

    <main id="main" class="main">

    <div class="pagetitle">
      <h1>Agency Onboarding </h1>
      <nav>
        <ol class="breadcrumb">
          <!--li class="breadcrumb-item"><a href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>">Home</a></li -->
          <li class="breadcrumb-item active">Onboard Agency</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
	
    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
				<h5 class="card-title">SPrimeCare Agency Onboarding</h5>
			  
			  <div class="row mt-5 mb-3">
				<!--div class="col-md-2"></div-->
				<div class="col-md-12">
					<h5>Welcome to the SPrimeCare Agency Onboarding process.</h5>
					<h5>In this process, please provide your agency's full name and an agency short name will be recommended for you, but you also can enter an agency short name of your choice. Once this information is provided the SPrimeCare Application will be provisioned for your agency.</h5>
				</div>
				<!--div class="col-md-2"></div-->
			</div>
              <!-- Floating Labels Form -->
              <!--form id="onboardingForm" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/onboardingAndStatus/index.php" enctype="multipart/form-data" novalidate-->
              <form id="onboardingForm" class="row g-3 needs-validation"  novalidate> 				
			<div class="row">
				<!--div class="col-md-2"></div-->
				<div class="col-md-8">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="agencyfname" id="agencyfname" placeholder="Agency Full Name: eg Computer ServicesCorporation, Inc." value="<?php echo ( $onboardError == 1 ) ? $_REQUEST['agencyfname'] : ''; ?>" required />
                    <label  for="agencyfname">Agency Full Name: eg Computer Services Corporation, Inc.</label>
					<div class="invalid-feedback">
                    	Please provide the Agency Full Name.
                  	</div>
                  </div>
                </div>
				<div class="col-md-4">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="agencyrecsname" id="agencyrecsname" autocomplete="off" placeholder="Recommended Short Name" value="<?php echo ( $onboardError == 1  ) ? $_REQUEST['agencysname'] : ''; ?>" >
                    <label  for="agencyrecsname">Recommended Short Name</label>
					<div class="invalid-feedback">
                    	Please provide the Recommended Short Name.
                  	</div>
                  </div>
                </div>
				<!--div class="col-md-1"></div-->
			  </div>		

				<div class="row">
			  	<!--div class="col-md-2"></div-->
				
				<div class="col-md-4">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="agencysname" id="agencysname" autocomplete="off" placeholder="Preferred Short Name" value="<?php echo ( $onboardError == 1  ) ? ( isset($_REQUEST['agencysname']) ? $_REQUEST['agencysname'] :'') : ''; ?>" required />
                    <label  for="agencysname">Preferred Short Name</label>
					<div class="invalid-feedback">
                    	Please provide the Preferred Short Name.
                  	</div>
                  </div>
                </div>
				<div class="col-md-4">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="agencysubdomain" id="agencysubdomain" autocomplete="off" placeholder="Assigned Subdomain" value="<?php echo ( $onboardError == 1  ) ? $_REQUEST['agencysubdomain'] : ''; ?>" readonly>
                    <label  for="agencysubdomain">Assigned Subdomain</label>
                  </div>
                </div>
				<div class="col-md-4">
                  <div class="form-floating mt-3">
                    <input type="email" class="form-control" name="agencyadminemail" id="agencyadminemail" autocomplete="off" placeholder="Agency Admin Email" value="<?php echo ( $onboardError == 1  ) ? $_REQUEST['agencyadminemail'] : ''; ?>" required>
                    <label  for="agencyadminemail">Agency Admin Email</label>
					<div class="invalid-feedback">
                    	Please provide the Agency Admin Email.
                  	</div>
                  </div>
                </div>
				<!--div class="col-md-1"></div-->
			  </div>
			  
			  <div class="row">
			  	<!--div class="col-md-2"></div-->
				
				<div class="col-md-4">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="username" id="adminusername" autocomplete="off" placeholder="Admin User Name" value="<?php echo ( $onboardError == 1  ) ? $_REQUEST['username'] : ''; ?>" required />
                    <label  for="agencysname">Admin User Name</label>
					<div class="invalid-feedback">
                    	Please provide the Admin User Name.
                  	</div>
                  </div>
                </div>
				<div class="col-md-4">
                  <div class="form-floating mt-3 password-container">
                    <input type="password" class="form-control" name="adminpassword" id="adminpassword" autocomplete="off" placeholder="Admin Password" value="<?php echo ( $onboardError == 1  ) ? $_REQUEST['adminpassword'] : ''; ?>" required >
                    <label  for="agencysubdomain">Admin Password</label>
					<div class="invalid-feedback no-match-password">
                    	Please provide the Admin Passord.
                  	</div>
					<span class="toggle-icon" id="togglePassword1"><i class="bi bi-eye"></i></span>
                  </div>
                </div>
				<div class="col-md-4">
                  <div class="form-floating mt-3 password-container">
                    <input type="password" class="form-control" name="adminpassword2" id="adminpassword2" autocomplete="off" placeholder="Re-enter Admin Password" value="<?php echo ( $onboardError == 1  ) ? $_REQUEST['adminpassword'] : ''; ?>"  required >
                    <label  for="agencysubdomain">Re-enter Admin Password</label>
					<div class="invalid-feedback no-match-password">
                    	Please confirm the Admin Password.
                  	</div>
					<!-- Eye icon for toggling visibility -->
        			<span class="toggle-icon" id="togglePassword2"><i class="bi bi-eye"></i></span>
                  </div>
                </div>
				<!--div class="col-md-1"></div-->
			  </div>
			  
                <div class="text-center my-3 py-3">
				   <input type="hidden" name="step" value="2">
				   <input type="hidden" name="main_domain" id="main_domain" value="<?php echo $_ENV['MAIN_DOMAIN']; ?>">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Process Agency Onboarding</button><!--Configure Application</button-->
				   <button type="reset" class="btn btn-secondary mt-3 configbtn" name="btnreset">Start Onboarding Over</button>
                   <!--Reset</button-->
                </div>
              </form><!-- End floating Labels Form -->			
			<?php //} ?>
            </div>
          </div>

        </div>
      </div>
	  
	  
  <div id="spinnerWrapper">
    <div class="spinner"></div>
    <div id="statusText" style="margin-top: 15px; display:block; clear:both;"><h3>Provisioning your agency. Please wait...</h3></div>
  </div>

  <script>
  	function checkStatus() {
	  fetch('status.json')
		.then(response => response.json())
		.then(data => {
		  if (data.status === 'error') {
		  	const statusText = document.getElementById('statusText');

			statusText.innerHTML = 'An error occurred: ' + data.message + '<br><br>' +
    '<button type="button" onclick="window.location.href=\'https://<?php echo $_ENV['MAIN_DOMAIN']; ?>/onboardingAndStatus\'">Return to Onboarding</button>';
  			statusText.classList.add('error-text'); // <-- Add red color class
			statusText.style.color = '#ffffff';
			document.querySelector('.spinner').style.display = 'none';
			// Optionally show retry button or log
		  } else if (data.status === 'done') {
			window.location.href = 'success.php'; // Or go to a success page
			//const statusText = document.getElementById('statusText');
  			//statusText.textContent = 'Onboarding completed successfully...';
  			//statusText.classList.add('error-text'); // <-- Add red color class
			//document.querySelector('.spinner').style.display = 'none';
		  }
		})
		.catch(err => {
		  console.error('Error checking status:', err);
		});
	}

    document.getElementById('onboardingForm').addEventListener('submit', function(e) {
      e.preventDefault();

      const formData = new FormData(this);

      // Show spinner
      document.getElementById('spinnerWrapper').style.display = 'flex';

      // Submit to start_onboarding.php
      fetch('start_onboarding.php', {
        method: 'POST',
        body: formData
      }).then(res => res.text())
        .then(data => {
          //console.log('Started onboarding:', data);
          // Optionally poll or redirect
        }).catch(err => {
          alert("Failed to start onboarding");
          document.getElementById('spinnerWrapper').style.display = 'none';
        });
    });
	
	setInterval(checkStatus, 3000);
	
  </script>
  
    </section>

  </main><!-- End #main -->
 <?php 
	if ( $_SERVER['SERVER_NAME'] == $_ENV['MAIN_DOMAIN'] ) {
 		include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.rightbar.php' ); 
 	}
 ?>
 <?php include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.footer.php' ); ?>