<?php
	
	$doconfigredirect = 1;
	$requireSignOn = 'N';
	$includeFooter = false;
	$nosidebar = true;
	$onboardError = false;
	$fromConfigScreen = true;
	$protocol = isset($_SERVER['HTTPS']) ? 'https' : 'http';

	require_once __DIR__ . '/../assets/PHPDotEnv/vendor/autoload.php';
	
    $dotenv = Dotenv\Dotenv::createImmutable(__DIR__.'/../assets/PHPDotEnv', '.onboarding');
    $dotenv->load();
		
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.inc.php' );
	
	$PULL_CONFIG_DATA = false;
	unset($agency_info);
	
	$filebase = basename(dirname(__FILE__));
	
	if ( preg_match("/onboarding/i", $_SERVER['SCRIPT_NAME'] ) ) {
		$dest = "onboarding";
	}
	
	$step = 1;
	if ( isset($_REQUEST) && isset($_REQUEST['step']) ) {
		 $step = $_REQUEST['step'];
	}
	
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.header.php' );
?>

    <main id="main" class="main">

    <div class="pagetitle">
      <h1>Agency Onboarding </h1>
      <nav>
        <ol class="breadcrumb">
          <!--li class="breadcrumb-item"><a href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>">Home</a></li -->
          <li class="breadcrumb-item active">Onboard Agency</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
	
    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
				<h5 class="card-title">SPrimeCare Agency Onboarding</h5>
	
			<?php 
				if ( $step == 2 ) 
				{   
					$writeError = 0;
					include( $_SERVER['DOCUMENT_ROOT'] . '/onboarding/onboarding.php' );
					if ( $onboardError ) { 
						$step = 1;
					}
			?>
				
				<!--div class="row centerInDiv">
					<div id="progress-container">
						<div id="progress-bar">0%</div>
					</div>
				</div>
				
				<div class="row  centerInDiv">
					<div id="messages">
						<div id="message-div"></div>
					</div>
				</div-->
				
				
				<div class="row">
					<div class="col-md-2"></div>
					<div class="col-md-8 text-center">
					
						<?php if ( ! $onboardError ) { ?> 
						
						<div class="alert  <?php echo ( $onboardError ) ? "alert-danger" : "alert-success"; ?> text-center mb-1">
						<h4>
						<?php 
							echo $onboardingMessage;
						?>
						</h4>
						
						
						<table class="table table table-striped">
						  <thead>
							<tr>
							  <th scope="col"></th>
							  <th scope="col">Staging Database<br /><?php echo $_ENV['MAIN_SYSTEM_DB']; ?></th>
							  <th scope="col">Agency Database<br /><?php echo $DB_NAME; ?></th>
							</tr>
						  </thead>
						  <tbody>
							<tr>
							  <td>Number of Tables</td>
							  <td><?php echo count($staging_table_counts); ?></td>
							  <td><?php echo count($newdb_table_counts); ?></td>
							</tr>
							<tr>
							  <td>Number of Functions</td>
							  <td><?php echo $staging_function_count; ?></td>
							  <td><?php echo $newdb_function_count; ?></td>
							</tr>
							<tr>
							  <td>Number of Procedures</td>
							  <td><?php echo $staging_procedure_count; ?></td>
							  <td><?php echo $newdb_procedure_count; ?></td>
							</tr>
							<tr>
							  <td>Total Number of Data Rows</td>
							  <td><?php echo $staging_total_records; ?></td>
							  <td><?php echo $newdb_total_records; ?></td>
							</tr>
						  </tbody>
						</table>
						<?php } ?>
						
						</div>
						<?php if ( $onboardError ) { ?>
							<!-- Redirecting to Dashboard -->
							<div class="redirect-container mt-2">
							
								 <a class="btn btn-primary mt-3 configbtn" href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/onboarding">Return to Agency Onboarding</a>

							</div>
				  		<?php } else { ?>
							<a class="btn btn-primary mt-3 configbtn" href="<?php echo $protocol; ?>://<?php echo trim($_REQUEST['agencysubdomain']); ?>/">Continue to Agency Application</a>
						<?php }  ?>
					</div>
					<div class="col-md-2"></div>
				</div>
				//-->
			<?php 
				  } 
				  
				  if ( $step == 1 ) { 
			?>
              <!--h5 class="card-title">SPrimeCare Agency Onboarding</h5-->
			  <?php if ( isset($onboardingMessage) ) { ?> 
			  <div class="row mt-3">
					<div class="col-md-2"></div>
					<div class="col-md-8 text-center">
						<div class="alert  <?php echo ( $onboardError ) ? "alert-danger" : "alert-success"; ?> text-center mb-1">
						<h4>
						<?php 
							echo $onboardingMessage;
						?>
						</h4>
						</div>
					</div>
					<div class="col-md-2"></div>
				</div>
			  <?php } ?>
			  
			  <div class="row mt-5 mb-3">
				<div class="col-md-2"></div>
				<div class="col-md-8">
					<h5>Welcome to the SPrimeCare Agency Onboarding process.</h5>
					<h5>In this process, please provide your agency's full name and an agency short name will be recommended for you, but you also can enter an agency short name of your choice. Once this information is provided the SPrimeCare Application will be provisioned for your agency.</h5>
				</div>
				<div class="col-md-2"></div>
			</div>
              <!-- Floating Labels Form -->
              <form id="onboardingForm" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/onboarding/index.php" enctype="multipart/form-data" novalidate>
                				
			<div class="row">
				<div class="col-md-2"></div>
				<div class="col-md-6">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="agencyfname" id="agencyfname" placeholder="Agency Full Name: eg Computer ServicesCorporation, Inc." value="<?php echo ( $onboardError ) ? $_REQUEST['agencyfname'] : ''; ?>" required />
                    <label  for="agencyfname">Agency Full Name: eg Computer Services Corporation, Inc.</label>
					<div class="invalid-feedback">
                    	Please provide the Agency Full Name.
                  	</div>
                  </div>
                </div>
				<div class="col-md-3">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="agencyrecsname" id="agencyrecsname" autocomplete="off" placeholder="Recommended Short Name" value="<?php echo ( $onboardError ) ? $_REQUEST['agencysname'] : ''; ?>" >
                    <label  for="agencyrecsname">Recommended Short Name</label>
					<div class="invalid-feedback">
                    	Please provide the Recommended Short Name.
                  	</div>
                  </div>
                </div>
				<div class="col-md-1"></div>
			  </div>		

				<div class="row">
			  	<div class="col-md-2"></div>
				
				<div class="col-md-3">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="agencysname" id="agencysname" autocomplete="off" placeholder="Preferred Short Name" value="<?php echo ( $onboardError ) ? ( isset($_REQUEST['agencysname']) ? $_REQUEST['agencysname'] :'') : ''; ?>" required />
                    <label  for="agencysname">Preferred Short Name</label>
					<div class="invalid-feedback">
                    	Please provide the Preferred Short Name.
                  	</div>
                  </div>
                </div>
				<div class="col-md-3">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="agencysubdomain" id="agencysubdomain" autocomplete="off" placeholder="Assigned Subdomain" value="<?php echo ( $onboardError ) ? $_REQUEST['agencysubdomain'] : ''; ?>" readonly>
                    <label  for="agencysubdomain">Assigned Subdomain</label>
                  </div>
                </div>
				<div class="col-md-3">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="agencyadminemail" id="agencyadminemail" autocomplete="off" placeholder="Agency Admin Email" value="<?php echo ( $onboardError ) ? $_REQUEST['agencyadminemail'] : ''; ?>" required>
                    <label  for="agencyadminemail">Agency Admin Email</label>
					<div class="invalid-feedback">
                    	Please provide the Agency Admin Email.
                  	</div>
                  </div>
                </div>
				<div class="col-md-1"></div>
			  </div>
			  
			  <div class="row">
			  	<div class="col-md-2"></div>
				
				<div class="col-md-3">
                  <div class="form-floating mt-3">
                    <input type="text" class="form-control" name="username" id="adminusername" autocomplete="off" placeholder="Admin User Name" value="<?php echo ( $onboardError ) ? $_REQUEST['username'] : ''; ?>" required />
                    <label  for="agencysname">Admin User Name</label>
					<div class="invalid-feedback">
                    	Please provide the Admin User Name.
                  	</div>
                  </div>
                </div>
				<div class="col-md-3">
                  <div class="form-floating mt-3 password-container">
                    <input type="password" class="form-control" name="adminpassword" id="adminpassword" autocomplete="off" placeholder="Admin Password" value="<?php echo ( $onboardError ) ? $_REQUEST['adminpassword'] : ''; ?>" required >
                    <label  for="agencysubdomain">Admin Password</label>
					<div class="invalid-feedback no-match-password">
                    	Please provide the Admin Passord.
                  	</div>
					<span class="toggle-icon" id="togglePassword1"><i class="bi bi-eye"></i></span>
                  </div>
                </div>
				<div class="col-md-3">
                  <div class="form-floating mt-3 password-container">
                    <input type="password" class="form-control" name="adminpassword2" id="adminpassword2" autocomplete="off" placeholder="Re-enter Admin PAssword" value="<?php echo ( $onboardError ) ? $_REQUEST['adminpassword'] : ''; ?>"  required >
                    <label  for="agencysubdomain">Re-enter Admin Password</label>
					<div class="invalid-feedback no-match-password">
                    	Please confirm the Admin Password.
                  	</div>
					<!-- Eye icon for toggling visibility -->
        			<span class="toggle-icon" id="togglePassword2"><i class="bi bi-eye"></i></span>
                  </div>
                </div>
				<div class="col-md-1"></div>
			  </div>
			  
                <div class="text-center my-3 py-3">
				   <input type="hidden" name="step" value="2">
				   <input type="hidden" name="main_domain" id="main_domain" value="<?php echo $_ENV['MAIN_DOMAIN']; ?>">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Process Agency Onboarding</button><!--Configure Application</button-->
				   <button type="reset" class="btn btn-secondary mt-3 configbtn" name="btnreset">Start Onboarding Over</button>
                   <!--Reset</button-->
                </div>
              </form><!-- End floating Labels Form -->			
			<?php } ?>
            </div>
          </div>

        </div>
      </div>
	  <!-- The Modal -->
		<div id="myModal" class="modal">
			<br />
		  <span class="close">&times;</span>
		  <br />
		  <br />
		  <img class="modal-content" id="img01">
		</div>
    </section>

  </main><!-- End #main -->
  
 <?php include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.footer.php' ); ?>