<?php
	
	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		
	if (  $step == 3 ) {
	
		$rtn = putNewAllowance($_REQUEST);	
		$updtMessage = $rtn[1];
		if ( $rtn[0] == SUCCESS ) {
			$updtMessage = "The Weekly Spending  Money was recorded successfully.";
			$isFail = false;
		}
		else
			$isFail = true;
			
		$step = 1;
	}
	
	if ( $step == 1 ) { 

		$houses = getHousesListing( true );
?>
<form id="allowances" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/indv-services/index/dest/<?php echo $dest; ?>/step/2/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo  $RESIDENT_SERVICES_BREADCRUMB[$dest]; ?></h5>
			   <?php if ( isset($isFail) ) { ?>
			   		<div class="row mt-3 mb-3">
						<div class="col-md-1"></div>
						<div class="col-md-10 col-sm-offset-1 text-center">
							  <div class="alert  <?php echo ( $isFail === false ) ? "alert-success" : "alert-danger"; ?> text-center mb-1">
								<h4>
								<?php 
									echo $updtMessage;
								?>
								</h4>
								</div>
						</div>
						<div class="col-md-1"></div>
					</div>
			   <?php } ?>
              <!-- Floating Labels Form -->
			  
			  <div class="row">
			  		<div class="col-md-3"></div>
					<div class="col-md-4">
					  <div class="form-floating mt-3">
							<select class="form-select js-select" name="houseID" id="houseID" aria-label="House Being Recorded" required>
								  <option selected disabled value="">Choose House Being Recorded </option>
								  <?php for( $i = 0; $i < count($houses); $i++ ) { 
								  		if ( $houses[$i]['HouseID'] == MANAGEMENT ) { continue; }
								  ?>
								  <option value="<?php echo $houses[$i]['HouseID']; ?>"><?php echo $houses[$i]['HouseName']; ?></option>
								  <?php } ?>
							</select>
							<label  for="houseID">House Being Recorded</label>
							<div class="invalid-feedback">
								Please select House Being Recorded .
							</div>
					  	</div>
                	</div>
					<div class="col-md-2 position-relative">
						<div class="form-floating mt-3">
							<input type="number" class="form-control" id="maxWeekAmount" name="maxWeekAmount"  min="1" step="1" placeholder="Weekly Amount" required>
							<label  for="maxWeekAmount">Weekly Amount</label>
							<div class="invalid-feedback">
								Please enter weekly amount.
							</div>
						</div>
					</div>					
					<div class="col-md-3"></div>
			</div>
								
			<div class="text-center mt-5 mb-5">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Get <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?> List</button>
                </div>	
 			</div>
	   </div>
		
	</form>	
<?php }
	  else if ( $step == 2 ) { 

		$clients = getHouseClients($_REQUEST['houseID']);
?>
	<form id="allowances2" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/indv-services/index/dest/<?php echo $dest; ?>/step/3/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo  $RESIDENT_SERVICES_BREADCRUMB[$dest]; ?></h5>
			
			<div class="row">
			  		<div class="col-md-3"></div>
					<div class="col-md-6 mt-3 text-center"><h5 class="card-title">Maximum Weekly Amount is <span class="redtext fs-5"><strong>$<?php echo  $_REQUEST['maxWeekAmount']; ?></strong></span></h5><input type="hidden" name="allowanceDue" value="<?php echo  $_REQUEST['maxWeekAmount']; ?>" /></div>
					<div class="col-md-3"></div>
					
			</div>
			<?php for( $row = 0; $row < count($clients); $row++ ) { ?>
			
			<div class="row">
			  		<div class="col-md-1"></div>
					<div class="col-md-3">
					  <div class="form-floating mt-3">
							<select class="form-select staffselect" name="resident[]" id="resident<?php echo $row; ?>" aria-label="<?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?> Name" >
							  <option selected disabled value="">Choose a <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?></option>
							  <?php for( $j = 0; $j < count($clients); $j++ ) { ?>
							  	<option value="<?php echo $clients[$j]['ClientID']; ?>"><?php echo $clients[$j]['ClientFname'] . ' ' . $clients[$j]['ClientLname']; ?></option>
							  <?php } ?>
							</select>
							<label  for="staffID"><?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?> Name</label>
							<div class="invalid-feedback">
								Please select a <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?> Name.
							</div>
						</div>
                	</div>
					
					<div class="col-md-2">
					  <div class="form-floating mt-3 input-group" id='div_allowancedate<?php echo $row; ?>' data-td-target-input='nearest' data-td-target-toggle='nearest'>
						<input type="text" class="form-control" name="allowancedate[]" id="allowancedate<?php echo $row; ?>" placeholder="Amount Date"  data-td-target='#div_allowancedate<?php echo $row; ?>' readonly />
						<label   class="form-label" for="allowancedate<?php echo $row; ?>">Amount Date</label>
						<span class='input-group-text' data-td-target='#div_allowancedate<?php echo $row; ?>' data-td-toggle='datetimepicker'>
							 <span class='bi bi-calendar-date fs-4'></span>
						  </span>
						<div class="invalid-feedback">
							Please provide the amount date
						</div>
					  </div>
                	</div>
					
					<div class="col-md-2 position-relative">
						<div class="form-floating mt-3">
							<input type="number" class="form-control" id="todayAllowance<?php echo $row; ?>" name="todayAllowance[]"  min="1" max="<?php echo $_REQUEST['maxWeekAmount']; ?>" step="1" placeholder="Amount" >
							<label  for="todayAllowance<?php echo $row; ?>">Amount</label>
							<div class="invalid-feedback">
								Please enter amount.
							</div>
						</div>
					</div>
					
					<div class="col-md-4 position-relative">
						<div class="form-floating mt-3">
							<input type="text" class="form-control" id="comments<?php echo $row; ?>" name="comments[]"  placeholder="Amount" >
							<label  for="comments<?php echo $row; ?>">Comments</label>
							<div class="invalid-feedback">
								Please enter allowance comments.
							</div>
						</div>
					</div>
					
			</div>
			
			<?php } ?>
								
			<div class="text-center mt-5 mb-5">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Record Spending Money</button>
				   <button type="reset" class="btn btn-secondary mt-3 configbtn" >Start Over</button>
                </div>	
 			</div>
	   </div>
		
	</form>	

<?php
	}
?>