<?php 
	$doredirect = 0;
	$requireSignOn = 'Y';
	$includeFooter = true;
	$filebase = basename(dirname(__FILE__));
	$protocol = isset($_SERVER['HTTPS']) ? 'https' : 'http';
	
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.inc.php' );
	
	// 
	// Check if session is still valid
	//
	if ( $requireSignOn == 'Y' ) {
		if ( ! sessionIsValid( $_SESSION['sessID'], $IDLE_TIMEOUT ) ) {
			deleteSession($_SESSION['sessID']);
			
			$redirectURL =  (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
			
			saveRedirectURL( $_SESSION['sessID'], $redirectURL );
			$_SESSION['userIsLoggedIn'] = false;
			if ( isset($_SESSION['userRec']) ) 
			{
				$_SESSION['staffID'] = $_SESSION['userRec']['StaffID'];
				$_SESSION['user_houseID'] = $_SESSION['userRec']['HouseID'];
				$_SESSION['username'] = $_SESSION['userRec']['Username'];
				$_SESSION['user-finit-lname'] = ucfirst(substr(trim($_SESSION['userRec']['StaffFname']), 0, 1 )) . '. ' . ucfirst($_SESSION['userRec']['StaffLname']);
				$_SESSION['user-fullname'] = trim($_SESSION['userRec']['StaffFname']) . ' ' . ucfirst($_SESSION['userRec']['StaffLname']);
				$_SESSION['user-position'] = $_SESSION['userRec']['Position'];
				$_SESSION['user-type'] = $_SESSION['userRec']['StaffType'];
				$_SESSION['user-role'] = $_SESSION['userRec']['StaffRoleID'];
				$_SESSION['user-gender'] = $_SESSION['userRec']['StaffGender'];
				$_SESSION['user-housename'] = $_SESSION['userRec']['HouseName'];
				$_SESSION['user-isDriver'] = $_SESSION['userRec']['IsDriver'];
				$_SESSION['user-email'] = $_SESSION['userRec']['StaffEmail'];
			}
			$_SESSION['doRedirect'] = 1;
			$_SESSION['userIsAdmin'] = in_array( $_SESSION['user-role'], array(  ADMINISTRATOR, NURSE, DAY_PROGRAM_MANAGER, PERSONAL_SUPPORT_MANAGER,
																					 YOUTH_COORDINATOR, RESPITE_MANAGER, RESIDENTIAL_MANAGER, HOUSE_MANAGER,
																					 QUALITY_ASSURANCE, IT_STAFF ) );
																					 
			Header('Location: ' . $protocol . '://' . $_SERVER['SERVER_NAME'] . '/authaz/index/dest/signin/' );
			exit();
		}
		else {
			updateSession($_SESSION['sessID']);
		}
		
		//echo dpp($_SESSION);
	}
	
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.header.php' );
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.sidebar.php' );
	
	if ( file_exists( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/indv-reporting.db.php' ) ) {
	
		include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/indv-reporting.db.php' );
	}
	
	if ( $dest == ACTVHOUSE || $dest == DEACTVHOUSE ) {
	
		$isFail = false;
		if ( isset($staffID) ) { $houseID = $staffID; }
		
		if ( $dest == ACTVHOUSE ) {
			$houseRtn = activateHouse($houseID);
		}
		else {
			$houseRtn = deactivateHouse($houseID);
		}
		if ( $houseRtn[0] == SUCCESS ) { $isFail = false; } else { $isFail = true; }
		$step = 1;
		$dest = 'actdeacthouse';
		$updtMessage = $houseRtn[1];
	}
	
	if ( $dest == CPROBS ) {
	
		if ( isset($staffID) ) { $problemID = $staffID; }
		
		if ( $step == 2 ) {
			$isFail = false;
			$problemRtn = getCriticalProblemDetail($problemID);
			if ( $problemRtn[0] == SUCCESS ) { 
				$isFail = false; 
				$problenDetails = $problemRtn[1];
			} 
			else { 
				$isFail = true; 
				$step = 1;
				$dest = 'cprobs';
				$updtMessage = $problemRtn[1];
			}
		}
		else if ( $step == 3 ) {
			$problemRtn = resolveCriticalProblem($_REQUEST);
			if ( $problemRtn[0] == SUCCESS ) { $isFail = false; } else { $isFail = true; }
			$step = 1;
			$dest = 'cprobs';
			$updtMessage = $problemRtn[1];
		}
	}
	
?>

  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Resident Manangement - Daily Data Entry</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>">Home</a></li>
		  <?php if ( $dest == 'main' ) { ?>
          	<li class="breadcrumb-item active">Daily Data Entry</li>
		 <?php } else { ?>
		 	<li class="breadcrumb-item active"><a href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/indv-reporting/index/dest/main/">Daily Data Entry</a></li>
			<li class="breadcrumb-item active"><?php echo $INDV_REPORTING_BREADCRUMB[$dest]; ?></li>
		 <?php } ?>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section dashboard">
      <div class="row">
			<!-- ================================================================================== -->
			<?php 
					if ( file_exists( $_SERVER['DOCUMENT_ROOT'] . '/indv-reporting/' .  $dest . '.inc.php' ) ) {
						include( $_SERVER['DOCUMENT_ROOT'] . '/indv-reporting/' .  $dest . '.inc.php' );
					}
			?>
			<!-- ================================================================================== -->

      </div>
    </section>
	
	</main><!-- End #main -->
  
 <?php include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.footer.php' ); ?>