<?php
	
	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
	
	if ( $isFail != 1 ) { 
		$isFail = -1;
		
		$config = getHRCFromDB();	
		
		$updtMessage = $config[1];
		if ( $config[0] == SUCCESS ) {
	
			$hrcmembers = $config[1][0];
			
			if ( is_array($hrcmembers) && count($hrcmembers) <= 0 ) {
							
				$updtMessage = "Sorry, the system did not find any Human Right Committee members.";
				$isFail = 1;
				$step = 1;
			}
		}
		else {
			$isFail = 1;
			$step = 1;
		}
	}
	
	if ( $step == 2 )
	{
		$saveRtn = saveHRCMinutes( $_REQUEST );
		
		$updtMessage = $saveRtn[1];
		if ( $saveRtn[0] == SUCCESS ) {
			$updtMessage = "Human Rights Committee Minutes successfully saved.";
			$isFail = 0;
		}
		else {
			$isFail = 1;
		}
		$step = 1;
	}
		
	if ( $step == 1 ) { 
	
?>
<form id="hrcnotes" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/hrc-corner/index/dest/<?php echo $dest; ?>/step/2/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo  $HRC_CORNER_BREADCRUMB[$dest]; ?></h5>
			   <?php 
					if ( $isFail != -1 ) {
				?>
				<div class="row mt-3 mb-3">
				<div class="col-md-1"></div>
				<div class="col-md-10 col-sm-offset-1 text-center">
					  <p class="alert <?php if ( $isFail == 1 ) { ?> alert-danger <?php } else if ( $isFail == 0 ) { ?> alert-success <?php } ?>">
							<?php 
								echo $updtMessage; 
							?>
					  </p>
				</div>
				<div class="col-md-1"></div>
				</div>
				<?php } ?>
              <!-- Floating Labels Form -->
			  
			  <div class="row">
					<div class="col-md-4 position-relative">
					  <div class="form-floating mt-3">
							<select class="form-select js-select" name="minutestaker" id="minutestaker" aria-label="Minutes Taker" required>
								  <option selected disabled value="">Choose the Minutes Taker </option>
								  <?php for( $i = 0; $i < count($hrcmembers); $i++ ) { ?>
								  <option value="<?php echo $hrcmembers[$i]['Member']; ?>"><?php echo $hrcmembers[$i]['Member']; ?></option>
								  <?php } ?>
							</select>
							<label class="slct2" for="minutestaker">Minutes Taker</label>
							<div class="invalid-feedback">
								Please select a Minutes Taker.
							</div>
					  	</div>
                	</div>	
					<div class="col-md-4 position-relative">
					  <div class="form-floating mt-3 input-group" id='div_currentdate' data-td-target-input='nearest' data-td-target-toggle='nearest'>
						<input type="text" class="form-control" name="currentdate" id="currentdate" placeholder="Staff Hire Date"  data-td-target='#div_currentdate' required readonly />
						<label   class="form-label" for="currentdate">Current Meeting Date</label>
						<span class='input-group-text' data-td-target='#div_currentdate' data-td-toggle='datetimepicker'>
							 <span class='bi bi-calendar-date fs-3'></span>
						  </span>
						<div class="invalid-feedback">
							Please provide the Current Meeting Date.
						</div>
					  </div>
                	</div>
					<div class="col-md-4 position-relative">
					  <div class="form-floating mt-3 input-group" id='div_nextdate' data-td-target-input='nearest' data-td-target-toggle='nearest'>
						<input type="text" class="form-control" name="nextdate" id="nextdate" placeholder="Staff Hire Date"  data-td-target='#div_nextdate' readonly />
						<label   class="form-label" for="nextdate">Next Meeting Date</label>
						<span class='input-group-text' data-td-target='#div_nextdate' data-td-toggle='datetimepicker'>
							 <span class='bi bi-calendar-date fs-3'></span>
						  </span>
						<div class="invalid-feedback">
							Please provide the Next Meeting Date.
						</div>
					  </div>
                	</div>
			</div>
			
			<div class="row">
					<div class="col-md-4 mt-5">
						<h5>Meeting Attendance</h5>
                	</div>	
					<div class="col-md-4 position-relative">
                	</div>
					<div class="col-md-4 position-relative">
                	</div>
			</div>
			
			<?php
				
				
				for ( $i = 0; $i < count($hrcmembers); $i++ ) {
			?>
		    <div class="row align-items-center">
					<div class="col-md-3">
					  <div class="form-floating mt-3">
							<?php echo $hrcmembers[$i]['Member']; ?>
							<input type="hidden" name="director[]" class="director"  id="director-<?php echo $i; ?>" value ="<?php echo $hrcmembers[$i]['Member']; ?>" />
					  	</div>
                	</div>	
					<div class="col-md-3">
					  <div class="form-floating mt-3">
							<?php echo $hrcmembers[$i]['Title']; ?>
							<input type="hidden" name="position[]" value ="<?php echo $hrcmembers[$i]['Title']; ?>" />
					  	</div>
                	</div>	
					<div class="col-md-3">
					  <div class="form-floating mt-3">
							<select class="form-select js-select" name="attended[]" id="attended-<?php echo $i; ?>" aria-label="Attended Meeting" required>
								  <option selected disabled value="">Choose Attendance </option>
								  <option value="Y">Yes </option>
								  <option value="N">No </option>
							</select>
							<label  for="attended-<?php echo $i; ?>">Attended Meeting?</label>
							<div class="invalid-feedback">
								Please select attendance.
							</div>
					  	</div>
                	</div>
					<div class="col-md-3">
					  <div class="form-floating mt-3">
							<select class="form-select js-select" name="attendmethod[]" id="attendmethod-<?php echo $i; ?>" aria-label="Attendance Method" required>
								  <option selected disabled value="">Choose Method </option>
								  <option value="In Person">In Person </option>
								  <option value="Phone/Zoom">Phone/Zoom </option>
								  <option value="Absent">Absent </option>
							</select>
							<label  for="attendmethod-<?php echo $i; ?>">Attendance Method</label>
							<div class="invalid-feedback">
								Please select attendance method.
							</div>
					  	</div>
                	</div>	
			</div>
			
			<?php } ?>
			
			<div class="row">
					<div class="col-md-12">
					  <div class="form-floating mt-3">
							<textarea class="form-control tinymce-editor" name="meeting_notes" id="meeting_notes" aria-label="Meeting Minutes"  placeholder="Meeting Minutes" required>
								 
							</textarea>
							<label  for="attended-<?php echo $i; ?>">Meeting Minutes</label>
							<div class="invalid-feedback">
								Please provide Meeting Minutes.
							</div>
					  	</div>
                	</div>
			</div>
			
			<div class="row">
					<div class="col-md-12">
					  <div class="form-floating mt-3">
							<textarea class="form-control tinymce-editor" name="recommendation" id="recommendation" placeholder="Recommendations" aria-label="Recommendation" required>
								 
							</textarea>
							<label  for="attended-<?php echo $i; ?>">Recommendation</label>
							<div class="invalid-feedback">
								Please provide recommendations.
							</div>
					  	</div>
                	</div>
			</div>
							
			<div class="text-center mt-5 mb-5">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Post Committee Minutes</button>
                </div>	
 			</div>
	   </div>
		
	</form>	
<?php 
	}
	else if ( $step == 3 ) {
?>
	<div class="card">
		<div class="card-body">
		   <h5 class="card-title"><?php echo  $HRC_CORNER_BREADCRUMB[$dest]; ?></h5>
		<div class="row mt-3 mb-3">
		<div class="col-md-1"></div>
		<div class="col-md-10 col-sm-offset-1 text-center">
			  <p class="alert <?php if ( $isFail == 1 ) { ?> alert-danger <?php } else if ( $isFail == 0 ) { ?> alert-success <?php } ?>">
					<?php 
						echo $updtMessage; 
					?>
			  </p>
		</div>
		<div class="col-md-1"></div>
		</div>
	</div>
	</div>
<?php
	}
?>
		