#!/usr/bin/php -q
<?php

	$localRoot =  dirname(dirname(__FILE__));
	include( $localRoot . "/cronjobs/cron.inc.php" );

    // Set Default Timesone
	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
	
	$message = "";
	$sendMail = 0;
	
	$rtn = getCISHDocsDue();

	if ( $rtn[0] != SUCCESS )
	{
		// exit with a false
		echo "

			  Automated Job 'Corporate Document Due Notification' failed.

			  ";
		exit;
	}
	
	if ( $rtn[0] == SUCCESS && count( $rtn[1] ) > 0 )
	{	
		$myData = $rtn[1];
		$today = intval(date( "Ymd" ));
		$message = "";


		$message =  "<strong>Corporate Document Due Report</strong><br>
					 ========================
					 <br>
					 <br>
					 ";

		$message .= "<table width=\"600\" border=\"1\" cellspacing=\"0\" cellpadding=\"5\">
						<tr>
    						<td colspan='3'>Corporate Documents/Items to be Renewed Soon</td>
  						</tr>
						<tr>
    						<td width='300'>Document</td><td width='175'>Renewal Date</td><td width='125'>To be Renewed in</td>
  						</tr>
				 		";
		if ( count($myData) > 0 )
		{
			$sendMail = 1;
			for ( $i = 0; $i < count($myData); $i++ )
			{
				$message .= "
								<tr>
									<td>" .  $myData[$i][0] .  "</td><td>" .  $myData[$i][1] .  "</td><td>" .  $myData[$i][2] .  (( $myData[$i][2] > 1 ) ? " Days" : " Day" ) .  "</td>
								</tr>
							";				
			}
			$message .= "</table><br><br>";
		} 
		else
			$message = "";
	}
	
	
	$rtn = getExpiredCISHDocs();
	
	if ( $rtn[0] != SUCCESS )
	{
		// exit with a false
		echo "

			  Automated Job 'Corporate Document Due Notification' failed.

			  ";
		exit;
	}
		
	if ( $rtn[0] == SUCCESS && count( $rtn[1] ) > 0 )
	{

		$myData = $rtn[1];
		$today = intval(date( "Ymd" ));	
	
		$message .=  "<strong>Corporate Expired Document Report</strong><br>
					  ============================
					 <br>
					 <br>
					 ";
	
		$message .= "<table width=\"600\" border=\"1\" cellspacing=\"0\" cellpadding=\"5\">
						<tr>
							<td colspan='3'>Corporate Expired Documents/Items that need to be renewed</td>
						</tr>
						<tr>
							<td width='300'>Document</td><td width='175'>Renewal Date</td><td width='125'>Days Past Due</td>
						</tr>
						";
		if ( count($myData) > 0 )
		{
			$sendMail = 1;
			for ( $i = 0; $i < count($myData); $i++ )
			{
				$message .= "
								<tr>
									<td>" .  $myData[$i][0] .  "</td><td>" .  $myData[$i][1] .  "</td><td>" .  $myData[$i][2] .  "</td>
								</tr>
							";				
			}
			$message .= "</table>";
		}
	}
	
	if ( $sendMail == 1 ) {
	
		emailAdmins( $message, "DDN" );
		echo "
		
			  Automated Job 'Corporate Document Due Notification' completed successfully

			  ";
	}

?>
