#!/usr/bin/php -q
<?php

	$localRoot =  dirname(dirname(__FILE__));
	include( $localRoot . "/cronjobs/cron.inc.php" );
	
	// Set Default Timesone
	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
	
	$mth = date("n");
	$yr = date("Y");
	
	$yr = ( $mth == 12 ) ? ( $yr + 1 ) : $yr;
	$mth = ( $mth == 12 ) ? 1 : ( $mth + 1 );
	
	$clientData = array( 'programCd' => '', 'clientID' => '', 'monthYr' => $mth . '/' . $yr );
	$programCode = array( 'D', 'R' );

	$nurse = getNurseInfo();
	
	$errMsg = "MAR Initialization for " . date("F Y", strtotime('first day of +1 month')) . "
	           ===========================================<br /><br />";
	foreach( $programCode as $key => $code )
	{	
		$clients = ( $code == 'D' ) ? getDayInitClients() : getResidentialInitClients();
		
		$clientData['programCd'] = $code;
		
		list( $initMonth, $initYear ) = explode("/", $clientData['monthYr'] );
		if ( isset($clients) && ( count($clients) > 0 ) )
		{
			foreach( $clients as $k => $clientID )
			{
				$clientData['clientID'] = $clientID;
				
				$clientMedications = array();
				$medicationsList = getMARClientMedications( $clientData, TRUE );
				
				for ( $meds = 0; $meds < count($medicationsList); $meds++ )
				{
					$clientMedications = array_merge( $clientMedications, $medicationsList[$meds] );
				}													
				
				$initArray = array();
				$initArray['clientID'] = array();
				$initArray['medID'] = array();
				$initArray['seqID'] = array();
				$initArray['timekey'] = array();
				$initArray['month'] = array();
				$initArray['year'] = array();
				$initArray['medType'] = array();
				$initArray['programCd'] = array();
				$initArray['startDate'] = array();
				if ( count($clientMedications) > 0 )
				{
					for( $j = 0; $j < count($clientMedications); $j++ ) 
					{
						$initArray['clientID'][] = $clientData['clientID'];
						$initArray['medID'][] = $clientMedications[$j][0];
						$initArray['seqID'][] = $clientMedications[$j][3];
						$initArray['timekey'][] = $clientMedications[$j][6];
						$initArray['month'][] = $initMonth;
						$initArray['year'][] = $initYear;
						$initArray['medType'][] = $clientMedications[$j][9];
						$initArray['programCd'][] = $clientData['programCd'];
						$initArray['startDate'][] = $clientMedications[$j][8];
					}
					$initArray['reviewClientID'] = $clientData['clientID'];
					$initArray['reviewProgramCd'] = $clientData['programCd'];
					$initArray['reviewNurseID'] = $nurse[0];
					$initArray['reviewNurse'] = $nurse[1];
					$initArray['reviewInitial'] = $nurse[2];
					$initArray['reviewMonth'] = $initMonth;
					$initArray['reviewYear'] = $initYear;
					$initArray['marInitDate'] = date("m/d/Y");
					$initArray['resident'][] = getClientName( $clientData['clientID'] );
					$initArray['marClientID'] = $clientData['clientID'];
					$initArray['marProgramCd'] = $clientData['programCd'];
					$initArray['monthYr'] = $clientData['monthYr'];
					
					//echo dpp($initArray);
					
					$rtn = initializeMAR( $initArray );
					if ( $rtn[0] == SUCCESS )
					{
						$rtn = putNurseReview( $initArray, $nurse[0] );
						if ( $rtn[0] == SUCCESS )
						{
							$rtn = approveMAR( $initArray );
							if ( $rtn[0] == SUCCESS )
							{
								$errMsg .= "<span style='color: #008000; font-weight:bold'> MAR Initialization for " . $initArray['resident'][0] . ", Nurse initialization and MAR Approval initialization to N completed successfully.</span><br /><br />";
							}
							else
								$errMsg .= "<span style='color: #ff0000; font-weight:bold'> MAR Initialization for " . $initArray['resident'][0] . " and Nurse initialization succeeded but could not initalize MAR Approval to N. Notify IT support immediately.<br /></span><br />";
						}
						else
						{
							$errMsg .= "<span style='color: #ff0000; font-weight:bold'> MAR Initialization for " . $initArray['resident'][0] . " succeeded but Nurse initialization failed. Notify IT support immediately.</span><br /><br />";
						}
					}
					else
					{
						$errMsg .= "<span style='color: #ff0000; font-weight:bold'> MAR Initialization for " . $initArray['resident'][0] . " failed.<br />" .  $rtn[1] . "</span><br /><br />";
					}					
				}
			}
		}
	}
	
	$message = "<br><br>";					
					
	$message .= "<table width=\"700\" border=\"0\" cellpadding=\"5\">
					  ";

	$message .= "<tr>
				<td>" . $errMsg . "</td>
			  </tr>
			  ";
			
	$message .= "</table><br><br>";	

	emailAdmins( $message, "MARINIT" );
	echo "
	
		  Automated Job 'MAR Initialization' completed successfully\n

		  " . str_replace( array( "<br />", "<br>" ), array( "\n", "\n" ), $errMsg ); 
	
	
?>
