<?php

// Include the PhpSpreadsheet library
require $_SERVER['DOCUMENT_ROOT'] . '/assets/vendor/autoload.php'; // Assuming you've installed PhpSpreadsheet via Composer

use PhpOffice\PhpSpreadsheet\Reader\Xlsx;

// Connect to MySQL database
$mysqli = loginToDB();

// Check connection
if (mysqli_connect_errno()) {
    $clientsfileload .= "but DB Connection failed: " . mysqli_connect_error();
	$fileUploadError = 1;
	$configError = true;
}

if ( ! file_exists($_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/configurator/loadtables/Staff.xlsx') ) {
	$fileUploadError = 1;
	$configError = true;
	$Stafffileload .= " but there Staff data file was not found. <br>";
			
	// enable foreign key checks
	$query  = "SET foreign_key_checks = 1";
	$statement = mysqli_prepare($mysqli, $query);
	mysqli_stmt_execute($statement);
		
	if ( $mysqli ) {
		closeDB( $mysqli );
	}
	
}

if ( $fileUploadError == 0 ) {

	// Path to your Excel file
	$excelFile = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/configurator/loadtables/Staff.xlsx';
		
	// Load the Excel file
	$reader = new Xlsx();
	$spreadsheet = $reader->load($excelFile);
	
	if ( ! mysqli_begin_transaction( $mysqli, MYSQLI_TRANS_START_READ_WRITE ) ) {
			
		$Stafffileload .= " but there was an error loading Staff data to the database. Error Message: " . mysqli_error($mysqli) . "<br>";
		$fileUploadError = 1;
		$configError = true;
		closeDB( $mysqli );	
	}
	else {
		
		// Disable foreign key checks
		$query  = "SET foreign_key_checks = 0";
		$statement = mysqli_prepare($mysqli, $query);
		mysqli_stmt_execute($statement);
			
		// Get the number of sheets in the Excel file
		$sheetCount = $spreadsheet->getSheetCount();
	
		for ($i = 0; $i < $sheetCount; $i++) {
		
			// Get the active sheet
			//$sheet = $spreadsheet->getActiveSheet();
			
			// Get the sheet by index
			$sheet = $spreadsheet->getSheet($i);
			
			// Get Highest row
			$highestRow = $sheet->getHighestRow(); // e.g. 10
			
			// Get the sheet name
    		$sheetName = $sheet->getTitle();
	
			//
			// Initial load, so make sure table is empty
			//

			$query  = "DELETE FROM " . $sheetName;
			$statement = mysqli_prepare($mysqli, $query);
			mysqli_stmt_execute($statement);
			if ( mysqli_stmt_errno($statement) != 0 ) {
				mysqli_rollback($mysqli);
				$Stafffileload .= " but there was an error loading Staff data to the database. Error Message: " . mysqli_stmt_error($statement);
				// enable foreign key checks
				$query  = "SET foreign_key_checks = 1";
				$statement = mysqli_prepare($mysqli, $query);
				mysqli_stmt_execute($statement);
				closeDB( $mysqli );		
				$fileUploadError = 1;
				$configError = true;
				$i += $sheetCount;
			}
			mysqli_stmt_close($statement);
				
			// Iterate through each row of the sheet
			$autoID = 1;
			$uname = 1;
			
			for ($row = 2; $row <= $highestRow && !$configError; ++$row) {
				
				switch($sheetName)
				{
					case 'Staff':
						$StaffID = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
						if ( trim($StaffID) == '' ) { $StaffID = $autoID++; }
						 
						$SupervisorID = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();			
						$StaffFname = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
						$StaffMInit = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
						$StaffLname = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
						
						$StaffGender = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
						if ( trim($StaffGender) == '' ) { $StaffGender = 'M'; }
						
						$StaffType = $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();
						$StaffInitials = $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
						$StaffHireDate = $sheet->getCellByColumnAndRow(9, $row)->getCalculatedValue();
						if ( preg_match( '/0000-00-00/', $StaffHireDate )  || ( trim($StaffHireDate) == '' )  ) {
							$StaffHireDate = "NULL";
						}
						else {
							$unixTimeStamp = ($StaffHireDate - 25569) * 86400;
							$StaffHireDate = "" . date('Y-m-d', $unixTimeStamp) . "";
						}
						
			
						$PhoneNum = $sheet->getCellByColumnAndRow(10, $row)->getCalculatedValue();
									
						$PhoneGateway = $sheet->getCellByColumnAndRow(11, $row)->getCalculatedValue();
						$StaffEmail = $sheet->getCellByColumnAndRow(12, $row)->getCalculatedValue();
						$EmergencyContactName = $sheet->getCellByColumnAndRow(13, $row)->getCalculatedValue();
																				 
						$EmergencyContactPhone = $sheet->getCellByColumnAndRow(14, $row)->getCalculatedValue();
						$EmergencyContactEmail = $sheet->getCellByColumnAndRow(15, $row)->getCalculatedValue();
										
						$Status = $sheet->getCellByColumnAndRow(16, $row)->getCalculatedValue();
						$StatusDate = $sheet->getCellByColumnAndRow(17, $row)->getCalculatedValue();
						$unixTimeStamp = ($StatusDate - 25569) * 86400;
						$StatusDate = "" . date('Y-m-d', $unixTimeStamp) . "";
						
						$StatusReason = $sheet->getCellByColumnAndRow(18, $row)->getCalculatedValue();
						$StaffRootDir = $sheet->getCellByColumnAndRow(19, $row)->getCalculatedValue();
						$StaffImage = $sheet->getCellByColumnAndRow(20, $row)->getCalculatedValue();
						
						$query  = "INSERT INTO `Staff`(`StaffID`, `SupervisorID`, `StaffFname`, `StaffMInit`, `StaffLname`, `StaffGender`, ";
						$query .= " `StaffType`, `StaffInitials`, `StaffHireDate`, `PhoneNum`, `PhoneGateway`, `StaffEmail`, `EmergencyContactName`, ";
						$query .= " `EmergencyContactPhone`, `EmergencyContactEmail`, `Status`, `StatusDate`, `StatusReason`, `StaffRootDir`, `StaffImage`) ";
						$query .= " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
						break;
						
					case 'StaffAuthAz':
						$StaffID = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
						if ( trim($StaffID) == '' ) { $StaffID = $autoID++; }
						
						$FirtName = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
						$LastName = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
						
						$Username = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
						$StaffPassword = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
									
						if ( trim($Username) == '' ) {
							$Username = strtolower( substr($FirtName, 0, 1) . $LastName );
						}
						$query = "SELECT count(*) as cnt FROM `StaffAuthAz` WHERE `Username` = '" . trim($Username) . "'";
						$result = mysqli_query( $mysqli, $query  );		
							
						if ( mysqli_errno($mysqli) != 0 ) {
						
							mysqli_rollback($mysqli);
							$Stafffileload .= " but there was an error loading Staff data to the database. Error Message: " . mysqli_srror($mysqli) . "<br>";
							// enable foreign key checks
							$query  = "SET foreign_key_checks = 1";
							$statement = mysqli_prepare($mysqli, $query);
							mysqli_stmt_execute($statement);
							$fileUploadError = 1;
							$configError = true;
							if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
							closeDB( $dbHandle );					
							break;
						}
						$datarow = mysqli_fetch_assoc( $result );
						if ( $datarow['cnt'] > 0 ) {
							$Username .= $datarow['cnt'];
						}
						
						//if ( trim($StaffPassword) == '' ) {
						//	$StaffPassword = trim( $Username );
						//}
						$StaffPassword = password_hash( sql_quote( $mysqli, trim( $Username )), PASSWORD_DEFAULT );
								
						$StaffRoleID = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
						if ( trim($StaffRoleID) == '' ) { $StaffRoleID = AUXILLARY_STAFF; }
						
						$PswdReset = $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();
						$PswdReset = "N";
						
						$AdminByPass = $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
						
						$ByPassHouseID = $sheet->getCellByColumnAndRow(9, $row)->getCalculatedValue();
						$LastLoginDate = $sheet->getCellByColumnAndRow(10, $row)->getCalculatedValue();
						if ( preg_match( '/0000-00-00/', $LastLoginDate ) || ( trim($LastLoginDate) == '' ) ) {
							$LastLoginDate = "NULL";
						}
						else {
							$unixTimeStamp = ($LastLoginDate - 25569) * 86400;
							$LastLoginDate = "" . date('Y-m-d', $unixTimeStamp) . "";
						}
						
						$LastLoginTime = $sheet->getCellByColumnAndRow(11, $row)->getCalculatedValue();
						if ( preg_match( '/00:00:00/', $LastLoginTime ) || ( trim($LastLoginTime) == '' )  ) {
							$LastLoginTime = "NULL";
						}
						else {
							$unixTimeStamp = ($LastLoginTime - 25569) * 86400;
							$LastLoginTime = "" . date('H:i:s', $unixTimeStamp) . "";
						}
						
												
						$query  = "INSERT INTO `StaffAuthAz`(`StaffID`, `Username`, `StaffPassword`, `StaffRoleID`, `PswdReset`, ";
						$query  .= " `AdminByPass`, `ByPassHouseID`, `LastLoginDate`, `LastLoginTime`) ";
						$query .= " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ? )";
						break;
					
					case 'StaffIndicators':
						$StaffID = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
						if ( trim($StaffID) == '' ) { $StaffID = $autoID++; }
						
						$PositionID = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
						if ( trim($PositionID) == '' ) { $PositionID = POSITION_HOLDER; }
						
						$HouseID = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
						$IsConfirmed = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
						$isEmailVerified = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
										
						$IsDriver = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
						$IsQuarantined = $sheet->getCellByColumnAndRow(7, $row)->getCalculatedValue();
						$IsDayStaff = $sheet->getCellByColumnAndRow(8, $row)->getCalculatedValue();
						$IsPickDropStaff = $sheet->getCellByColumnAndRow(9, $row)->getCalculatedValue();
						
						$IsWeekendStaff = $sheet->getCellByColumnAndRow(10, $row)->getCalculatedValue();
						$CanAssignClientMeds = $sheet->getCellByColumnAndRow(11, $row)->getCalculatedValue();
						$UsesOwnCar = $sheet->getCellByColumnAndRow(12, $row)->getCalculatedValue();
						$CarIsInsured = $sheet->getCellByColumnAndRow(13, $row)->getCalculatedValue();
							
						$query  = "INSERT INTO `StaffIndicators`(`StaffID`, `PositionID`, `HouseID`, `IsConfirmed`, "; 
						$query  .= " `isEmailVerified`, `IsDriver`, `IsQuarantined`, `IsDayStaff`, `IsPickDropStaff`, ";
						$query  .= " `IsWeekendStaff`, `CanAssignClientMeds`, `UsesOwnCar`, `CarIsInsured`) ";
						$query .= " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
						break;
				}
				
				if ( $statement = mysqli_prepare($mysqli, $query) ) {
				
					switch($sheetName) 
					{
						case 'Staff':
							mysqli_stmt_bind_param($statement, 'iissssssssisssssssss', $StaffID, $SupervisorID, $StaffFname, $StaffMInit, $StaffLname, 
																 $StaffGender, $StaffType, $StaffInitials, $StaffHireDate, $PhoneNum, $PhoneGateway, 
																 $StaffEmail, $EmergencyContactName, $EmergencyContactPhone, $EmergencyContactEmail, 
																 $Status, $StatusDate, $StatusReason, $StaffRootDir, $StaffImage );
							break;
						
						case 'StaffAuthAz':
							mysqli_stmt_bind_param($statement, 'ississsss', $StaffID, $Username, $StaffPassword, $StaffRoleID, $PswdReset, 
																    $AdminByPass, $ByPassHouseID, $LastLoginDate, $LastLoginTime );
							break;
							
						case 'StaffIndicators':
							mysqli_stmt_bind_param($statement, 'iiissssssssss', $StaffID, $PositionID, $HouseID, $IsConfirmed, $isEmailVerified, 
																 $IsDriver, $IsQuarantined, $IsDayStaff, $IsPickDropStaff,  $IsWeekendStaff,
																 $CanAssignClientMeds, $UsesOwnCar, $CarIsInsured );
							break;
					}
					
					
					mysqli_stmt_execute($statement);
					if ( mysqli_stmt_errno($statement) != 0 ) {
						mysqli_rollback($mysqli);
						$Stafffileload .= " but there was an error loading Staff data to the database. Error Message: " . mysqli_stmt_error($statement) . "<br>";
						// enable foreign key checks
						$query  = "SET foreign_key_checks = 1";
						$statement = mysqli_prepare($mysqli, $query);
						mysqli_stmt_execute($statement);
						closeDB( $mysqli );		
						$fileUploadError = 1;
						$configError = true;
						$row += $highestRow;
					}
					mysqli_stmt_close($statement);
				}
				else {
					mysqli_rollback($mysqli);
					$Stafffileload .= " but there was an error loading Staff data to the database. Error Message: " . mysqli_stmt_error($statement) . "<br>";
					// enable foreign key checks
					$query  = "SET foreign_key_checks = 1";
					$statement = mysqli_prepare($mysqli, $query);
					mysqli_stmt_execute($statement);
					closeDB( $mysqli );		
					$fileUploadError = 1;
					$configError = true;
					$row += $highestRow;
				}
			}
		}
	}
	
	if ( $fileUploadError == 0 ) {
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($mysqli);
		
		// now get the highest Staff ID plus 1 from the staff table
		$query = "SELECT ifnull(max(`StaffID`), 1 ) + 1 as StaffID FROM `Staff`";
		$result = mysqli_query( $mysqli, $query  );	
		$staffRow = mysqli_fetch_assoc( $result );
		$staffID = $staffRow['StaffID'];

		// Update configue tables but make sure they exists
		$query = "SHOW TABLES LIKE 'Configure%'";
		$result = mysqli_query($mysqli, $query);

		// Check if any result is returned
		if (mysqli_num_rows($result) > 0) {
		
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
			// Make sure Configure ID not in Main Staff tables
			$query = "SELECT a.* FROM `StaffAuthAz` a, `ConfigureStaffAuthAz` b WHERE a.Username=b.Username";
			$result = mysqli_query( $mysqli, $query  );	
			if (mysqli_num_rows($result) > 0) {
				
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				
				// enable foreign key checks
				$query  = "SET foreign_key_checks = 1";
				$statement = mysqli_prepare($mysqli, $query);
				mysqli_stmt_execute($statement);
				
				closeDB( $mysqli );
				return array( SUCCESS, '' );
			}
				
			// update Staff ID on configure tables
			$query = "UPDATE `ConfigureStaff` SET `StaffID`=" . $staffID . "";
			$result = mysqli_query($mysqli, $query);
			
			$query = "UPDATE `ConfigureStaffAuthAz` SET `StaffID`=" . $staffID . "";
			$result = mysqli_query($mysqli, $query);
			
			$query = "UPDATE `ConfigureStaffIndicators` SET `StaffID`=" . $staffID . "";
			$result = mysqli_query($mysqli, $query);
			
			// Update done, so copy Configure tables to Staff
			$query = "insert into Staff select * from ConfigureStaff";
			$result = mysqli_query($mysqli, $query);
			
			$query = "insert into StaffAuthAz select * from ConfigureStaffAuthAz";
			$result = mysqli_query($mysqli, $query);
			
			$query = "insert into StaffIndicators select * from ConfigureStaffIndicators";
			$result = mysqli_query($mysqli, $query);
			
		}
				
		// enable foreign key checks
		$query  = "SET foreign_key_checks = 1";
		$statement = mysqli_prepare($mysqli, $query);
		mysqli_stmt_execute($statement);
		
		$Stafffileload .= " and Staff data was successfully loaded to the database. <br>";
		closeDB( $mysqli );
	}
}
?>

