<?php
session_start();
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Cache-Control: private");
header("Pragma: no-cache");
header("Access-Control-Allow-Origin: *");

$doconfigredirect = 1;
$requireSignOn = 'N';
$includeFooter = false;
$nosidebar = true;
$configError = false;
$fromConfigScreen = true;
$protocol = isset($_SERVER['HTTPS']) ? 'https' : 'http';

require_once __DIR__ . '/../assets/PHPDotEnv/vendor/autoload.php';

$dotenv = Dotenv\Dotenv::createImmutable(__DIR__.'/../assets/PHPDotEnv', '.' . $_SERVER['SERVER_NAME'] . '.env');
$dotenv->load();

include( $_SERVER['DOCUMENT_ROOT'] . '/assets/config/constants.inc.php' );
include( $_SERVER['DOCUMENT_ROOT'] . '/assets/functions/functions.inc.php' );
include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/db.inc.php' );
include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/general.db.php' );
include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/configurator.db.php' );
include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/authaz.db.php' );

$dest = 'configurator';
if (!isset($_SESSION['userIsLoggedIn']) || $_SESSION['userIsLoggedIn'] !== true) {
	// Redirect to login page
	$dest = 'signin';
}

if ( $dest === 'signin' ) {
	if ( isset($_REQUEST) && isset($_REQUEST['step']) && ( $_REQUEST['step'] == 2 ) ) {
		
		$isFail = '';
		$_REQUEST['configurator'] = 'Configure';
		
		$userRtn = userSignOn( $_REQUEST );		
				
		if ( !( ( $userRtn[0] == SUCCESS ) &&  ( isset($userRtn[1]['StaffPassword']) && ( $userRtn[1]['StaffPassword'] != '' ) ) && password_verify($_REQUEST['password'], $userRtn[1]['StaffPassword']) ) ) {
			$userRtn[0] = FAIL;
			$userRtn[1] = "Your Username and password combination does not match our records!";
		}
		else if ( $userRtn[0] == SUCCESS ) {
			$userRtn = userSignOnDetails( $_REQUEST );	
		}
				
		if ( $userRtn[0] == FAIL ) {
			$isFail = true;
			$step = 1;
			$errorMessage = $userRtn[1];
		}
		else {
			$_SESSION['userRec'] = $userRtn[1];
			
			if ( $userRtn[1]['isEmailVerified'] == 'N' ) {
				$step = 2;
				$isFail = true;
				$errorMessage = "Your email address has not been verified. Verify it now!";
				$dest = 'verifyemail';
			}
			else if ( $userRtn[1]['PswdReset'] == 'N' ) {
				$step = 1;
				$dest = 'passwdReset';
			}
			else {
				$_SESSION['sessID'] = str_rand(16);
				$_SESSION['userIsLoggedIn'] = true;
				
				if ( isset($_SESSION['userRec']) ) 
				{
					$_SESSION['userIsLoggedIn'] = true;
					$_SESSION['menus-allowed'] = menuAccessAllowed( isset($_SESSION['staffID']) ? $_SESSION['staffID'] : 0 );
					$_SESSION['staffID'] = $_SESSION['userRec']['StaffID'];
					$_SESSION['user_houseID'] = $_SESSION['userRec']['HouseID'];
					$_SESSION['username'] = $_SESSION['userRec']['Username'];
					$_SESSION['user-finit-lname'] = ucfirst(substr(trim($_SESSION['userRec']['StaffFname']), 0, 1 )) . '. ' . ucfirst($_SESSION['userRec']['StaffLname']);
					$_SESSION['user-fullname'] = trim($_SESSION['userRec']['StaffFname']) . ' ' . ucfirst($_SESSION['userRec']['StaffLname']);
					$_SESSION['user-position'] = $_SESSION['userRec']['Position'];
					$_SESSION['user-type'] = $_SESSION['userRec']['StaffType'];
					$_SESSION['user-role'] = $_SESSION['userRec']['StaffRoleID'];
					$_SESSION['user-gender'] = $_SESSION['userRec']['StaffGender'];
					$_SESSION['user-housename'] = $_SESSION['userRec']['HouseName'];
					$_SESSION['user-isDriver'] = $_SESSION['userRec']['IsDriver'];
					$_SESSION['user-email'] = $_SESSION['userRec']['StaffEmail'];
					
					if ( file_exists( $_SERVER['DOCUMENT_ROOT'] . '/assets/img/staff-imgs/' . $_SESSION['userRec']['Username'] . '.png') ) {
						$_SESSION['staff-image'] = '' . $_SESSION['userRec']['Username'] . '.png';
					}
					else if ( file_exists( $_SERVER['DOCUMENT_ROOT'] . '/assets/img/staff-imgs/' . $_SESSION['userRec']['Username'] . '.jpg') ) {
						$_SESSION['staff-image'] = '' . $_SESSION['userRec']['Username'] . '.jpg';
					}
					else if ( file_exists( $_SERVER['DOCUMENT_ROOT'] . '/assets/img/staff-imgs/' . $_SESSION['userRec']['Username'] . '.jpeg') ) {
						$_SESSION['staff-image'] = '' . $_SESSION['userRec']['Username'] . '.jpeg';
					}
					else {
						if ( $_SESSION['user-gender'] == MALE ) {
							$_SESSION['staff-image'] = 'male.png';
						}
						else {
							$_SESSION['staff-image'] = 'female.png';
						}
					}
				}
				
				$_SESSION['userIsAdmin'] = isset($_SESSION['user-role']) ? in_array( $_SESSION['user-role'], array(  ADMINISTRATOR, NURSE, DAY_PROGRAM_MANAGER, PERSONAL_SUPPORT_MANAGER, YOUTH_COORDINATOR, RESPITE_MANAGER, RESIDENTIAL_MANAGER, HOUSE_MANAGER, QUALITY_ASSURANCE, IT_STAFF ) ) : false;
																					 
				if ( isset($_SESSION['userRec']) ) { unset( $_SESSION['userRec'] );  }
				unset( $_SESSION['sessionExpired'] );
				
				//startSession( $_SESSION['sessID'], $_SESSION['staffID'] );
				updateStaffSignOnDateTime( $_SESSION['staffID'], date("Y-m-d"), date("H:i:s") );
				
				$dest = 'configurator';
				$_REQUEST['step'] = 1;
				
			}
		}
	}
}

$PULL_CONFIG_DATA = false;

if ( $dest == 'configurator' ) { 
	$getConfig = getConfigFromDB();
	if ( $getConfig[0] == SUCCESS ) {
		$PULL_CONFIG_DATA = true;
		include( $_SERVER['DOCUMENT_ROOT'] . '/assets/config/generateConfig.inc.php' );
	}
	else {
		unset($PULL_CONFIG_DATA);
	}
	
	$filebase = basename(dirname(__FILE__));
		
	$step = 1;
	if ( isset($_REQUEST) && isset($_REQUEST['step']) ) {
		 $step = $_REQUEST['step'];
	}
	
	$writeError = 0;
	if ( $step == 1 ) {
		// Get States
		list( $stateCode, $states )  = getStates();
		if ( $stateCode == FAIL ) {
			$step = 2;
			$writeError = 1;
			$configError = true;
			$configureMessage = "The system is unabled to retrieve a listing of the US States.";
		}
		
		list( $timeCode, $timezones )  = getTimezones();
		if ( $timeCode == FAIL ) {
			$step = 2;
			$writeError = 1;
			$configError = true;
			$configureMessage = "The system is unabled to retrieve a listing of the required US Timezones.";
		}
	}
	else if ( $step == 2 ) {
	
		$pgmRtn = writeProgramsToDB( $_REQUEST['services-provided'] );
		$corpRtn = writeCorpInfoToDB( $_REQUEST );
		$stateID = getStateID( trim( $_REQUEST['officestate'] ) );
		if ( ( $pgmRtn[0] == FAIL ) || ( $corpRtn[0] == FAIL ) ) {
			$writeError = 1;
			$configError = true;
			$configureMessage = $pgmRtn[1] . ' ' . $corpRtn[1];
		}
		else {
			if ( isset( $_SESSION['staffID'] ) ) {
				saveRedirectURL( $_SESSION['staffID'], (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['SERVER_NAME'] . "/" );
			}
			include( $_SERVER['DOCUMENT_ROOT'] . '/configurator/configureApp.php' );
		}
	}
}
include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.header.php' );
?>

<main id="main" class="main">

<div class="pagetitle">
  <h1>Application Configuration</h1>
  <nav>
	<ol class="breadcrumb">
	  <li class="breadcrumb-item"><a href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>">Home</a></li>
	  <li class="breadcrumb-item active">Install</li>
	</ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
	<div class="col-lg-12">

	  <div class="card">
		<div class="card-body">

<?php $isFail = ''; 
      if (  $dest == 'signin' ) { ?>

		<div class="row justify-content-center">
		<div class="col-lg-6 col-md-8 d-flex flex-column align-items-center justify-content-center">
	
		  <div class="d-flex justify-content-center py-2">
			<a href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>" class="logo d-flex align-items-center w-auto">
			  <!--img src="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/assets/img/logo.png" alt=""-->
			  <span class="d-none d-lg-block"><?php echo isset($agency_info['agency_fullname']) ? $agency_info['agency_fullname'] : $_ENV['AGENCY_NAME']; ?></span>
			</a>
	
		  </div><!-- End Logo -->
		<?php if ( $isFail != '' ) { ?>
			<div class="row mb-2">
			
			<div class="col-md-12 text-center">
				<div class="alert  <?php echo ( $isFail === false ) ? "alert-success" : "alert-danger"; ?> text-center mb-1">
				<h4>
				<?php 
					echo $errorMessage;
				?>
				</h4>
				</div>
			</div>
		</div>
		<?php } ?>
		  <div class="card mb-3">
	
			<div class="card-body">
	
			  <div class="pt-4 pb-2">
			  <?php 
			  if ( isset($_SESSION['sessionExpired']) && $_SESSION['sessionExpired'] == 1 ) { ?>
			  	<h3 class="card-title text-center pb-0 fs-4 text-danger">Your Previous Session has Expired<br/>Re-sign Into Your Account</h3>
			  <?php } else { ?>
				<h3 class="card-title text-center pb-0 fs-4">Sign Into Your Account</h3>
			  <?php } ?>
				<p class="text-center fs-5">Enter your username & password to Sign In</p>
			  </div>
	
			  <form id="signinform" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/configurator/" novalidate>
	
				<div class="col-12">
				  <label  for="yourUsername" class="form-label">Username</label>
				  <div class="input-group has-validation">
					<span class="input-group-text prependpad" id="inputGroupPrepend"><i class="bi bi-person-fill fs-3"></i></span>
					<input type="text" name="username" class="form-control" id="yourUsername" value="<?php echo isset($currentUser) ? $currentUser : ''; ?>" required>
					<div class="invalid-feedback">Please enter your username.</div>
				  </div>
				</div>
	
				<div class="col-12">
				  <label  for="yourPassword" class="form-label">Password &nbsp; </label> 
				  
				  <div class="input-group has-validation">
					<span class="input-group-text prependpad" id="inputGroupPrepend2"><i class="bi bi-lock-fill fs-3"></i></span>
					<input type="password" name="password" class="form-control" id="yourPassword" >
					<div class="invalid-feedback">Please enter your password!</div>
					<span class="toggle-icon" id="togglePassword1"><i class="bi bi-eye"></i></span>
				  </div>
				  
				  <div id="blankpswd" class"alert-danger" style="display:none"><strong>Your password is blank or all spaces!</strong></div>
				</div>
	
				<div class="col-12">
					<input type="hidden" name="step" value="2" />
				  <button class="btn btn-primary mt-3 w-100" type="submit">Sign In</button>
				</div>

			  </form>
	
			</div>
		  </div>
	
		</div>
	  </div>
		
<?php } else if (  $dest == 'configurator' ) { ?>

		<?php if ( $step == 2 ) { ?>
			<h5 class="card-title">SPrimeCare Agency Configuration</h5>
			<div class="row">
				<div class="col-md-2"></div>
				<div class="col-md-8 text-center">
					<div class="alert  <?php echo ( $writeError == 0 ) ? "alert-success" : "alert-danger"; ?> text-center mb-1">
					<h4>
					<?php 
						echo $configureMessage;
						
						if ( $fileUploadError == 1 ) {
							//exit;
						}
					?>
					</h4>
					</div>
					<?php if ( $configError ) { ?>
						<!-- Redirecting to Dashboard-->
						<div class="redirect-container mt-2">
						
							 <a class="btn btn-primary mt-3 configbtn" href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/configurator">Return to Application Configurator</a>

						</div>
					<?php } else {  
							unset( $_SESSION );
							session_destroy(); 
					?>
						<a class="btn btn-primary mt-3 configbtn" href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/">Continue to Main Application</a>
					<?php }  ?>
				</div>
				<div class="col-md-2"></div>
			</div>
		<?php } else if ( $step == 1 ) { ?>
		  <h5 class="card-title">PrimeCare Agency Configuration</h5>

		  <!-- Floating Labels Form -->
		  <form id="configurator" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/configurator/index.php" enctype="multipart/form-data" novalidate>
							
			
			<div class="col-md-6">
			  <div class="form-floating mt-3">
			  
				<input type="hidden" name="configID" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $getConfig[1][0][0]['ConfigID'] : 0 ); ?>" />
				<input type="hidden" name="agencyID" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $getConfig[1][0][0]['AgencyID'] : 0 ); ?>" />
				<input type="hidden" name="servicesID" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $getConfig[1][0][0]['ServicesID'] : 0 ); ?>" />
				<input type="hidden" name="managerID" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $getConfig[1][0][0]['ManagerID'] : 0 ); ?>" />
				<input type="hidden" name="bodID" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $getConfig[1][0][0]['BodID'] : 0 ); ?>" />
				
				<input type="text" class="form-control" name="agencyfname" id="agencyfname" placeholder="Agency Full Name" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['agency_fullname'] : $_ENV['AGENCY_NAME'] ); ?>" required />
				<label  for="agencyfname">Agency Full Name</label>
				<div class="invalid-feedback">
					Please provide the Agency Full Name.
				</div>
			  </div>
			</div>
			<div class="col-md-2">
			  <div class="form-floating mt-3">
				<input type="text" class="form-control" name="agencysname" id="agencysname" placeholder="Agency Short Name" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['agency_shortname'] : $_ENV['AGENCY_SHORT_NAME'] ); ?>" required>
				<label  for="agencysname">Agency Short Name</label>
				<div class="invalid-feedback">
					Please provide the Agency Short Name.
				</div>
			  </div>
			</div>
			
			<div class="col-md-2">
			  <div class="form-floating mt-3">
				<input type="text" class="form-control" name="nprnumber" id="nprnumber" placeholder="Medicaid/NPR Number" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['npr_number'] : '' ); ?>" >
				<label  for="nprnumber">Medicaid/NPR Number</label>
				<div class="invalid-feedback">
					Please provide your Medicaid/NPR Number.
				</div>
			  </div>
			</div>
			<div class="col-md-2">
			  <div class="form-floating mt-3">
				<input type="text" class="form-control" name="licensenumber" id="licensenumber" placeholder="DDA License Number" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['license_number'] : '' ); ?>" >
				<label  for="licensenumber">DDA License Number</label>
				<div class="invalid-feedback">
					Please provide a DDA License Number.
				</div>
			  </div>
			</div>
			
			<div class="col-md-9">
			  <div class="form-floating mt-3">
				<input type="text" class="form-control" name="officeaddress" id="officeaddress" placeholder="Agency Address" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['office_address'] : '' ); ?>" required>
				<label  for="officeaddress">Agency Address</label>
				<div class="invalid-feedback">
					Please provide the Agency Address.
				</div>
			  </div>
			</div>
			
			<div class="col-md-3">
			  <div class="form-floating mt-3">
				<input type="file" accept="image/*" class="form-control" name="agencylogo" id="agencylogo" placeholder="Agency Logo">
				<label  for="agencylogo">Agency Logo</label>
			  </div>
			</div>
			
			<div class="col-md-4">
			  <div class="col-md-12">
				<div class="form-floating mt-3 mb-3">
				  <input type="text" class="form-control" name="officecity" id="officecity" placeholder="Agency City" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['office_city'] : '' ); ?>" required>
				  <label  for="officecity">Agency City</label>
				  <div class="invalid-feedback">
					Please provide the Agency City.
				</div>
				</div>
			  </div>
			</div>
			<div class="col-md-3">
			  <div class="form-floating mt-3 mb-3">
				<select class="form-select js-select" name="officestate" id="officestate" aria-label="Agency State" required >
					  <option selected disabled value="">Choose a State</option>
					  <?php for ( $i = 0; $i < count($states); $i++ ) { 
								list( $state, $zipcode ) = explode( " ", $agency_info['office_statezip'] );
								$selected = ( $states[$i]['StateAbbrev'] == $state ) ? " selected " : '';
					  ?>
						<option value="<?php echo $states[$i]['StateAbbrev']; ?>" <?php echo $selected; ?>><?php echo $states[$i]['StateName']; ?></option>
					 <?php } ?>
				</select>
				<label  for="officestate">Agency State</label>
				<div class="invalid-feedback">
					Please provide the Agency State.
				</div>
			  </div>
			</div>
			<div class="col-md-3">
			  <div class="form-floating mt-3 mb-3">
				<select class="form-select js-select" name="officeregion" id="officeregion" aria-label="Agency Region" required>
					  <option selected disabled value="">Choose a Region</option>						  
				</select>
				<label  for="officestate">Agency Region</label>
				<div class="invalid-feedback">
					Please select the Agency Region.
				</div>
			  </div>
			</div>
			<div class="col-md-2">
			  <div class="form-floating mt-3 mb-3">
				<input type="text" class="form-control" name="officezip" id="officezip" placeholder="Agency Zip Code" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $zipcode : '' ); ?>" required>
				<label  for="officezip">Agency Zip Code</label>
				<div class="invalid-feedback">
					Please provide Zip Code.
				</div>
			  </div>
			</div>
			 <div class="col-md-3 mt-0 pt-0">
			  <div class="form-floating mt-3">
				<span class="align-middle">Agency Office Hours<br/><span class="Mon-Fri mt-1">( Monday - Friday )</span></span>
			  </div>
			</div>
			<div class="col-md-3 mt-0 pt-0">
			  <div id="div_office_hours_start" class="form-floating mt-3 input-group"  data-td-target-input="nearest" data-td-target-toggle="nearest">
				<input type="text" class="form-control clock-field d-md-inline-block" name="office_hours_start" id="office_hours_start" data-td-target="#div_office_hours_start" placeholder="Agency Opens At" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['office_hours_start'] : '' ); ?>" readonly required />
				
				<label class="form-label" for="office_hours_start">Agency Opens At</label>
				   <span class='input-group-text' data-td-target='#div_office_hours_start' data-td-toggle='datetimepicker' >
						<span class='bi bi-clock fs-4'></span>
				 </span>
				<div class="invalid-feedback">
					The Agency Opens at?
				</div>
			  </div>
			  
			</div>
			<div class="col-md-3 mt-0 pt-0">
			  <div id="div_office_hours_end" class="form-floating mt-3 input-group"  data-td-target-input="nearest" data-td-target-toggle="nearest">
				<input type="text" class="form-control clock-field d-md-inline-block" name="office_hours_end" id="office_hours_end" data-td-target="#div_office_hours_end" placeholder="Agency Closes At" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['office_hours_end'] : '' ); ?>" readonly required />

				<label class="form-label" for="office_hours_end">Agency Closes At</label>
				<span class='input-group-text' data-td-target='#div_office_hours_end' data-td-toggle='datetimepicker' >
						 <span class='bi bi-clock fs-4'></span>
				</span>
				<div class="invalid-feedback">
					The Agency Closes at?
				</div>
			  </div>
			</div>
			
			 <div class="col-md-3 mt-0 pt-0">
			  <div class="form-floating mt-3">
				<select class="form-select js-select" name="time_zone" id="time_zone" aria-label="Agency Time Zone" required>
				  <option selected disabled value="">Choose a Time Zone</option>
				  <?php for ( $i = 0; $i < count($timezones); $i++ ) { ?>
						<option value="<?php echo $timezones[$i]['TimeZoneID']; ?>"><?php echo $timezones[$i]['TimeZone']; ?></option>
				   <?php } ?>
				</select>
				<label  for="time_zone">Agency Time Zone</label>
				<div class="invalid-feedback">
					The Agency TimeZone is?
				</div>
			  </div>
			</div>
			 
			 <div class="col-md-4">
			  <div class="form-floating mt-3">
				<input type="tel" class="form-control" name="agencyphone" id="agencyphone" placeholder="Agency Phone" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['telephone'] : '' ); ?>" required>
				<label  for="agencyphone">Agency Phone</label>
				<div class="invalid-feedback">
					Please provide the Agency Phone.
				</div>
			  </div>
			</div>
			
			<div class="col-md-4">
			  <div class="form-floating mt-3">
				<input type="tel" class="form-control" name="agencyfax" id="agencyfax" placeholder="Agency Fax" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['fax'] : '' ); ?>" >
				<label  for="agencyfax">Agency Fax</label>
			  </div>
			</div>
			
			<div class="col-md-4">
			  <div class="form-floating mt-3">
				<input type="email" class="form-control" name="agencyemail" id="agencyemail" placeholder="Agency Email" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['email'] : '' ); ?>" required>
				<label  for="agencyemail">Agency Email</label>
				<div class="invalid-feedback">
					Please provide the Agency Email.
				</div>
			  </div>
			</div>
			
			<div class="col-md-4">
			  <div class="form-floating mt-3">
				<input type="tel" class="form-control" name="altagencyphone" id="altagencyphone" placeholder="Alternate Agency Phone" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['alt_telephone'] : '' ); ?>" >
				<label  for="altagencyphone">Alternate Agency Phone</label>
			  </div>
			</div>
			
			<div class="col-md-4">
			  <div class="form-floating mt-3">
				<input type="tel" class="form-control" name="altagencyfax" id="altagencyfax" placeholder="Alternate Agency Fax" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['alt_fax'] : '' ); ?>" >
				<label  for="altagencyfax">Alternate Agency Fax</label>
			  </div>
			</div>
			
			<div class="col-md-4">
			  <div class="form-floating mt-3">
				<input type="email" class="form-control" name="altagencyemail" id="altagencyemail" placeholder="Alternate Agency Email" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['alt_email'] : '' ); ?>"  />
				<label  for="altagencyemail">Alternate Agency Email</label>
			  </div>
			</div>
			
			<div class="col-md-12">
			  <div class="form-check">
				  <input class="form-check-input" type="checkbox" id="mailCheck1" value="0">
				  <input type="hidden" name="mailchecked" id="mailchecked" value="0" />
				  <label class="form-check-label" for="mailCheck1">
					Mailing Address is the same as the Agency Address
				  </label>
			  </div>
			</div>
			
			<div class="col-md-12">
			  <div class="form-floating mt-3">
				<input type="text" class="form-control" name="mailingaddress" id="mailingaddress" placeholder="Mailing Address" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['mailing_address'] : '' ); ?>" required>
				<label  for="mailingaddress">Mailing Address</label>
				<div class="invalid-feedback">
					Please provide Mailing Address.
				</div>
			  </div>
			</div>
			
			
			<div class="col-md-6">
			  <div class="col-md-12">
				<div class="form-floating mt-3">
				  <input type="text" class="form-control" name="mailingcity" id="mailingcity" placeholder="Mailing Address City" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $agency_info['mailing_city'] : '' ); ?>" required>
				  <label  for="mailingcity">Mailing Address City</label>
				  <div class="invalid-feedback">
					Please provide Mailing Address City.
				  </div>
				</div>
			  </div>
			</div>
			<div class="col-md-3">
			  <div class="form-floating mt-3 mb-3">
				<select class="form-select js-select" name="mailingstate" id="mailingstate" aria-label="Mailing Address State" required>
					  <option selected value="">Choose a State</option>
					  <?php for ( $i = 0; $i < count($states); $i++ ) { 
								list( $altstate, $altzipcode ) = explode( " ", $agency_info['mailing_statezip'] );
								$altselected = ( $states[$i]['StateAbbrev'] == $altstate ) ? " selected " : '';
					  ?>
						<option value="<?php echo $states[$i]['StateAbbrev']; ?>" <?php echo $altselected; ?> ><?php echo $states[$i]['StateName']; ?></option>
					 <?php } ?>
				</select>
				<label  for="mailingstate">Mailing Address State</label>
				<div class="invalid-feedback">
					Please provide Mailing Address State.
				</div>
			  </div>
			</div>
			<div class="col-md-3">
			  <div class="form-floating mt-3">
				<input type="text" class="form-control" name="mailingzip" id="mailingzip" placeholder="Mailing Address Zip Code" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $altzipcode : '' ); ?>" required>
				<label  for="mailingzip">Mailing Address Zip Code</label>
				<div class="invalid-feedback">
					Please provide Mailing Address Zip Code.
				</div>
			  </div>
			</div>
			
			<div class="col-md-6">
				<div class="form-floating mt-2">
				<h5 class="card-title mb-1">Agency Vision Statement</h5>
					<textarea id="background" class="form-control" name="vision"  placeholder="Agency Vision Statement ( use tools at the top to format text. DO NOT PRESS <Enter> key unless you want to end a paragraph and begin another. )" required>
					<?php echo getVisionInfo(); ?>
					</textarea>
					<!--label  for="background">Agency Vision Statement</label-->
					  <div class="invalid-feedback">
						Please provide your agency's vision statement.
					  </div>
				</div>
			</div>
			
			<div class="col-md-6">
				<div class="form-floating mt-2">
				<h5 class="card-title mb-1">Agency Mission Statement</h5>
					<textarea id="mission" class="form-control" name="mission"  placeholder="Agency Mission Statement ( use tools at the top to format text. DO NOT PRESS <Enter> key unless you want to end a paragraph and begin another. )" required>

					<?php echo getMissionStaement(); ?>
					</textarea>
					<!--label  for="mission">Agency Mission Statement</label-->
					  <div class="invalid-feedback">
						Please provide your agency's mission ststement.
					  </div>
				</div>
			</div>
			
			<h5 class="card-title">SPrimeCare Application Configuration</h5>
			
			<div class="col-md-12">
				<div class="row d-flex align-items-center">
				  <div class="col-md-3">
						<label>Idle Timeout in minutes</label>
				  </div>
				  
				  <div class="col-md-2 text-start ps-0 pe-0">
					<div class="form-floating mt-3">
					  <input type="number" min="1" step="1" class="form-control" name="idletimeout" id="idletimeout" placeholder="Idle Timeout" value="<?php echo ( isset($PULL_CONFIG_DATA) ? $IDLE_TIMEOUT : '' ); ?>" required>
					  <label  for="idletimeout">Idle Timeout</label>
					  <div class="invalid-feedback">
						Please provide Idle Timeout.
					  </div>
					</div>
				  </div>
				  <div class="col-md-7">
					<span id="timeout-message">
							<strong>NOTE:</strong> This is how long ( in minutes ) the application can be idle before you must log in again..
					</span>
				  </div>
			  </div>
			</div>
			
			<div class="col-md-12">
				<div class="row">
				  <div class="col-md-3">
						<label>Will there be a management team listing?</label>
				  </div>
				  
				  <div class="col-md-2 text-start">
					<?php 
						$turnOn = array( 'toyes' => "", 'tono' => '' );
						if(  isset($SHOWMGMT) && $SHOWMGMT == 'Y' ) { $turnOn['toyes'] = " checked=\"checked\" "; } else { $turnOn['tono'] = " checked=\"checked\" "; } ?>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="mgmtlist" id="mgmtlistyes" value="Y" <?php echo $turnOn['toyes']; ?> />
						<label class="form-check-label" for="mgmtlistyes"> Yes</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="mgmtlist" id="mgmtlistno" value="N" <?php echo $turnOn['tono']; ?> />
						<label class="form-check-label" for="mgmtlistno"> No</label>
					</div>
				  </div>
			  </div>
			</div>
			
			<div id="mgmtteam" class="col-md-12" style="display:none;">
				<h5 class="card-title">Management Team</h5>
				<div class="row">
				  <div class="col-md-3">
						<label>Name</label>
				  </div>
				  <div class="col-md-2">
						<label>Sex</label>
				  </div>
				  <div class="col-md-3">
						<label>Title</label>
				  </div>
				  <div class="col-md-1  ps-0 pe-0 d-flex align-items-center justify-content-center">
						<label>Current Photo</label>
				  </div>
				  <div class="col-md-3">
						<label>New Photo</label>
				  </div>
				  <!--div class="col-md-1"></div-->
				</div>
				
				<?php
					$noMF = 0;
					if ( isset($MANAGEMENT_TEAM) && ( count($MANAGEMENT_TEAM) > 0 ) ) {
						$mrowcount = count($MANAGEMENT_TEAM);
					}
					else {
						$mrowcount = 3;
						$noMF = 1;
					}
					
					for ( $i = 1; $i <= $mrowcount; $i++ ) {
				?>
				<div class="row mgmtrow mb-2 d-flex align-items-center justify-content-center">
				  <div class="col-md-3">
					  <div class="form-non-floating">
						<input type="text" class="form-control mgmtclass" name="managername[]" id="managername<?php echo $i; ?>" value="<?php echo isset($MANAGEMENT_TEAM[$i-1]['officer']) && ucwords($MANAGEMENT_TEAM[$i-1]['officer']); ?>" placeholder="" >
						<label  for="managername<?php echo $i; ?>"></label>
						<input type="hidden" name="managerseqid[]" value="<?php echo isset($MANAGEMENT_TEAM[$i-1]['seqid']) ? $MANAGEMENT_TEAM[$i-1]['seqid'] : ''; ?>" />
					  </div>
				  </div>
				  <div class="col-md-2 text-start pt-1">
						<?php
							$turnOn = array( 'toyes' => "", 'tono' => '' );
							if(  isset($MANAGEMENT_TEAM[$i-1]['sex']) && $MANAGEMENT_TEAM[$i-1]['sex'] == 'M' ) { 
								$turnOn['toyes'] = " checked=\"checked\" "; 
							} 
							else { 
								if ( $noMF == 0 ) {
									$turnOn['tono'] = " checked=\"checked\" "; 
								}
							} 
						?>
						<div class="form-check form-check-inline">
							<input class="form-check-input" type="radio" name="managersex<?php echo $i; ?>" id="managersexm<?php echo $i; ?>" value="M" <?php echo $turnOn['toyes']; ?>>
							<label class="form-check-label" for="managersexm<?php echo $i; ?>"> Male</label>
						</div>
						<div class="form-check form-check-inline">
							<input class="form-check-input" type="radio" name="managersex<?php echo $i; ?>" id="managersexf<?php echo $i; ?>" value="F" <?php echo $turnOn['tono']; ?>>
							<label class="form-check-label" for="managersexf<?php echo $i; ?>"> Female</label>
						</div>
				  </div>
				  <div class="col-md-3">
					  <div class="form-non-floating">
						<input type="text" class="form-control" name="managertitle[]" id="managertitle<?php echo $i; ?>" value="<?php echo isset($MANAGEMENT_TEAM[$i-1]['title']) ? strtoupper($MANAGEMENT_TEAM[$i-1]['title']) : ''; ?>" placeholder="" >
						<label  for="managertitle<?php echo $i; ?>"></label>
					  </div>
				  </div>
				  <div class="col-md-1 d-flex align-items-center justify-content-center">
						<?php 
							$imageUrl = '';
							
							if ( isset($MANAGEMENT_TEAM[$i-1]['photofile'])  && trim($MANAGEMENT_TEAM[$i-1]['photofile']) != '' ) {
								$imageUrl = $protocol. "://" . $_SERVER['SERVER_NAME'] . "/assets/img/mgmt-imgs/" . $MANAGEMENT_TEAM[$i-1]['photofile']; 
							}
							if ( $imageUrl != '' ) {
						?>
							<img class="oldphoto" id="oldmgrphoto<?php echo $i; ?>" src="<?php echo $imageUrl; ?>" style="height: 50px; width:50px; margin-bottom: 5px;"  />
							<input type="hidden" name="mgroldphoto[]" id="mgroldphoto<?php echo $i; ?>" value="<?php echo strtoupper($MANAGEMENT_TEAM[$i-1]['photofile']); ?>" >
						<?php
							} else {
						?>
							None
							<input type="hidden" name="mgroldphoto[]" id="mgroldphoto<?php echo $i; ?>" value="" >
						<?php
							}
						?>
				  </div>
				  <div class="col-md-3">					  		
					  <div class="form-non-floating">
						<input type="file" accept="image/*" class="form-control" name="managerphoto[]" id="managerphoto<?php echo $i; ?>" value="<?php echo $localFilePath; ?>" placeholder="">
						<label  for="managerphoto<?php echo $i; ?>"></label>
					  </div>
				  </div>
				  <!--div class="col-md-1"></div-->
				</div>
			   <?php 
					}
				?>

				<div class="row">
				  <div class="col-md-4 align-self-center d-flex gap-2 mb-3">
						<button id="addManagement" type="button" class="btn btn-primary"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-plus-square-fill" viewBox="0 0 16 16">
<path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3a.5.5 0 0 1 1 0z"/></path>
</svg> Add Another Management Team Member</button>
				  </div>
				  <div class="col-md-8"></div>
				</div>					
			</div>
			
			<div class="col-md-12">
				<div class="row">
				  <div class="col-md-3">
						<label>Will there be a board of directors listing?</label>
				  </div>
				  
				  <div class="col-md-8 text-start">
					<?php
						$turnOn = array( 'toyes' => "", 'tono' => '' );
						if(  isset($SHOWBOD) && $SHOWBOD == 'Y' ) { $turnOn['toyes'] = " checked=\"checked\" "; } else { $turnOn['tono'] = " checked=\"checked\" "; } 
					?>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="bodlist" id="bodlistyes" value="Y" <?php echo $turnOn['toyes']; ?> >
						<label class="form-check-label" for="bodlistyes"> Yes</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="bodlist" id="bodlistno" value="N" <?php echo $turnOn['tono']; ?> >
						<label class="form-check-label" for="bodlistno"> No</label>
					</div>
				  </div>
			  </div>
			</div>

			<div id="bodteam" class="col-md-12" style="display:none;">
				<h5 class="card-title">Board of Directors</h5>
				<div class="row">
				  <div class="col-md-3">
						<label>Name</label>
				  </div>
				  <div class="col-md-2">
						<label>Sex</label>
				  </div>
				  <div class="col-md-3">
						<label>Title</label>
				  </div>
				  <div class="col-md-1 ps-0 pe-0 d-flex align-items-center justify-content-center">
						<label>Current Photo</label>
				  </div>
				  <div class="col-md-3">
						<label>New Photo</label>
				  </div>
				  <!--div class="col-md-1"></div-->
				</div>
				
				<?php
					$noMF = 0;
					if ( isset($BOARD_OF_DIRECTORS) && ( count($BOARD_OF_DIRECTORS) > 0 ) ) {
						$browcount = count($BOARD_OF_DIRECTORS);
					}
					else {
						$browcount = 3;
						$noMF = 1;
					}
					
					for ( $i = 1; $i <= $browcount; $i++ ) {
				?>
				<div class="row bodrow mb-2 d-flex align-items-center justify-content-center">
				  <div class="col-md-3">
					  <div class="form-non-floating">
						<input type="text" class="form-control bodclass" name="bodname[]" id="bodname<?php echo $i; ?>" placeholder="" value="<?php echo isset($BOARD_OF_DIRECTORS[$i-1]['director']) ? ucwords($BOARD_OF_DIRECTORS[$i-1]['director']) : ''; ?>" >
						<label  for="bodname<?php echo $i; ?>"></label>
						<input type="hidden" name="bodseqid[]" value="<?php echo $BOARD_OF_DIRECTORS[$i-1]['seqid']; ?>" />
					  </div>
				  </div>
				  <div class="col-md-2 text-start pt-1">
					<?php
						$turnOn = array( 'toyes' => "", 'tono' => '' );
						if(  isset($BOARD_OF_DIRECTORS[$i-1]['sex']) && $BOARD_OF_DIRECTORS[$i-1]['sex'] == 'M' ) { 
							$turnOn['toyes'] = " checked=\"checked\" "; 
						} 
						else { 
							if ( $noMF == 0 ) {
								$turnOn['tono'] = " checked=\"checked\" "; 
							}
						} 
					?>
						<div class="form-check form-check-inline">
							<input class="form-check-input" type="radio" name="bodsex<?php echo $i; ?>" id="bodsexm<?php echo $i; ?>" value="M" <?php echo $turnOn['toyes']; ?>>
							<label class="form-check-label" for="bodsexm<?php echo $i; ?>"> Male</label>
						</div>
						<div class="form-check form-check-inline">
							<input class="form-check-input" type="radio" name="bodsex<?php echo $i; ?>" id="bodsexf<?php echo $i; ?>" value="F" <?php echo $turnOn['tono']; ?>>
							<label class="form-check-label" for="bodsexf<?php echo $i; ?>"> Female</label>
						</div>
				  </div>
				  <div class="col-md-3">
					  <div class="form-non-floating">
						<input type="text" class="form-control" name="bodtitle[]" id="bodtitle<?php echo $i; ?>" placeholder="" value="<?php echo isset($BOARD_OF_DIRECTORS[$i-1]['title']) && strtoupper($BOARD_OF_DIRECTORS[$i-1]['title']); ?>" >
						<label  for="bodtitle<?php echo $i; ?>"></label>
					  </div>
				  </div>
				  <div class="col-md-1 d-flex align-items-center justify-content-center">
						<?php 
							$imageUrl = '';
							
							if ( isset($BOARD_OF_DIRECTORS[$i-1]['photofile'])  && trim($BOARD_OF_DIRECTORS[$i-1]['photofile']) != '' ) {
								$imageUrl = $protocol. "://" . $_SERVER['SERVER_NAME'] . "/assets/img/bod-imgs/" . $BOARD_OF_DIRECTORS[$i-1]['photofile']; 
							}
							if ( $imageUrl != '' ) {
						?>
						<img src="<?php echo $imageUrl; ?>" style="height: 50px; width:50px; margin-bottom: 5px;"  />
						<input class="oldphoto" id="oldbodphoto<?php echo $i; ?>" type="hidden" name="bodoldphoto[]" id="bodoldphoto<?php echo $i; ?>" value="<?php echo strtoupper($BOARD_OF_DIRECTORS[$i-1]['photofile']); ?>" >
						<?php
							} else {
						?>
							None
							<input type="hidden" name="bodoldphoto[]" id="bodoldphoto<?php echo $i; ?>" value="" >
						<?php
							}
						?>
				  </div>
				  <div class="col-md-3">
					  <div class="form-non-floating">
						<input type="file" accept="image/*" class="form-control" name="bodphoto[]" id="bodphoto<?php echo $i; ?>" value="<?php echo $localFilePath; ?>"  placeholder="">
						<label  for="bodphoto<?php echo $i; ?>"></label>
					  </div>
				  </div>
				  <!--div class="col-md-1"></div-->
				</div>
				<?php 
					}
				?>

				
				<div class="row">
				  <div class="col-md-4 align-self-center d-flex gap-2 mb-3">
						<button id="addDirector" type="button" class="btn btn-primary"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-plus-square-fill" viewBox="0 0 16 16">
<path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6.5 4.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3a.5.5 0 0 1 1 0z"/></path>
</svg> Add Another Director</button>
				  </div>
				  <div class="col-md-8"></div>
				</div>	
			</div>
			
			<!--
			
			<div class="col-md-12">
				<div class="row">
				  <div class="col-md-3">
						<label>Do you have any downloadable documents?</label>
				  </div>
				  
				  <div class="col-md-9 text-start">
					<?php
						$turnOn = array( 'toyes' => "", 'tono' => '' );
						if(  isset($ONLINEDOCS) && $ONLINEDOCS == 'Y' ) { $turnOn['toyes'] = " checked=\"checked\" "; } else { $turnOn['tono'] = " checked=\"checked\" "; } 
					?>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="onlinedocs" id="onlinedocsyes" value="Y" <?php echo $turnOn['toyes']; ?> >
						<label class="form-check-label" for="onlinedocsyes"> Yes</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="onlinedocs" id="onlinedocsno" value="N" <?php echo $turnOn['tono']; ?> >
						<label class="form-check-label" for="onlinedocsno"> No</label>
					</div>
				  </div>
			  </div>
			</div>
			
			<div class="col-md-12">
				<div class="row">
				  <div class="col-md-3">
						<label>Will you be uploading documents?</label>
				  </div>
				  
				  <div class="col-md-9 text-start">
					<?php
						$turnOn = array( 'toyes' => "", 'tono' => '' );
						if(  isset($FILEUPLOAD) && $FILEUPLOAD == 'Y' ) { $turnOn['toyes'] = " checked=\"checked\" "; } else { $turnOn['tono'] = " checked=\"checked\" "; } 
					?>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="fileupload" id="fileuploadyes" value="Y" <?php echo $turnOn['toyes']; ?> >
						<label class="form-check-label" for="fileuploadyes"> Yes</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="fileupload" id="fileuploadno" value="N"  <?php echo $turnOn['tono']; ?> >
						<label class="form-check-label" for="fileuploadno"> No</label>
					</div>
				  </div>
			  </div>
			</div>
			
			<div class="col-md-12">
				<div class="row">
				  <div class="col-md-3">
						<label>Will you be receiving job applications online?</label>
				  </div>
				  
				  <div class="col-md-9 text-start">
				  <?php
						$turnOn = array( 'toyes' => "", 'tono' => '' );
						if(  isset($EMPLOYMENT) && $EMPLOYMENT == 'Y' ) { $turnOn['toyes'] = " checked=\"checked\" "; } else { $turnOn['tono'] = " checked=\"checked\" "; } 
					?>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="employment" id="employmentyes" value="Y" <?php echo $turnOn['toyes']; ?> >
						<label class="form-check-label" for="employmentyes"> Yes</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="employment" id="employmentno" value="N" <?php echo $turnOn['tono']; ?> >
						<label class="form-check-label" for="employmentno"> No</label>
					</div>
				  </div>
			  </div>
			</div>
			
			-->
			
			<div class="col-md-12">
				<div class="row">
				  <div class="col-md-3">
						<label>Show office map on your contact page?</label>
				  </div>
				  
				  <div class="col-md-9 text-start">
				  <?php
						$turnOn = array( 'toyes' => "", 'tono' => '' );
						if(  isset($SHOWMAP) && $SHOWMAP == 'Y' ) { $turnOn['toyes'] = " checked=\"checked\" "; } else { $turnOn['tono'] = " checked=\"checked\" "; } 
					?>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="contactmap" id="contactmapyes" value="Y" <?php echo $turnOn['toyes']; ?> >
						<label class="form-check-label" for="contactmapyes"> Yes</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="contactmap" id="contactmapno" value="N" <?php echo $turnOn['tono']; ?> >
						<label class="form-check-label" for="contactmapno"> No</label>
					</div>
					<span id="map-message">
							<strong>NOTE:</strong> A $0.005 fee is charged for any map displayed using Map API.
					</span>
				  </div>
			  </div>
			</div>
			
			<div class="col-md-12">
				<div class="row">
				  <div class="col-md-3">
						<label>Allow Staff to Chart past days/months?</label>
				  </div>
				  
				  <div class="col-md-9 text-start">
				  <?php
						$turnOn = array( 'toyes' => "", 'tono' => '' );
						if(  isset($CHART_BACK) && $CHART_BACK == 'Y' ) { $turnOn['toyes'] = " checked=\"checked\" "; } else { $turnOn['tono'] = " checked=\"checked\" "; } 
					?>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="chartback" id="chartyes" value="Y" <?php echo $turnOn['toyes']; ?> required>
						<label class="form-check-label" for="chartyes"> Yes</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="chartback" id="chartno" value="N" <?php echo $turnOn['tono']; ?> >
						<label class="form-check-label" for="chartno"> No</label>
					</div>
					<span id="chart-error" style="display:none;">
							Please select a staff charting option.
					</span>
				  </div>
				  
			  </div>
			</div>
			
			
			
			<div class="col-md-12 chartbackdetails" style="display:none;">
				<div class="row  d-flex align-items-center">
				  <div class="col-md-3">
						<label>How long to allow charting in the past.</label>
				  </div>
				  
				  <div class="col-md-1 text-start">
						<input type="number" class="form-control" name="chartbacklength" id="chartbacklength" min="1" step="1"  max="180" placeholder="" required>
				 </div>
				 <div class="col-md-8 text-start">
					<?php
						$turnOn = array( 'toyes' => "", 'tono' => '' );
						if ( isset($CHART_PERIOD) ) {
							if(  $CHART_PERIOD == 0 ) { $turnOn['toyes'] = " checked=\"checked\" "; } else { $turnOn['tono'] = " checked=\"checked\" "; } 
						}
						else {
							$turnOn['toyes'] = " checked=\"checked\" ";
						}
					?>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="chartbackperiod" id="chartperiodyes" value="0"  <?php echo $turnOn['toyes']; ?> required>
						<label class="form-check-label" for="chartperiodyes"> Day(s)</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="chartbackperiod" id="chartperiodno" value="1" <?php echo $turnOn['tono']; ?> >
						<label class="form-check-label" for="chartperiodno"> Month(s)</label>
					</div>
				  </div>
			  </div>
			</div>
			
			
			
			<div class="col-md-12">
				<div class="row d-flex align-items-center">
				  <div class="col-md-3 d-flex align-self-start">
						<label>Which services do you provide?</label>
				  </div>
				  
				  <div class="col-md-9 text-start" id="servicesProvided">
				  </div>
			  </div>
			</div>
			
			<div class="col-md-12">
				<div class="row d-flex align-items-center">
				  <div class="col-md-3">
						<label>How do you refer to your clients?</label>
				  </div>
				  
				  <div class="col-md-4 pe-0 text-start">
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="clientcall" id="clientscall" value="Clients" required>
						<label class="form-check-label" for="clientcall"> Clients</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="clientcall" id="residentscall" value="Residents">
						<label class="form-check-label" for="residentcall"> Residents</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="clientcall" id="individualscall" value="Individuals">
						<label class="form-check-label" for="individualcall"> Individuals</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="clientcall" id="othercall" value="Other">
						<label class="form-check-label" for="othercall"> Other</label>
					</div>
					<br/>
					<span id="client-error" style="display:none;">
							Please select a Client reference option.
					</span>
				  </div>
				  <div class="col-md-3" id="othercalldiv" style="display:none;">
						<div class="form-floating mt-3">
							<input type="text" class="form-control" name="othercallvalue" id="othercallvalue" placeholder="How are clients referred to?" required>
							<label  for="othercallvalue">How are clients referred to?</label>
							<div class="invalid-feedback">
								How are clients referred to?
							</div>
						</div>
				  </div>
					<div class="col-md-1"></div>
			  </div>
			</div>

			<?php if ( isset($PULL_CONFIG_DATA) && $PULL_CONFIG_DATA ) { ?>
				<h5 class="card-title">Data Load &nbsp; &nbsp; <span class="text-danger fs-6"><strong>NOTE:</strong> Application was previously configured, so any files below will overwrite currently saved data.</span></h5>
			<?php } else { ?>
				<h5 class="card-title">Initial Data Load</h5>
			<?php } ?>
			<div class="row">
				<div class="col-md-3">
				  <div class="form-floating mt-3 mb-3">
					<input type="file" accept=".xls,.xlsx, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel" class="form-control" name="clientsfile" id="clientsfile" value="" placeholder="">
					<label  for="clientsfile">Clients File to Load</label>
				  </div>
				</div>
				<div class="col-md-3">
				  <div class="form-floating mt-3 mb-3">
					<input type="file"  accept=".xls,.xlsx, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel" class="form-control" name="locationsfile" id="locationsfile" value="" placeholder="">
					<label  for="locationsfile">Company Locations ( Houses ) File to Load</label>
				  </div>
				</div>
				<div class="col-md-3">
				  <div class="form-floating mt-3 mb-3">
					<input type="file"  accept=".xls,.xlsx, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel" class="form-control" name="stafffile" id="stafffile" value="" placeholder="">
					<label  for="stafffile">Staff File to Load</label>
				  </div>
				</div>
				<div class="col-md-3">
				  <div class="form-floating mt-3 mb-3">
					<input type="file"  accept=".xls,.xlsx, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel" class="form-control" name="ccsstafffile" id="ccsstafffile" value="" placeholder="">
					<label  for="ccsstafffile">CCS Staff File to Load</label>
				  </div>
				</div>
			</div>
			
		<?php //} ?>

			<div class="text-center my-3 py-3">
			   <input type="hidden" name="step" value="2">
			   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Configure Application</button><!--Configure Application</button-->
			   <button type="reset" class="btn btn-secondary mt-3 configbtn" name="btnreset">Start Configuration Over</button>
			   <!--Reset</button-->
			</div>
		  </form><!-- End floating Labels Form -->
		<?php } ?>
		</div>
	  </div>

<?php } ?>

	</div>
  </div>
  <!-- The Modal -->
	<div id="myModal" class="modal">
		<br />
	  <span class="close">&times;</span>
	  <br />
	  <br />
	  <img class="modal-content" id="img01">
	</div>
</section>

</main><!-- End #main -->
  
 <?php include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.footer.php' ); ?>