<?php
	
	date_default_timezone_set( getTimeZone( $TIMEZONE ) );
	
	list( $stateCD, $zipCode ) = explode( " ", $agency_info['office_statezip'] );
	
	if ( $_SESSION['user-role'] == CCS_STAFF ) {
		$step = 2;
		$swID = $_SESSION['staffID'];
	}
	else {
		if ( $step == 2 ) { 
			$swID = $_REQUEST['staffID'];
		}
	}
		
	if (  $step == 2 ) {
	
		$rtn = getResidentsForSW( $swID );	
		
		$updtMessage = $rtn[1];
		if ( $rtn[0] == SUCCESS ) {

			$clients = $rtn[1];
			//echo dpp($clients);
			
			if ( is_array($clients) && count($clients) <= 0 ) {
							
				$updtMessage = "Sorry, " . getSocialWorker( $swID ) . " has no clients at this time.";
				$isFail = true;
				$step = 1;
			}
		}
		else {
			$isFail = true;
			$step = 1;
		}
		
		
		
	}
	
	if ( $step == 1 ) { 

		$socialwrkrs = getCCSListing();
?>
<form id="allowances" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/ccs-corner/index/dest/<?php echo $dest; ?>/step/2/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo  $CCS_CORNER_BREADCRUMB[$dest]; ?></h5>
			   <?php if ( isset($isFail) ) { ?>
			   		<div class="row mt-3 mb-3">
						<div class="col-md-1"></div>
						<div class="col-md-10 col-sm-offset-1 text-center">
							  <div class="alert  <?php echo ( $isFail === false ) ? "alert-success" : "alert-danger"; ?> text-center mb-1">
								<h4>
								<?php 
									echo $updtMessage;
								?>
								</h4>
								</div>
						</div>
						<div class="col-md-1"></div>
					</div>
			   <?php } ?>
              <!-- Floating Labels Form -->
			  
			  <div class="row">
			  		<div class="col-md-4"></div>
					<div class="col-md-4">
					  <div class="form-floating mt-3">
							<select class="form-select js-select" name="staffID" id="staffID" aria-label="CCS Staff" required>
								  <option selected disabled value="">Choose a CCS Staff </option>
								  <?php for( $i = 0; $i < count($socialwrkrs); $i++ ) { ?>
								  <option value="<?php echo $socialwrkrs[$i]['CCS_StaffID']; ?>"><?php echo $socialwrkrs[$i]['CCS_StaffName']; ?></option>
								  <?php } ?>
							</select>
							<label  for="staffID">CCS Staff</label>
							<div class="invalid-feedback">
								Please select a CCS Staff.
							</div>
					  	</div>
                	</div>	
					<div class="col-md-4"></div>
			</div>
								
			<div class="text-center mt-5 mb-5">
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Get <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?> List</button>
                </div>	
 			</div>
	   </div>
		
	</form>	
<?php }
	  else if ( $step == 2 ) { 
?>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo  $CCS_CORNER_BREADCRUMB[$dest]; ?></h5>
			
			<table class="table  datatable"> <!-- table-borderless -->
				<thead>
				  <tr>
				  <th scope="col">&nbsp;</th>
					<th scope="col"><?php echo( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?></th>
					<th scope="col">Birth Date</th>
					<th scope="col">Gender</th>
					<th scope="col">Admission Date</th>
					<!--th scope="col">Service</th-->
					<th scope="col"><?php echo( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?> House(s)</th>
					<th scope="col">&nbsp;</th>
					<th scope="col">&nbsp;</th>
				  </tr>
				</thead>
				<tbody>
					
				<?php for( $row = 0; $row < count($clients); $row++ ) { 
					$rootDir = trim(strtolower(getRootDirs( $clients[$row]['ClientID'] )[0]));
										
					$dir = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' .  $_SERVER['SERVER_NAME'] . '.files/images/client-imgs/';
					$clientImg = $protocol . '://' . $_SERVER['SERVER_NAME'] . '/clients-online-files/' .  $_SERVER['SERVER_NAME'] . '.files/images/client-imgs/no_image.png';					
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) !== false) {
								if (strpos($file, $rootDir ) !== false) {
									$clientImg = $protocol . '://' . $_SERVER['SERVER_NAME'] . '/clients-online-files/' .  $_SERVER['SERVER_NAME'] . '.files/images/client-imgs/' . $file;
								}
							}
							closedir($dh);
						}
					}
					
				?>
                      <tr>
					    <td class="align-middle"></td>
                        <td class="align-middle"><img class="ccsimg rounded-circle me-3" src="<?php echo $clientImg; ?>" /> <?php echo $clients[$row]['ClientName']; ?></td>
						<td class="align-middle"><?php echo $clients[$row]['ClientBirthDate']; ?></td>
						<td class="align-middle"><?php echo ($clients[$row]['ClientGender']=='M') ? 'Male' : 'Female'; ?></td>
						<td class="align-middle"><?php echo $clients[$row]['ClientAdmisionDate']; ?></td>
						<!--td class="align-middle"><?php echo getServiceName( $clients[$row]['ResidenceID'], $stateCD ); ?></td-->
						<td class="align-middle"><?php echo getHouseName( $clients[$row]['ResidenceID'] ); ?></td>
                        <td class="align-middle"><a href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/ccs-corner/index/dest/swrpt/step/1/id/<?php echo $clients[$row]['ClientID']; ?>/">Get <?php echo( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ); ?>'s Report(s)</a></td>
						<td class="align-middle"></td>
                      </tr>
			
				<?php } ?>
				</tbody>
              </table>						
 			</div>
	   </div>
		
<?php
	}
?>