<?php

	// Load the Environmental file
	//
	require_once __DIR__ . '/../PHPDotEnv/vendor/autoload.php';
	$dotenv = Dotenv\Dotenv::createImmutable(__DIR__.'/../PHPDotEnv', '.' . $_SERVER['SERVER_NAME'] . '.env');
	$dotenv->load();
	
	// ---- DB connection ----
	$mysqli = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
	if ($mysqli->connect_errno) {
		die("DB connect error: {$mysqli->connect_error}\n");
	}
	
	$typeFilter = $_GET['type'] ?? 'all';
	
	$sql = "SELECT ci.*, d.name AS doctor_name, c.name AS category_name, c.color
			FROM calendar_items ci
			LEFT JOIN doctors d ON ci.doctor_id = d.id
			LEFT JOIN event_categories c ON ci.category_id = c.id";
	if ($typeFilter !== 'all') $sql .= " WHERE ci.type = '$typeFilter'";
	
	$result = $mysqli->query($sql);
	$events = [];
	
	while ($row = $result->fetch_assoc()) {
	  $color = ($row['type'] === 'appointment') ? '#007bff' : '#28a745';
	  if ($row['type'] === 'event' && !empty($row['color'])) $color = $row['color'];
	
	  $events[] = [
		'id' => $row['id'],
		'title' => $row['title'],
		'start' => $row['date'].'T'.$row['start_time'],
		'end' => $row['date'].'T'.$row['end_time'],
		'color' => $color
	  ];
	}
	echo json_encode($events);
?>


