<?php 
	ob_start(); // Start output buffering

	$doredirect = 0;
	$requireSignOn = 'N';
	$includeFooter = false;
	$protocol = isset($_SERVER['HTTPS']) ? 'https' : 'http';
	$isFail = '';
	
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.inc.php' );
	
	//
	// Save Cookie, if Remember me is checked
	//
	if ( $dest == SIGNIN && $step == 2 ) {

		if ( isset($_REQUEST) &&  isset($_REQUEST['rememberMe']) && ( $_REQUEST['rememberMe'] == 'true' ) ) {
			$cookie_name = "PrimeCareUser";
			$cookie_value = trim( $_REQUEST['username'] );
			setcookie($cookie_name, $cookie_value, time() + (86400 * 30), "/"); // 86400 = 1 day
		}
	}
	
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.header.php' );
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/authaz.db.php' );
	
	$errorMessage = '';
	
	if ( $dest == SIGNIN && $step == 2 ) {
		
		if ( isset($routed) && $routed ) {
		
			$userRec = array();
			$_REQUEST['username'] = getStaffUsername( $uid );
			$_REQUEST['password'] = decrypt( $uPass );
			
		}

		$isFail = '';

		if ( isset($_ENV['MAIN_DOMAIN']) && ( trim($_SERVER['SERVER_NAME']) == trim($_ENV['MAIN_DOMAIN']) ) ) {
			$userRtn = userSignOnAndRedirect( $_REQUEST );	
				
			if ( ( $userRtn[0] == SUCCESS ) && isset($userRtn[1]['redirectDomain']) ) {

				header("Location: " . $protocol . "://" . $userRtn[1]['redirectDomain'] . "/authaz/index/dest/signin/step/2/route/" . $userRtn[1]['StaffID'] . "/stop/" . encrypt($_REQUEST['password']) . "/" );
				exit();
			}		
		}
		else {
			$userRtn = userSignOn( $_REQUEST );	
		}
				
		if ( !( ( $userRtn[0] == SUCCESS ) &&  ( isset($userRtn[1]['StaffPassword']) && ( $userRtn[1]['StaffPassword'] != '' ) ) && password_verify($_REQUEST['password'], $userRtn[1]['StaffPassword']) ) ) {
			$userRtn[0] = FAIL;
			$userRtn[1] = "Your Username and password combination does not match our records!";
		}
		else if ( $userRtn[0] == SUCCESS ) {
			if ( isset($userRtn[1]['configurator']) ) {
				$_REQUEST['configurator'] = 'Configure';
			}
			$userRtn = userSignOnDetails( $_REQUEST );	
		}
				
		if ( $userRtn[0] == FAIL ) {
			$isFail = true;
			$step = 1;
			$errorMessage = $userRtn[1];
		}
		else {
			$_SESSION['userRec'] = $userRtn[1];
			
			if ( $userRtn[1]['isEmailVerified'] == 'N' ) {
				$step = 2;
				$isFail = true;
				$errorMessage = "Your email address has not been verified. Verify it now!";
				$dest = 'verifyemail';
			}
			else if ( $userRtn[1]['PswdReset'] == 'N' ) {
				$step = 1;
				$dest = 'passwdReset';
			}
			else {
				$_SESSION['sessID'] = str_rand(16);
				$_SESSION['userIsLoggedIn'] = true;
				
				if ( isset($_SESSION['userRec']) ) 
				{
					$_SESSION['userIsLoggedIn'] = true;
					$_SESSION['menus-allowed'] = menuAccessAllowed( isset($_SESSION['staffID']) ? $_SESSION['staffID'] : 0 );
					$_SESSION['staffID'] = $_SESSION['userRec']['StaffID'];
					$_SESSION['user_houseID'] = $_SESSION['userRec']['HouseID'];
					$_SESSION['username'] = $_SESSION['userRec']['Username'];
					$_SESSION['user-finit-lname'] = ucfirst(substr(trim($_SESSION['userRec']['StaffFname']), 0, 1 )) . '. ' . ucfirst($_SESSION['userRec']['StaffLname']);
					$_SESSION['user-fullname'] = trim($_SESSION['userRec']['StaffFname']) . ' ' . ucfirst($_SESSION['userRec']['StaffLname']);
					$_SESSION['user-position'] = $_SESSION['userRec']['Position'];
					$_SESSION['user-type'] = $_SESSION['userRec']['StaffType'];
					$_SESSION['user-role'] = $_SESSION['userRec']['StaffRoleID'];
					$_SESSION['user-gender'] = $_SESSION['userRec']['StaffGender'];
					$_SESSION['user-housename'] = $_SESSION['userRec']['HouseName'];
					$_SESSION['user-isDriver'] = $_SESSION['userRec']['IsDriver'];
					$_SESSION['user-email'] = $_SESSION['userRec']['StaffEmail'];
					
					if ( file_exists( $_SERVER['DOCUMENT_ROOT'] . '/assets/img/staff-imgs/' . $_SESSION['userRec']['Username'] . '.png') ) {
						$_SESSION['staff-image'] = '' . $_SESSION['userRec']['Username'] . '.png';
					}
					else if ( file_exists( $_SERVER['DOCUMENT_ROOT'] . '/assets/img/staff-imgs/' . $_SESSION['userRec']['Username'] . '.jpg') ) {
						$_SESSION['staff-image'] = '' . $_SESSION['userRec']['Username'] . '.jpg';
					}
					else if ( file_exists( $_SERVER['DOCUMENT_ROOT'] . '/assets/img/staff-imgs/' . $_SESSION['userRec']['Username'] . '.jpeg') ) {
						$_SESSION['staff-image'] = '' . $_SESSION['userRec']['Username'] . '.jpeg';
					}
					else {
						if ( $_SESSION['user-gender'] == MALE ) {
							$_SESSION['staff-image'] = 'male.png';
						}
						else {
							$_SESSION['staff-image'] = 'female.png';
						}
					}
				}
				
				$_SESSION['userIsAdmin'] = isset($_SESSION['user-role']) ? in_array( $_SESSION['user-role'], array(  ADMINISTRATOR, NURSE, DAY_PROGRAM_MANAGER, PERSONAL_SUPPORT_MANAGER, YOUTH_COORDINATOR, RESPITE_MANAGER, RESIDENTIAL_MANAGER, HOUSE_MANAGER, QUALITY_ASSURANCE, IT_STAFF ) ) : false;
																					 
				if ( isset($_SESSION['userRec']) ) { unset( $_SESSION['userRec'] );  }
				unset( $_SESSION['sessionExpired'] );
				
				startSession( $_SESSION['sessID'], $_SESSION['staffID'] );
				updateStaffSignOnDateTime( $_SESSION['staffID'], date("Y-m-d"), date("H:i:s") );
				
				header("Location: " . $protocol . "://" . $_SERVER['SERVER_NAME'] . "/" );
				exit();
				
				/*
				// Redirect to the original page if it exists, otherwise go to a default page
				$redirectPage = $_SESSION['redirectAfterLogin'] ?? "" . $protocol . "://" . $_SERVER['SERVER_NAME'] . "/";
				
				//echo $redirectPage;
				
				unset($_SESSION['redirectAfterLogin']); // Clear the session variable
				unset($_SESSION['configurationRequired']); // Clear the session variable
				
				header("Location: " . $redirectPage );
				*/
			}
		}
		
	}
	ob_end_flush(); // Flush the buffer
	
	if ( $dest == SIGNOUT ) { 
		deleteRedirectURL( $_SESSION['sessID'] );
		deleteSession( $_SESSION['sessID'] );
		$_SESSION['userIsLoggedIn'] = false;
		unset( $_SESSION );
		session_destroy();
	}
	
	if ( $dest == RESETPASSWORD && $step == 3  ) {
	
		$userRtn = resetPassword( $_REQUEST );	
		$isFail = false;	
		$errorMessage = $userRtn[1] . PHP_EOL . PHP_EOL . "<a href=\"" . $protocol . "://" . $_SERVER['SERVER_NAME'] . "/authaz/index/dest/signin/step/1/\">Proceed to Sign In</a>";
		if ( $userRtn[0] == FAIL ) {
			$isFail = true;
			$step = 2;
			$errorMessage = $userRtn[1];
		}
	}
	
	if ( $dest == FORGOTPASSWORD ) {
		$isFail = '';
		if ( $step == 2 ) {
			$uqReturn = getUserSecurityQuestions( $_REQUEST );
			if ( $uqReturn[0] == FAIL ) {
				$isFail = true;
				$step = 1;
				$dest = RESETPASSWORD;
				$errorMessage = $uqReturn[1];
								
			}
			else {
				$isFail = false;
				$questions = $uqReturn[1];
				$idx = mt_rand( 0, 1 );
			}
		}
		else if ( $step == 3 ) {
			$uqReturn = resetForgottenPassword($_REQUEST);
			if ( $uqReturn[0] == FAIL ) {
				$isFail = true;
				$step = 2;
				$errorMessage = $uqReturn[1];
			}
			else {
				$isFail = false;
				$questions = $uqReturn[1];
				$errorMessage = $uqReturn[1] . "<a href=\"" . $protocol . "://" . $_SERVER['SERVER_NAME'] . "/authaz/index/dest/signin/step/1/\">Proceed to Sign In</a>";;
				$idx = mt_rand( 0, 1 );
			}
		}
	}
	
	if ( $dest == VERIFYEMAIL && $step == 3  ) {
	
		$verified = verifyEmail( $_REQUEST );
		$isFail = false;	
		$verifyMessage = "Your email address has been verified, so your staff account is now confirmed and active. <a href=\"" . $protocol . "://" . $_SERVER['SERVER_NAME'] . "/authaz/index/dest/signin/step/1/\">Proceed to Sign In</a>";
		if ( $verified[0] == FAIL ) {
			$isFail = true;
			$step = 2;
			$errorMessage = $verified[1];
		}
	}
		
?>


	  <main>
	  	<section class="section">
			<div class="container">
		
			  <section class="section register min-vh-100 d-flex flex-column align-items-center justify-content-center py-4">
				<div class="container">
				
				<!-- ================================================================================== -->
				<?php 
						include( $_SERVER['DOCUMENT_ROOT'] . '/authaz/' .  $dest . '.inc.php' );
				?>
				<!-- ================================================================================== -->
	
	
				</div>
			  </section>
			  
			</div>
		</section>
	  </main><!-- End #main -->
  
 

 <?php include( $_SERVER['DOCUMENT_ROOT'] . '/assets/theme/theme.footer.php' ); ?>