
$(document).ready(function() {								
	
	$( '#vehiclehouse' ).select2( {
		theme: "bootstrap-5",
		placeholder: $( this ).data( 'placeholder' ),
		width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
		//allowClear: true
	} );
	
	new tempusDominus.TempusDominus(document.getElementById('div_tagexpiredt'), {
	   display: {
		 viewMode: 'calendar',
		 components: {
		   decades: true,
		   year: true,
		   month: true,
		   date: true,
		   hours: false,
		   minutes: false,
		   seconds: false,
		 },
		 icons: {
		   time: 'bi bi-clock',
		   up: 'bi bi-arrow-up',
		   down: 'bi bi-arrow-down',
		   previous: 'bi bi-chevron-left',
		   next: 'bi bi-chevron-right',
		   clear: 'bi bi-trash-fill',
		   close: 'bi bi-x-lg',
		 },
		 buttons: {
		   today: true,
		   clear: true,
		   close: true,
		 }
	   },
		localization: {
		   format: 'MM/dd/yyyy',
	   },
		useCurrent: false,
	 });
	
	new tempusDominus.TempusDominus(document.getElementById('div_vehicleyear'), {
	   display: {
		 viewMode: 'years',
		 components: {
		   decades: true,
		   year: true,
		   month: false,
		   date: false,
		   hours: false,
		   minutes: false,
		   seconds: false,
		 },
		 icons: {
		   time: 'bi bi-clock',
		   up: 'bi bi-arrow-up',
		   down: 'bi bi-arrow-down',
		   previous: 'bi bi-chevron-left',
		   next: 'bi bi-chevron-right',
		   clear: 'bi bi-trash-fill',
		   close: 'bi bi-x-lg',
		 },
		 buttons: {
		   today: true,
		   clear: true,
		   close: true,
		 }
	   },
		localization: {
		   format: 'yyyy',
	   },
		useCurrent: false,
	 });
	
	$('#docname').change( function() {
		if ( ( $('#docname').val() == null ) || ( $('#docname').val().trim().length == 0 ) ) {
			$('#docname').val("");
		}	
		else {
			$('#formField').val(  $('#docname').val().trim().toLowerCase().replace(/ /g, '_').replace( /"|'|-|:|;/g, '_' ) );                                     
		}
	});
	
	
	$('#renewalinterval').change( function() {
		if ( $('#renewalinterval').val() == -1 ) {
			$('#calcNewDate').val("N");
		}	
		else {
			$('#calcNewDate').val("Y");
		}
	});
	
	$('#addmonitor').submit( function() {	
						
		if ( ( $('#docname').val() == null ) || ( $('#docname').val().trim().length == 0 ) ) {
			return false;
		}
		if ( ( $('#doctype').val() == null ) || ( $('#doctype').selectedIndex == 'undefined' ) ) {
			return false;
		}
		if ( ( $('#renewalinterval').val() == null ) || ( $('#renewalinterval').selectedIndex == 'undefined' ) ) {
			return false;
		}

		return true;
		
	});
	
});

	
