
$(document).ready(function() {								
	
	$( '#providerID,#state,#providerTypeID' ).select2( {
		theme: "bootstrap-5",
		placeholder: $( this ).data( 'placeholder' ),
		width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
		//allowClear: true
	} );
	
	$('#phonenum').blur( function() {
		if ( $('#phonenum').val().trim().length >= 10 )	{
			$('.phoneerror').text("Please provide a Provider Phone Number.");
			$('.phoneerror').hide();
		}
	});
	
	$('#cellnum').blur( function() {
		if ( $('#cellnum').val().trim().length >= 10 || ( $('#cellnum').val().trim().length == 0 ) )	{
			$('.cellerror').text("Please provide a Provider Cell Phone Number.");
			$('.cellerror').hide();
		}
	});
	
	$('#fax').blur( function() {
		if ( $('#fax').val().trim().length >= 10 || ( $('#fax').val().trim().length == 0 )  )	{
			$('.faxerror').text("Please provide a Provider Fax Number.");
			$('.faxerror').hide();
		}
	});
	
	$('#updtprovider').submit( function() {	
		
		if ( $('#providerID').length ) {
			if ( ( $('#providerID').val() == null ) || ( $('#providerID').selectedIndex == 'undefined' ) ) {
				return false;
			}
		} 
		
		if ( $('#provider').length )  {
			if ( ( $('#provider').val() == null ) || ( $('#provider').val().trim().length == 0 ) ) {
				return false;
			}
			if ( ( $('#providerTypeID').val() == null ) || ( $('#providerTypeID').selectedIndex == 'undefined' ) ) {
				return false;
			}
			if ( ( $('#phonenum').val() == null ) || ( $('#phonenum').val().trim().length == 0 ) ) {
				return false;
			}
			if ( ( $('#staffemail').val() == null ) || ( $('#staffemail').val().trim().length == 0 ) ) {
				return false;
			}
		}
		
		if ( $('#address').length && ( $('#address').val().trim().length > 0 ) )  {
			
			$('#state').prop('required', true);
			$('#city').prop('required', true);
			$('#zipcode').prop('required', true);
			
			if ( ( $('#city').val() == null ) || ( $('#city').val().trim().length == 0 ) ) {
				return false;
			}
			if ( ( $('#state').val() == null ) || ( $('#state').selectedIndex == 'undefined' ) ) {
				return false;
			}

			if ( ( $('#zipcode').val() == null ) || ( $('#zipcode').val().trim().length == 0 ) ) {
				return false;
			}
		}
		
		if ( $('#phonenum').length && ( $('#phonenum').val().trim().length < 10 ) )  {
			
			$('.phoneerror').text('Phone number is not valid');
			$('.phoneerror').css("color","red");
			$('.phoneerror').show();
			return false;
		}
		else {
			$('.phoneerror').text("Please provide a Provider Phone Number.");
			$('.phoneerror').hide();
		}
		
		if ( $('#cellnum').length && ( $('#cellnum').val().trim().length > 0 ) && ( $('#cellnum').val().trim().length < 10 ) )  {
			
			$('.cellerror').text('Cell Phone number is not valid');
			$('.cellerror').css("color","red");
			$('.cellerror').show();
			return false;
		}
		else {
			$('.cellerror').text("Please provide a Provider Cell Phone Number.");
			$('.cellerror').hide();
		}
		
		if ( $('#fax').length && ( $('#fax').val().trim().length > 0 ) && ( $('#fax').val().trim().length < 10 ) )  {
			
			$('.faxerror').text('Fax number is not valid');
			$('.faxerror').css("color","red");
			$('.faxerror').show();
			return false;
		}
		else {
			$('.faxerror').text("Please provide a Provider Fax Number.");
			$('.faxerror').hide();
		}
		return true;
		
	});
	
});

	
