
function updateProgress() 
{
    fetch('/onboarding/progress.json?' + new Date().getTime())
        .then(res => res.json())
        .then(data => {
            const percent = data.progress || 0;
            const progressBar = document.getElementById('progress-bar');
			const messageDiv = document.getElementById('message-div');
			
			if (progressBar) {
			  progressBar.style.width = progress + '%';
			  progressBar.textContent = percent + '%';
			} else {
			  console.warn('Progress elements not found in DOM');
			}

            if (data.status === 'error' ) {
				if (progressBar) {
					progressBar.textContent = 'Error!';
					progressBar.style.background = '#f44336'; // red
				}
				else {
				  console.warn('Progress elements not found in DOM');
				}
				if (messageDiv) {
					messageDiv.textContent = data.message;
				}
				else {
				  console.warn('Message Div element not found in DOM');
				}
                //alert('Error: ' + data.error);
            } else if (data.status === 'done' ) {
				if (progressBar) {
                	progressBar.textContent = 'Completed!';
                	progressBar.style.background = '#00c000'; // green
				}
				else {
				  console.warn('Progress elements not found in DOM');
				}
                //alert('Done: ' + data.data.result);
            } else {
                setTimeout(updateProgress, 3000);
            }
        })
        .catch(err => {
            console.error('Failed to load progress.json:', err);
        });
}

document.getElementById('onboardingForm').addEventListener('submit', function (e) {
    e.preventDefault(); // prevent default form submission

    const form = document.getElementById('onboardingForm');
    const formData = new FormData(form);

    fetch('/onboarding/new_onboarding.php', {
        method: 'POST',
        body: formData
    }).then(() => {
        //updateProgress();
		document.addEventListener('DOMContentLoaded', () => {
													   alert("document loaded");
		  updateProgress();
		});
    }).catch(err => {
        console.error('Failed to start onboarding:', err);
    });
});

