function getAbbreviation(str) {
    // List of words to remove (like "Inc.", "LLC", etc.)
    var removeWords = ['Inc.', 'LLC', 'Ltd.', 'Corp.', 'Corporation', 'Co.'];

    // Split the string into words using space as a delimiter
    var words = str.split(/\s+/);

    // Filter out unwanted words (like "Inc.", "LLC", etc.)
    words = words.filter(function(word) {
        return !removeWords.includes(word.replace(/[^a-zA-Z]/g, '')); // Remove non-alphabetic characters and check
    });

    // Map through the words, get the first letter, and convert to uppercase
    var abbreviation = words.map(function(word) {
        word = word.replace(/[^a-zA-Z]/g, ''); // Remove any non-alphabetic characters
        return word.charAt(0).toUpperCase(); // Get first letter and convert to uppercase
    }).join(''); // Join the first letters into a single string

    return abbreviation;
}
		
$(document).ready(function() {	
	
	$('#hidesidebar').click();
	$('#hidesidebar').hide();
	$('#showsidebar').hide();
	
	// Get references to the password input and the toggle icon
	if ( $('#togglePassword1').length ) {
		const togglePassword1 = document.getElementById("togglePassword1");
	}
	
	if ( $('#togglePassword2').length ) {
		const togglePassword2 = document.getElementById("togglePassword2");
	}
	
	if ( $('#adminpassword').length ) {
		const passwordField1 = document.getElementById("adminpassword");
		$('#adminpassword').val('');
		
		// Add an event listener for the toggle icon click
		togglePassword1.addEventListener("click", function () {
			// Toggle the type between 'password' and 'text'
			const type = passwordField1.type === "password" ? "text" : "password";
			passwordField1.type = type;
	
			// Change the icon based on visibility
			togglePassword1.innerHTML = type === "password" ? '<i class="bi bi-eye"></i>' : '<i class="bi bi-eye-slash"></i>';
	
		});
	}
	
	if ( $('#adminpassword2').length ) {
		const passwordField2 = document.getElementById("adminpassword2");
		$('#adminpassword2').val('');
		
		// Add an event listener for the toggle icon click
		togglePassword2.addEventListener("click", function () {
			// Toggle the type between 'password' and 'text'
			const type = passwordField2.type === "password" ? "text" : "password";
			passwordField2.type = type;
	
			// Change the icon based on visibility
			togglePassword2.innerHTML = type === "password" ? '<i class="bi bi-eye"></i>' : '<i class="bi bi-eye-slash"></i>';
	
		});
	}
		
	if ( $('#agencyfname').length ) {
		$('#agencyfname').blur( function() {	
			$('#agencyrecsname').val( getAbbreviation($('#agencyfname').val()) );
			$('#agencysname').val( getAbbreviation($('#agencyfname').val()) );
			if ( ( $('#agencyfname').val() == null ) || ( $('#agencyfname').val().trim().length <= 0 )  ) {
				$('#agencysubdomain').val("");
			}
			else {
				$('#agencysubdomain').val( (getAbbreviation($('#agencyfname').val()) + "." + $('#main_domain').val()).toLowerCase() );
			}
		});
		
		$('#agencysname').blur( function() {	
			$('#agencysname').val( $('#agencysname').val().toUpperCase() );
			$('#agencysubdomain').val( ( $('#agencysname').val() + "." + $('#main_domain').val()).toLowerCase() );
		});
		
		$('#agencysname').change( function() {	
			$('#agencysname').val( $('#agencysname').val().toUpperCase() );
			$('#agencysubdomain').val( ( $('#agencysname').val() + "." + $('#main_domain').val()).toLowerCase() );
		});
	}
	
	if ( $('#onboardingForm').length ) {
		$('#onboardingForm').submit( function() {	
			$('#agencyfname').val()
			$('#agencysname').val()
			
			if ( ( $('#agencyfname').val() == null ) || ( $('#agencyfname').val().trim().length <= 0 )  ) {
				return false;
			}
			if ( ( $('#agencysname').val() == null ) || ( $('#agencysname').val().trim().length <= 0 )  ) {
				return false;
			}
			if ( ( $('#agencyadminemail').val() == null ) || ( $('#agencyadminemail').val().trim().length <= 0 )  ) {
				return false;
			}
			
			if ( ( $('#adminusername').val() == null ) || ( $('#adminusername').val().trim().length <= 0 )  ) {
				return false;
			}
			
			if ( ( $('#adminpassword').val() == null ) || ( $('#adminpassword').val().trim().length <= 0 )  ) {
				return false;
			}
			
			if ( ( $('#adminpassword2').val() == null ) || ( $('#adminpassword2').val().trim().length <= 0 )  ) {
				return false;
			}
			
			if ( $('#adminpassword').val().trim()  != $('#adminpassword2').val().trim() ) {
				$('.no-match-password').show();
				return false;
			}
			
			return true;
		});
	}
	else {
		// Start the onboarding process
		//startProcess();
	}
	
});

		