/**
* Template Name: NiceAdmin - v2.1.0
* Template URL: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/
* Author: BootstrapMade.com
* License: https://bootstrapmade.com/license/
*/
(function() {
  "use strict";

  /**
   * Easy selector helper function
   */
  const select = (el, all = false) => {
    el = el.trim()
    if (all) {
      return [...document.querySelectorAll(el)]
    } else {
      return document.querySelector(el)
    }
  }

  /**
   * Easy event listener function
   */
  const on = (type, el, listener, all = false) => {
    if (all) {
      select(el, all).forEach(e => e.addEventListener(type, listener))
    } else {
      select(el, all).addEventListener(type, listener)
    }
  }

  /**
   * Easy on scroll event listener 
   */
  const onscroll = (el, listener) => {
    el.addEventListener('scroll', listener)
  }

  /**
   * Sidebar toggle
   */
  //if (select('.toggle-sidebar-btn')) {
  //  on('click', '.toggle-sidebar-btn', function(e) {
  //    select('body').classList.toggle('toggle-sidebar');
  //  })
  //}
  
  if (select('#hidesidebar')) {
    on('click', '#hidesidebar', function(e) {
      select('body').classList.toggle('toggle-sidebar');
	  select('body').classList.toggle('toggle-rightbar');
    })
  }
  
  if (select('#showsidebar')) {
    on('click', '#showsidebar', function(e) {
      select('body').classList.toggle('toggle-sidebar');
	  select('body').classList.toggle('toggle-rightbar');
    })
  }
  

  /**
   * Search bar toggle
   */
  if (select('.search-bar-toggle')) {
    on('click', '.search-bar-toggle', function(e) {
      select('.search-bar').classList.toggle('search-bar-show')
    })
  }

  /**
   * Navbar links active state on scroll
   */
  let navbarlinks = select('#navbar .scrollto', true)
  const navbarlinksActive = () => {
    let position = window.scrollY + 200
    navbarlinks.forEach(navbarlink => {
      if (!navbarlink.hash) return
      let section = select(navbarlink.hash)
      if (!section) return
      if (position >= section.offsetTop && position <= (section.offsetTop + section.offsetHeight)) {
        navbarlink.classList.add('active')
      } else {
        navbarlink.classList.remove('active')
      }
    })
  }
  window.addEventListener('load', navbarlinksActive)
  onscroll(document, navbarlinksActive)

  /**
   * Toggle .header-scrolled class to #header when page is scrolled
   */
  let selectHeader = select('#header')
  if (selectHeader) {
    const headerScrolled = () => {
      if (window.scrollY > 100) {
        selectHeader.classList.add('header-scrolled')
      } else {
        selectHeader.classList.remove('header-scrolled')
      }
    }
    window.addEventListener('load', headerScrolled)
    onscroll(document, headerScrolled)
  }

  /**
   * Back to top button
   */
  let backtotop = select('.back-to-top')
  if (backtotop) {
    const toggleBacktotop = () => {
      if (window.scrollY > 100) {
        backtotop.classList.add('active')
      } else {
        backtotop.classList.remove('active')
      }
    }
    window.addEventListener('load', toggleBacktotop)
    onscroll(document, toggleBacktotop)
  }

  /**
   * Initiate tooltips
   */
  var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
  var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl)
  })

  /**
   * Initiate quill editors
   */
  if (select('.quill-editor-default')) {
    new Quill('.quill-editor-default', {
      theme: 'snow'
    });
  }

  if (select('.quill-editor-bubble')) {
    new Quill('.quill-editor-bubble', {
      theme: 'bubble'
    });
  }

  if (select('.quill-editor-full')) {
    new Quill(".quill-editor-full", {
      modules: {
        toolbar: [
          [{
            font: []
          }, {
            size: []
          }],
          ["bold", "italic", "underline", "strike"],
          [{
              color: []
            },
            {
              background: []
            }
          ],
          [{
              script: "super"
            },
            {
              script: "sub"
            }
          ],
          [{
              list: "ordered"
            },
            {
              list: "bullet"
            },
            {
              indent: "-1"
            },
            {
              indent: "+1"
            }
          ],
          ["direction", {
            align: []
          }],
          ["link", "image", "video"],
          ["clean"]
        ]
      },
      theme: "snow"
    });
  }

  /**
   * Initiate TinyMCE Editor
   */

  var useDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;

  tinymce.init({
    selector: 'textarea.tinymce-editor',
    plugins: 'print preview paste importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount imagetools textpattern noneditable help charmap quickbars emoticons',
    imagetools_cors_hosts: ['picsum.photos'],
    menubar: 'file edit view insert format tools table help',
    toolbar: 'undo redo | bold italic underline strikethrough | fontselect fontsizeselect formatselect | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
    toolbar_sticky: true,
    autosave_ask_before_unload: true,
    autosave_interval: '30s',
    autosave_prefix: '{path}{query}-{id}-',
    autosave_restore_when_empty: false,
    autosave_retention: '2m',
    image_advtab: true,
    link_list: [{
        title: 'My page 1',
        value: 'https://www.tiny.cloud'
      },
      {
        title: 'My page 2',
        value: 'http://www.moxiecode.com'
      }
    ],
    image_list: [{
        title: 'My page 1',
        value: 'https://www.tiny.cloud'
      },
      {
        title: 'My page 2',
        value: 'http://www.moxiecode.com'
      }
    ],
    image_class_list: [{
        title: 'None',
        value: ''
      },
      {
        title: 'Some class',
        value: 'class-name'
      }
    ],
    importcss_append: true,
    file_picker_callback: function(callback, value, meta) {
      /* Provide file and text for the link dialog */
      if (meta.filetype === 'file') {
        callback('https://www.google.com/logos/google.jpg', {
          text: 'My text'
        });
      }

      /* Provide image and alt text for the image dialog */
      if (meta.filetype === 'image') {
        callback('https://www.google.com/logos/google.jpg', {
          alt: 'My alt text'
        });
      }

      /* Provide alternative source and posted for the media dialog */
      if (meta.filetype === 'media') {
        callback('movie.mp4', {
          source2: 'alt.ogg',
          poster: 'https://www.google.com/logos/google.jpg'
        });
      }
    },
    templates: [{
        title: 'New Table',
        description: 'creates a new table',
        content: '<div class="mceTmpl"><table width="98%%"  border="0" cellspacing="0" cellpadding="0"><tr><th scope="col"> </th><th scope="col"> </th></tr><tr><td> </td><td> </td></tr></table></div>'
      },
      {
        title: 'Starting my story',
        description: 'A cure for writers block',
        content: 'Once upon a time...'
      },
      {
        title: 'New list with dates',
        description: 'New List with dates',
        content: '<div class="mceTmpl"><span class="cdate">cdate</span><br /><span class="mdate">mdate</span><h2>My List</h2><ul><li></li><li></li></ul></div>'
      }
    ],
    template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',
    template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',
    height: 400,
	/*height: 600,*/
    image_caption: true,
    quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
    noneditable_noneditable_class: 'mceNonEditable',
    toolbar_mode: 'sliding',
    contextmenu: 'link image imagetools table',
    skin: useDarkMode ? 'oxide-dark' : 'oxide',
    content_css: useDarkMode ? 'dark' : 'default',
    content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:14px }'
  });

  /**
   * Initiate Bootstrap validation check
   */
  var needsValidation = document.querySelectorAll('.needs-validation')

  Array.prototype.slice.call(needsValidation)
    .forEach(function(form) {
      form.addEventListener('submit', function(event) {
        if (!form.checkValidity()) {
			// Check how to fix this validity check 
            //event.preventDefault()
            //event.stopPropagation()
        }

        form.classList.add('was-validated')
      }, false)
    })

  /**
   * Initiate Datatables
   */
  const datatables = select('.datatable', true)
  datatables.forEach(datatable => {
    new simpleDatatables.DataTable(datatable);
  })

  /**
   * Autoresize echart charts
   */
  const mainContainer = select('#main');
  if (mainContainer) {
    setTimeout(() => {
      new ResizeObserver(function() {
        select('.echart', true).forEach(getEchart => {
          echarts.getInstanceByDom(getEchart).resize();
        })
      }).observe(mainContainer);
    }, 200);
  }

})();


$(document).ready(function() {								
	
	$('#hidesidebar').click( function(){
			$('#hidesidebar').hide();
			$('#showsidebar').show();
	});
	
	$('#showsidebar').click( function(){
			$('#showsidebar').hide();
			$('#hidesidebar').show();
	});
	
	$("body").on("contextmenu", function(e) {
	  //return false;
	});
	
	/*
	$('.js-select').select2().on('select2:open', (elm) => {
	  const targetLabel = $(elm.target).prev('label.slct2');
	  targetLabel.addClass('selected');
	}).on('select2:close', (elm) => {
	  const target = $(elm.target);
	  const targetLabel = target.prev('label.slct2');
	  const targetOptions = $(elm.target.selectedOptions);
	  if (targetOptions.length === 0) {
		targetLabel.removeAttr('class');
	  }
	});
	*/
	
	$('.js-select')
    .parent('div')
    .children('span')
    .children('span')
    .children('span')
    .css('height', ' calc(3.5rem + 5px)');
$('.js-select')
    .parent('div')
    .children('span')
    .children('span')
    .children('span')
    .children('span')
    .css('margin-top', '18px');
$('.js-select')
    .parent('div')
    .find('label')
    .css('z-index', '1');
	

});

$(document).ready(function() {
						  
    $('optgroup').each(function() {
        if ($(this).children('option').length === 0) {
			$(this).prop("hidden", true );
            $(this).hide();
        }
    });
	$('.dateerror').hide();
	
	$('select').each(function() {
		$(this).find('optgroup').each(function() {
		  if ($(this).find('option').length === 0) {
			$(this).remove();
		  }
		});
	});
	
	$('input[type="text"]').each(function() {
        if ($(this).prop('readonly')) {
            $(this).css('background-color', 'white');
        }
    });
	
	let boxes = document.querySelectorAll(".corpInfoCard");
  	let maxHeight = Math.max(...Array.from(boxes).map(el => el.clientHeight));
  	boxes.forEach(el => el.style.height = maxHeight + "px");
  
  	$('#gallerychoice').change( function() {
		//enable text field
		let selected = $(this).val();
		if ( selected == 0 ) {
			$('#newalbum').prop('disabled', false )) 
		}
		else {
			$('#newalbum').prop('disabled', true )) 
		}
		
	});
	
});

var whichButton = "";

function checkBtn(event) {
    whichButton = event.target.name;
}

function setRenewalDate( docDtID, renewDtID, renewPeriod )
{	

	if ( renewPeriod < 0 ) { return; }

	var rFactor = 1;
	var docDT = $('#'+docDtID).val();
	
	var newDate = ( docDT.indexOf("-") == -1 ) ? docDT.split('/') : docDT.split('-');
	
	//alert( newDate );
				
	// Special treatment of TB Screaning
	if (( docDtID.toLowerCase().indexOf("tb_screening") != -1 ) && $('#xraychk').is(':checked') ) { rFactor = 3; }
	
	var myDate = ( docDT.indexOf("-") == -1 ) ? ( new Date(newDate[2], newDate[0] - 1, newDate[1]) ) : ( new Date(newDate[0], newDate[1] - 1, newDate[2]) );
	var myRenewDate = new Date( myDate.setTime( myDate.getTime() + renewPeriod * 86400000 * rFactor ) );
		
	$('#'+renewDtID+'View').prop('readonly',false);
		
	//$('#'+renewDtID).val( "" + myRenewDate.getFullYear() + "-" + ( ( ( myRenewDate.getMonth() + 1 ) < 10 ) ? ( '0' + ( myRenewDate.getMonth() + 1 ) ) : ( myRenewDate.getMonth() + 1 ) ) + "-" + ( ( myRenewDate.getDate() < 10 ) ? ( '0' + myRenewDate.getDate() ) : myRenewDate.getDate() ) + ""	);	
	
	$('#'+renewDtID).val( "" + ( ( ( myRenewDate.getMonth() + 1 ) < 10 ) ? ( '0' + ( myRenewDate.getMonth() + 1 ) ) : ( myRenewDate.getMonth() + 1 ) ) + "/" + ( ( myRenewDate.getDate() < 10 ) ? ( '0' + myRenewDate.getDate() ) : myRenewDate.getDate() ) + "/" +  myRenewDate.getFullYear() + ""	);	
	
	$('#'+renewDtID+'View').val( "" + ( ( ( myRenewDate.getMonth() + 1 ) < 10 ) ? ( '0' + ( myRenewDate.getMonth() + 1 ) ) : ( myRenewDate.getMonth() + 1 ) ) + "/" + ( ( myRenewDate.getDate() < 10 ) ? ( '0' + myRenewDate.getDate() ) : myRenewDate.getDate() ) + "/" +  myRenewDate.getFullYear() + ""	);	
	
	$('#'+renewDtID+'View').prop('readonly',true);
	
	//alert( $('#'+renewDtID).val() );
	//alert( $('#'+renewDtID+'View').val() );

}

function leapYear(year)
{
  return ((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0);
}

function formatFullDate(date) {
	return (date.getMonth() + 1) + '/' + date.getDate() + '/' + date.getFullYear();
}
	
Date.prototype.addDays = function(days) {
    var date = new Date(this.valueOf());
    date.setDate(date.getDate() + days);
    return date;
}

function toTitleCase(str) {
  return str.replace(
    /\w\S*/g,
    function(txt) {
      return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
    }
  );
}

function readonly_select(objs, action) {
  	if (action === true)
		objs.prepend('<div class="disabled-select"></div>');
  	else
		$(".disabled-select", objs).remove();
}

function daysInMonth(month, year) {
    return new Date(year, month, 0).getDate();
}

function getDaysInMonth(month, year) {
    month--; // lets fix the month once, here and be done with it
    var date = new Date(year, month, 1);
    var days = [];
    while (date.getMonth() === month) {

        // Exclude weekends
        var tmpDate = new Date(date);            
        var weekDay = tmpDate.getDay(); // week day
        var day = tmpDate.getDate(); // day

        if (weekDay%6) { // exclude 0=Sunday and 6=Saturday
            days.push(day);
        }

        date.setDate(date.getDate() + 1);
    }

    return days;
}  

function convertToMilitaryTime(time) {
    // Parse the time string
    let [timePart, modifier] = time.split(" ");
    let [hours, minutes] = timePart.split(":").map(Number);

    // Convert to 24-hour format
    if (modifier === "PM" && hours !== 12) {
        hours += 12;
    } else if (modifier === "AM" && hours === 12) {
        hours = 0;
    }

    // Format the result as HHMM
    return `${hours.toString().padStart(2, '0')}${minutes.toString().padStart(2, '0')}`;
}

function addBudgetRow(butgetItems) {
	
	//alert("Budget Items = " + butgetItems);
	let rowcount = parseInt( $('#trackrowcount').val() ) - 1;
	let table = document.getElementById('budgetTable').getElementsByTagName('tbody')[0];
	let rowCount = table.rows.length;	
	let lastRow = table.getElementsByTagName("tr")[rowCount - 3]; // Get the first row inside <tbody>	
	let cellCount = lastRow.cells.length;	
	let numDataCols = 1;
	const rowCell = [];
	
	// Create a new row
	let newRow = table.insertRow(rowCount - 3);
	let newRowNumber = (rowCount - 3 + 1);
	
	// Insert new cells (columns)
	for (let i = 0; i < cellCount; i++) {
	  rowCell[i] = newRow.insertCell(i);
	}

	// Insert new cells (columns)			
	for (let i = 0; i < cellCount; i++) {
		if ( i == 0 ) {
			rowCell[i].innerHTML = "<select name=\"budgetItem[" + newRowNumber + "]\" class=\"budgetItmSlct\"><option value=\"\">Select Budget Item</option><option value=\"1\">New Budget Item</option>" + butgetItems + "</select><input style=\"display:none;\" class=\"mt-1\" name=\"newbudgetitem[" + newRowNumber + "]\" id=\"newbudgetitem" + newRowNumber + "\" type=\"text\" size=\"20\"  />";    				
		}
		else if ( i == ( cellCount - 1 ) ) {
			rowCell[i].innerHTML = "<img src=\"/assets/img/remove.png\" alt=\"X\" width=\"24\" id=\"delImg"+ newRowNumber + "\" onClick=\"deleteRow(\'delImg"+ newRowNumber + "\')\">";			}
		else {
			rowCell[i].innerHTML = "<input style=\"padding: 2px; text-align:right; width: 125px; margin: 3px 0 3px 3px;\" class=\"column" + i + " dynamic-field\" name=\"itemAmount"+ numDataCols + "[" + newRowNumber + "]\" id=\"itemAmount"+ newRowNumber + (numDataCols++) + "\" type=\"number\">";
		}
	}
}

function deleteLastTableRow( id ) {
	let table = document.getElementById(id).getElementsByTagName('tbody')[0];
	let rowCount = table.rows.length;

	if (rowCount > 0) {
		table.deleteRow(rowCount - 2);
	} 
}

function deleteRow( id ) {
	let btn = document.getElementById(id);
	let trElementrow = btn.closest("tr"); // Find the closest <tr> (row) to the clicked button
	
	// Get the number oof cells in the row
	let rowCells = trElementrow.cells.length	

	// Remove the row
	trElementrow.remove();	
	
	sumRunningTotals();
	/*
	for( let i = 1; i <= ( rowCells - 2 ); i++ )
	{
		var sum = 0.00;
		$(".column"+i).each( function() {
						
			if ( isNaN( $(this).val() ) ||  (  $(this).val().trim() == "" ) ) {	
			}
			else {
				sum += parseFloat($(this).val());
			}
		});
		$("#runningTotal"+i).val( parseFloat( sum ).toFixed(2) ); 
	}
	*/
}

function trim (str) {

  return str.replace(/^\s+/g, '').replace(/\s+$/g, '');

}

function adjustTotal( src, fID )
{
	var fieldValue;
	if ( trim(src.value) == "" )
		src.value = 0.00;
	else {
		fieldValue = parseFloat(src.value);
		src.value = fieldValue.toFixed(2);
	}
	
	sumRunningTotals();
}

function sumRunningTotals( skip )
{
	var table   = document.getElementById("budgetTable");
	var numCols = table.rows[1].cells.length;
	var numRows = table.rows.length;
	
	if ( numCols == 0 ) {
		
		numCols = table.tBodies[0].rows[0].cells.length;
	}
	
	var fieldID;
	var fieldValue;	

	for( var j = 1; j < numCols - 1; j++ )
	{
		fieldID = document.getElementById('runningTotal'+j);		
		fieldID.value = 0.00;
		for ( var i = 1; i <= numRows; i++ )
		{
			if ( document.getElementById('itemAmount'+i+j) != null )
			{
				if ( ( i != skip ) && ( trim(document.getElementById('itemAmount'+i+j).value) != "" ) )
					fieldID.value = parseInt(fieldID.value) + parseInt(document.getElementById('itemAmount'+i+j).value);
			}
		}
		fieldValue = parseInt(fieldID.value)
		fieldID.value = fieldValue.toFixed(2);
	}
}





