	
$(document).ready(function() {								
	
	$( '#staffID' ).select2( {
		theme: "bootstrap-5",
		placeholder: $( this ).data( 'placeholder' ),
		width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
	});	 
	
	$( '.request-checkbox').on( "click", function() {
		
		var chkValue = $(this).val();
		var chkIDParts = $(this).prop("id").split("-");
		var chkKeyDigit = parseInt(chkIDParts[chkIDParts.length - 1], 10)
				
		if ( $(this).is(":checked") ) {
			$( '#startDate-'+chkKeyDigit ).prop('required',true);
			$( '#endDate-'+chkKeyDigit ).prop('required',true);
			
			if ( chkValue == 3 ) {
				$( '#hourlyDate-'+chkKeyDigit ).prop('required',true);
				$( '#numhours-'+chkKeyDigit ).prop('required',true);
			}
			
			if ( chkValue == 4 ) {
				$( '#numdays-'+chkKeyDigit ).prop('required',true);
			}
		}
		else {
			$( '#startDate-'+chkKeyDigit ).prop('required',false);
			$( '#endDate-'+chkKeyDigit ).prop('required',false);
			
			if ( chkValue == 3 ) {
				$( '#hourlyDate-'+chkKeyDigit ).prop('required',false);
				$( '#numhours-'+chkKeyDigit ).prop('required',false);
			}
			
			if ( chkValue == 4 ) {
				$( '#numdays-'+chkKeyDigit ).prop('required',false);
			}

		}
		
	});
	
});

// Bootstrap 5 form validation + custom check for at least one request type
(function () {
    'use strict';

    const form = document.querySelector('.needs-validation');
    const requestCheckboxes = document.querySelectorAll('.request-checkbox');
    const requestTypeError = document.getElementById('requestTypeError');

    form.addEventListener('submit', function (event) {
        let atLeastOneChecked = false;
        requestCheckboxes.forEach(cb => {
            if (cb.checked) atLeastOneChecked = true;
        });

        if (!atLeastOneChecked) {
            event.preventDefault();
            event.stopPropagation();
            requestTypeError.classList.remove('d-none');
        } else {
            requestTypeError.classList.add('d-none');
        }

        if (!form.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        }

        form.classList.add('was-validated');
    }, false);
})();


	
