
$(document).ready(function() {								
	
	$('#hidesidebar').click();
	
	if ( $( '#resident' ).length > 0 ) {
		$( '#resident,#service' ).select2( {
			theme: "bootstrap-5",
			placeholder: $( this ).data( 'placeholder' ),
			width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
		});
	}
	
	if ( $( '.activitySelect' ).length > 0 ) {
		
		$( '.activitySelect,.staffSelect' ).select2( {
			theme: "bootstrap-5",
			placeholder: $( this ).data( 'placeholder' ),
			width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
		});
	
	}
	
	$('.activityMonth').each(function() {
		
		new tempusDominus.TempusDominus(this, {
		   display: {
			 viewMode: 'calendar',
			 components: {
			   decades: true,
			   year: true,
			   month: true,
			   date: false,
			   hours: false,
			   minutes: false,
			   seconds: false,
			 },
			 icons: {
			   time: 'bi bi-clock',
			   up: 'bi bi-arrow-up',
			   down: 'bi bi-arrow-down',
			   previous: 'bi bi-chevron-left',
			   next: 'bi bi-chevron-right',
			   clear: 'bi bi-trash-fill',
			   close: 'bi bi-x-lg',
			 },
			 buttons: {
			   today: true,
			   clear: true,
			   close: true,
			 }
		   },
		   localization: {
			   format: 'MMM yyyy',
		   },
		   useCurrent: false,
		 });
		
	});
	
	$('.activityDate').each(function() {
		
		new tempusDominus.TempusDominus(this, {
		   display: {
			 viewMode: 'calendar',
			 components: {
			   decades: true,
			   year: true,
			   month: true,
			   date: true,
			   hours: false,
			   minutes: false,
			   seconds: false,
			 },
			 icons: {
			   time: 'bi bi-clock',
			   up: 'bi bi-arrow-up',
			   down: 'bi bi-arrow-down',
			   previous: 'bi bi-chevron-left',
			   next: 'bi bi-chevron-right',
			   clear: 'bi bi-trash-fill',
			   close: 'bi bi-x-lg',
			 },
			 buttons: {
			   today: true,
			   clear: true,
			   close: true,
			 }
		   },
		   localization: {
			   format: 'MM/dd/yyyy',
		   },
		   useCurrent: false,
		 });
		
	});
	
	$('.startEndTime').each(function() {
									 
		   new tempusDominus.TempusDominus(this, {
		   display: {
			 viewMode: 'clock',
			 components: {
			   decades: false,
			   year: false,
			   month: false,
			   date: false,
			   hours: true,
			   minutes: true,
			   seconds: false
			 },
			 icons: {
			   time: 'bi bi-clock',
			   up: 'bi bi-arrow-up',
			   down: 'bi bi-arrow-down',
			   previous: 'bi bi-chevron-left',
			   next: 'bi bi-chevron-right',
			   clear: 'bi bi-trash-fill',
			   close: 'bi bi-x-lg',
			 },
			 buttons: {
			   clear: true,
			   close: true,
			 }
		   },
		   localization: {
			  format: 'hh:mm T',
		   },		
			useCurrent: false,
		 });
	});
	
	
	$('.actvyStart').change( function() {
		const idArray = $(this).prop("id").split("_");
		$('#startTimeID_'+idArray[1]).val( convertToMilitaryTime($(this).val()) );
	});
	
	$('.actvyEnd').change( function() {
		const idArray = $(this).prop("id").split("_");
		$('#endTimeID_'+idArray[1]).val( convertToMilitaryTime($(this).val()) );
	});
	
	$('#chartingdate').change( function() {
		const myArray = $(this).val().split(" ");
		$('#chart_month').val(myArray[0]);
		$('#chart_year').val(myArray[1]);
	});
	
	$('#resident').change( function() {
		
		// Populate Region select using ajax
		var clientID  = $('#resident').val();
		var stateCD  = $('#stateCD').val();
		var clientRef = $('#clientRef').val();
	
		// Create our XMLHttpRequest object
		var hr = new XMLHttpRequest();
		
		// Create some variables we need to send to our PHP file
		var url = "/assets/ajaxphp/getClientsChartingServices.php";
		var vars = "clientID="+clientID+"&stateCD="+stateCD;
		hr.open("POST", url, true);
		
		// Set content type header information for sending url encoded variables in the request
		hr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		
		// Access the onreadystatechange event for the XMLHttpRequest object
		hr.onreadystatechange = function() {		 
			if(hr.readyState == 4 && hr.status == 200) {
				var return_data = hr.responseText;
				
				//alert(return_data);
				
				var obj = JSON.parse(return_data);
				var serviceLen = obj.length;
			
				$('#service').empty();
				for ( var i =0; i < obj.length; i++ ) {
					$('#service').append('<option value="'  + obj[i].ServiceID + '">' + obj[i].ServiceName  + '</option>');
				}
				var options = $('#service option');
				var arr = options.map(function(_, o) { return { t: $(o).text(), v: o.value }; }).get();
				arr.sort(function(o1, o2) { return o1.t > o2.t ? 1 : o1.t < o2.t ? -1 : 0; });
				options.each(function(i, o) {
					o.value = arr[i].v;
					$(o).text(arr[i].t);
				});
				$('#service').prepend('<option selected disabled value="">Choose a ' + clientRef + ' Service</option>');
			}
		}
		
		// Send the data to PHP now... and wait for response to update the status div
		hr.send(vars); // Actually execute the request
		
	});
	
	$('#activity1').submit( function() {	
		
		
		if ( ( $('#resident').val() == null ) || ( $('#resident').val() == "" ) || ( $('#resident').selectedIndex == 'undefined' ) ) {
			return false;
		}
		
		if ( ( $('#service').val() == null ) || ( $('#service').val() == "" ) || ( $('#service').selectedIndex == 'undefined' ) ) {
			return false;
		}
		
		if ( ( $('#chartingdate').val() == null ) || ( $('#chartingdate').val().trim().length == 0 ) ) {
			return false;
		}

		return true;
		
	});
	
	$('#activity2').submit( function() {
									 
		const idArray = $(this).prop("id").split("_");
		
		if ( ( $('#startTimeID_'+idArray[1]).val() == "" ) || ( $('#endTimeID_'+idArray[1]).val() == "" ) ) {
			$('#startTimeID_'+idArray[1]).val( convertToMilitaryTime($(this).val()) );
			$('#endTimeID_'+idArray[1]).val( convertToMilitaryTime($(this).val()) );
		}

		return true;
		
	});
	
	
});

	
