<?php
	
	 //
	 // Attendance Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/rqstoff.db.php' );
	 
	function postStaffActivityLog( $formdata, $staffID )
	{
		$dbHandle = loginToDB();
		$retVal = array();
		
		global $TIMEZONE;
		
		date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		$logdate = date('Y-m-d');
		$logtime = date('h:i:s A');
		
		$timeArr = explode( " ", $formdata['timestart'] );
		$startTime = $timeArr[count($timeArr)-2] . ' ' . $timeArr[count($timeArr)-1];
		$timeArr = explode( " ", $formdata['timeend'] );
		$endTime = $timeArr[count($timeArr)-2] . ' ' . $timeArr[count($timeArr)-1];
		
		$query  = "INSERT INTO `StaffActivityLog`(`StaffID`, `LogDate`, `LogTime`, `ActivityStart`, ";
		$query .= "`ActivityEnd`, `ActivityDetail`, `PostedBy`) VALUES ( ";
		$query .= "" . $staffID . ", ";
		$query .= "'" . $logdate . "', ";
		$query .= "'" . $logtime . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $startTime ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $endTime ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['activitydtl'] ) . "', ";
		$query .= "" . $staffID . " ";
		$query .= " )";
		
		//echo $query;
		
		mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
          			
            //echo $rtnMsg;                 // Free result set
            if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return array( SQLERROR, $rtnMsg . "<br />" . $query );
		}
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return array( SUCCESS, "Staff Activity posted successfully" );
	}
	
	function recordStaffTemperature( $staffData )
	{
		
		$dbHandle = loginToDB();
		
		global $TIMEZONE;
		
		date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		list( $tempMonth, $tempDay, $tempYear ) = explode("/", $staffData['tempdate']);
		
		for( $jj = 0; $jj < count($staffData['staffID']); $jj++ ) 
		{
			if  ( ( $staffData['staffID'][$jj] == '' ) or ( $staffData['tempValue'][$jj] == '' ) ) { continue; }
			
			$query = "INSERT INTO `StaffBodyTemperature`(`StaffID`, `Month`, `Year`, `TempReadingTime`, `";
			$query .= "" . ltrim($tempDay, "0") . "` ) VALUES ( ";
			$query .= $staffData['staffID'][$jj] . ", ";
			$query .= ltrim($tempMonth, "0") . ", ";
			$query .= "'" . $tempYear . "', ";
			$query .= "'" . $staffData['tempReading'] . "', ";
			$query .= $staffData['tempValue'][$jj] . " ";
			$query .= " )";
			$query .= " ON DUPLICATE KEY UPDATE ";
			$query .= "`" . ltrim($tempDay, "0") . "` = " . $staffData['tempValue'][$jj];
			
			//echo $query;
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);
						
				// Free result set
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, $rtnMsg . "<br />" . $query );
			}
		}
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return array( SUCCESS, "Staff Body Temperature posted successfully" );
	}
	
	function SaveProfileUpdates( $updateRec ) 
	{
		$dbHandle = loginToDB();
		
		$query = " UPDATE `Staff` SET `PhoneNum`= '" . formatPhone( sql_quote( $dbHandle, $updateRec['phone'] ) ) .  "', ";
		$query .=  " `PhoneGateway`= " . $updateRec['carrier'] . ", `StaffEmail` = '" . $updateRec['email'] . "' WHERE `StaffID`=" . $updateRec['staffID'];
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
					
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		
		
		$query = " UPDATE `StaffAuthAz` SET `StaffPassword`= '" . password_hash( $updateRec['passwd'], PASSWORD_DEFAULT ) .  "' WHERE `StaffID`=" . $updateRec['staffID'];
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
					
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return array( SUCCESS, "Your profile was updated successfully" );
	}
	
   function getTripPurpose()
   {

   		$dbHandle  = loginToDB();

		$retStr    = "";
   		$purpose = "";
		$query = "SELECT usePurpose FROM VehiculeUsePurpose order by useID";

		//echo $query;

		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$purpose .=  "<option value=\"" . $row[0] . "\">" . $row[0] .  "</option><br />";
			}
			$retStr = array( SUCCESS, $purpose );
		}
		else
			$retStr = array( FAIL, $purpose );
          		
        // Free result set
        if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return $retStr;
   }
   
    function getVehicules( $StaffID = 0 )
   {

   		$dbHandle  = loginToDB();

		$retStr    = "";
   		$vehicules = "";
		$mileage   = array();
		$vehicleTag = array();
		
		$query = "SELECT a.vehiculeID, a.vehiculeYear, a.vehiculeMake, a.vehiculeModel, a.vehicleColor, a.endingMileage, a.tagImage FROM VehiculeLkup a WHERE  a.inService = 'Y' ORDER BY 1 ";
		//$query .= " UNION ";
		//$query .= "SELECT a.vehiculeID, a.vehiculeYear, a.vehiculeMake, a.endingMileage FROM VehiculeLkup a, Employees b WHERE  b.Status = 'Active' and b.HouseID = 0 and b.StaffID = " .  $StaffID . " order by 1";

		//echo $query;

		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$vehicules .=  "<option value=\"" . $row[0] . "\">" . $row[1] . " " . $row[2]  . " " . $row[3] . " ( " . $row[4] . " )</option><br />";
				$mileage[$row[0]] = $row[5] . '';
				$vehicleTag[$row[0]] =  $row[6];
			}
			$retStr = array( SUCCESS, $vehicules, $mileage, $vehicleTag );
		}
		else
			$retStr = array( FAIL, $vehicules );
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		return $retStr;

   }


	function getVehiculeEndingMileage(  )
   {

   		$dbHandle  = loginToDB();

		$retStr    = "";
		$mileage   = array();
   				
		$query = "SELECT vehiculeID, EndingMileage FROM  VehiculeLog a WHERE LogID IN ( SELECT MAX(LogID) FROM VehiculeLog b WHERE a.vehiculeID = b.vehiculeID) order by vehiculeID";
		
		//echo $query;

		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$mileage[$row[0]] =  $row[1];
			}
			$retStr = array( SUCCESS, $mileage );
		}
		else
			$retStr = array( FAIL, $mileage );
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return $retStr;

   }
   
   function getRepairList()
	{
		$retStr = '';
		$dbHandle    = loginToDB();
		$query  = "SELECT `repairLkupID`, `repairLkupDesc`  FROM `VehicleRepairLkup` order by 2";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$retStr .= "<option value=\"" . $row[1] . "\">" . $row[1] . "</option>";
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( SUCCESS, $retStr );
		}
		else
			return array( SQLERROR, mysqli_error($dbHandle) );
	}
	
	function getMileageAndTag()
	{
		$dbHandle  = loginToDB();

		$retStr    = array( 'endingMileage' => '', 'tagImage'=> ''  );;
		
		$query = "SELECT a.endingMileage, a.tagImage FROM VehiculeLkup a WHERE  a.`vehiculeID`= " . $_GET['vehicleID'] . " AND a.inService = 'Y' ORDER BY 1 ";

		//echo $query;
		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			$retStr = mysqli_fetch_assoc( $result );
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		return $retStr;
	}
	
	function putVehiculeLog( $formdata )
    {
		
		$dbHandle = loginToDB();
		$retStr = "";
		
		$repairID = $fuelingID = 'NULL';
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		}
		
		
		if ( $formdata['repaired'] == 'Y' ) { 
			$repairID = getNextID( 'VehiculeRepairs', 'repairID', $dbHandle );
			$query = "INSERT INTO `VehiculeRepairs`(`repairID`, `repairDate`, `repairDone`, `repairDetails`, `repairMileage`, `repairCost`) VALUES ( ";
			$query .= $repairID . ", ";
			$query  .= "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['repairdate'] ) . "', '%m/%d/%Y'), ";		
			$query .=  "'" . sql_quote( $dbHandle,  $formdata['repairWorkDone'] ) . "', ";
			$query .=  "'" . sql_quote( $dbHandle,  $formdata['repairDetails'] ) . "', ";
			$query .= $formdata['repairMileage'] . ", ";
			$query .= $formdata['repairCost'] . " ";
			$query .= " ) ";
			
			//echo $query;
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 ) {
				$retStr = array( FAIL, mysqli_error($dbHandle) );
				mysqli_rollback($dbHandle);
				closeDB( $dbHandle );
				return $retStr;
			}
		}
		
		if ( $formdata['fueled'] == 'Y' ) {
			$fuelingID = getNextID( 'VehiculeFueling', 'fuelingID', $dbHandle );
			$query = "INSERT INTO `VehiculeFueling`(`fuelingID`, `fuelingDate`, `fuelingMileage`, `fuelingCost`) VALUES (";
			$query .= $fuelingID . ", ";
			$query  .= "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['fueldate'] ) . "', '%m/%d/%Y'), ";		
			$query .= $formdata['fuelingMileage'] . ", ";
			$query .= $formdata['fuelingCost'] . " ";
			$query .= " ) ";
			//echo $query;
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 ) {
				$retStr = array( FAIL, mysqli_error($dbHandle) );
				mysqli_rollback($dbHandle);
				closeDB( $dbHandle );
				return $retStr;
			}	
		}
		
		$logID = getNextID( 'VehiculeLog', 'LogID', $dbHandle );
		$query  = "INSERT INTO VehiculeLog (LogID, LogDate, StaffID, BeginningMileage, TripPurpose, TripDetails, EndingMileage, UsageMileage, vehiculeID, repairID, fuelingID) ";

		$query .= "VALUES ( ";
		$query .=  $logID . ", ";
		$query .=  "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['usagedate'] ) . "', '%m/%d/%Y'), ";
		$query .=  $formdata['staffID'] . ", ";
		$query .=  $formdata['beginMileage'] . ", ";
		$query .=  "'" . sql_quote( $dbHandle,  $formdata['tripPurpose'] ) . "', ";
		$query .=  "'" . sql_quote( $dbHandle,  $formdata['tripDetails'] ) . "', ";
		$query .=  $formdata['endMileage'] . ", ";
		$query .=  $formdata['usageMileage'] . ", ";
		$query .=  $formdata['vehiculeID'] . ", ";
		$query .=  $repairID . ", ";
		$query .=  $fuelingID . " ";
		$query .= " )";

		//echo $query;
		mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 ) {
			$retStr = array( FAIL, mysqli_error($dbHandle) );
			mysqli_rollback($dbHandle);
			closeDB( $dbHandle );
			return $retStr;
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

	   $retStr = array( SUCCESS, '' );
	   mysqli_commit($dbHandle);
	   closeDB( $dbHandle );

	   return $retStr;
   }
	

	function postLeaveRequest( $formdata )
	{
	  		$dbHandle = loginToDB();
			
			for( $i = 0; $i < count($formdata['request']); $i++ ) 
			{
				$query  = "SELECT ifnull(MAX(`LeaveRequestID`), 0) + 1 as 'LeaveRequestID' FROM `LeaveRequests`";
				$result = mysqli_query( $dbHandle, $query  );
				$row = mysqli_fetch_assoc($result);
				$leaveRequestID = $row['LeaveRequestID'];
				
				$HourlyDate = $NumHoursDays = 'NULL';
				if ( $formdata['request'][$i] == BY_THE_DAY ) {
					$NumHoursDays = $formdata['numdays'];
					$StartDate = dbDateFormat($formdata['startDate'][$formdata['request'][$i]]);
					$EndDate = dbDateFormat($formdata['endDate'][$formdata['request'][$i]]);
				} 
				else if ( $formdata['request'][$i] == BY_THE_HOURS ) {
					$NumHoursDays = $formdata['numhours'];
					$HourlyDate = "'" . dbDateFormat($formdata['hourlyDate']) . "'";
					$StartDate = date( "g:i A", strtotime( $formdata['startDate'][$formdata['request'][$i]] . ":00" ) );
					$EndDate = date( "g:i A", strtotime( $formdata['endDate'][$formdata['request'][$i]] . ":00" ) );
				}
				else {
					$StartDate = dbDateFormat($formdata['startDate'][$formdata['request'][$i]]);
					$EndDate = dbDateFormat($formdata['endDate'][$formdata['request'][$i]]);
				}
				
				$query = "INSERT INTO `LeaveRequests`(`LeaveRequestID`, `StaffID`, `RequestTypeID`, `RequestDate`, ";
				$query .= " `RequestReason`, `StartDateTime`, `EndDateTime`, `HourlyDate`, `NumHoursDays`, `StaffSignature` ) VALUES ( ";
				
				$query .= $leaveRequestID . ", " . $formdata['staffID'] . ", " . $formdata['request'][$i] . ", '"  . $formdata['requestDate'] . "', ";
				$query .= "'" . htmlspecialchars($formdata['requestReason'], ENT_QUOTES, 'UTF-8') . "', '" . $StartDate . "', ";
				$query .=  "'" . $EndDate . "', " . $HourlyDate  . ", " . $NumHoursDays . ", ";
				$query .=  "'" . htmlspecialchars($formdata['staffSignature'], ENT_QUOTES, 'UTF-8') . "' )";
						
				//echo $query;
										
				$result = mysqli_query( $dbHandle, $query  );		
				if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$errMsg = mysqli_error( $dbHandle );
					
					// Free result set
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					closeDB( $dbHandle );
					return array( FAIL, $errMsg );
				}
			}
			closeDB( $dbHandle );
			return array( SUCCESS, $leaveRequestID, "Your Leave Request was saved successfully and your supervisor has been notified");
	}
	
	function approveLeaveRequest( $formdata )
	{
	  		$dbHandle = loginToDB();
						
			$query = "UPDATE `LeaveRequests` SET ";
			$query .= "`Approved`='" . $formdata['approved'] . "', ";
			$query .= "`ReviewDate`='" . dbDateFormat($formdata['reviewDate']) . "', ";
			$query .= "`ReviewedBy`=" . $formdata['reviewedBy'] . ", ";
			$query .= "`ReviewNotes`='" . htmlspecialchars($formdata['reviewNotes'], ENT_QUOTES, 'UTF-8') . "', ";
			$query .= "`SupervisorSignature`='" . htmlspecialchars($formdata['supervisorSignature'], ENT_QUOTES, 'UTF-8') . "' ";
			$query .= "WHERE `LeaveRequestID`= " . $formdata['leaveRequestID'] . " ";
			
			$result = mysqli_query( $dbHandle, $query  );		
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$errMsg = mysqli_error( $dbHandle );
				
				// Free result set
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, $errMsg );
			}
			
			closeDB( $dbHandle );
			return array( SUCCESS, "Leave Request for " .  getStaffName($formdata['staffID']) . " has been " . (( $formdata['approved'] == 'Y') ?  'Approved' : 'Disapproved' ),  $formdata['leaveRequestID'],  $formdata['staffID']   );
	}
	
	function getPendingRequests( $supervisorID )
	{
	  		$dbHandle = loginToDB();
			$pendingRequests = array();
	  
	  		$query = "SELECT a.`LeaveRequestID`, a.`StaffID`,  concat(c.`StaffFname`, ' ', c.`StaffLname`) as StaffName, b.`LeaveRequest` ";
			$query .= "FROM `LeaveRequests` a, `LeaveRequestTypes`  b, `Employees` c WHERE a.`RequestTypeID`=b.`RequestTypeID` ";
			$query .= "and a.`StaffID`=c.`StaffID` and ReviewDate is NULL and c.`SupervisorID`= " . $supervisorID;
	  		
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_num_rows( $result ) == 0 )
			{
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );		
				return array( FAIL, "There are no leave requests to approve at this time. If you believe this is wrong please contact support" );
			}
				
			while ($row = mysqli_fetch_assoc($result)) {
				$pendingRequests[] = $row;
			}
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return array( SUCCESS, $pendingRequests );
	}
	
	function getLeaveRequestTypes( $requestID = 0 )
	{
	  		$dbHandle = loginToDB();
			$leaveTypes = array();
			
			$query = "SELECT * FROM `LeaveRequestTypes` " . ( ( $requestID == 0 ) ? '' :  ( " WHERE RequestTypeID = " . $requestID ) ) ;
			
			//echo $query;
			
			$result = mysqli_query( $dbHandle, $query  );
			while ($row = mysqli_fetch_assoc($result)) {
				$leaveTypes[] = $row;
			}
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return $leaveTypes;
	  }
	  
	  function getManagers( )
	  {
	  		$dbHandle = loginToDB();
			$leaveTypes = array();
			
			$query = "SELECT `StaffID`, concat(`StaffFname`, ' ', `StaffLname` ) as StaffName  FROM `Employees` WHERE `Employees`.`AdminType` IN ( 'A', 'N', 'HR', 'PS', 'D', 'Y' )
 ";
			
			$result = mysqli_query( $dbHandle, $query  );
			while ($row = mysqli_fetch_assoc($result)) {
				$leaveTypes[] = $row;
			}
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return $leaveTypes;
	  }
	  
	  function getLeaveDetails( $leaveID )
	  {
	  		$dbHandle = loginToDB();
			$leaveDetails = array();
			
			$query = "SELECT * FROM `LeaveRequests` WHERE LeaveRequestID=" . $leaveID;
			
			$result = mysqli_query( $dbHandle, $query  );
			while ($row = mysqli_fetch_assoc($result)) {
				$leaveDetails[] = $row;
			}
	
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );		
			return $leaveDetails;
	  }
	  
	  function getStaffLeaveDetails( $formdata, $formerStaff = 0 )
	  {
	  		$retArray = array();
	  		$dbHandle = loginToDB();
		
			$query  = "SELECT a.`StaffID`, Concat( a.`StaffFname`, IF(a.`StaffMInit` not in ( ' ', '' ), a.`StaffMInit`, ' '), a.`StaffLname` ) as StaffName,  a.`StaffHireDate`,  c.`RoleName` ";
			
			$query  .= " FROM `Staff" .  (($formerStaff == 1) ? "History" : "" ) . "` a, `StaffAuthAz` b, `StaffRoleLkup` c ";
			$query  .= " WHERE a.`StaffID`= " . $formdata['staffID'] . " AND a.`StaffID`=b.`StaffID` AND b.`StaffRoleID` =  c.`RoleID` ";
			$result = mysqli_query( $dbHandle, $query  );
       		if ( mysqli_errno( $dbHandle ) == 0 )
       		{
          		if ( mysqli_num_rows( $result ) == 0 )
          		{
               		$retArray = array( 0 => FAIL, NOT_EMP_SW, $query );
          		}
          		else {
               		$row = mysqli_fetch_row( $result );
                    $retArray = array( 0 => SUCCESS, $row[0], $row[1], $row[2], $row[3] );
          		}
       		}
			else {
				$errMsg = mysqli_error( $dbHandle );
				$errNo  = mysqli_errno( $dbHandle );
				$retArray = array( 0 => FAIL, SQLERROR, "Error No: " . $errNo . ": Error Message: " . $errMsg . "<br>" . $query );
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return $retArray;
		
	  }
	  
	 function getHRStaff( $staffID, $admin = 'S' )
	{
		
		$dbHandle = loginToDB();
		$staffRecord = array();
		
		if ( $admin == 'S' ) {
			$query  = "SELECT IFNULL(a.`StaffEmail`, 'NO VALID SUPERVISOR ASSIGNED' ) AS  SupervisorEmail, concat(a.`StaffFname`, ' ', a.`StaffLname`) as NAME ";
			$query .= " FROM `Staff` a, `Staff` b WHERE a.`StaffID`=b.`SupervisorID` and b.`StaffID`=". $staffID . " ";
		}
		else {
			$query  = "SELECT a.`StaffEmail` as SupervisorEmail, concat(a.`StaffFname`, ' ', a.`StaffLname`) as NAME FROM `Staff` a, `StaffAuthAz` b, StaffRoleLkup c WHERE a.`StaffID`=b.`StaffID` and b.`StaffRoleID` = c.`RoleID` and c.`RoleCode`='" . $admin ."'";
		}
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		
		while ($row = mysqli_fetch_assoc($result)) {
			$staffRecord[] = $row;
		}
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );	
			
		return $staffRecord;
	}
	  
	  
?>
